"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultS3NotificationEventTypes = exports.DefaultLoggingBucketProps = exports.DefaultS3Props = void 0;
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
function DefaultS3Props(loggingBucket, lifecycleRules) {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        ...((lifecycleRules !== undefined) && { lifecycleRules }),
        ...((loggingBucket !== undefined) && { serverAccessLogsBucket: loggingBucket })
    };
}
exports.DefaultS3Props = DefaultS3Props;
function DefaultLoggingBucketProps() {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
    };
}
exports.DefaultLoggingBucketProps = DefaultLoggingBucketProps;
// Default event types to trigger S3 notifications
exports.defaultS3NotificationEventTypes = [s3.EventType.OBJECT_CREATED];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtYnVja2V0LWRlZmF1bHRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiczMtYnVja2V0LWRlZmF1bHRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUgseUNBQXlDO0FBQ3pDLDZDQUE0QztBQUc1QyxTQUFnQixjQUFjLENBQUMsYUFBdUIsRUFBRSxjQUFtQztJQUN6RixPQUFPO1FBQ0wsVUFBVSxFQUFFLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVO1FBQzFDLFNBQVMsRUFBRSxJQUFJO1FBQ2YsaUJBQWlCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7UUFDakQsYUFBYSxFQUFFLDJCQUFhLENBQUMsTUFBTTtRQUNuQyxHQUFHLENBQUMsQ0FBQyxjQUFjLEtBQUssU0FBUyxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQztRQUN6RCxHQUFHLENBQUMsQ0FBQyxhQUFhLEtBQUssU0FBUyxDQUFDLElBQUksRUFBRSxzQkFBc0IsRUFBRSxhQUFhLEVBQUUsQ0FBQztLQUNqRSxDQUFDO0FBQ25CLENBQUM7QUFURCx3Q0FTQztBQUVELFNBQWdCLHlCQUF5QjtJQUN2QyxPQUFPO1FBQ0wsVUFBVSxFQUFFLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVO1FBQzFDLFNBQVMsRUFBRSxJQUFJO1FBQ2YsaUJBQWlCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7UUFDakQsYUFBYSxFQUFFLDJCQUFhLENBQUMsTUFBTTtLQUNyQixDQUFDO0FBQ25CLENBQUM7QUFQRCw4REFPQztBQUVELGtEQUFrRDtBQUNyQyxRQUFBLCtCQUErQixHQUFHLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgczMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcbmltcG9ydCB7IFJlbW92YWxQb2xpY3kgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBCdWNrZXQsIEJ1Y2tldFByb3BzIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcblxuZXhwb3J0IGZ1bmN0aW9uIERlZmF1bHRTM1Byb3BzKGxvZ2dpbmdCdWNrZXQgPzogQnVja2V0LCBsaWZlY3ljbGVSdWxlcz86IHMzLkxpZmVjeWNsZVJ1bGVbXSk6IHMzLkJ1Y2tldFByb3BzIHtcbiAgcmV0dXJuIHtcbiAgICBlbmNyeXB0aW9uOiBzMy5CdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgdmVyc2lvbmVkOiB0cnVlLFxuICAgIGJsb2NrUHVibGljQWNjZXNzOiBzMy5CbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5SRVRBSU4sXG4gICAgLi4uKChsaWZlY3ljbGVSdWxlcyAhPT0gdW5kZWZpbmVkKSAmJiB7IGxpZmVjeWNsZVJ1bGVzIH0pLFxuICAgIC4uLigobG9nZ2luZ0J1Y2tldCAhPT0gdW5kZWZpbmVkKSAmJiB7IHNlcnZlckFjY2Vzc0xvZ3NCdWNrZXQ6IGxvZ2dpbmdCdWNrZXQgfSlcbiAgfSBhcyBCdWNrZXRQcm9wcztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIERlZmF1bHRMb2dnaW5nQnVja2V0UHJvcHMoKTogczMuQnVja2V0UHJvcHMge1xuICByZXR1cm4ge1xuICAgIGVuY3J5cHRpb246IHMzLkJ1Y2tldEVuY3J5cHRpb24uUzNfTUFOQUdFRCxcbiAgICB2ZXJzaW9uZWQ6IHRydWUsXG4gICAgYmxvY2tQdWJsaWNBY2Nlc3M6IHMzLkJsb2NrUHVibGljQWNjZXNzLkJMT0NLX0FMTCxcbiAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LlJFVEFJTixcbiAgfSBhcyBCdWNrZXRQcm9wcztcbn1cblxuLy8gRGVmYXVsdCBldmVudCB0eXBlcyB0byB0cmlnZ2VyIFMzIG5vdGlmaWNhdGlvbnNcbmV4cG9ydCBjb25zdCBkZWZhdWx0UzNOb3RpZmljYXRpb25FdmVudFR5cGVzID0gW3MzLkV2ZW50VHlwZS5PQkpFQ1RfQ1JFQVRFRF07XG4iXX0=