/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as sns from 'aws-cdk-lib/aws-sns';
import * as kms from 'aws-cdk-lib/aws-kms';
import { Construct } from 'constructs';
export interface BuildTopicProps {
    /**
     * Existing instance of SNS Topic object, providing both this and `topicProps` will cause an error.
     *
     * @default - None.
     */
    readonly existingTopicObj?: sns.Topic;
    /**
     * Optional user provided props to override the default props for the SNS topic.
     *
     * @default - Default props are used.
     */
    readonly topicProps?: sns.TopicProps;
    /**
     * Use a Customer Managed KMS Key, either managed by this CDK app, or imported.
     *
     * If importing an encryption key, it must be specified in
     * the encryptionKey property for this construct.
     *
     * @default - false (encryption enabled with AWS Managed KMS Key).
     */
    readonly enableEncryptionWithCustomerManagedKey?: boolean;
    /**
     * An optional, imported encryption key to encrypt the SNS topic with.
     *
     * @default - not specified.
     */
    readonly encryptionKey?: kms.Key;
    /**
     * Optional user-provided props to override the default props for the encryption key.
     *
     * @default - Ignored if encryptionKey is provided
     */
    readonly encryptionKeyProps?: kms.KeyProps;
}
export declare function buildTopic(scope: Construct, props: BuildTopicProps): [sns.Topic, kms.Key?];
