"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSsmStringParameter = void 0;
const aws_ssm_1 = require("aws-cdk-lib/aws-ssm");
const utils_1 = require("./utils");
/**
 * Method to build the default AWS SSM Parameter Store
 *
 * @param scope
 * @param id
 * @param stringParameterProps
 */
function buildSsmStringParameter(scope, id, stringParameterProps) {
    let props = stringParameterProps;
    if (stringParameterProps.type && stringParameterProps.type !== aws_ssm_1.ParameterType.STRING) {
        utils_1.printWarning('Overriding SSM String Parameter type to be ParameterType.STRING');
        props = {
            ...stringParameterProps,
            type: aws_ssm_1.ParameterType.STRING
        };
    }
    return new aws_ssm_1.StringParameter(scope, id, props);
}
exports.buildSsmStringParameter = buildSsmStringParameter;
//# sourceMappingURL=data:application/json;base64,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