"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultIsolatedVpcProps = exports.DefaultPublicPrivateVpcProps = void 0;
const ec2 = require("aws-cdk-lib/aws-ec2");
/**
 * Default VPC with public and private subnets
 */
function DefaultPublicPrivateVpcProps() {
    return {};
}
exports.DefaultPublicPrivateVpcProps = DefaultPublicPrivateVpcProps;
/**
 * Default VPC with isolated subnets
 */
function DefaultIsolatedVpcProps() {
    return {
        natGateways: 0,
        subnetConfiguration: [
            {
                cidrMask: 18,
                name: "isolated",
                subnetType: ec2.SubnetType.PRIVATE_ISOLATED,
            }
        ]
    };
}
exports.DefaultIsolatedVpcProps = DefaultIsolatedVpcProps;
//# sourceMappingURL=data:application/json;base64,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