"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("../index");
require("@aws-cdk/assert/jest");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_cdk_lib_2 = require("aws-cdk-lib");
const utils_1 = require("../lib/utils");
test('test EventsRuleProps override ruleName and description', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const lambdaFunc = {
        bind: () => ({
            id: '',
            arn: 'ARN'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc]);
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        ruleName: 'test',
        description: 'hello world',
        schedule: aws_events_1.Schedule.rate(aws_cdk_lib_2.Duration.minutes(5))
    });
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        Description: "hello world",
        Name: "test",
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN",
                Id: "Target0"
            }
        ]
    });
});
test('test EventsRuleProps add more event targets', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const lambdaFunc1 = {
        bind: () => ({
            id: '',
            arn: 'ARN1'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc1]);
    const lambdaFunc2 = {
        bind: () => ({
            id: '',
            arn: 'ARN2'
        })
    };
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        targets: [lambdaFunc2],
        schedule: aws_events_1.Schedule.rate(aws_cdk_lib_2.Duration.minutes(5))
    }, true);
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN1",
                Id: "Target0"
            },
            {
                Arn: "ARN2",
                Id: "Target1"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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