"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const mediastore_helper_1 = require("../lib/mediastore-helper");
test('MediaStore container override params', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const mediaStoreContainerProps = {
        containerName: 'TestContainer',
        policy: '{}',
        lifecyclePolicy: '{}',
        metricPolicy: {
            containerLevelMetrics: 'DISABLED'
        }
    };
    mediastore_helper_1.MediaStoreContainer(stack, mediaStoreContainerProps);
    expect(stack).toHaveResourceLike('AWS::MediaStore::Container', {
        AccessLoggingEnabled: true,
        CorsPolicy: [
            {
                AllowedHeaders: ['*'],
                AllowedMethods: ['GET'],
                AllowedOrigins: ['*'],
                ExposeHeaders: ['*'],
                MaxAgeSeconds: 3000
            }
        ],
        MetricPolicy: {
            ContainerLevelMetrics: 'DISABLED'
        },
        Policy: '{}',
        LifecyclePolicy: '{}',
        ContainerName: 'TestContainer'
    });
});
//# sourceMappingURL=data:application/json;base64,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