"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const defaults = require("../");
require("@aws-cdk/assert/jest");
const ec2 = require("aws-cdk-lib/aws-ec2");
// --------------------------------------------------------------
// Test minimal deployment with no properties
// --------------------------------------------------------------
test("Test minimal deployment with no properties", () => {
    // Stack
    const stack = new aws_cdk_lib_1.Stack();
    const vpc = new ec2.Vpc(stack, "test-vpc", {});
    // Helper declaration
    defaults.buildSecurityGroup(stack, "primary-queue", {
        vpc,
        allowAllOutbound: true,
    }, [], []);
    expect(stack).toHaveResource("AWS::EC2::SecurityGroup", {
        SecurityGroupEgress: [
            {
                CidrIp: "0.0.0.0/0",
                Description: "Allow all outbound traffic by default",
                IpProtocol: "-1",
            },
        ],
    });
});
test("Test deployment with ingress rules", () => {
    // Stack
    const stack = new aws_cdk_lib_1.Stack();
    const vpc = new ec2.Vpc(stack, "test-vpc", {});
    // Helper declaration
    defaults.buildSecurityGroup(stack, "primary-queue", {
        vpc,
        allowAllOutbound: true,
    }, [{ peer: ec2.Peer.ipv4("1.1.1.1/16"), connection: ec2.Port.tcp(100) }], []);
    expect(stack).toHaveResource("AWS::EC2::SecurityGroup", {
        SecurityGroupIngress: [
            {
                CidrIp: "1.1.1.1/16",
                Description: "from 1.1.1.1/16:100",
                FromPort: 100,
                IpProtocol: "tcp",
                ToPort: 100,
            },
        ],
    });
});
test("Test deployment with egress rule", () => {
    // Stack
    const stack = new aws_cdk_lib_1.Stack();
    const vpc = new ec2.Vpc(stack, "test-vpc", {});
    // Helper declaration
    defaults.buildSecurityGroup(stack, "primary-queue", {
        vpc,
        allowAllOutbound: false,
    }, [], [
        { peer: ec2.Peer.ipv4("1.1.1.1/16"), connection: ec2.Port.tcp(100) },
        { peer: ec2.Peer.ipv4("2.2.2.2/24"), connection: ec2.Port.tcp(200) },
    ]);
    expect(stack).toHaveResource("AWS::EC2::SecurityGroup", {
        SecurityGroupEgress: [
            {
                CidrIp: "1.1.1.1/16",
                Description: "from 1.1.1.1/16:100",
                FromPort: 100,
                IpProtocol: "tcp",
                ToPort: 100,
            },
            {
                CidrIp: "2.2.2.2/24",
                Description: "from 2.2.2.2/24:200",
                FromPort: 200,
                IpProtocol: "tcp",
                ToPort: 200,
            },
        ],
    });
});
//# sourceMappingURL=data:application/json;base64,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