# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2023-03-08T14:10:39+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr


class AccessByType(Enum):
    account = 'account'
    grouping = 'grouping'


class AccessToType(Enum):
    asset = 'asset'
    grouping = 'grouping'


class AddIncidentCommentRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    content: constr(max_length=1025) = Field(
        ..., description='Content of comment.', title='Content'
    )


class AicpaTsc2017Standard(Enum):
    CC1_1 = 'CC1.1'
    CC6_3 = 'CC6.3'
    CC5_1 = 'CC5.1'
    CC5_3 = 'CC5.3'
    CC6_1 = 'CC6.1'
    CC6_2 = 'CC6.2'
    CC6_7 = 'CC6.7'
    CC6_6 = 'CC6.6'
    CC3_2 = 'CC3.2'
    CC3_3 = 'CC3.3'
    CC3_4 = 'CC3.4'


class AlertCategoryType(Enum):
    Change_Management = 'Change Management'
    Misconfiguration = 'Misconfiguration'
    Exposure = 'Exposure'
    Privileged_Access = 'Privileged Access'
    Suspicious_Behavior = 'Suspicious Behavior'
    Least_Privilege = 'Least Privilege'
    Custom = 'Custom'
    IAM_Infrastructure_Security = 'IAM Infrastructure Security'
    Detection = 'Detection'
    Stale_Access = 'Stale Access'
    Over_privileges = 'Over-privileges'
    Privilege_Escalation = 'Privilege Escalation'
    Account_Takeover = 'Account Takeover'
    Account_Impersonation__PE__LM_ = 'Account Impersonation (PE, LM)'


class AttackTacticType(Enum):
    Collection = 'Collection'
    Credential_Access = 'Credential Access'
    Defense_Evasion = 'Defense Evasion'
    Discovery = 'Discovery'
    Exfiltration = 'Exfiltration'
    Impact = 'Impact'
    Initial_Access = 'Initial Access'
    Lateral_Movement = 'Lateral Movement'
    Persistence = 'Persistence'
    Privilege_Escalation = 'Privilege Escalation'


class BaseBooleanFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    field_eq: Optional[bool] = Field(
        None, alias='$eq', description='Equals To', title='$Eq'
    )


class BaseDateFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    field_gt: Optional[datetime] = Field(
        None, alias='$gt', description='Greater Than', title='$Gt'
    )
    field_gte: Optional[datetime] = Field(
        None, alias='$gte', description='Greater Than Or Equals To', title='$Gte'
    )
    field_lt: Optional[datetime] = Field(
        None, alias='$lt', description='Less Than', title='$Lt'
    )
    field_lte: Optional[datetime] = Field(
        None, alias='$lte', description='Less Than Or Equals To', title='$Lte'
    )


class BaseSingleValuedStringFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    field_eq: Optional[str] = Field(
        None, alias='$eq', description='Equals To', title='$Eq'
    )


class CampaignExpansion(Enum):
    owner = 'owner'


class CampaignStatus(Enum):
    draft = 'draft'
    initializing = 'initializing'
    running = 'running'
    completed = 'completed'
    failed = 'failed'
    empty = 'empty'
    overdue = 'overdue'


class Ccm301Standard(Enum):
    AIS_04 = 'AIS-04'
    IAM_01 = 'IAM-01'
    IAM_02 = 'IAM-02'
    IAM_03 = 'IAM-03'
    IAM_04 = 'IAM-04'
    IAM_05 = 'IAM-05'
    IAM_06 = 'IAM-06'
    IAM_07 = 'IAM-07'
    IAM_08 = 'IAM-08'
    IAM_09 = 'IAM-09'
    IAM_10 = 'IAM-10'
    IAM_11 = 'IAM-11'
    IAM_12 = 'IAM-12'
    IAM_13 = 'IAM-13'
    GRM_06 = 'GRM-06'
    IVS_06 = 'IVS-06'
    IVS_08 = 'IVS-08'
    DSI_04 = 'DSI-04'


class Ccm402Standard(Enum):
    IAM_01 = 'IAM-01'
    IAM_02 = 'IAM-02'
    IAM_03 = 'IAM-03'
    IAM_04 = 'IAM-04'
    IAM_05 = 'IAM-05'
    IAM_06 = 'IAM-06'
    IAM_07 = 'IAM-07'
    IAM_08 = 'IAM-08'
    IAM_09 = 'IAM-09'
    IAM_10 = 'IAM-10'
    IAM_11 = 'IAM-11'
    IAM_12 = 'IAM-12'
    IAM_13 = 'IAM-13'
    IAM_14 = 'IAM-14'
    IAM_15 = 'IAM-15'
    IAM_16 = 'IAM-16'
    IVS_03 = 'IVS-03'
    IVS_04 = 'IVS-04'
    DSP_07 = 'DSP-07'
    DSP_08 = 'DSP-08'
    DSP_10 = 'DSP-10'
    AIS_03 = 'AIS-03'
    DSP_17 = 'DSP-17'
    DSP_01 = 'DSP-01'
    HRS_05 = 'HRS-05'


class CisV8Standard(Enum):
    field_3_1 = '3.1'
    field_3_3 = '3.3'
    field_6_8 = '6.8'
    field_5_4 = '5.4'
    field_12_7 = '12.7'
    field_6_5 = '6.5'
    field_6_2 = '6.2'
    field_5_3 = '5.3'
    field_12_2 = '12.2'
    field_6_1 = '6.1'
    field_5_1 = '5.1'
    field_4_11 = '4.11'
    field_13_4 = '13.4'
    field_13_9 = '13.9'
    field_13_10 = '13.10'


class Cisv8(BaseModel):
    values: List[CisV8Standard] = Field(..., description='Values')
    id: Optional[str] = Field('cisv8', description='UniqueID', title='Id')
    name: Optional[str] = Field('CIS v.8', description='Name', title='Name')


class CommentSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    id: str = Field(..., description='Unique ID of comment.', title='Id')
    content: constr(max_length=1025) = Field(
        ..., description='Content of comment.', title='Content'
    )


class FieldName(Enum):
    name = 'name'
    status = 'status'
    startDate = 'startDate'
    endDate = 'endDate'
    createdAt = 'createdAt'
    reviewerType = 'reviewerType'
    templateName = 'templateName'


class IncidentExpansion(Enum):
    policy = 'policy'
    assignee = 'assignee'


class IncidentSeverity(Enum):
    Low = 'Low'
    Medium = 'Medium'
    High = 'High'
    Critical = 'Critical'


class IncidentStatus(Enum):
    Open = 'Open'
    InProgress = 'InProgress'
    WaitingForInput = 'WaitingForInput'
    Closed = 'Closed'


class InventoryObjects(Enum):
    identity = 'identity'
    account = 'account'
    asset = 'asset'
    privilege = 'privilege'
    other = 'other'


class IsAliveResponse(BaseModel):
    isAlive: bool = Field(..., description='**isAlive**', title='Isalive')


class IsoIec27001Standard(Enum):
    A_6_1_2 = 'A.6.1.2'
    A_8_1_1 = 'A.8.1.1'
    A_8_1_3 = 'A.8.1.3'
    A_8_3_3 = 'A.8.3.3'
    A_9_1_1 = 'A.9.1.1'
    A_9_2_1 = 'A.9.2.1'
    A_9_2_3 = 'A.9.2.3'
    A_9_2_6 = 'A.9.2.6'
    A_9_4_1 = 'A.9.4.1'
    A_9_1_2 = 'A.9.1.2'
    A_9_4_2 = 'A.9.4.2'
    A_9_2_2 = 'A.9.2.2'
    A_13_2_1 = 'A.13.2.1'
    A_9_4_3 = 'A.9.4.3'
    A_7_2_2 = 'A.7.2.2'
    A_9_4_5 = 'A.9.4.5'
    A_8_2_3 = 'A.8.2.3'
    A_7_3_1 = 'A.7.3.1'
    A_8_1_4 = 'A.8.1.4'


class MeResponse(BaseModel):
    version: Optional[str] = Field('3.1.0', description='**version**', title='Version')
    id: str = Field(..., description='**id**', title='Id')
    tenant: str = Field(..., description='**tenant**', title='Tenant')


class NonPaginatedResponseSchemaCommentSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    data: CommentSchema = Field(..., description='Actual Data', title='Data')


class PaginationRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    limit: Optional[int] = Field(None, description='Limit', title='Limit')
    nextPage: Optional[str] = Field(
        None, description='Starting after', title='NextPage'
    )


class PaginationResponseSchema(BaseModel):
    limit: Optional[int] = Field(-1, description='Limit', title='Limit')
    hasMore: Optional[bool] = Field(
        None, description='Has more? `true` or `false`.', title='HasMore'
    )
    nextPage: Optional[str] = Field(
        None, description='Starting after', title='NextPage'
    )


class PermissionsExpansion(Enum):
    reviewer_user = 'reviewer.user'


class PolicySchema(BaseModel):
    id: str = Field(..., description='Unique id of policy.', title='Id')
    name: str = Field(..., description='Name of policy.', title='Name')
    templateId: str = Field(..., description='Template ID', title='Templateid')


class ReviewStatus(Enum):
    pending = 'pending'
    completed = 'completed'
    reviewing = 'reviewing'
    notified = 'notified'
    inactive = 'inactive'


class ReviewerExpansion(Enum):
    user = 'user'


class SearchIncidentsSortFields(Enum):
    createdAt = 'createdAt'
    updatedAt = 'updatedAt'
    severity = 'severity'
    status = 'status'
    isResolved = 'isResolved'


class Selection(Enum):
    keep = 'keep'
    revoke = 'revoke'
    null = 'null'


class SortOrder(Enum):
    ASC = 'ASC'
    DESC = 'DESC'


class SortSchemaFieldName(BaseModel):
    class Config:
        extra = Extra.forbid

    fieldName: FieldName = Field(
        ..., description='Sort By Field Name', title='FieldName'
    )
    order: Optional[SortOrder] = Field('ASC', description='Sort Order', title='Order')


class SortSchemaSearchIncidentsSortFields(BaseModel):
    class Config:
        extra = Extra.forbid

    fieldName: SearchIncidentsSortFields = Field(
        ..., description='Sort By Field Name', title='FieldName'
    )
    order: Optional[SortOrder] = Field('ASC', description='Sort Order', title='Order')


class SourceAppSchema(BaseModel):
    id: str = Field(..., description='Unique ID', title='Id')
    name: str = Field(..., description='Name', title='Name')


class UpdateIncidentRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    assigneeId: Optional[str] = Field(
        None,
        description='ID of the entity assigned to this incident.',
        title='Assigneeid',
    )
    status: Optional[IncidentStatus] = Field(
        None,
        description='The status of the incident (Open, InProgress, WaitingForInput, or Closed).',
    )
    severity: Optional[IncidentSeverity] = Field(
        None,
        description='The severity of the incident (Low, Medium, High or Critical).',
    )


class UserSchema(BaseModel):
    userId: str = Field(..., description='Unique ID', title='Userid')
    userFirstName: str = Field(..., description='First Name', title='Userfirstname')
    userLastName: str = Field(..., description='Last Name', title='Userlastname')
    userEmail: str = Field(..., description='Email', title='Useremail')


class ValidationError(BaseModel):
    loc: List[str] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class AicpaTsc2017(BaseModel):
    values: List[AicpaTsc2017Standard] = Field(..., description='Values')
    id: Optional[str] = Field('aicpaTsc2017', description='UniqueID', title='Id')
    name: Optional[str] = Field('SOC 2 (TSC 2017)', description='Name', title='Name')


class BasicEnumFilterCampaignStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    field_in: Optional[List[CampaignStatus]] = Field(
        None, alias='$in', description='In'
    )


class BasicEnumFilterIncidentSeverity(BaseModel):
    class Config:
        extra = Extra.forbid

    field_in: Optional[List[IncidentSeverity]] = Field(
        None, alias='$in', description='In'
    )


class BasicEnumFilterIncidentStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    field_in: Optional[List[IncidentStatus]] = Field(
        None, alias='$in', description='In'
    )


class BasicEnumFilterSelection(BaseModel):
    class Config:
        extra = Extra.forbid

    field_in: Optional[List[Selection]] = Field(None, alias='$in', description='In')


class CampaignPermissionsSearchFilterBody(BaseModel):
    class Config:
        extra = Extra.forbid

    decision: Optional[BasicEnumFilterSelection] = Field(
        None,
        description='Reviewer decisions (keep, revoke or null).\n',
        title='Decision',
    )


class CampaignSchema(BaseModel):
    id: str = Field(..., description='Unique ID of campaign', title='Id')
    name: str = Field(..., description='Name of the campaign', title='Name')
    status: CampaignStatus = Field(..., description='The campaign status')
    startDate: datetime = Field(
        ..., description='Date when the campaign starts', title='Startdate'
    )
    endDate: datetime = Field(
        ..., description='Date when campaign ends', title='Enddate'
    )
    createdAt: datetime = Field(
        ..., description='Time of creation of campaign', title='Createdat'
    )
    ownerUserId: str = Field(
        ..., description='User ID of the campaign owner', title='Owneruserid'
    )
    owner: Optional[UserSchema] = Field(
        None, description='User Schema of the campaign owner', title='Owner'
    )


class CampaignSearchFilterBody(BaseModel):
    class Config:
        extra = Extra.forbid

    status: Optional[BasicEnumFilterCampaignStatus] = Field(
        None,
        description='Enum: "draft" "initializing" "running" "completed" "failed" "empty" "overdue"\n',
        title='Status',
    )


class Ccm301(BaseModel):
    values: List[Ccm301Standard] = Field(..., description='Values')
    id: Optional[str] = Field('ccm301', description='UniqueID', title='Id')
    name: Optional[str] = Field(
        'CSA STAR (CCM 3.0.1)', description='Name', title='Name'
    )


class Ccm402(BaseModel):
    values: List[Ccm402Standard] = Field(..., description='Values')
    id: Optional[str] = Field('ccm402', description='UniqueID', title='Id')
    name: Optional[str] = Field(
        'CSA STAR (CCM 4.0.2)', description='Name', title='Name'
    )


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class IncidentEntitiesSchema(BaseModel):
    id: str = Field(..., description='Unique id of entity.', title='Id')
    name: Optional[str] = Field(None, description='Name of entity.', title='Name')
    object: Union[InventoryObjects, str] = Field(
        ..., description='Identity | Account | Asset', title='Object'
    )
    email: Optional[str] = Field(None, description='Email', title='Email')
    originId: Optional[str] = Field(None, description='Origin ID', title='Originid')
    originType: Optional[str] = Field(
        None, description='Origin Type', title='Origintype'
    )


class IsoIec27001(BaseModel):
    values: List[IsoIec27001Standard] = Field(..., description='Values')
    id: Optional[str] = Field('isoIec27001', description='UniqueID', title='Id')
    name: Optional[str] = Field('ISO/IEC 27001', description='Name', title='Name')


class NonPaginatedResponseSchemaCampaignSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    data: CampaignSchema = Field(..., description='Actual Data', title='Data')


class PaginatedResponseSchemaCampaignSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    pagination: Optional[PaginationResponseSchema] = Field(
        None, description='Pagination Metadata', title='Pagination'
    )
    data: List[CampaignSchema] = Field(
        ..., description='List of Actual Data', title='Data'
    )


class ReviewerSchema(BaseModel):
    userId: str = Field(..., description='User ID of the Reviewer', title='Userid')
    campaignId: str = Field(..., description='Campaign ID', title='Campaignid')
    lastNotifiedAt: datetime = Field(
        ..., description='Time of last notified', title='Lastnotifiedat'
    )
    lastActiveAt: datetime = Field(
        ..., description='Time of last activity', title='Lastactiveat'
    )
    reviewStatus: Union[ReviewStatus, str] = Field(
        ..., description='Review Status', title='Reviewstatus'
    )
    id: str = Field(..., description='Unique ID', title='Id')
    user: Optional[UserSchema] = Field(
        None, description='User Schema of the reviewer', title='User'
    )


class SearchCampaignPermissionsRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    pagination: Optional[PaginationRequestSchema] = Field(
        None, description='Pagination', title='Pagination'
    )
    filter: Optional[CampaignPermissionsSearchFilterBody] = Field(
        None, description='Filter by the reviewer decisions. \n', title='Filter'
    )
    expand: Optional[List[PermissionsExpansion]] = Field(
        None, description='Fields to expand.\n'
    )


class SearchCampaignsRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    filter: Optional[CampaignSearchFilterBody] = Field(
        None, description='Filter', title='Filter'
    )
    expand: Optional[List[CampaignExpansion]] = Field(None, description='Expand Fields')
    pagination: Optional[PaginationRequestSchema] = Field(
        None, description='Pagination', title='Pagination'
    )
    sort: Optional[List[SortSchemaFieldName]] = Field(
        None, description='Sort', title='Sort'
    )


class SearchIncidentsFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    createdAt: Optional[BaseDateFilter] = Field(
        None, description='Created At date', title='Createdat'
    )
    updatedAt: Optional[BaseDateFilter] = Field(
        None, description='Updated At date', title='Updatedat'
    )
    severity: Optional[BasicEnumFilterIncidentSeverity] = Field(
        None, description='Severity', title='Severity'
    )
    status: Optional[BasicEnumFilterIncidentStatus] = Field(
        None, description='Status', title='Status'
    )
    policyId: Optional[BaseSingleValuedStringFilter] = Field(
        None, description='Policy Id ', title='Policyid'
    )
    policyTemplateId: Optional[BaseSingleValuedStringFilter] = Field(
        None, description='Policy Template ID', title='Policytemplateid'
    )
    isResolved: Optional[BaseBooleanFilter] = Field(
        None, description='Is resolved?', title='Isresolved'
    )


class SearchIncidentsRequestSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    filter: Optional[SearchIncidentsFilter] = Field(
        None, description='Filter', title='Filter'
    )
    expand: Optional[List[IncidentExpansion]] = Field(None, description='Expend')
    sort: Optional[List[SortSchemaSearchIncidentsSortFields]] = Field(
        None, description='Sort', title='Sort'
    )
    pagination: Optional[PaginationRequestSchema] = Field(
        None, description='Pagination', title='Pagination'
    )


class CampaignsPermissionSchema(BaseModel):
    id: str = Field(..., description='Campaign ID (unique). \n', title='Id')
    campaignId: str = Field(
        ..., description='ID of the Campaign.\n', title='Campaignid'
    )
    reviewerId: str = Field(..., description='Reviewer ID', title='Reviewerid')
    reviewer: Optional[ReviewerSchema] = Field(
        None, description='Details of the reviewer.\n', title='Reviewer'
    )
    accessById: str = Field(
        ...,
        description='Access by ID (Account or Grouping ID) that their access was reviewed. \n',
        title='Accessbyid',
    )
    accessByType: AccessByType = Field(
        ...,
        description='Type of entity that was reviewed, can be Account or Grouping.\n',
    )
    accessToId: str = Field(
        ...,
        description='Access to ID (Asset or Grouping ID) that the access to was reviewed, for example a database the access to was reviewed.  \n',
        title='Accesstoid',
    )
    accessToType: AccessToType = Field(
        ..., description='Assets or grouping that the access to was reviewed.  \n'
    )
    privilegeId: str = Field(
        ...,
        description='ID of the privileges that was reviewed. \n',
        title='Privilegeid',
    )
    decision: Optional[Selection] = Field(
        None, description='Reviewer decisions (keep, revoke or null).\n'
    )
    decisionReason: Optional[str] = Field(
        None,
        description='Reviewer decision for keeping or revoking the reviewed access.  \n',
        title='Decisionreason',
    )


class IncidentSchema(BaseModel):
    id: str = Field(..., description='Unique id', title='Id')
    createdAt: Optional[datetime] = Field(
        None, description='The date the incident was first reported.', title='Createdat'
    )
    updatedAt: Optional[datetime] = Field(
        None, description='The date the incident was last updated.', title='Updatedat'
    )
    entities: Optional[List[IncidentEntitiesSchema]] = Field(
        [], description='Entity', title='Entities'
    )
    apps: Optional[List[SourceAppSchema]] = Field(
        [], description='Applications', title='Apps'
    )
    category: Optional[AlertCategoryType] = Field(None, description='Category')
    tactics: Optional[List[AttackTacticType]] = Field([], description='Tactics')
    compliance: Optional[
        List[Union[IsoIec27001, AicpaTsc2017, Ccm402, Ccm301, Cisv8]]
    ] = Field([], description='Compliance', title='Compliance')
    techniques: Optional[List[str]] = Field(
        [], description='Techniques', title='Techniques'
    )
    status: Optional[IncidentStatus] = Field(
        None,
        description='The status of the incident (Open, In Progress, Waiting for Input, or Closed)',
    )
    severity: IncidentSeverity = Field(
        ..., description='The severity of the incident (Low, Medium, High or Critical).'
    )
    policyId: str = Field(..., description='Unique id of policy.', title='Policyid')
    policy: Optional[PolicySchema] = Field(None, description='Policy', title='Policy')
    assigneeId: Optional[str] = Field(
        None, description='Unique id of assignee.', title='Assigneeid'
    )
    assignee: Optional[UserSchema] = Field(
        None, description='Assignee', title='Assignee'
    )
    recommendation: Optional[str] = Field(
        None, description='Recommendation', title='Recommendation'
    )
    description: Optional[str] = Field(
        None, description='Description', title='Description'
    )
    isResolved: bool = Field(..., description='Is Resolved?', title='Isresolved')
    url: str = Field(..., description='URL', title='Url')


class NonPaginatedResponseSchemaIncidentSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    data: IncidentSchema = Field(..., description='Actual Data', title='Data')


class NonPaginatedResponseSchemaReviewerSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    data: ReviewerSchema = Field(..., description='Actual Data', title='Data')


class PaginatedResponseSchemaCampaignsPermissionSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    pagination: Optional[PaginationResponseSchema] = Field(
        None, description='Pagination Metadata', title='Pagination'
    )
    data: List[CampaignsPermissionSchema] = Field(
        ..., description='List of Actual Data', title='Data'
    )


class PaginatedResponseSchemaIncidentSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    pagination: Optional[PaginationResponseSchema] = Field(
        None, description='Pagination Metadata', title='Pagination'
    )
    data: List[IncidentSchema] = Field(
        ..., description='List of Actual Data', title='Data'
    )
