# Generated by Django 3.2.5 on 2021-07-28 15:46

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tagging.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('entities', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('files', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CaseStudy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=150)),
                ('owner_username', models.CharField(max_length=150)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('client', models.CharField(max_length=75)),
                ('website', models.URLField(max_length=150)),
                ('slug', models.SlugField(max_length=100)),
                ('overview', models.TextField(blank=True, null=True)),
                ('execution', models.TextField(blank=True, null=True)),
                ('results', models.TextField(blank=True, null=True)),
                ('tags', tagging.fields.TagField(blank=True, help_text='Tags separated by commas. E.g Tag1, Tag2, Tag3', max_length=255)),
                ('creator', models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='case_studies_casestudy_creator', to=settings.AUTH_USER_MODEL)),
                ('entity', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='case_studies_casestudy_entity', to='entities.entity')),
                ('owner', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='case_studies_casestudy_owner', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Case Study',
                'verbose_name_plural': 'Case Studies',
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='Technology',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'verbose_name': 'Technology',
                'verbose_name_plural': 'Technologies',
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('file_ptr', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='case_studies_image_related', serialize=False, to='files.file')),
                ('file_type', models.CharField(choices=[('featured', 'Featured Screenshot'), ('screenshot', 'Screenshot'), ('homepage', 'Homepage Image'), ('other', 'Other')], default='other', max_length=50, verbose_name='File type')),
                ('position', models.IntegerField(blank=True)),
                ('case_study', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='case_studies.casestudy')),
            ],
            options={
                'ordering': ('position',),
            },
            bases=('files.file',),
        ),
    ]
