# Generated by Django 2.2.14 on 2020-07-31 15:11

import uuid
from django.db import migrations

def assign_entity_to_directory(apps, schema_editor):
    """
    The entity field will be altered to a OneToOneField in the next migration.
    Before it can be a OneToOneField, we need to handle the data in the existing
    directories_directory table.
    """
    Entity = apps.get_model("entities", "Entity")
    # make sure we pick the first one with the lowest id
    default_entity_parent = Entity.objects.all().order_by('id').first()
    Directory = apps.get_model("directories", "Directory")
    for directory in Directory.objects.all():
        entity = directory.entity
        if entity:
            if Directory.objects.filter(entity=entity).exclude(id=directory.id).exists():
                # create an entity for this directory to make entity unique in the directories
                params = {'entity_name': '{name} (Directory ID: {id})'.format(name=directory.headline, id=directory.id),
                          'entity_type': 'Directory',
                          'entity_parent': default_entity_parent,
                          'guid': str(uuid.uuid4()),
                          'contact_name': '{first_name} {last_name}'.format(first_name=directory.first_name, last_name=directory.last_name),
                          'phone': directory.phone,
                          'email': directory.email,
                          'fax': directory.fax,
                          'website': directory.website,
                          'summary': '',
                          'notes': '',
                          'admin_notes': 'system auto created',
                          'allow_anonymous_view': directory.allow_anonymous_view,
                          'allow_user_view': directory.allow_user_view,
                          'allow_member_view': directory.allow_member_view,
                          'creator': directory.creator,
                          'creator_username': directory.creator_username,
                          'owner': directory.owner,
                          'owner_username': directory.owner_username
                          }
                new_entity = Entity.objects.create(**params)
                Directory.objects.filter(id=directory.id).update(entity=new_entity)
            

class Migration(migrations.Migration):

    dependencies = [
        ('directories', '0010_directory_region'),
    ]

    operations = [
        migrations.RunPython(assign_entity_to_directory),
    ]
