# Generated by Django 2.2.17 on 2020-12-03 22:19

from django.db import migrations


def convert_pickled_query(apps, schema_editor):
    """
    Convert saved queries in SavedSearch from pickle serialized to json dumped string.
    """
    import pickle
    import simplejson
    from base64 import b64decode
    from base64 import b64encode

    SavedSearch = apps.get_model("helpdesk", "SavedSearch")
    for saved_search in SavedSearch.objects.all():
        query = saved_search.query
        query = pickle.loads(b64decode(str(query).encode()))
        query = b64encode(bytes(simplejson.dumps(query), encoding='utf-8')).decode('utf-8')
        saved_search.query = query
        saved_search.save()
    

class Migration(migrations.Migration):

    dependencies = [
        ('helpdesk', '0011_auto_20200905_1843'),
    ]

    operations = [
        migrations.RunPython(convert_pickled_query),
    ]
