(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main"],{

/***/ "/ARz":
/*!************************************************************!*\
  !*** ./src/app/user-list-item/user-list-item.component.ts ***!
  \************************************************************/
/*! exports provided: UserListItemComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UserListItemComponent", function() { return UserListItemComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_user_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./user-list-item.component.html */ "MsHb");
/* harmony import */ var _user_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./user-list-item.component.less */ "I94c");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../confirmer.service */ "c41A");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ "kU1M");







var UserListItemComponent = /** @class */ (function () {
    function UserListItemComponent(api, confirmer) {
        this.api = api;
        this.confirmer = confirmer;
        this._level = '';
    }
    UserListItemComponent.prototype.ngOnInit = function () {
        this._level = this.item.level + '';
    };
    Object.defineProperty(UserListItemComponent.prototype, "level", {
        get: function () {
            return this._level;
        },
        set: function (value) {
            this._level = value;
            this.item.level = parseInt(value, 10);
            this.api.updateUser(this.item)
                .subscribe(function (result) {
                console.log('UPDATED', result);
            });
        },
        enumerable: false,
        configurable: true
    });
    UserListItemComponent.prototype.delete = function (e) {
        var _this = this;
        this.confirmer.confirm(this.confirmer.ACTION_DELETE_USER, this.item.email)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["filter"])(function (x) { return x; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function () { return _this.api.deleteUser(_this.item.id); })).subscribe(function (result) {
            console.log('DELETED USER', result);
        });
        e.preventDefault();
        return false;
    };
    UserListItemComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] },
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_5__["ConfirmerService"] }
    ]; };
    UserListItemComponent.propDecorators = {
        item: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    UserListItemComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-user-list-item',
            template: _raw_loader_user_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_user_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"], _confirmer_service__WEBPACK_IMPORTED_MODULE_5__["ConfirmerService"]])
    ], UserListItemComponent);
    return UserListItemComponent;
}());



/***/ }),

/***/ "/ZFW":
/*!******************************************************!*\
  !*** ./src/app/taxonomies/taxonomies.component.less ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .add-new {\n  margin-top: 40px;\n  margin-bottom: 100px;\n}\n:host .add-new .formish {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n}\n:host .add-new .formish > * {\n  margin: 0 8px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvdGF4b25vbWllcy90YXhvbm9taWVzLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC90YXhvbm9taWVzL3RheG9ub21pZXMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFUSxnQkFBQTtFQUNBLG9CQUFBO0FDQVI7QURIQTtFQU1ZLGFBQUE7RUFDQSxjQUFBO0VBQ0EsbUJBQUE7QUNBWjtBRFJBO0VBV2dCLGFBQUE7QUNBaEIiLCJmaWxlIjoic3JjL2FwcC90YXhvbm9taWVzL3RheG9ub21pZXMuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgLmFkZC1uZXcge1xuICAgICAgICBtYXJnaW4tdG9wOiA0MHB4O1xuICAgICAgICBtYXJnaW4tYm90dG9tOiAxMDBweDtcblxuICAgICAgICAuZm9ybWlzaCB7XG4gICAgICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICAgICAgZmxleC1mbG93OiByb3c7XG4gICAgICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuXG4gICAgICAgICAgICA+ICoge1xuICAgICAgICAgICAgICAgIG1hcmdpbjogMCA4cHg7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG59IiwiOmhvc3QgLmFkZC1uZXcge1xuICBtYXJnaW4tdG9wOiA0MHB4O1xuICBtYXJnaW4tYm90dG9tOiAxMDBweDtcbn1cbjpob3N0IC5hZGQtbmV3IC5mb3JtaXNoIHtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1mbG93OiByb3c7XG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG59XG46aG9zdCAuYWRkLW5ldyAuZm9ybWlzaCA+ICoge1xuICBtYXJnaW46IDAgOHB4O1xufVxuIl19 */");

/***/ }),

/***/ 0:
/*!***************************!*\
  !*** multi ./src/main.ts ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /Users/adam/Code/datariver/dgp/dgp-app/ui/src/main.ts */"zUnb");


/***/ }),

/***/ "0mIb":
/*!************************************************************************!*\
  !*** ./src/app/results-tab-selector/results-tab-selector.component.ts ***!
  \************************************************************************/
/*! exports provided: ResultsTabSelectorComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResultsTabSelectorComponent", function() { return ResultsTabSelectorComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_results_tab_selector_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./results-tab-selector.component.html */ "rGKi");
/* harmony import */ var _results_tab_selector_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./results-tab-selector.component.less */ "E81H");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var ResultsTabSelectorComponent = /** @class */ (function () {
    function ResultsTabSelectorComponent() {
        this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
    }
    ResultsTabSelectorComponent.prototype.ngOnInit = function () {
    };
    Object.defineProperty(ResultsTabSelectorComponent.prototype, "state", {
        get: function () {
            var ret = 'unknown';
            if (this.table.errors && this.table.errors.length > 0) {
                ret = 'fail';
            }
            else if (this.table.valid) {
                ret = 'success';
            }
            else if (this.table.progress) {
                ret = 'progress';
            }
            return ret;
        },
        enumerable: false,
        configurable: true
    });
    ResultsTabSelectorComponent.ctorParameters = function () { return []; };
    ResultsTabSelectorComponent.propDecorators = {
        table: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        label: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        active: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        select: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    ResultsTabSelectorComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-results-tab-selector',
            template: _raw_loader_results_tab_selector_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_results_tab_selector_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ResultsTabSelectorComponent);
    return ResultsTabSelectorComponent;
}());



/***/ }),

/***/ "1Gxh":
/*!****************************************************************************!*\
  !*** ./src/app/step-extract-structure/step-extract-structure.component.ts ***!
  \****************************************************************************/
/*! exports provided: StepExtractStructureComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepExtractStructureComponent", function() { return StepExtractStructureComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_extract_structure_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-extract-structure.component.html */ "tJ4o");
/* harmony import */ var _step_extract_structure_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-extract-structure.component.less */ "Xtub");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var StepExtractStructureComponent = /** @class */ (function () {
    function StepExtractStructureComponent() {
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
    }
    StepExtractStructureComponent.prototype.ngOnInit = function () {
    };
    StepExtractStructureComponent.prototype.changed = function () {
        this.change.emit();
    };
    StepExtractStructureComponent.ctorParameters = function () { return []; };
    StepExtractStructureComponent.propDecorators = {
        structure: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        change: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    StepExtractStructureComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-extract-structure',
            template: _raw_loader_step_extract_structure_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_extract_structure_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], StepExtractStructureComponent);
    return StepExtractStructureComponent;
}());



/***/ }),

/***/ "1aDE":
/*!****************************************************!*\
  !*** ./src/app/confirmer/confirmer.component.less ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .modal-bg,\n:host .modal-wrapper {\n  position: fixed;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n}\n:host .modal-bg {\n  background-color: rgba(0, 0, 0, 0.8);\n}\n:host .modal-wrapper {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  justify-content: center;\n}\n:host .modal-wrapper .modal {\n  background-color: white;\n  border: 1px solid black;\n  border-radius: 4px;\n  padding: 20px;\n  font-size: 18px;\n  font-weight: bold;\n}\n:host .modal-wrapper .modal .modal-buttons {\n  margin-top: 20px;\n  display: flex;\n  flex-flow: row;\n  justify-content: space-evenly;\n  align-items: center;\n}\n:host .modal-wrapper .modal .modal-buttons .modal-button {\n  cursor: pointer;\n  padding: 4px 10px;\n  border: 1px solid black;\n  border-radius: 4px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "1jOV":
/*!************************************************************!*\
  !*** ./src/app/file-list-item/file-list-item.component.ts ***!
  \************************************************************/
/*! exports provided: FileListItemComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FileListItemComponent", function() { return FileListItemComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_file_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./file-list-item.component.html */ "UTD6");
/* harmony import */ var _file_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./file-list-item.component.less */ "IXcg");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../confirmer.service */ "c41A");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ "kU1M");









var FileListItemComponent = /** @class */ (function () {
    function FileListItemComponent(auth, roles, api, confirmer) {
        var _this = this;
        this.auth = auth;
        this.roles = roles;
        this.api = api;
        this.confirmer = confirmer;
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.auth.getUser().subscribe(function (user) {
            _this.userId = user.profile.id;
        });
    }
    Object.defineProperty(FileListItemComponent.prototype, "size", {
        get: function () {
            var size = this.item.size;
            var suffix = '';
            if (size > 1000) {
                size = size / 1000;
                suffix = ' KB';
            }
            if (size > 1000) {
                size = size / 1000;
                suffix = ' MB';
            }
            if (size > 1000) {
                size = size / 1000;
                suffix = ' GB';
            }
            return size.toFixed(2) + suffix;
        },
        enumerable: false,
        configurable: true
    });
    FileListItemComponent.prototype.ngOnInit = function () {
    };
    FileListItemComponent.prototype.updateable = function () {
        return this.roles._.filesUpdateAll || (this.roles._.filesUpdateOwn && this.item.owner_id === this.userId);
    };
    FileListItemComponent.prototype.deletable = function () {
        return this.roles._.filesDeleteAll || (this.roles._.filesDeleteOwn && this.item.owner_id === this.userId);
    };
    FileListItemComponent.prototype.delete = function () {
        var _this = this;
        this.confirmer.confirm(this.confirmer.ACTION_DELETE_FILE, this.item.filename)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_8__["filter"])(function (x) { return x; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_8__["switchMap"])(function () { return _this.api.deleteFile(_this.item.filename); })).subscribe(function (result) {
            console.log('deleted', result);
            _this.api.queryFiles();
        });
    };
    FileListItemComponent.prototype.requestUpdate = function () {
        this.update.emit();
    };
    FileListItemComponent.ctorParameters = function () { return [
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"] },
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_7__["ConfirmerService"] }
    ]; };
    FileListItemComponent.propDecorators = {
        item: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        update: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    FileListItemComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-file-list-item',
            template: _raw_loader_file_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_file_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"], _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"],
            _api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"], _confirmer_service__WEBPACK_IMPORTED_MODULE_7__["ConfirmerService"]])
    ], FileListItemComponent);
    return FileListItemComponent;
}());



/***/ }),

/***/ "1tCB":
/*!******************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/confirmer/confirmer.component.html ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='srv.active'>\n  <div class='modal-bg'></div>\n  <div class='modal-wrapper'>\n    <div class='modal theme-primary-border'>\n      <div class='message theme-primary-fg'>\n        <span i18n>Would you really like to</span>\n        <span i18n *ngIf='srv.action === srv.ACTION_DELETE_USER'>&nbsp;delete the user&nbsp;</span>\n        <span i18n *ngIf='srv.action === srv.ACTION_DELETE_TASK'>&nbsp;delete the task&nbsp;</span>\n        <span i18n *ngIf='srv.action === srv.ACTION_DELETE_FILE'>&nbsp;delete the file&nbsp;</span>\n        <span>\"{{srv.what}}\"</span>?\n        <div class='modal-buttons'>\n          <a class='modal-button theme-secondary-bg theme-primary-fg' (click)='srv.choose(false)' i18n>Cancel</a>\n          <a class='modal-button theme-primary-bg theme-secondary-fg' (click)='srv.choose(true)' i18n>Confirm</a>\n        </div>\n      </div>\n    </div>\n  </div>\n</ng-container>        ");

/***/ }),

/***/ "2m28":
/*!************************************************************!*\
  !*** ./src/app/step-taxonomy/step-taxonomy.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3N0ZXAtdGF4b25vbXkvc3RlcC10YXhvbm9teS5jb21wb25lbnQubGVzcyJ9 */");

/***/ }),

/***/ "3YVL":
/*!**************************************************************************!*\
  !*** ./src/app/step-flipped-mapping/step-flipped-mapping.component.less ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .unpivot-info {\n  margin: 8px 0;\n}\n:host table.unpivot {\n  border-collapse: collapse;\n}\n:host table.unpivot th,\n:host table.unpivot td {\n  text-align: left;\n  padding: 0 8px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvc3RlcC1mbGlwcGVkLW1hcHBpbmcvc3RlcC1mbGlwcGVkLW1hcHBpbmcuY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL3N0ZXAtZmxpcHBlZC1tYXBwaW5nL3N0ZXAtZmxpcHBlZC1tYXBwaW5nLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRVEsYUFBQTtBQ0FSO0FERkE7RUFLUSx5QkFBQTtBQ0FSO0FETEE7O0VBUVksZ0JBQUE7RUFDQSxjQUFBO0FDQ1oiLCJmaWxlIjoic3JjL2FwcC9zdGVwLWZsaXBwZWQtbWFwcGluZy9zdGVwLWZsaXBwZWQtbWFwcGluZy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICAudW5waXZvdC1pbmZvIHtcbiAgICAgICAgbWFyZ2luOiA4cHggMDtcbiAgICB9XG4gICAgdGFibGUudW5waXZvdCB7XG4gICAgICAgIGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2U7XG5cbiAgICAgICAgdGgsIHRkIHtcbiAgICAgICAgICAgIHRleHQtYWxpZ246IGxlZnQ7XG4gICAgICAgICAgICBwYWRkaW5nOiAwIDhweDtcbiAgICAgICAgfSBcbiAgICB9XG59IiwiOmhvc3QgLnVucGl2b3QtaW5mbyB7XG4gIG1hcmdpbjogOHB4IDA7XG59XG46aG9zdCB0YWJsZS51bnBpdm90IHtcbiAgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZTtcbn1cbjpob3N0IHRhYmxlLnVucGl2b3QgdGgsXG46aG9zdCB0YWJsZS51bnBpdm90IHRkIHtcbiAgdGV4dC1hbGlnbjogbGVmdDtcbiAgcGFkZGluZzogMCA4cHg7XG59XG4iXX0= */");

/***/ }),

/***/ "3d/c":
/*!************************************************!*\
  !*** ./src/app/results/results.component.less ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".results {\n  width: 100%;\n  flex: 0 0 auto;\n  background-color: #fff;\n}\n.results .tab-selectors {\n  display: flex;\n  flex-flow: row;\n  align-items: stretch;\n}\n.results:not(.visible),\napp-result-table:not(.visible),\n.tab-selectors:not(.visible) {\n  display: none;\n}\n.failure {\n  font-family: monospace;\n  color: salmon;\n  margin: 10px 0;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvcmVzdWx0cy9yZXN1bHRzLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9yZXN1bHRzL3Jlc3VsdHMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxXQUFBO0VBQ0EsY0FBQTtFQUNBLHNCQUFBO0FDQ0o7QURKQTtFQU1RLGFBQUE7RUFDQSxjQUFBO0VBQ0Esb0JBQUE7QUNDUjtBRElJOzs7RUFDSSxhQUFBO0FDQVI7QURJQTtFQUNJLHNCQUFBO0VBQ0EsYUFBQTtFQUNBLGNBQUE7QUNGSiIsImZpbGUiOiJzcmMvYXBwL3Jlc3VsdHMvcmVzdWx0cy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIi5yZXN1bHRzIHtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBmbGV4OiAwIDAgYXV0bztcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjZmZmO1xuXG4gICAgLnRhYi1zZWxlY3RvcnMge1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWZsb3c6IHJvdztcbiAgICAgICAgYWxpZ24taXRlbXM6IHN0cmV0Y2g7XG4gICAgfVxufVxuXG4ucmVzdWx0cywgYXBwLXJlc3VsdC10YWJsZSwgLnRhYi1zZWxlY3RvcnMge1xuICAgICY6bm90KC52aXNpYmxlKSB7XG4gICAgICAgIGRpc3BsYXk6IG5vbmU7XG4gICAgfVxufVxuXG4uZmFpbHVyZSB7XG4gICAgZm9udC1mYW1pbHk6IG1vbm9zcGFjZTtcbiAgICBjb2xvcjogc2FsbW9uO1xuICAgIG1hcmdpbjogMTBweCAwO1xufSIsIi5yZXN1bHRzIHtcbiAgd2lkdGg6IDEwMCU7XG4gIGZsZXg6IDAgMCBhdXRvO1xuICBiYWNrZ3JvdW5kLWNvbG9yOiAjZmZmO1xufVxuLnJlc3VsdHMgLnRhYi1zZWxlY3RvcnMge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IHJvdztcbiAgYWxpZ24taXRlbXM6IHN0cmV0Y2g7XG59XG4ucmVzdWx0czpub3QoLnZpc2libGUpLFxuYXBwLXJlc3VsdC10YWJsZTpub3QoLnZpc2libGUpLFxuLnRhYi1zZWxlY3RvcnM6bm90KC52aXNpYmxlKSB7XG4gIGRpc3BsYXk6IG5vbmU7XG59XG4uZmFpbHVyZSB7XG4gIGZvbnQtZmFtaWx5OiBtb25vc3BhY2U7XG4gIGNvbG9yOiBzYWxtb247XG4gIG1hcmdpbjogMTBweCAwO1xufVxuIl19 */");

/***/ }),

/***/ "4cWX":
/*!********************************************************************!*\
  !*** ./src/app/step-mapping-field/step-mapping-field.component.ts ***!
  \********************************************************************/
/*! exports provided: StepMappingFieldComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepMappingFieldComponent", function() { return StepMappingFieldComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_mapping_field_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-mapping-field.component.html */ "a3Je");
/* harmony import */ var _step_mapping_field_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-mapping-field.component.less */ "IFHQ");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");





var StepMappingFieldComponent = /** @class */ (function () {
    function StepMappingFieldComponent(api) {
        this.api = api;
        this.objectKeys = Object.keys;
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.more = false;
        this.ct = null;
    }
    StepMappingFieldComponent.prototype.ngOnInit = function () {
        this.mapping.options = this.mapping.options || {};
        this.updateOwnCt();
    };
    StepMappingFieldComponent.prototype.changed = function () {
        this.change.emit();
    };
    Object.defineProperty(StepMappingFieldComponent.prototype, "hasErrors", {
        get: function () {
            return this.sample && this.sample.length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StepMappingFieldComponent.prototype, "trueValues", {
        get: function () {
            if (this.mapping.options.trueValues && Array.isArray(this.mapping.options.trueValues)) {
                return this.mapping.options.trueValues.join(',');
            }
            return null;
        },
        set: function (values) {
            this.mapping.options.trueValues = values.split(',');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StepMappingFieldComponent.prototype, "falseValues", {
        get: function () {
            if (this.mapping.options.falseValues && Array.isArray(this.mapping.options.falseValues)) {
                return this.mapping.options.falseValues.join(',');
            }
            return null;
        },
        set: function (values) {
            this.mapping.options.falseValues = values.split(',');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StepMappingFieldComponent.prototype, "compound", {
        get: function () {
            return !!this.mapping.normalize;
        },
        set: function (value) {
            if (value) {
                delete this.mapping['columnType'];
                this.mapping['normalize'] = {};
                this.mapping['normalizeTarget'] = '';
            }
            else {
                delete this.mapping['normalize'];
                delete this.mapping['normalizeTarget'];
                this.mapping['columnType'] = '';
            }
        },
        enumerable: false,
        configurable: true
    });
    StepMappingFieldComponent.prototype.updateOwnCt = function () {
        var ctName = this.mapping.columnType;
        for (var _i = 0, _a = this.taxonomy.columnTypes; _i < _a.length; _i++) {
            var ct = _a[_i];
            if (ct.name === ctName) {
                this.ct = ct;
                this.ct.options = this.ct.options || {};
                if (this.ct.dataType === 'date') {
                    this.mapping.options.format = this.mapping.options.format || 'default';
                }
                else if (this.ct.dataType === 'boolean') {
                    this.mapping.options.trueValues = this.mapping.options.trueValues ||
                        this.ct.options.trueValues || ['true', 'True', 'TRUE', '1'];
                    this.mapping.options.falseValues = this.mapping.options.falseValues ||
                        this.ct.options.falseValues || ['false', 'False', 'FALSE', '0'];
                }
                else if (this.ct.dataType === 'number') {
                    this.mapping.options.decimalChar = this.mapping.options.decimalChar || this.ct.options.decimalChar || '.';
                    this.mapping.options.groupChar = this.mapping.options.groupChar || this.ct.options.groupChar || '';
                    this.mapping.options.bareNumber = this.mapping.options.bareNumber === undefined ? true : this.mapping.options.bareNumber;
                }
                else if (this.ct.dataType === 'integer') {
                    this.mapping.options.bareNumber = this.mapping.options.bareNumber === undefined ? true : this.mapping.options.bareNumber;
                }
                return;
            }
        }
        this.ct = null;
    };
    StepMappingFieldComponent.prototype.updateMapping = function (ctName) {
        if (ctName !== 'null') {
            this.mapping.columnType = ctName;
            for (var _i = 0, _a = this.taxonomy.columnTypes; _i < _a.length; _i++) {
                var ct = _a[_i];
                if (ct.name === ctName) {
                    if (!this.mapping.title) {
                        this.mapping.title = ct.title;
                    }
                    this.mapping.description = ct.description;
                    break;
                }
            }
        }
        else {
            delete this.mapping['columnType'];
        }
        this.updateOwnCt();
        this.changed();
    };
    StepMappingFieldComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    StepMappingFieldComponent.propDecorators = {
        mapping: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        taxonomy: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        sample: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        change: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    StepMappingFieldComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-mapping-field',
            template: _raw_loader_step_mapping_field_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_mapping_field_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], StepMappingFieldComponent);
    return StepMappingFieldComponent;
}());



/***/ }),

/***/ "4gMr":
/*!************************************************************!*\
  !*** ./src/app/edit-pipeline/edit-pipeline.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .field-description {\n  font-size: 12px;\n  margin: 0;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZWRpdC1waXBlbGluZS9lZGl0LXBpcGVsaW5lLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9lZGl0LXBpcGVsaW5lL2VkaXQtcGlwZWxpbmUuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFUSxlQUFBO0VBQ0EsU0FBQTtBQ0FSIiwiZmlsZSI6InNyYy9hcHAvZWRpdC1waXBlbGluZS9lZGl0LXBpcGVsaW5lLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIC5maWVsZC1kZXNjcmlwdGlvbiB7XG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcbiAgICAgICAgbWFyZ2luOiAwO1xuICAgIH1cbn0iLCI6aG9zdCAuZmllbGQtZGVzY3JpcHRpb24ge1xuICBmb250LXNpemU6IDEycHg7XG4gIG1hcmdpbjogMDtcbn1cbiJdfQ== */");

/***/ }),

/***/ "6bTb":
/*!****************************************************************************!*\
  !*** ./src/app/pipeline-list-section/pipeline-list-section.component.less ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("h2 {\n  font-size: 18px;\n  padding: 0 16px;\n  margin-bottom: 4px;\n}\nh2 i {\n  cursor: pointer;\n  width: 16px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvcGlwZWxpbmUtbGlzdC1zZWN0aW9uL3BpcGVsaW5lLWxpc3Qtc2VjdGlvbi5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvcGlwZWxpbmUtbGlzdC1zZWN0aW9uL3BpcGVsaW5lLWxpc3Qtc2VjdGlvbi5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGVBQUE7RUFDQSxlQUFBO0VBQ0Esa0JBQUE7QUNDSjtBREpBO0VBTVEsZUFBQTtFQUNBLFdBQUE7QUNDUiIsImZpbGUiOiJzcmMvYXBwL3BpcGVsaW5lLWxpc3Qtc2VjdGlvbi9waXBlbGluZS1saXN0LXNlY3Rpb24uY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyJoMiB7XG4gICAgZm9udC1zaXplOiAxOHB4O1xuICAgIHBhZGRpbmc6IDAgMTZweDtcbiAgICBtYXJnaW4tYm90dG9tOiA0cHg7XG5cbiAgICBpIHtcbiAgICAgICAgY3Vyc29yOiBwb2ludGVyO1xuICAgICAgICB3aWR0aDogMTZweDtcbiAgICB9XG59IiwiaDIge1xuICBmb250LXNpemU6IDE4cHg7XG4gIHBhZGRpbmc6IDAgMTZweDtcbiAgbWFyZ2luLWJvdHRvbTogNHB4O1xufVxuaDIgaSB7XG4gIGN1cnNvcjogcG9pbnRlcjtcbiAgd2lkdGg6IDE2cHg7XG59XG4iXX0= */");

/***/ }),

/***/ "7YSA":
/*!**************************************************************!*\
  !*** ./src/app/failure-marquee/failure-marquee.component.ts ***!
  \**************************************************************/
/*! exports provided: FailureMarqueeComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FailureMarqueeComponent", function() { return FailureMarqueeComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_failure_marquee_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./failure-marquee.component.html */ "G2WK");
/* harmony import */ var _failure_marquee_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./failure-marquee.component.less */ "pfSI");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var FailureMarqueeComponent = /** @class */ (function () {
    function FailureMarqueeComponent(store) {
        this.store = store;
        this.error = null;
    }
    FailureMarqueeComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.store.getFailure().subscribe(function (failure) {
            _this.error = failure;
        });
    };
    FailureMarqueeComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    FailureMarqueeComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-failure-marquee',
            template: _raw_loader_failure_marquee_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_failure_marquee_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], FailureMarqueeComponent);
    return FailureMarqueeComponent;
}());



/***/ }),

/***/ "7j6H":
/*!**************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/results/results.component.html ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='results' [class.visible]='hasResults || failureMain'>\n    <h2 class='workbench-subtitle' i18n>Data Sample</h2>\n\n    <div class='failure' *ngIf='failureMain'>{{ failureMain }}</div>\n    <ng-container *ngIf='analysisErrors && analysisErrors.length > 0'>\n        <div class='failure' *ngFor='let error of analysisErrors'>\n            {{error}}\n        </div>\n    </ng-container>\n    <ng-container *ngIf='errors && errors.length > 0'>\n        <div class='failure' *ngFor='let error of errors'>\n            {{error}}\n        </div>\n    </ng-container>\n\n    <div class='tab-selectors' [class.visible]='hasResults'>\n        <app-results-tab-selector [table]='TABLES[0]' [active]='step === TABLES[0].slug' (select)='step = TABLES[0].slug' label='Original Data' i18n-label></app-results-tab-selector>\n        <app-results-tab-selector [table]='TABLES[1]' [active]='step === TABLES[1].slug' (select)='step = TABLES[1].slug' label='Mapped Data' i18n-label></app-results-tab-selector>\n        <app-results-tab-selector [table]='TABLES[2]' [active]='step === TABLES[2].slug' (select)='step = TABLES[2].slug' label='Transformed Data' i18n-label></app-results-tab-selector>\n    </div>\n\n    <app-result-table\n        *ngFor='let table of TABLES; let i = index'\n        [kind]='i' [hidden]='step!==table.slug'\n        [kindName]='table.slug'\n        [class.visible]='hasResults && step === table.slug'\n    ></app-result-table>\n</div>");

/***/ }),

/***/ "86H0":
/*!******************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/container/container.component.html ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-header></app-header>\n<div class='container'>\n<ng-content></ng-content>\n</div>");

/***/ }),

/***/ "8KsV":
/*!**************************************************************************************!*\
  !*** ./src/app/step-flipped-mapping-field/step-flipped-mapping-field.component.less ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: column;\n  padding: 0 8px;\n}\n:host .description {\n  font-size: 14px;\n  max-width: 70%;\n}\n:host .constant {\n  display: flex;\n  flex-flow: row;\n  margin-left: 40px;\n  align-items: center;\n}\n:host .constant input {\n  margin-left: 16px;\n}\n:host .formish label {\n  margin: 0;\n}\n:host .expander {\n  font-size: 14px;\n  color: #059;\n  margin-bottom: 10px;\n  display: block;\n}\n:host .options {\n  display: flex;\n  flex-flow: row;\n}\n:host .options > * {\n  flex: 0 1 50%;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvc3RlcC1mbGlwcGVkLW1hcHBpbmctZmllbGQvc3RlcC1mbGlwcGVkLW1hcHBpbmctZmllbGQuY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL3N0ZXAtZmxpcHBlZC1tYXBwaW5nLWZpZWxkL3N0ZXAtZmxpcHBlZC1tYXBwaW5nLWZpZWxkLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLGlCQUFBO0VBQ0EsY0FBQTtBQ0NKO0FESkE7RUFNUSxlQUFBO0VBQ0EsY0FBQTtBQ0NSO0FEUkE7RUFXUSxhQUFBO0VBQ0EsY0FBQTtFQUNBLGlCQUFBO0VBQ0EsbUJBQUE7QUNBUjtBRGRBO0VBaUJZLGlCQUFBO0FDQVo7QURqQkE7RUFzQlEsU0FBQTtBQ0ZSO0FEcEJBO0VBMEJRLGVBQUE7RUFDQSxXQUFBO0VBQ0EsbUJBQUE7RUFDQSxjQUFBO0FDSFI7QUQxQkE7RUFpQ1EsYUFBQTtFQUNBLGNBQUE7QUNKUjtBREtRO0VBQ0ksYUFBQTtBQ0haIiwiZmlsZSI6InNyYy9hcHAvc3RlcC1mbGlwcGVkLW1hcHBpbmctZmllbGQvc3RlcC1mbGlwcGVkLW1hcHBpbmctZmllbGQuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWZsb3c6IGNvbHVtbjtcbiAgICBwYWRkaW5nOiAwIDhweDtcblxuICAgIC5kZXNjcmlwdGlvbiB7XG4gICAgICAgIGZvbnQtc2l6ZTogMTRweDtcbiAgICAgICAgbWF4LXdpZHRoOiA3MCU7XG4gICAgfVxuICAgIFxuICAgIC5jb25zdGFudCB7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZmxvdzogcm93O1xuICAgICAgICBtYXJnaW4tbGVmdDogNDBweDtcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcblxuICAgICAgICBpbnB1dCB7XG4gICAgICAgICAgICBtYXJnaW4tbGVmdDogMTZweDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIC5mb3JtaXNoIGxhYmVsIHtcbiAgICAgICAgbWFyZ2luOiAwO1xuICAgIH1cblxuICAgIC5leHBhbmRlciB7XG4gICAgICAgIGZvbnQtc2l6ZTogMTRweDtcbiAgICAgICAgY29sb3I6ICMwNTk7XG4gICAgICAgIG1hcmdpbi1ib3R0b206IDEwcHg7XG4gICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIH1cblxuICAgIC5vcHRpb25zIHtcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1mbG93OiByb3c7XG4gICAgICAgICYgPiAqIHtcbiAgICAgICAgICAgIGZsZXg6IDAgMSA1MCU7XG4gICAgICAgIH1cbiAgICB9XG5cbn0iLCI6aG9zdCB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZmxvdzogY29sdW1uO1xuICBwYWRkaW5nOiAwIDhweDtcbn1cbjpob3N0IC5kZXNjcmlwdGlvbiB7XG4gIGZvbnQtc2l6ZTogMTRweDtcbiAgbWF4LXdpZHRoOiA3MCU7XG59XG46aG9zdCAuY29uc3RhbnQge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IHJvdztcbiAgbWFyZ2luLWxlZnQ6IDQwcHg7XG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG59XG46aG9zdCAuY29uc3RhbnQgaW5wdXQge1xuICBtYXJnaW4tbGVmdDogMTZweDtcbn1cbjpob3N0IC5mb3JtaXNoIGxhYmVsIHtcbiAgbWFyZ2luOiAwO1xufVxuOmhvc3QgLmV4cGFuZGVyIHtcbiAgZm9udC1zaXplOiAxNHB4O1xuICBjb2xvcjogIzA1OTtcbiAgbWFyZ2luLWJvdHRvbTogMTBweDtcbiAgZGlzcGxheTogYmxvY2s7XG59XG46aG9zdCAub3B0aW9ucyB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZmxvdzogcm93O1xufVxuOmhvc3QgLm9wdGlvbnMgPiAqIHtcbiAgZmxleDogMCAxIDUwJTtcbn1cbiJdfQ== */");

/***/ }),

/***/ "8uQj":
/*!****************************************************************************!*\
  !*** ./src/app/data-record-edit-inner/data-record-edit-inner.component.ts ***!
  \****************************************************************************/
/*! exports provided: DataRecordEditInnerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataRecordEditInnerComponent", function() { return DataRecordEditInnerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_data_record_edit_inner_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./data-record-edit-inner.component.html */ "aRl/");
/* harmony import */ var _data_record_edit_inner_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-record-edit-inner.component.less */ "LF3E");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var DataRecordEditInnerComponent = /** @class */ (function () {
    function DataRecordEditInnerComponent() {
    }
    DataRecordEditInnerComponent.prototype.ngOnInit = function () {
    };
    DataRecordEditInnerComponent.ctorParameters = function () { return []; };
    DataRecordEditInnerComponent.propDecorators = {
        datarecord: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        def: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    DataRecordEditInnerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-data-record-edit-inner',
            template: _raw_loader_data_record_edit_inner_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_data_record_edit_inner_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], DataRecordEditInnerComponent);
    return DataRecordEditInnerComponent;
}());



/***/ }),

/***/ "9//7":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-extract-source/step-extract-source.component.html ***!
  \**************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<h2 class='workbench-subtitle'>Source of Data</h2>\n<div class='formish'>\n  <label i18n>Uploaded Source File:</label>\n  <select [(ngModel)]='loader.filename' (change)='changed({loader: {filename: loader.filename}, source:{}, structure: {}})'>\n    <optgroup label='My Files'>\n      <option *ngFor='let file of (api.ownFiles | async)' [value]='file.filename'>{{file.filename}}</option>\n    </optgroup>\n    <optgroup label='Other Files'>\n      <option *ngFor='let file of (api.otherFiles | async)' [value]='file.filename'>{{file.filename}}</option>\n    </optgroup>\n  </select>\n</div>\n<div class='formish'>\n  <label i18n>Direct URL:</label>\n  <input type='text' class='url' class='force-ltr'\n    [(ngModel)]='source.path'\n    (change)='changed({source: {path: source.path}, loader:{}, structure:{}})'\n  />\n</div>\n<div class='formish'>\n  <label i18n>Format:</label>\n  <select [(ngModel)]='source.format' (change)='changed()'>\n    <option value='xls' i18n>Excel (xls)</option>\n    <option value='xlsx' i18n>Excel (xlsx)</option>\n    <option value='csv' i18n>CSV</option>\n    <option value='json' i18n>JSON</option>\n    <option value='gsheet' i18n>Google Spreadsheet</option>\n    <option value='html' i18n>HTML Table</option>\n  </select>\n</div>\n<ng-container *ngIf='source.sheet_names'>\n  <div class='formish'>\n    <label i18n>Sheet:</label>\n    <select [(ngModel)]='source.sheet' (change)='changed()'>\n      <option *ngFor='let x of source.sheet_names' [value]='x[1]'>{{x[1]}}</option>\n    </select>\n  </div>\n</ng-container>\n<ng-container *ngIf='source.format===\"csv\"'>\n  <div class='formish'>\n    <label i18n>Encoding:</label>\n    <input type='text'\n      [(ngModel)]='source.encoding'\n      (change)='changed()'\n    />\n  </div>\n</ng-container>\n<ng-container *ngIf='source.format===\"json\"'>\n  <div class='formish'>\n    <label i18n>JSON Path:</label>\n    <input type='text' class='force-ltr'\n      [(ngModel)]='source.property'\n      (change)='changed()'\n    />\n  </div>\n</ng-container>\n<ng-container *ngIf='source.format===\"html\"'>\n  <div class='formish'>\n    <label i18n>CSS Selector:</label>\n    <input type='text' class='force-ltr'\n      [(ngModel)]='source.selector'\n      (change)='changed()'\n    />\n    <a (click)='source.selector = \"\"; changed()' i18n>Clear selector</a>\n  </div>\n</ng-container>\n");

/***/ }),

/***/ "ACWU":
/*!**********************************************************!*\
  !*** ./src/app/file-uploader/file-uploader.component.ts ***!
  \**********************************************************/
/*! exports provided: FileUploaderComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FileUploaderComponent", function() { return FileUploaderComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_file_uploader_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./file-uploader.component.html */ "ET67");
/* harmony import */ var _file_uploader_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./file-uploader.component.less */ "I29R");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");





var FileUploaderComponent = /** @class */ (function () {
    function FileUploaderComponent(api) {
        this.api = api;
        this.close = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this._progress = 0;
        this._active = false;
        this._success = false;
        this._selected = false;
        this.selectedFile = null;
    }
    FileUploaderComponent.prototype.ngOnInit = function () {
        this.addFiles();
    };
    FileUploaderComponent.prototype.addFiles = function () {
        this.file.nativeElement.click();
    };
    FileUploaderComponent.prototype.onFilesAdded = function () {
        var _this = this;
        var files = this.file.nativeElement.files;
        console.log(files);
        if (files.length > 0) {
            this.selectedFile = files.item(0);
            this._selected = true;
            this.active = true;
            this.api.uploadFile(this.selectedFile, this.filename || this.selectedFile.name, function (progress) { _this.progress = progress; }, function (success) { _this.success = success; });
        }
    };
    Object.defineProperty(FileUploaderComponent.prototype, "progress", {
        set: function (progress) {
            if (this._selected && this._active) {
                this._progress = progress;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileUploaderComponent.prototype, "active", {
        set: function (active) {
            if (this._selected) {
                this._active = active;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileUploaderComponent.prototype, "success", {
        set: function (success) {
            var _this = this;
            if (this._active) {
                this._success = success;
                if (success) {
                    this.api.queryFiles();
                }
                this._active = false;
                this._progress = 100;
                setTimeout(function () {
                    _this.close.emit();
                }, 2000);
            }
        },
        enumerable: false,
        configurable: true
    });
    FileUploaderComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    FileUploaderComponent.propDecorators = {
        file: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['file', { static: true },] }],
        filename: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        close: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    FileUploaderComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-file-uploader',
            template: _raw_loader_file_uploader_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_file_uploader_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], FileUploaderComponent);
    return FileUploaderComponent;
}());



/***/ }),

/***/ "ACr3":
/*!******************************************************************!*\
  !*** ./src/app/data-record-list/data-record-list.component.less ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .add-new {\n  align-self: flex-end;\n}\n:host .add-new a {\n  text-decoration: none;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZGF0YS1yZWNvcmQtbGlzdC9kYXRhLXJlY29yZC1saXN0LmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9kYXRhLXJlY29yZC1saXN0L2RhdGEtcmVjb3JkLWxpc3QuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFUSxvQkFBQTtBQ0FSO0FERkE7RUFJWSxxQkFBQTtBQ0NaIiwiZmlsZSI6InNyYy9hcHAvZGF0YS1yZWNvcmQtbGlzdC9kYXRhLXJlY29yZC1saXN0LmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3QgeyAgIFxuICAgIC5hZGQtbmV3IHtcbiAgICAgICAgYWxpZ24tc2VsZjogZmxleC1lbmQ7XG4gICAgICAgIGEge1xuICAgICAgICAgICAgdGV4dC1kZWNvcmF0aW9uOiBub25lO1xuICAgICAgICB9XG4gICAgfVxufSIsIjpob3N0IC5hZGQtbmV3IHtcbiAgYWxpZ24tc2VsZjogZmxleC1lbmQ7XG59XG46aG9zdCAuYWRkLW5ldyBhIHtcbiAgdGV4dC1kZWNvcmF0aW9uOiBub25lO1xufVxuIl19 */");

/***/ }),

/***/ "AGu5":
/*!****************************************************************************!*\
  !*** ./src/app/extra-config-questions/extra-config-questions.component.ts ***!
  \****************************************************************************/
/*! exports provided: ExtraConfigQuestionsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExtraConfigQuestionsComponent", function() { return ExtraConfigQuestionsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_extra_config_questions_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./extra-config-questions.component.html */ "GSIN");
/* harmony import */ var _extra_config_questions_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./extra-config-questions.component.less */ "lGKN");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var ExtraConfigQuestionsComponent = /** @class */ (function () {
    function ExtraConfigQuestionsComponent() {
    }
    ExtraConfigQuestionsComponent.prototype.ngOnInit = function () {
    };
    ExtraConfigQuestionsComponent.ctorParameters = function () { return []; };
    ExtraConfigQuestionsComponent.propDecorators = {
        questions: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    ExtraConfigQuestionsComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-extra-config-questions',
            template: _raw_loader_extra_config_questions_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_extra_config_questions_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ExtraConfigQuestionsComponent);
    return ExtraConfigQuestionsComponent;
}());



/***/ }),

/***/ "ApWy":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-list-headers/pipeline-list-headers.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='name' i18n>Name</div>\n<div class='status' i18n>Status</div>\n<div class='kind' i18n>Kind</div>\n<div class='schedule' i18n>Schedule</div>\n<div class='actions' i18n>Actions</div>");

/***/ }),

/***/ "AytR":
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/*! exports provided: environment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "environment", function() { return environment; });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
var environment = {
    production: false,
    api_endpoint: 'http://localhost:5000/api',
    auth_endpoint: 'http://localhost:5000'
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.


/***/ }),

/***/ "Az0/":
/*!************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/result-table/result-table.component.html ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<table>\n    <thead>\n        <th class='theme-primary-dark-bg theme-secondary-fg' *ngFor='let hdr of headers'>{{hdr}}</th>\n    </thead>\n    <tbody>\n        <ng-container *ngFor='let row of rows'>\n            <tr [class.errd]='row.errd'>\n                <td *ngFor='let val of row.data; let idx=index' [innerHtml]='val' [class.errd]='row.errd_field === idx'>\n                </td>\n            </tr>\n        </ng-container>\n    </tbody>\n</table>\n");

/***/ }),

/***/ "Bxt6":
/*!****************************************************!*\
  !*** ./src/app/dashboard/dashboard.component.less ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: column;\n}\n:host .intro {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n}\n:host .intro img {\n  width: 100px;\n  border-radius: 50px;\n  margin: 20px;\n}\n:host .intro a {\n  -webkit-margin-start: auto;\n          margin-inline-start: auto;\n  -webkit-margin-end: 20px;\n          margin-inline-end: 20px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZGFzaGJvYXJkL2Rhc2hib2FyZC5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvZGFzaGJvYXJkL2Rhc2hib2FyZC5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxpQkFBQTtBQ0NKO0FESEE7RUFLUSxhQUFBO0VBQ0EsY0FBQTtFQUNBLG1CQUFBO0FDQ1I7QURSQTtFQVVZLFlBQUE7RUFDQSxtQkFBQTtFQUNBLFlBQUE7QUNDWjtBRGJBO0VBZ0JZLDBCQUFBO1VBQUEseUJBQUE7RUFDQSx3QkFBQTtVQUFBLHVCQUFBO0FDQVoiLCJmaWxlIjoic3JjL2FwcC9kYXNoYm9hcmQvZGFzaGJvYXJkLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3R7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWZsb3c6IGNvbHVtbjtcbiAgICBcbiAgICAuaW50cm8ge1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWZsb3c6IHJvdztcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcblxuICAgICAgICBpbWcge1xuICAgICAgICAgICAgd2lkdGg6IDEwMHB4O1xuICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogNTBweDtcbiAgICAgICAgICAgIG1hcmdpbjogMjBweDtcbiAgICAgICAgfVxuXG4gICAgICAgIGEge1xuICAgICAgICAgICAgbWFyZ2luLWlubGluZS1zdGFydDogYXV0bztcbiAgICAgICAgICAgIG1hcmdpbi1pbmxpbmUtZW5kOiAyMHB4O1xuICAgICAgICB9XG4gICAgfVxufSIsIjpob3N0IHtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1mbG93OiBjb2x1bW47XG59XG46aG9zdCAuaW50cm8ge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IHJvdztcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn1cbjpob3N0IC5pbnRybyBpbWcge1xuICB3aWR0aDogMTAwcHg7XG4gIGJvcmRlci1yYWRpdXM6IDUwcHg7XG4gIG1hcmdpbjogMjBweDtcbn1cbjpob3N0IC5pbnRybyBhIHtcbiAgbWFyZ2luLWlubGluZS1zdGFydDogYXV0bztcbiAgbWFyZ2luLWlubGluZS1lbmQ6IDIwcHg7XG59XG4iXX0= */");

/***/ }),

/***/ "DDN7":
/*!********************************************************!*\
  !*** ./src/app/step-enrich/step-enrich.component.less ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3N0ZXAtZW5yaWNoL3N0ZXAtZW5yaWNoLmNvbXBvbmVudC5sZXNzIn0= */");

/***/ }),

/***/ "E81H":
/*!**************************************************************************!*\
  !*** ./src/app/results-tab-selector/results-tab-selector.component.less ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .selector {\n  display: flex;\n  flex-flow: column;\n  align-items: flex-start;\n  cursor: pointer;\n  padding: 5px 20px;\n}\n:host .selector .main {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  font-size: 16px;\n}\n:host .selector .main label {\n  margin: 0;\n}\n:host .selector .main i {\n  margin: 0 10px;\n}\n:host .selector .main .fa-check-circle {\n  color: #66e866;\n}\n:host .selector .main .fa-circle-notch {\n  color: #ffba00;\n}\n:host .selector .main .fa-exclamation-triangle {\n  color: red;\n}\n:host .selector .main .fa-question-circle {\n  color: #aaa;\n}\n:host .selector .secondary {\n  font-size: 14px;\n  align-self: center;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "ET67":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/file-uploader/file-uploader.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<input type=\"file\" #file (change)=\"onFilesAdded()\" />\n<div class='button' (click)='addFiles()' \n     [class.selected]='_selected'\n     [class.active]='_active'\n     [class.success]='_success'\n     >\n    <div *ngIf='!_active && !_selected' class='message' i18n>Select File...</div>\n    <div *ngIf='_active' class='message'>{{ selectedFile.name }}</div>\n    <div *ngIf='!_active && _selected && _success' class='message' i18n>File upload successful</div>\n    <div *ngIf='!_active && _selected && !_success' class='message' i18n>Failed to upload file</div>\n    <div *ngIf='_active' class='progress'>\n        <div class='bar theme-primary-bg' [style.left]='(_progress-100) + \"%\"'>\n        </div>\n    </div>\n</div>\n");

/***/ }),

/***/ "FAFV":
/*!********************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/taxonomies/taxonomies.component.html ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Taxonomies</h1>\n  <div class='formish'>\n    <label class='theme-primary-fg' i18n>Choose taxonomy to edit</label>\n    <select [(ngModel)]='selected'>\n      <option value=''>-</option>\n      <ng-container *ngFor='let taxonomy of (api.taxonomies | async)'>\n        <option [value]='taxonomy.id'>{{taxonomy.title}}</option>\n      </ng-container>\n    </select>\n  </div>\n  <ng-container *ngIf='selectedTaxonomy'>\n    <app-taxonomy-item *ngFor='let ct of selectedTaxonomy.column_types' [ct]='ct' (changed)='changed()'></app-taxonomy-item>\n    <div class='add-new'>\n      <div class='formish'>\n        <label class='theme-primary-fg' i18n>Add new based on...</label>\n        <select (change)='addNew($event.target.value)'>\n          <option disabled i18n>Choose column type tp copy</option>\n          <ng-container *ngFor='let taxonomy of (api.taxonomies | async)'>\n            <optgroup [label]='taxonomy.title'>\n              <ng-container *ngFor='let ct of taxonomy.column_types'>\n                <option [value]='JSON.stringify(ct)'>{{ct.title}}</option>\n              </ng-container>\n            </optgroup>\n          </ng-container>\n        </select>\n        <strong>&nbsp;-&nbsp;OR&nbsp;-&nbsp;</strong>\n        <label class='theme-primary-fg' i18n>Add a new column type named... </label>\n        <input type='text' (change)='addNew(createNew($event.target.value))'/>\n      </div> \n    </div>\n  </ng-container>\n</app-container>");

/***/ }),

/***/ "FYRw":
/*!**********************************!*\
  !*** ./src/app/roles.service.ts ***!
  \**********************************/
/*! exports provided: RolesService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RolesService", function() { return RolesService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


var RolesService = /** @class */ (function () {
    function RolesService() {
        this._ = {};
    }
    RolesService.prototype.setRoles = function (roles) {
        this._ = {};
        for (var _i = 0, roles_1 = roles; _i < roles_1.length; _i++) {
            var role = roles_1[_i];
            this._[role] = true;
        }
    };
    RolesService.ctorParameters = function () { return []; };
    RolesService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], RolesService);
    return RolesService;
}());



/***/ }),

/***/ "Fw5j":
/*!**********************************************!*\
  !*** ./src/app/header/header.component.less ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n}\n:host .container {\n  width: 100%;\n  display: flex;\n  flex-flow: row;\n  border-bottom-width: 1px;\n  border-bottom-style: solid;\n  margin-bottom: 20px;\n  align-items: center;\n}\n:host .container a.logo {\n  line-height: 0;\n}\n:host .container a.logo img {\n  margin: 2.5px 20px;\n  height: 40px;\n}\n:host .container a.menu {\n  display: block;\n  margin: 0px 20px;\n  padding: 0px 10px;\n  line-height: 45px;\n  text-decoration: none;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "G2WK":
/*!******************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/failure-marquee/failure-marquee.component.html ***!
  \******************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='failure-marquee' *ngIf='!!error'>\n  <pre>{{error}}</pre>\n</div>");

/***/ }),

/***/ "GDe7":
/*!****************************************************************************!*\
  !*** ./src/app/dynamic-fields-editor/dynamic-fields-editor.component.less ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host > div.field {\n  width: 100%;\n}\n:host > div.field input[type='checkbox'] {\n  display: inline-block;\n  width: auto;\n  margin: 0 20px;\n}\n:host > div.field input[type='text'] {\n  width: 600px;\n  max-width: 100%;\n}\n:host > div.field .field-description {\n  font-size: 12px;\n  margin: 0;\n}\n:host > div.field.invalid label {\n  color: red;\n  font-weight: bold;\n}\n:host > div.field .section {\n  margin-top: 30px;\n  width: 100%;\n  padding-left: 20px;\n}\n:host > div.field .section h2 {\n  font-size: 16px;\n  font-weight: bold;\n  margin-left: -20px;\n  padding: 3px 10px;\n  margin-bottom: 10px;\n}\n:host > div.field .section .section-description {\n  font-size: 14px;\n  font-weight: 100;\n  margin-left: -10px;\n}\n:host > div.field .section .expander {\n  font-size: 14px;\n  color: #059;\n  margin-top: 10px;\n  display: block;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "GSIN":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/extra-config-questions/extra-config-questions.component.html ***!
  \********************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-extra-config-question *ngFor='let question of questions' [question]='question'></app-extra-config-question>");

/***/ }),

/***/ "GikQ":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/dgp-workbench/dgp-workbench.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n    <h1 class='theme-primary-fg' i18n>Data Import Workbench</h1>\n\n    <app-dgp-workbench-buttons (finalize)='finalize($event)' [status]='status'></app-dgp-workbench-buttons> \n\n    <app-step-extract-source [source]='config.source'\n                             [loader]='config.loader'\n                             *ngIf='stage >= STAGE_SPECIFY_SOURCE'\n                             (update)='updateUrl($event)'>\n    </app-step-extract-source>\n    <app-step-extract-structure [structure]='config.structure'\n                                *ngIf='stage >= STAGE_SOURCE_PARAMETERS'\n                                (change)='store.setConfig(config)'>\n    </app-step-extract-structure>\n    <app-step-taxonomy [taxonomy]='config.taxonomy'\n                        *ngIf='stage >= STAGE_SELECT_TAXONOMY'\n                        (change)='store.setConfig(config)'>\n    </app-step-taxonomy>\n    <app-step-flipped-mapping *ngIf='stage >= STAGE_MAPPING'>\n    </app-step-flipped-mapping>\n    <app-step-enrich [params]='params' *ngIf='stage >= STAGE_METADATA'>\n    </app-step-enrich>\n\n    <app-dgp-workbench-buttons (finalize)='finalize($event)' [status]='status' *ngIf='complete !== null'></app-dgp-workbench-buttons> \n\n    <app-results *ngIf='config.source.path || config.loader.filename'></app-results>\n</app-container>");

/***/ }),

/***/ "H/d9":
/*!******************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/dashboard/dashboard.component.html ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <div class='intro' *ngIf='profile'>\n    <img [src]='profile.avatar_url'/>\n    <h1 class='theme-primary-fg' i18n>Welcome, {{profile.name}}!</h1>\n    <a class='logout' routerLink='/logout' i18n>Logout</a>\n  </div>\n  <app-pipeline-status-dashboard></app-pipeline-status-dashboard>\n</app-container>");

/***/ }),

/***/ "HV3y":
/*!****************************************************!*\
  !*** ./src/app/taxonomies/taxonomies.component.ts ***!
  \****************************************************/
/*! exports provided: TaxonomiesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaxonomiesComponent", function() { return TaxonomiesComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_taxonomies_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./taxonomies.component.html */ "FAFV");
/* harmony import */ var _taxonomies_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./taxonomies.component.less */ "/ZFW");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "kU1M");






var TaxonomiesComponent = /** @class */ (function () {
    function TaxonomiesComponent(api) {
        var _this = this;
        this.api = api;
        this._selected = '';
        this.selectedTaxonomy = null;
        this.taxonomies = [];
        this.JSON = JSON;
        this.api.taxonomies.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["first"])()).subscribe(function (taxonomies) {
            _this.taxonomies = taxonomies;
        });
        this.api.queryTaxonomies();
    }
    TaxonomiesComponent.prototype.ngOnInit = function () {
    };
    Object.defineProperty(TaxonomiesComponent.prototype, "selected", {
        get: function () {
            return this._selected;
        },
        set: function (value) {
            this._selected = value;
            this.selectedTaxonomy = null;
            for (var _i = 0, _a = this.taxonomies; _i < _a.length; _i++) {
                var taxonomy = _a[_i];
                if (taxonomy.id === value) {
                    this.selectedTaxonomy = taxonomy;
                    break;
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    TaxonomiesComponent.prototype.changed = function () {
        this.selectedTaxonomy.column_types = this.selectedTaxonomy.column_types.filter(function (x) { return !!x.name; });
        this.api.updateTaxonomy(this.selectedTaxonomy)
            .subscribe(function (result) {
            console.log('saved');
        });
    };
    TaxonomiesComponent.prototype.addNew = function (event) {
        var ct = JSON.parse(event);
        this.selectedTaxonomy.column_types.push(ct);
    };
    TaxonomiesComponent.prototype.createNew = function (name) {
        return JSON.stringify({ name: name, title: name, dataType: 'string' });
    };
    TaxonomiesComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    TaxonomiesComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-taxonomies',
            template: _raw_loader_taxonomies_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_taxonomies_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], TaxonomiesComponent);
    return TaxonomiesComponent;
}());



/***/ }),

/***/ "Hi4r":
/*!********************************************!*\
  !*** ./src/app/files/files.component.less ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .add-new {\n  align-self: flex-end;\n  margin-bottom: 10px;\n}\n:host .add-new a {\n  text-decoration: none;\n}\n:host app-file-uploader {\n  margin-bottom: 10px;\n}\n:host .controls {\n  margin: 5px 0;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZmlsZXMvZmlsZXMuY29tcG9uZW50Lmxlc3MiLCJzcmMvYXBwL2ZpbGVzL2ZpbGVzLmNvbXBvbmVudC5sZXNzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRVEsb0JBQUE7RUFDQSxtQkFBQTtBQ0FSO0FESEE7RUFLWSxxQkFBQTtBQ0NaO0FETkE7RUFVUSxtQkFBQTtBQ0RSO0FEVEE7RUFjUSxhQUFBO0FDRlIiLCJmaWxlIjoic3JjL2FwcC9maWxlcy9maWxlcy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHsgICBcbiAgICAuYWRkLW5ldyB7XG4gICAgICAgIGFsaWduLXNlbGY6IGZsZXgtZW5kO1xuICAgICAgICBtYXJnaW4tYm90dG9tOiAxMHB4O1xuICAgICAgICBhIHtcbiAgICAgICAgICAgIHRleHQtZGVjb3JhdGlvbjogbm9uZTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGFwcC1maWxlLXVwbG9hZGVyIHtcbiAgICAgICAgbWFyZ2luLWJvdHRvbTogMTBweDtcbiAgICB9XG5cbiAgICAuY29udHJvbHMge1xuICAgICAgICBtYXJnaW46IDVweCAwO1xuICAgIH1cbn0iLCI6aG9zdCAuYWRkLW5ldyB7XG4gIGFsaWduLXNlbGY6IGZsZXgtZW5kO1xuICBtYXJnaW4tYm90dG9tOiAxMHB4O1xufVxuOmhvc3QgLmFkZC1uZXcgYSB7XG4gIHRleHQtZGVjb3JhdGlvbjogbm9uZTtcbn1cbjpob3N0IGFwcC1maWxlLXVwbG9hZGVyIHtcbiAgbWFyZ2luLWJvdHRvbTogMTBweDtcbn1cbjpob3N0IC5jb250cm9scyB7XG4gIG1hcmdpbjogNXB4IDA7XG59XG4iXX0= */");

/***/ }),

/***/ "HmNa":
/*!**************************************************************************!*\
  !*** ./src/app/dgp-workbench-buttons/dgp-workbench-buttons.component.ts ***!
  \**************************************************************************/
/*! exports provided: DgpWorkbenchButtonsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DgpWorkbenchButtonsComponent", function() { return DgpWorkbenchButtonsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_dgp_workbench_buttons_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./dgp-workbench-buttons.component.html */ "PeRK");
/* harmony import */ var _dgp_workbench_buttons_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dgp-workbench-buttons.component.less */ "sEft");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../roles.service */ "FYRw");





var DgpWorkbenchButtonsComponent = /** @class */ (function () {
    function DgpWorkbenchButtonsComponent(roles) {
        this.roles = roles;
        this.finalize = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
    }
    DgpWorkbenchButtonsComponent.prototype.ngOnInit = function () {
    };
    DgpWorkbenchButtonsComponent.prototype.submit = function () {
        this.finalize.emit(true);
    };
    DgpWorkbenchButtonsComponent.prototype.save = function () {
        this.finalize.emit(false);
    };
    DgpWorkbenchButtonsComponent.prototype.submittable = function () {
        return !this.roles._.pipelinesExecute && this.status === 'complete';
    };
    DgpWorkbenchButtonsComponent.ctorParameters = function () { return [
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_4__["RolesService"] }
    ]; };
    DgpWorkbenchButtonsComponent.propDecorators = {
        status: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        finalize: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    DgpWorkbenchButtonsComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-dgp-workbench-buttons',
            template: _raw_loader_dgp_workbench_buttons_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_dgp_workbench_buttons_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_roles_service__WEBPACK_IMPORTED_MODULE_4__["RolesService"]])
    ], DgpWorkbenchButtonsComponent);
    return DgpWorkbenchButtonsComponent;
}());



/***/ }),

/***/ "I29R":
/*!************************************************************!*\
  !*** ./src/app/file-uploader/file-uploader.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: row;\n  justify-content: center;\n  flex: 0 0 auto;\n}\n:host input[type='file'] {\n  display: none;\n}\n:host .button {\n  display: flex;\n  flex-flow: column;\n  justify-content: center;\n  align-items: center;\n  border-radius: 7px;\n  box-shadow: 0 4px 4px 0 rgba(0, 0, 0, 0.08);\n  border: dashed 1px #059;\n  width: 100%;\n  padding: 18px;\n  margin-top: 5px;\n  margin-bottom: 5px;\n  color: #059;\n  cursor: pointer;\n  position: relative;\n  pointer-events: none;\n}\n:host .button .message {\n  width: 100%;\n  text-align: center;\n  z-index: 1;\n}\n:host .button .message:before {\n  content: '';\n  display: inline-block;\n  width: 20px;\n  height: 20px;\n  background-image: url('upload.svg');\n  background-position: center center;\n  background-size: contain;\n  background-repeat: no-repeat;\n  vertical-align: text-bottom;\n  margin: 0 7px;\n}\n:host .button .progress {\n  border: none;\n  overflow: hidden;\n  height: 100%;\n  width: 100%;\n  border-radius: 7px;\n  position: absolute;\n  top: 0px;\n  left: 0px;\n  background-color: transparent;\n}\n:host .button .progress .bar {\n  position: relative;\n  width: 100%;\n  height: 100%;\n  opacity: 0.1;\n  border-radius: 7px;\n  background-image: radial-gradient(circle at 14% 0, #059, #0071cc);\n}\n:host .button.success {\n  border: solid 1px #059;\n  background-image: radial-gradient(circle at 14% 0, #059, #0071cc);\n  color: white;\n}\n:host .button.success .message:before {\n  background-image: url('uploaded.svg');\n  margin: 0 7px;\n}\n:host .button:not(.selected) {\n  pointer-events: initial;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "I94c":
/*!**************************************************************!*\
  !*** ./src/app/user-list-item/user-list-item.component.less ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  border: 0.5px solid #888;\n  margin: 0;\n  padding: 1rem;\n  margin-top: 20px;\n  border-radius: 8px;\n}\n:host .avatar {\n  display: block;\n  height: 3rem;\n  margin: 0 1rem;\n  border-radius: 1.5rem;\n}\n:host .name,\n:host .email {\n  flex: 0 0 30%;\n  font-weight: bold;\n}\n:host .role {\n  -webkit-margin-start: auto;\n          margin-inline-start: auto;\n  flex: 0 0 auto;\n}\n:host .delete {\n  -webkit-margin-start: 10px;\n          margin-inline-start: 10px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "IFHQ":
/*!**********************************************************************!*\
  !*** ./src/app/step-mapping-field/step-mapping-field.component.less ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: column;\n  align-items: stretch;\n  margin: 0 10px;\n  margin-bottom: 10px;\n  max-width: 60vw;\n  font-size: 14px;\n}\n:host .selection {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n}\n:host .selection label.main {\n  font-weight: normal;\n  font-family: monospace;\n}\n:host .selection .fa,\n:host .selection .fas {\n  margin: 0 10px;\n}\n:host .selection select {\n  flex: 1 1 auto;\n}\n:host .selection .fa-caret-right,\n:host .selection .fa-exclamation-triangle {\n  margin-right: 10px;\n  cursor: pointer;\n  transition: transform 250ms;\n  transform: rotate(0deg);\n  font-size: 18px;\n}\n:host .selection .fa-caret-right.open,\n:host .selection .fa-exclamation-triangle.open {\n  transform: rotate(90deg);\n}\n:host .selection .fa-exclamation-triangle {\n  cursor: auto;\n  margin-left: 5px;\n  color: salmon;\n  font-size: 14px;\n}\n:host .description {\n  margin: 0 40px;\n}\n:host .formish {\n  padding: 0;\n}\n:host .formish span {\n  margin: 0 20px;\n}\n:host .toggle-compound {\n  align-self: flex-end;\n}\n:host .more {\n  width: 100%;\n  padding-left: 40px;\n  display: flex;\n  flex-flow: column;\n  align-items: stretch;\n}\n:host .more .options {\n  display: flex;\n  flex-flow: row;\n}\n:host .more .options > * {\n  flex: 0 1 50%;\n}\n:host .more .sample {\n  display: flex;\n  flex-flow: row;\n}\n:host .more .sample table {\n  margin: 8px;\n  width: calc(100% - 16px);\n  border-collapse: collapse;\n  border: 1px solid #444;\n}\n:host .more .sample table th {\n  font-weight: bold;\n  text-align: start;\n  padding: 3px 6px;\n}\n:host .more .sample table tr:nth-child(2n+1) {\n  background-color: #eee;\n}\n:host .more .sample table tr td {\n  padding: 1px 6px;\n  white-space: nowrap;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "IThQ":
/*!**********************************************!*\
  !*** ./src/app/logout/logout.component.less ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2xvZ291dC9sb2dvdXQuY29tcG9uZW50Lmxlc3MifQ== */");

/***/ }),

/***/ "IXcg":
/*!**************************************************************!*\
  !*** ./src/app/file-list-item/file-list-item.component.less ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  display: flex;\n  flex-flow: row wrap;\n  align-items: center;\n  border: 0.5px solid #888;\n  margin: 0;\n  padding: 0.25rem 1rem;\n  padding: 0.5rem 1rem;\n  margin-top: -1px;\n}\n:host > *,\n:host .part > * {\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n  border-left: 1px solid rgba(0, 0, 0, 0.2);\n  padding: 0 20px;\n  white-space: nowrap;\n  text-align: center;\n}\n:host .part {\n  flex: 1 0 570px;\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  justify-content: flex-end;\n  margin-left: auto;\n  border: none;\n  padding: 0;\n}\n:host .name {\n  flex: 0 0 40%;\n  font-weight: bold;\n  text-align: left;\n  border: none;\n}\n:host .part .owner {\n  flex: 0 0 25%;\n  text-overflow: ellipsis;\n  overflow-x: hidden;\n}\n:host .part .last-modified,\n:host .part .delete,\n:host .part .update {\n  flex: 0 0 auto;\n}\n:host .part .size {\n  flex: 0 0 auto;\n  font-weight: bold;\n  border: none;\n  text-align: right;\n}\n:host .separator {\n  -webkit-margin-start: auto;\n          margin-inline-start: auto;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "JfQE":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-list-section/pipeline-list-section.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='root'>\n    <app-pipeline-list-headers></app-pipeline-list-headers>\n</ng-container>\n\n<ng-container *ngFor='let item of sections'>\n    <ng-container *ngIf='item.type === \"section\"'>\n        <h2 class='theme-secondary-fg theme-primary-bg'>\n            <span [style.padding]='\"0 \" + (item.level * 8) + \"px\"'>\n                <ng-container *ngIf='!item.open'>\n                    <i class='fa fa-caret-left only-ltr' (click)='item.open = !item.open'></i>\n                    <i class='fa fa-caret-right only-rtl' (click)='item.open = !item.open'></i>\n                </ng-container>\n                <ng-container *ngIf='item.open'>\n                    <i class='fa fa-caret-down' (click)='item.open = !item.open'></i>\n                </ng-container>\n                &nbsp;\n                <span [innerHtml]='item.display'></span>\n            </span>\n        </h2>\n        <app-pipeline-list-section *ngIf='item.open' [sections]='item.items'></app-pipeline-list-section>\n    </ng-container>\n    <app-pipeline-list-item *ngIf='item.type === \"pipeline\"' [item]='item.item'></app-pipeline-list-item>\n</ng-container>\n");

/***/ }),

/***/ "JjgC":
/*!**************************************************************************!*\
  !*** ./src/app/pipeline-list-headers/pipeline-list-headers.component.ts ***!
  \**************************************************************************/
/*! exports provided: PipelineListHeadersComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineListHeadersComponent", function() { return PipelineListHeadersComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_list_headers_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-list-headers.component.html */ "ApWy");
/* harmony import */ var _pipeline_list_headers_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-list-headers.component.less */ "TZvz");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var PipelineListHeadersComponent = /** @class */ (function () {
    function PipelineListHeadersComponent() {
    }
    PipelineListHeadersComponent.prototype.ngOnInit = function () {
    };
    PipelineListHeadersComponent.ctorParameters = function () { return []; };
    PipelineListHeadersComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-list-headers',
            template: _raw_loader_pipeline_list_headers_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_list_headers_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], PipelineListHeadersComponent);
    return PipelineListHeadersComponent;
}());



/***/ }),

/***/ "K1Oo":
/*!****************************************************************!*\
  !*** ./src/app/data-record-edit/data-record-edit.component.ts ***!
  \****************************************************************/
/*! exports provided: DataRecordEditComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataRecordEditComponent", function() { return DataRecordEditComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_data_record_edit_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./data-record-edit.component.html */ "M7yp");
/* harmony import */ var _data_record_edit_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-record-edit.component.less */ "gVy0");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../confirmer.service */ "c41A");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var _extras_extras__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../extras/extras */ "Y7eG");
/* harmony import */ var _data_record_edit_inner_data_record_edit_inner_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../data-record-edit-inner/data-record-edit-inner.component */ "8uQj");
/* harmony import */ var _data_record_edit_aux_directive__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../data-record-edit-aux.directive */ "mUmp");













var DataRecordEditComponent = /** @class */ (function () {
    function DataRecordEditComponent(api, roles, activatedRoute, router, confirmer, componentFactoryResolver) {
        var _this = this;
        this.api = api;
        this.roles = roles;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.confirmer = confirmer;
        this.componentFactoryResolver = componentFactoryResolver;
        this.def = {};
        this.datarecord = {};
        this.kind = '';
        this.editComponent = new rxjs__WEBPACK_IMPORTED_MODULE_5__["ReplaySubject"](1);
        var datarecords = null;
        this.api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function (configuration) {
            datarecords = configuration.dataRecords || [];
            return _this.activatedRoute.params;
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function (params) {
            _this.kind = params.name;
            var id = params.id;
            for (var _i = 0, datarecords_1 = datarecords; _i < datarecords_1.length; _i++) {
                var def = datarecords_1[_i];
                if (def.name === _this.kind) {
                    _this.def = def;
                    if (id === 'new') {
                        return Object(rxjs__WEBPACK_IMPORTED_MODULE_5__["of"])({ value: {} });
                    }
                    else {
                        return _this.api.queryDatarecord(_this.kind, id);
                    }
                }
            }
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["first"])())
            .subscribe(function (datarecord) {
            _this.datarecord = datarecord.value;
            _this.editComponent.next(_extras_extras__WEBPACK_IMPORTED_MODULE_10__["extraMapping"][_this.def.edit_component] || _data_record_edit_inner_data_record_edit_inner_component__WEBPACK_IMPORTED_MODULE_11__["DataRecordEditInnerComponent"]);
        });
        console.log('constructed DataRecordEditComponent!');
    }
    DataRecordEditComponent.prototype.ngOnInit = function () {
        var _this = this;
        console.log(this.inner);
        this.editComponent.subscribe(function (editComponent) {
            var componentFactory = _this.componentFactoryResolver.resolveComponentFactory(editComponent);
            var viewContainerRef = _this.inner.viewContainerRef;
            viewContainerRef.clear();
            var componentRef = viewContainerRef.createComponent(componentFactory);
            componentRef.instance.datarecord = _this.datarecord;
            componentRef.instance.def = _this.def;
        });
    };
    DataRecordEditComponent.prototype._save = function () {
        this.datarecord.id = this.datarecord.id || this.datarecord[this.def.id];
        return this.api.saveDatarecord(this.kind, this.datarecord);
    };
    DataRecordEditComponent.prototype.save = function () {
        var _this = this;
        this._save()
            .subscribe(function (result) {
            if (result.id) {
                _this.router.navigate(['/datarecords/', _this.kind]);
            }
            else {
                console.log('Failed to SAVE Datarecord!', _this.kind);
            }
        });
    };
    DataRecordEditComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_7__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_9__["RolesService"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"] },
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_8__["ConfirmerService"] },
        { type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ComponentFactoryResolver"] }
    ]; };
    DataRecordEditComponent.propDecorators = {
        inner: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: [_data_record_edit_aux_directive__WEBPACK_IMPORTED_MODULE_12__["DataRecordEditAuxDirective"], { static: true },] }]
    };
    DataRecordEditComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-data-record-edit',
            template: _raw_loader_data_record_edit_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_data_record_edit_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_7__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_9__["RolesService"],
            _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"], _confirmer_service__WEBPACK_IMPORTED_MODULE_8__["ConfirmerService"],
            _angular_core__WEBPACK_IMPORTED_MODULE_3__["ComponentFactoryResolver"]])
    ], DataRecordEditComponent);
    return DataRecordEditComponent;
}());



/***/ }),

/***/ "LF3E":
/*!******************************************************************************!*\
  !*** ./src/app/data-record-edit-inner/data-record-edit-inner.component.less ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .field-description {\n  font-size: 12px;\n  margin: 0;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZGF0YS1yZWNvcmQtZWRpdC1pbm5lci9kYXRhLXJlY29yZC1lZGl0LWlubmVyLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9kYXRhLXJlY29yZC1lZGl0LWlubmVyL2RhdGEtcmVjb3JkLWVkaXQtaW5uZXIuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFUSxlQUFBO0VBQ0EsU0FBQTtBQ0FSIiwiZmlsZSI6InNyYy9hcHAvZGF0YS1yZWNvcmQtZWRpdC1pbm5lci9kYXRhLXJlY29yZC1lZGl0LWlubmVyLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIC5maWVsZC1kZXNjcmlwdGlvbiB7XG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcbiAgICAgICAgbWFyZ2luOiAwO1xuICAgIH1cbn0iLCI6aG9zdCAuZmllbGQtZGVzY3JpcHRpb24ge1xuICBmb250LXNpemU6IDEycHg7XG4gIG1hcmdpbjogMDtcbn1cbiJdfQ== */");

/***/ }),

/***/ "Loy1":
/*!**********************************************************!*\
  !*** ./src/app/dgp-workbench/dgp-workbench.component.ts ***!
  \**********************************************************/
/*! exports provided: DgpWorkbenchComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DgpWorkbenchComponent", function() { return DgpWorkbenchComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_dgp_workbench_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./dgp-workbench.component.html */ "GikQ");
/* harmony import */ var _dgp_workbench_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dgp-workbench.component.less */ "ivW9");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _workbench_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../workbench.service */ "iwbm");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../store.service */ "eXth");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../roles.service */ "FYRw");










var DgpWorkbenchComponent = /** @class */ (function () {
    function DgpWorkbenchComponent(route, workbench, roles, store, api, router) {
        var _this = this;
        this.route = route;
        this.workbench = workbench;
        this.roles = roles;
        this.store = store;
        this.api = api;
        this.router = router;
        this.id = null;
        this.config = null;
        this.params = null;
        this.stage = 0;
        this.STAGE_SPECIFY_SOURCE = 0;
        this.STAGE_SOURCE_PARAMETERS = 10;
        this.STAGE_SELECT_TAXONOMY = 20;
        this.STAGE_MAPPING = 30;
        this.STAGE_METADATA = 40;
        this.complete = null;
        this.hasErrors = false;
        this.route.paramMap.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["switchMap"])(function (params) {
            _this.id = params.get('id');
            return _this.api.queryFiles(false);
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["switchMap"])(function () {
            return _this.store.setPipelineId(_this.id);
        })).subscribe(function (pipeline) {
            _this.params = pipeline.params;
            console.log('got pipeline', _this.params);
        });
        this.store.getConfig().subscribe(function (config) {
            _this.config = config;
            _this.config.source = _this.config.source || {};
            _this.config.loader = _this.config.loader || {};
            _this.config.taxonomy = _this.config.taxonomy || {};
            setTimeout(function () {
                _this.calculateStage(config);
            }, 0);
        });
        this.store.getRows().subscribe(function (row) {
            if (row.index === -2) {
                if (_this.hasErrors) {
                    _this.complete = 'errors';
                }
                else {
                    _this.complete = row.kind === 2 ? 'complete' : 'incomplete';
                }
            }
            else if (row.kind === -1) {
                _this.complete = 'progress';
                _this.hasErrors = false;
            }
            else if (row.errors && row.errors.length > 0) {
                _this.hasErrors = true;
            }
        });
    }
    Object.defineProperty(DgpWorkbenchComponent.prototype, "status", {
        get: function () {
            if ((!this.config.source || !this.config.source.path) &&
                (!this.config.loader || !this.config.loader.filename)) {
                return 'no-source';
            }
            if (this.complete === null) {
                return 'progress';
            }
            else {
                return this.complete;
            }
        },
        enumerable: false,
        configurable: true
    });
    DgpWorkbenchComponent.prototype.updateUrl = function (config) {
        this.store.setConfig(config ? Object.assign({}, this.store.BASE_CONFIG, config) : this.config);
    };
    DgpWorkbenchComponent.prototype.calculateStage = function (config) {
        this.stage = this.STAGE_SPECIFY_SOURCE;
        if (config.source && config.source.path && config.structure) {
            this.stage = this.STAGE_SOURCE_PARAMETERS;
        }
        if (config.taxonomy && config.taxonomy.options) {
            this.stage = this.STAGE_SELECT_TAXONOMY;
        }
        if (config.taxonomy && config.taxonomy.id) {
            this.stage = this.STAGE_MAPPING;
        }
        if (config.model && config.model.mapping) { // TODO: use validation instead
            this.stage = this.STAGE_METADATA;
        }
        console.log('CALCULATE STAGE:', this.stage, config);
    };
    DgpWorkbenchComponent.prototype.ngOnInit = function () {
    };
    DgpWorkbenchComponent.prototype.ngOnDestroy = function () {
        this.store.setPipelineId(null).subscribe(function () {
            console.log('set pipeline to null');
        });
    };
    DgpWorkbenchComponent.prototype.finalize = function (submit) {
        submit = !!submit;
        this.config.__submit = submit;
        this.store.setConfig(this.config);
        this.config.__submit = false;
        if (this.roles._.pipelinesExecute && this.status === 'complete') {
            this.router.navigate(['/status/' + this.store.getPipelineId()]);
        }
        else {
            this.router.navigate(['/pipelines/']);
        }
    };
    DgpWorkbenchComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__["ActivatedRoute"] },
        { type: _workbench_service__WEBPACK_IMPORTED_MODULE_4__["WorkbenchService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_9__["RolesService"] },
        { type: _store_service__WEBPACK_IMPORTED_MODULE_6__["StoreService"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_8__["ApiService"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"] }
    ]; };
    DgpWorkbenchComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-dgp-workbench',
            template: _raw_loader_dgp_workbench_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_dgp_workbench_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_5__["ActivatedRoute"], _workbench_service__WEBPACK_IMPORTED_MODULE_4__["WorkbenchService"],
            _roles_service__WEBPACK_IMPORTED_MODULE_9__["RolesService"], _store_service__WEBPACK_IMPORTED_MODULE_6__["StoreService"],
            _api_service__WEBPACK_IMPORTED_MODULE_8__["ApiService"], _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"]])
    ], DgpWorkbenchComponent);
    return DgpWorkbenchComponent;
}());



/***/ }),

/***/ "M7yp":
/*!********************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/data-record-edit/data-record-edit.component.html ***!
  \********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Edit {{def.display}}</h1>\n  <ng-template appDataRecordEditAux></ng-template>\n  <div class='buttons'>\n    <div *ngIf='roles._.datarecordEdit'  class='save button' (click)='save()' i18n>\n      <i class=\"fas fa-save\" aria-hidden=\"true\"></i>\n      Save {{def.display}}\n    </div>\n    <div *ngIf='roles._.datarecordDelete && datarecord.id' class='delete button' (click)='delete()' i18n>\n      <i class=\"fas fa-trash\" aria-hidden=\"true\"></i>\n      Delete {{def.display}}\n    </div>\n  </div>\n</app-container>");

/***/ }),

/***/ "MsHb":
/*!****************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/user-list-item/user-list-item.component.html ***!
  \****************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<img class='avatar' [src]='item.avatar_url'/>\n<div class='name'>{{item.name || item.username}}</div>\n<div class='email'>{{item.email}}</div>\n<ng-container *ngIf='!item.self'>\n  <select class='role' [(ngModel)]='level' [disabled]='item.self'>\n    <option value='1' i18n>Viewer</option>\n    <option value='2' i18n>Maintainer</option>\n    <option value='3' i18n>Administrator</option>\n  </select>\n  <a class='delete' (click)='delete($event)' i18n>Delete</a>\n</ng-container>");

/***/ }),

/***/ "NUXy":
/*!**********************************************!*\
  !*** ./src/app/results/results.component.ts ***!
  \**********************************************/
/*! exports provided: ResultsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResultsComponent", function() { return ResultsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_results_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./results.component.html */ "7j6H");
/* harmony import */ var _results_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./results.component.less */ "3d/c");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var ResultsComponent = /** @class */ (function () {
    function ResultsComponent(store) {
        var _this = this;
        this.store = store;
        this.validate = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.step = 'extract';
        this.hasResults = false;
        this.failure = null;
        this.failureMain = null;
        this.analysisErrors = [];
        this.errors = [];
        this.TABLES = [
            { slug: 'extract', rowCount: 0, progress: false, errors: null, valid: null },
            { slug: 'map', rowCount: 0, progress: false, errors: null, valid: null },
            { slug: 'enrich', rowCount: 0, progress: false, errors: null, valid: null },
        ];
        this.store.getRows()
            .subscribe(function (row) {
            if (row.kind === -1) {
                _this.hasResults = true;
                _this.stop();
            }
            else if (row.kind >= 0 && row.kind < _this.TABLES.length) {
                var table = _this.TABLES[row.kind];
                if (row.index === -1) {
                    table.rowCount = 0;
                    table.progress = true;
                    table.errors = null;
                }
                else if (row.index === -2) {
                    table.progress = false;
                    table.valid = table.errors === null;
                }
                else if (row.index >= 0) {
                    table.progress = true;
                    table.rowCount = row.index + 1;
                    if (table.errors === null && row.errors && row.errors.length > 0) {
                        table.errors = row.errors;
                        if (_this.errors.length === 0) {
                            _this.errors = row.errors;
                        }
                    }
                }
            }
        });
        this.store.getRowCount()
            .subscribe(function (count) {
            if (count.kind >= 0 && count.kind < _this.TABLES.length) {
                _this.TABLES[count.kind].rowCount = count.index + 1;
            }
        });
        this.store.getFailure().subscribe(function (failure) {
            _this.failure = failure;
            if (failure) {
                var parts = failure.replace(/^\s+|\s+$/g, '').split('\n');
                _this.failureMain = parts[parts.length - 1];
                _this.stop(-1);
            }
        });
        this.store.getErrors().subscribe(function (errors) {
            _this.analysisErrors = [];
            for (var _i = 0, errors_1 = errors; _i < errors_1.length; _i++) {
                var error = errors_1[_i];
                if (error && error.length === 3) {
                    var code = error[0];
                    var key = error[1];
                    var options = error[2];
                    var message = '';
                    if (code === 0) {
                        var description = options.description || key;
                        message = "Missing configuration: " + description + " (" + key + ")";
                    }
                    else if (code === 1) {
                        var description = options.description || key;
                        message = "Invalid configuration: " + description;
                    }
                    _this.analysisErrors.push(message);
                }
            }
        });
    }
    ResultsComponent.prototype.ngOnInit = function () {
    };
    ResultsComponent.prototype.stop = function (running) {
        if (running === void 0) { running = 0; }
        this.TABLES.forEach(function (x, i) {
            x.progress = i === running;
            x.rowCount = 0;
            x.errors = null;
            x.valid = null;
        });
        this.errors = [];
    };
    ResultsComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    ResultsComponent.propDecorators = {
        validate: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    ResultsComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-results',
            template: _raw_loader_results_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_results_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], ResultsComponent);
    return ResultsComponent;
}());



/***/ }),

/***/ "PNdE":
/*!**************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-status-dashboard/pipeline-status-dashboard.component.html ***!
  \**************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='indicators'>\n  <div class='indicator theme-primary-bg' [routerLink]='\"/pipelines\"'><span class='count'>{{total}}</span><span class='text' i18n>Total Tasks</span></div>\n  <div class='indicator theme-primary-bg' [routerLink]='\"/pipelines\"'><span class='count'>{{successful}}</span><span class='text' i18n>Successful Tasks</span></div>\n  <div class='indicator theme-primary-bg' [routerLink]='\"/pipelines\"'><span class='count'>{{failed}}</span><span class='text' i18n>Failed Tasks</span></div>\n</div>\n");

/***/ }),

/***/ "PeRK":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/dgp-workbench-buttons/dgp-workbench-buttons.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='buttons'>\n    <div class='button' (click)='save()' i18n>\n        <i class=\"fas fa-save\" aria-hidden=\"true\"></i>\n        Save\n    </div>\n    <div class='button' (click)='submit()' *ngIf='submittable()' i18n>\n        <i class=\"fas fa-save\" aria-hidden=\"true\"></i>\n        Save and Submit for Approval\n    </div>\n    <h4 *ngIf='status === \"no-source\"' i18n>\n        Please select a data source\n    </h4>\n    <h4 *ngIf='status === \"progress\"' i18n>\n        Data is processing...\n    </h4>\n    <h4 *ngIf='status === \"complete\" && submittable()' i18n>\n        Mapping completed successfully, click to submit data for approval\n    </h4>\n    <h4 *ngIf='status === \"complete\" && !submittable()' i18n>\n        Mapping completed successfully, click save to proceed\n    </h4>\n    <h4 *ngIf='status === \"incomplete\"' i18n>\n        Mapping is still incomplete, you can save and continue editing later\n    </h4>\n    <h4 *ngIf='status === \"errors\"' i18n>\n        Mapping completed with errors, you can save and continue editing later\n    </h4>\n</div>\n");

/***/ }),

/***/ "QX6l":
/*!**************************************************!*\
  !*** ./src/app/dashboard/dashboard.component.ts ***!
  \**************************************************/
/*! exports provided: DashboardComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DashboardComponent", function() { return DashboardComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_dashboard_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./dashboard.component.html */ "H/d9");
/* harmony import */ var _dashboard_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dashboard.component.less */ "Bxt6");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");





var DashboardComponent = /** @class */ (function () {
    function DashboardComponent(auth) {
        var _this = this;
        this.auth = auth;
        this.profile = null;
        this.auth.getUser().subscribe(function (user) {
            if (user) {
                _this.profile = user.profile;
            }
        });
    }
    DashboardComponent.prototype.ngOnInit = function () {
    };
    DashboardComponent.ctorParameters = function () { return [
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"] }
    ]; };
    DashboardComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-dashboard',
            template: _raw_loader_dashboard_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_dashboard_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"]])
    ], DashboardComponent);
    return DashboardComponent;
}());



/***/ }),

/***/ "Qa3L":
/*!**************************************************************************!*\
  !*** ./src/app/dynamic-fields-editor/dynamic-fields-editor.component.ts ***!
  \**************************************************************************/
/*! exports provided: DynamicFieldsEditorComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DynamicFieldsEditorComponent", function() { return DynamicFieldsEditorComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_dynamic_fields_editor_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./dynamic-fields-editor.component.html */ "zvAQ");
/* harmony import */ var _dynamic_fields_editor_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dynamic-fields-editor.component.less */ "GDe7");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var DynamicFieldsEditorComponent = /** @class */ (function () {
    function DynamicFieldsEditorComponent() {
        this.updated = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.valid = false;
        this.expanded = {};
    }
    DynamicFieldsEditorComponent.prototype.ngOnInit = function () {
        this.validate();
    };
    DynamicFieldsEditorComponent.prototype.update = function () {
        this.validate();
        this.updated.emit();
    };
    DynamicFieldsEditorComponent.prototype.ngAfterViewInit = function () {
        var _this = this;
        setTimeout(function () {
            _this.update();
        }, 0);
    };
    DynamicFieldsEditorComponent.prototype._validate = function (fields, item) {
        var ret = true;
        for (var _i = 0, fields_1 = fields; _i < fields_1.length; _i++) {
            var field = fields_1[_i];
            field.__valid = true;
            if (field.type === 'section') {
                if (!this._validate(field.fields, item)) {
                    ret = false;
                }
            }
            if (field.required && !item[field.name]) {
                field.__valid = false;
                ret = false;
            }
        }
        return ret;
    };
    DynamicFieldsEditorComponent.prototype.validate = function () {
        this.valid = this._validate(this.fields, this.item);
    };
    DynamicFieldsEditorComponent.ctorParameters = function () { return []; };
    DynamicFieldsEditorComponent.propDecorators = {
        item: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        fields: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        updated: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    DynamicFieldsEditorComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-dynamic-fields-editor',
            template: _raw_loader_dynamic_fields_editor_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_dynamic_fields_editor_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], DynamicFieldsEditorComponent);
    return DynamicFieldsEditorComponent;
}());



/***/ }),

/***/ "RDkR":
/*!******************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-tabs/step-tabs.component.html ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='tab-container'>\n    <span class='tab'\n            [ngClass]='{active: selected === \"extract\", valid: validation[\"extract\"].valid, inprogress: validation[\"extract\"].progress, errored: validation[\"extract\"].errors}'\n            (click)='select(\"extract\")'\n            >\n        <span i18n>Extract</span>&nbsp;\n        <i class='fa fa-check-circle'></i>\n        <i class='fa fa-circle-notch fa-spin'></i>\n        <i class='fa fa-question-circle'></i>\n        <i class='fa fa-exclamation-triangle' [title]='validation[\"extract\"].errors'></i>\n        &nbsp;<i class='fa fa-chevron-left only-rtl'></i><i class='fa fa-chevron-right only-ltr'></i>\n    </span>\n    <span class='tab'\n            [ngClass]='{active: selected === \"map\", valid: validation[\"map\"].valid, inprogress: validation[\"map\"].progress, errored: validation[\"map\"].errors}'\n            (click)='select(\"map\")'\n            >\n        <span i18n>Map</span>&nbsp;\n        <i class='fa fa-check-circle'></i>\n        <i class='fa fa-circle-notch fa-spin'></i>\n        <i class='fa fa-question-circle'></i>\n        <i class='fa fa-exclamation-triangle' [title]='validation[\"map\"].errors'></i>\n        &nbsp;<i class='fa fa-chevron-left only-rtl'></i><i class='fa fa-chevron-right only-ltr'></i>\n    </span>\n    <span class='tab'\n            [ngClass]='{active: selected === \"enrich\", valid: validation[\"enrich\"].valid, inprogress: validation[\"enrich\"].progress, errored: validation[\"enrich\"].errors}'\n            (click)='select(\"enrich\")'\n            >\n        <span i18n>Transform</span>&nbsp;\n        <i class='fa fa-check-circle'></i>\n        <i class='fa fa-circle-notch fa-spin'></i>\n        <i class='fa fa-question-circle'></i>\n        <i class='fa fa-exclamation-triangle' [title]='validation[\"enrich\"].errors'></i>\n        &nbsp;<i class='fa fa-chevron-left only-rtl'></i><i class='fa fa-chevron-right only-ltr'></i>\n    </span>\n    <span class='tab'\n            [ngClass]='{active: selected === \"publish\", valid: validation[\"publish\"].valid, inprogress: validation[\"publish\"].progress, errored: validation[\"publish\"].errors}'\n            (click)='select(\"publish\")'\n            >\n        <span i18n>Finalize</span>&nbsp;\n        <i class='fa fa-check-circle'></i>\n        <i class='fa fa-circle-notch fa-spin'></i>\n        <i class='fa fa-question-circle'></i>\n        <i class='fa fa-exclamation-triangle' [title]='validation[\"publish\"].errors'></i>\n        &nbsp;<i class='fa fa-chevron-left only-rtl'></i><i class='fa fa-chevron-right only-ltr'></i>\n    </span>\n    <span>\n        <a routerLink='/pipelines' i18n>&lt;&lt;&lt; Back</a>\n    </span>\n</div>");

/***/ }),

/***/ "RJ08":
/*!********************************************!*\
  !*** ./src/app/login/login.component.less ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  height: 100%;\n  display: flex;\n  flex-flow: column;\n  align-items: center;\n  justify-content: center;\n}\n:host img {\n  margin-bottom: 50px;\n  max-width: 80%;\n}\n:host a.login {\n  padding: 4px 40px;\n  color: white;\n  border: 2px solid #002a4c;\n  border-radius: 20px;\n  font-size: 22px;\n  font-weight: bold;\n}\n:host h2 {\n  font-size: 22px;\n  font-weight: bold;\n  text-align: center;\n}\n:host h2 a {\n  font-size: 18px;\n  text-decoration: underline;\n}\n:host .theme-primary-fg {\n  color: #059;\n}\n:host .theme-primary-bg {\n  background-color: #059;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "RnhZ":
/*!**************************************************!*\
  !*** ./node_modules/moment/locale sync ^\.\/.*$ ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./af": "K/tc",
	"./af.js": "K/tc",
	"./ar": "jnO4",
	"./ar-dz": "o1bE",
	"./ar-dz.js": "o1bE",
	"./ar-kw": "Qj4J",
	"./ar-kw.js": "Qj4J",
	"./ar-ly": "HP3h",
	"./ar-ly.js": "HP3h",
	"./ar-ma": "CoRJ",
	"./ar-ma.js": "CoRJ",
	"./ar-sa": "gjCT",
	"./ar-sa.js": "gjCT",
	"./ar-tn": "bYM6",
	"./ar-tn.js": "bYM6",
	"./ar.js": "jnO4",
	"./az": "SFxW",
	"./az.js": "SFxW",
	"./be": "H8ED",
	"./be.js": "H8ED",
	"./bg": "hKrs",
	"./bg.js": "hKrs",
	"./bm": "p/rL",
	"./bm.js": "p/rL",
	"./bn": "kEOa",
	"./bn-bd": "loYQ",
	"./bn-bd.js": "loYQ",
	"./bn.js": "kEOa",
	"./bo": "0mo+",
	"./bo.js": "0mo+",
	"./br": "aIdf",
	"./br.js": "aIdf",
	"./bs": "JVSJ",
	"./bs.js": "JVSJ",
	"./ca": "1xZ4",
	"./ca.js": "1xZ4",
	"./cs": "PA2r",
	"./cs.js": "PA2r",
	"./cv": "A+xa",
	"./cv.js": "A+xa",
	"./cy": "l5ep",
	"./cy.js": "l5ep",
	"./da": "DxQv",
	"./da.js": "DxQv",
	"./de": "tGlX",
	"./de-at": "s+uk",
	"./de-at.js": "s+uk",
	"./de-ch": "u3GI",
	"./de-ch.js": "u3GI",
	"./de.js": "tGlX",
	"./dv": "WYrj",
	"./dv.js": "WYrj",
	"./el": "jUeY",
	"./el.js": "jUeY",
	"./en-au": "Dmvi",
	"./en-au.js": "Dmvi",
	"./en-ca": "OIYi",
	"./en-ca.js": "OIYi",
	"./en-gb": "Oaa7",
	"./en-gb.js": "Oaa7",
	"./en-ie": "4dOw",
	"./en-ie.js": "4dOw",
	"./en-il": "czMo",
	"./en-il.js": "czMo",
	"./en-in": "7C5Q",
	"./en-in.js": "7C5Q",
	"./en-nz": "b1Dy",
	"./en-nz.js": "b1Dy",
	"./en-sg": "t+mt",
	"./en-sg.js": "t+mt",
	"./eo": "Zduo",
	"./eo.js": "Zduo",
	"./es": "iYuL",
	"./es-do": "CjzT",
	"./es-do.js": "CjzT",
	"./es-mx": "tbfe",
	"./es-mx.js": "tbfe",
	"./es-us": "Vclq",
	"./es-us.js": "Vclq",
	"./es.js": "iYuL",
	"./et": "7BjC",
	"./et.js": "7BjC",
	"./eu": "D/JM",
	"./eu.js": "D/JM",
	"./fa": "jfSC",
	"./fa.js": "jfSC",
	"./fi": "gekB",
	"./fi.js": "gekB",
	"./fil": "1ppg",
	"./fil.js": "1ppg",
	"./fo": "ByF4",
	"./fo.js": "ByF4",
	"./fr": "nyYc",
	"./fr-ca": "2fjn",
	"./fr-ca.js": "2fjn",
	"./fr-ch": "Dkky",
	"./fr-ch.js": "Dkky",
	"./fr.js": "nyYc",
	"./fy": "cRix",
	"./fy.js": "cRix",
	"./ga": "USCx",
	"./ga.js": "USCx",
	"./gd": "9rRi",
	"./gd.js": "9rRi",
	"./gl": "iEDd",
	"./gl.js": "iEDd",
	"./gom-deva": "qvJo",
	"./gom-deva.js": "qvJo",
	"./gom-latn": "DKr+",
	"./gom-latn.js": "DKr+",
	"./gu": "4MV3",
	"./gu.js": "4MV3",
	"./he": "x6pH",
	"./he.js": "x6pH",
	"./hi": "3E1r",
	"./hi.js": "3E1r",
	"./hr": "S6ln",
	"./hr.js": "S6ln",
	"./hu": "WxRl",
	"./hu.js": "WxRl",
	"./hy-am": "1rYy",
	"./hy-am.js": "1rYy",
	"./id": "UDhR",
	"./id.js": "UDhR",
	"./is": "BVg3",
	"./is.js": "BVg3",
	"./it": "bpih",
	"./it-ch": "bxKX",
	"./it-ch.js": "bxKX",
	"./it.js": "bpih",
	"./ja": "B55N",
	"./ja.js": "B55N",
	"./jv": "tUCv",
	"./jv.js": "tUCv",
	"./ka": "IBtZ",
	"./ka.js": "IBtZ",
	"./kk": "bXm7",
	"./kk.js": "bXm7",
	"./km": "6B0Y",
	"./km.js": "6B0Y",
	"./kn": "PpIw",
	"./kn.js": "PpIw",
	"./ko": "Ivi+",
	"./ko.js": "Ivi+",
	"./ku": "JCF/",
	"./ku.js": "JCF/",
	"./ky": "lgnt",
	"./ky.js": "lgnt",
	"./lb": "RAwQ",
	"./lb.js": "RAwQ",
	"./lo": "sp3z",
	"./lo.js": "sp3z",
	"./lt": "JvlW",
	"./lt.js": "JvlW",
	"./lv": "uXwI",
	"./lv.js": "uXwI",
	"./me": "KTz0",
	"./me.js": "KTz0",
	"./mi": "aIsn",
	"./mi.js": "aIsn",
	"./mk": "aQkU",
	"./mk.js": "aQkU",
	"./ml": "AvvY",
	"./ml.js": "AvvY",
	"./mn": "lYtQ",
	"./mn.js": "lYtQ",
	"./mr": "Ob0Z",
	"./mr.js": "Ob0Z",
	"./ms": "6+QB",
	"./ms-my": "ZAMP",
	"./ms-my.js": "ZAMP",
	"./ms.js": "6+QB",
	"./mt": "G0Uy",
	"./mt.js": "G0Uy",
	"./my": "honF",
	"./my.js": "honF",
	"./nb": "bOMt",
	"./nb.js": "bOMt",
	"./ne": "OjkT",
	"./ne.js": "OjkT",
	"./nl": "+s0g",
	"./nl-be": "2ykv",
	"./nl-be.js": "2ykv",
	"./nl.js": "+s0g",
	"./nn": "uEye",
	"./nn.js": "uEye",
	"./oc-lnc": "Fnuy",
	"./oc-lnc.js": "Fnuy",
	"./pa-in": "8/+R",
	"./pa-in.js": "8/+R",
	"./pl": "jVdC",
	"./pl.js": "jVdC",
	"./pt": "8mBD",
	"./pt-br": "0tRk",
	"./pt-br.js": "0tRk",
	"./pt.js": "8mBD",
	"./ro": "lyxo",
	"./ro.js": "lyxo",
	"./ru": "lXzo",
	"./ru.js": "lXzo",
	"./sd": "Z4QM",
	"./sd.js": "Z4QM",
	"./se": "//9w",
	"./se.js": "//9w",
	"./si": "7aV9",
	"./si.js": "7aV9",
	"./sk": "e+ae",
	"./sk.js": "e+ae",
	"./sl": "gVVK",
	"./sl.js": "gVVK",
	"./sq": "yPMs",
	"./sq.js": "yPMs",
	"./sr": "zx6S",
	"./sr-cyrl": "E+lV",
	"./sr-cyrl.js": "E+lV",
	"./sr.js": "zx6S",
	"./ss": "Ur1D",
	"./ss.js": "Ur1D",
	"./sv": "X709",
	"./sv.js": "X709",
	"./sw": "dNwA",
	"./sw.js": "dNwA",
	"./ta": "PeUW",
	"./ta.js": "PeUW",
	"./te": "XLvN",
	"./te.js": "XLvN",
	"./tet": "V2x9",
	"./tet.js": "V2x9",
	"./tg": "Oxv6",
	"./tg.js": "Oxv6",
	"./th": "EOgW",
	"./th.js": "EOgW",
	"./tk": "Wv91",
	"./tk.js": "Wv91",
	"./tl-ph": "Dzi0",
	"./tl-ph.js": "Dzi0",
	"./tlh": "z3Vd",
	"./tlh.js": "z3Vd",
	"./tr": "DoHr",
	"./tr.js": "DoHr",
	"./tzl": "z1FC",
	"./tzl.js": "z1FC",
	"./tzm": "wQk9",
	"./tzm-latn": "tT3J",
	"./tzm-latn.js": "tT3J",
	"./tzm.js": "wQk9",
	"./ug-cn": "YRex",
	"./ug-cn.js": "YRex",
	"./uk": "raLr",
	"./uk.js": "raLr",
	"./ur": "UpQW",
	"./ur.js": "UpQW",
	"./uz": "Loxo",
	"./uz-latn": "AQ68",
	"./uz-latn.js": "AQ68",
	"./uz.js": "Loxo",
	"./vi": "KSF8",
	"./vi.js": "KSF8",
	"./x-pseudo": "/X5v",
	"./x-pseudo.js": "/X5v",
	"./yo": "fzPg",
	"./yo.js": "fzPg",
	"./zh-cn": "XDpg",
	"./zh-cn.js": "XDpg",
	"./zh-hk": "SatO",
	"./zh-hk.js": "SatO",
	"./zh-mo": "OmwH",
	"./zh-mo.js": "OmwH",
	"./zh-tw": "kOpN",
	"./zh-tw.js": "kOpN"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "RnhZ";

/***/ }),

/***/ "S6Lp":
/*!******************************************************!*\
  !*** ./src/app/result-tabs/result-tabs.component.ts ***!
  \******************************************************/
/*! exports provided: ResultTabsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResultTabsComponent", function() { return ResultTabsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


var ResultTabsComponent = /** @class */ (function () {
    function ResultTabsComponent() {
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    ResultTabsComponent.prototype.ngOnInit = function () {
    };
    ResultTabsComponent.prototype.select = function (selected) {
        this.change.emit(selected);
    };
    ResultTabsComponent.ctorParameters = function () { return []; };
    ResultTabsComponent.propDecorators = {
        selected: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }],
        change: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"] }]
    };
    ResultTabsComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-result-tabs',
            template: "\n    <span class='tab'\n          [ngClass]='{active: selected === \"original\"}'\n          (click)='select(\"original\")'\n          i18n>\n      Original\n    </span>\n    <span class='tab'\n          [ngClass]='{active: selected === \"transformed\"}'\n          (click)='select(\"transformed\")'\n          i18n>\n      Transformed\n    </span>\n  "
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ResultTabsComponent);
    return ResultTabsComponent;
}());



/***/ }),

/***/ "Sy1n":
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/*! exports provided: AppComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppComponent", function() { return AppComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_app_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./app.component.html */ "VzVu");
/* harmony import */ var _app_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app.component.less */ "uBPG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _theme_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./theme.service */ "deNa");





var AppComponent = /** @class */ (function () {
    function AppComponent(theme) {
        this.theme = theme;
    }
    AppComponent.ctorParameters = function () { return [
        { type: _theme_service__WEBPACK_IMPORTED_MODULE_4__["ThemeService"] }
    ]; };
    AppComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-root',
            template: _raw_loader_app_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_app_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_theme_service__WEBPACK_IMPORTED_MODULE_4__["ThemeService"]])
    ], AppComponent);
    return AppComponent;
}());



/***/ }),

/***/ "TZvz":
/*!****************************************************************************!*\
  !*** ./src/app/pipeline-list-headers/pipeline-list-headers.component.less ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  display: flex;\n  flex-flow: row;\n  margin: 0;\n  padding: 1rem;\n  font-weight: bold;\n}\n:host .name {\n  flex: 1 1 auto;\n  font-weight: bold;\n}\n:host .status {\n  flex: 0 0 10%;\n}\n:host .kind {\n  flex: 0 0 10%;\n}\n:host .schedule {\n  flex: 0 0 10%;\n}\n:host .actions {\n  flex: 0 0 33%;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvcGlwZWxpbmUtbGlzdC1oZWFkZXJzL3BpcGVsaW5lLWxpc3QtaGVhZGVycy5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvcGlwZWxpbmUtbGlzdC1oZWFkZXJzL3BpcGVsaW5lLWxpc3QtaGVhZGVycy5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLFdBQUE7RUFDQSxhQUFBO0VBQ0EsY0FBQTtFQUNBLFNBQUE7RUFDQSxhQUFBO0VBQ0EsaUJBQUE7QUNDSjtBRFBBO0VBU1EsY0FBQTtFQUNBLGlCQUFBO0FDQ1I7QURYQTtFQWNRLGFBQUE7QUNBUjtBRGRBO0VBa0JRLGFBQUE7QUNEUjtBRGpCQTtFQXNCUSxhQUFBO0FDRlI7QURwQkE7RUEwQlEsYUFBQTtBQ0hSIiwiZmlsZSI6InNyYy9hcHAvcGlwZWxpbmUtbGlzdC1oZWFkZXJzL3BpcGVsaW5lLWxpc3QtaGVhZGVycy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZmxvdzogcm93O1xuICAgIG1hcmdpbjogMDtcbiAgICBwYWRkaW5nOiAxcmVtO1xuICAgIGZvbnQtd2VpZ2h0OiBib2xkO1xuXG4gICAgLm5hbWUge1xuICAgICAgICBmbGV4OiAxIDEgYXV0bztcbiAgICAgICAgZm9udC13ZWlnaHQ6IGJvbGQ7XG4gICAgfVxuXG4gICAgLnN0YXR1cyB7XG4gICAgICAgIGZsZXg6IDAgMCAxMCU7XG4gICAgfVxuXG4gICAgLmtpbmQge1xuICAgICAgICBmbGV4OiAwIDAgMTAlO1xuICAgIH1cblxuICAgIC5zY2hlZHVsZSB7XG4gICAgICAgIGZsZXg6IDAgMCAxMCU7XG4gICAgfVxuXG4gICAgLmFjdGlvbnMge1xuICAgICAgICBmbGV4OiAwIDAgMzMlO1xuICAgIH1cbn0iLCI6aG9zdCB7XG4gIHdpZHRoOiAxMDAlO1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IHJvdztcbiAgbWFyZ2luOiAwO1xuICBwYWRkaW5nOiAxcmVtO1xuICBmb250LXdlaWdodDogYm9sZDtcbn1cbjpob3N0IC5uYW1lIHtcbiAgZmxleDogMSAxIGF1dG87XG4gIGZvbnQtd2VpZ2h0OiBib2xkO1xufVxuOmhvc3QgLnN0YXR1cyB7XG4gIGZsZXg6IDAgMCAxMCU7XG59XG46aG9zdCAua2luZCB7XG4gIGZsZXg6IDAgMCAxMCU7XG59XG46aG9zdCAuc2NoZWR1bGUge1xuICBmbGV4OiAwIDAgMTAlO1xufVxuOmhvc3QgLmFjdGlvbnMge1xuICBmbGV4OiAwIDAgMzMlO1xufVxuIl19 */");

/***/ }),

/***/ "UTD6":
/*!****************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/file-list-item/file-list-item.component.html ***!
  \****************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='name'>{{item.filename || item.username}}</div>\n<div class='part'>\n    <div class='size'>{{size}}</div>\n    <div class='last-modified' [title]='item.last_modified_date + \" \" + item.last_modified_time'>{{item.last_modified_date}}</div>\n    <div class='owner'>{{item.owner_name}}</div>\n    <a *ngIf='updateable()' class='update' (click)='requestUpdate()' i18n>Update Contents</a>\n    <a *ngIf='deletable()' class='delete' (click)='delete()' i18n>Delete</a>\n</div>");

/***/ }),

/***/ "V4Lh":
/*!************************************************************!*\
  !*** ./src/app/pipeline-list/pipeline-list.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .add-new {\n  align-self: flex-end;\n}\n:host .add-new a {\n  text-decoration: none;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvcGlwZWxpbmUtbGlzdC9waXBlbGluZS1saXN0LmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9waXBlbGluZS1saXN0L3BpcGVsaW5lLWxpc3QuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFUSxvQkFBQTtBQ0FSO0FERkE7RUFJWSxxQkFBQTtBQ0NaIiwiZmlsZSI6InNyYy9hcHAvcGlwZWxpbmUtbGlzdC9waXBlbGluZS1saXN0LmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3QgeyAgIFxuICAgIC5hZGQtbmV3IHtcbiAgICAgICAgYWxpZ24tc2VsZjogZmxleC1lbmQ7XG4gICAgICAgIGEge1xuICAgICAgICAgICAgdGV4dC1kZWNvcmF0aW9uOiBub25lO1xuICAgICAgICB9XG4gICAgfVxufSIsIjpob3N0IC5hZGQtbmV3IHtcbiAgYWxpZ24tc2VsZjogZmxleC1lbmQ7XG59XG46aG9zdCAuYWRkLW5ldyBhIHtcbiAgdGV4dC1kZWNvcmF0aW9uOiBub25lO1xufVxuIl19 */");

/***/ }),

/***/ "VzVu":
/*!**************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/app.component.html ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-confirmer></app-confirmer>\n<router-outlet></router-outlet>\n");

/***/ }),

/***/ "Wbot":
/*!**********************************************************!*\
  !*** ./src/app/step-taxonomy/step-taxonomy.component.ts ***!
  \**********************************************************/
/*! exports provided: StepTaxonomyComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepTaxonomyComponent", function() { return StepTaxonomyComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_taxonomy_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-taxonomy.component.html */ "atfz");
/* harmony import */ var _step_taxonomy_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-taxonomy.component.less */ "2m28");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var StepTaxonomyComponent = /** @class */ (function () {
    function StepTaxonomyComponent(store) {
        this.store = store;
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.hidden = false;
    }
    StepTaxonomyComponent.prototype.ngOnInit = function () {
    };
    StepTaxonomyComponent.prototype.ngOnChanges = function () {
        var _this = this;
        if (this.taxonomy && this.taxonomy.options && this.taxonomy.options.length === 1) {
            if (!this.taxonomy.id) {
                this.taxonomy.id = this.taxonomy.options[0].id;
                this.changed();
            }
            setTimeout(function () {
                _this.hidden = true;
            }, 0);
        }
    };
    Object.defineProperty(StepTaxonomyComponent.prototype, "missingValues", {
        get: function () {
            if (this.taxonomy && this.taxonomy.missingValues && Array.isArray(this.taxonomy.missingValues)) {
                return this.taxonomy.missingValues.filter(function (i) { return i !== ''; }).join(',');
            }
        },
        set: function (missingValues) {
            this.taxonomy.missingValues = missingValues.split(',');
            this.taxonomy.missingValues.push('');
        },
        enumerable: false,
        configurable: true
    });
    StepTaxonomyComponent.prototype.changed = function () {
        this.change.emit();
    };
    StepTaxonomyComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    StepTaxonomyComponent.propDecorators = {
        taxonomy: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        change: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    StepTaxonomyComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-taxonomy',
            template: _raw_loader_step_taxonomy_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_taxonomy_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], StepTaxonomyComponent);
    return StepTaxonomyComponent;
}());



/***/ }),

/***/ "Wcxb":
/*!****************************************************************!*\
  !*** ./src/app/pipeline-status/pipeline-status.component.less ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .status-box {\n  display: flex;\n  flex-flow: row;\n}\n:host .status-box .status {\n  text-transform: capitalize;\n  padding: 0.5rem 1rem;\n  border-radius: 0.25rem;\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  justify-content: center;\n  border: 1px solid #888;\n  color: black;\n}\n:host .status-box .status label {\n  margin: 0;\n}\n:host .status-box .status.success {\n  background-color: #28a745;\n  border-color: #28a745;\n  color: white;\n}\n:host .status-box .status.failed {\n  background-color: #a93226;\n  border-color: #a93226;\n  color: white;\n}\n:host .status-box .status.running {\n  background-color: #f4d03f;\n  border-color: #f4d03f;\n}\n:host .status-box .started,\n:host .status-box .finished,\n:host .status-box .duration {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  margin: 0 1rem;\n}\n:host .status-box .started label,\n:host .status-box .finished label,\n:host .status-box .duration label {\n  font-weight: bold;\n  margin: 0;\n  margin-right: 0.25rem;\n}\n:host .logs {\n  width: 100%;\n  max-height: 100%;\n  overflow: scroll;\n  font-family: \"Courier New\", Courier, monospace;\n  white-space: pre-wrap;\n  font-size: 12px;\n  direction: ltr;\n}\n:host .result-table {\n  width: 100%;\n  overflow: scroll;\n  font-family: \"Courier New\", Courier, monospace;\n  font-size: 12px;\n}\n:host .result-table ::ng-deep table {\n  border-collapse: collapse;\n}\n:host .result-table ::ng-deep table th,\n:host .result-table ::ng-deep table td {\n  border: 1px solid #888;\n  padding: 3px 10px;\n}\n:host .result-table ::ng-deep table th {\n  text-align: center;\n  white-space: nowrap;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "X49k":
/*!**********************************************************!*\
  !*** ./src/app/pipeline-list/pipeline-list.component.ts ***!
  \**********************************************************/
/*! exports provided: PipelineListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineListComponent", function() { return PipelineListComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_list_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-list.component.html */ "wV9K");
/* harmony import */ var _pipeline_list_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-list.component.less */ "V4Lh");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../roles.service */ "FYRw");







var PipelineListComponent = /** @class */ (function () {
    function PipelineListComponent(api, roles) {
        this.api = api;
        this.roles = roles;
        this.pipelineSections = [];
    }
    PipelineListComponent.prototype.processSections = function (pipelines, level) {
        var sections = {};
        var ret = [];
        for (var _i = 0, pipelines_1 = pipelines; _i < pipelines_1.length; _i++) {
            var pipeline = pipelines_1[_i];
            var parts = pipeline.display.split('//');
            if (parts.length === 1) {
                ret.push({ type: 'pipeline', item: pipeline });
            }
            else {
                var section = parts.splice(0, 1)[0];
                pipeline.display = parts.join('//');
                sections[section] = (sections[section] || []);
                sections[section].push(pipeline);
            }
        }
        for (var _a = 0, _b = Object.keys(sections); _a < _b.length; _a++) {
            var section = _b[_a];
            var contents = this.processSections(sections[section], level + 1);
            ret.push({ type: 'section', display: section, items: contents, level: level, open: true });
        }
        return ret;
    };
    PipelineListComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.api.pipelines.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["filter"])(function (x) { return (!!x && x.length > 0); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["take"])(2)).subscribe(function (pipelines) {
            if (pipelines) {
                for (var _i = 0, pipelines_2 = pipelines; _i < pipelines_2.length; _i++) {
                    var pipeline = pipelines_2[_i];
                    pipeline.display = pipeline.name;
                }
                _this.pipelineSections = _this.processSections(pipelines, 0);
            }
        });
        this.api.queryPipelines();
    };
    PipelineListComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_6__["RolesService"] }
    ]; };
    PipelineListComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-list',
            template: _raw_loader_pipeline_list_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_list_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_6__["RolesService"]])
    ], PipelineListComponent);
    return PipelineListComponent;
}());



/***/ }),

/***/ "XG5g":
/*!************************************************************************!*\
  !*** ./src/app/step-flipped-mapping/step-flipped-mapping.component.ts ***!
  \************************************************************************/
/*! exports provided: FIELD_CONSTANT, FIELD_UNPIVOT_TARGET, FIELD_UNPIVOT_COLUMN, StepFlippedMappingComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FIELD_CONSTANT", function() { return FIELD_CONSTANT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FIELD_UNPIVOT_TARGET", function() { return FIELD_UNPIVOT_TARGET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FIELD_UNPIVOT_COLUMN", function() { return FIELD_UNPIVOT_COLUMN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepFlippedMappingComponent", function() { return StepFlippedMappingComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_flipped_mapping_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-flipped-mapping.component.html */ "vLuJ");
/* harmony import */ var _step_flipped_mapping_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-flipped-mapping.component.less */ "3YVL");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "kU1M");






var FIELD_CONSTANT = '  const  ';
var FIELD_UNPIVOT_TARGET = '  upt  ';
var FIELD_UNPIVOT_COLUMN = '  upc  ';
var StepFlippedMappingComponent = /** @class */ (function () {
    function StepFlippedMappingComponent(store) {
        var _this = this;
        this.store = store;
        this.config = null;
        this.taxonomy_id = null;
        this.mandatory_cts = [];
        this.optional_cts = [];
        this.mapping = {};
        this.badSample = {};
        this.unpivot_target = null;
        this.unpivot_columns = [];
        this.unpivot_fields = [];
        this.SAMPLE_SIZE = 5;
        this.FIELD_UNPIVOT_DUMMY = '  updummy  ';
        this.store.getConfig().pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["filter"])(function (config) { return config && config.taxonomy && config.taxonomy.columnTypes && config.taxonomy.columnTypes.length; })).subscribe(function (config) {
            if (_this.taxonomy_id !== config.taxonomy.id) {
                console.log('GOT TX CONFIG', _this.taxonomy_id, '!==', config.taxonomy.id, config);
                _this.processConfig(config);
                _this.taxonomy_id = config.taxonomy.id;
            }
            console.log('CONFIG MAPPING', config.model ? config.model.mapping : null);
            _this.config = config;
        });
        this.store.getRows().subscribe(function (row) {
            if (row.index === -1) {
                _this.badSample = {};
            }
            else {
                if (row.index >= 0) {
                    if (row.kind === 1) {
                        if (row.errors_field) {
                            var field = row.errors_field;
                            _this.badSample[field] = _this.badSample[field] || [];
                            var list = _this.badSample[field];
                            if (list.length < _this.SAMPLE_SIZE) {
                                var value = _this.store.strize(row.data[field]);
                                if (list.map(function (x) { return x.value; }).indexOf(value) < 0) {
                                    var idx = row.index;
                                    list.push({ idx: idx, value: value });
                                }
                            }
                        }
                    }
                }
            }
        });
    }
    StepFlippedMappingComponent.prototype.processConfig = function (config) {
        this.mandatory_cts = [];
        this.optional_cts = [];
        this.unpivot_target = null;
        this.unpivot_columns = [];
        this.unpivot_fields = [];
        // Mapping of mapping.name -> ct.title
        var mNameToCtTitle = {};
        for (var _i = 0, _a = config.model.mapping; _i < _a.length; _i++) {
            var mapping = _a[_i];
            if (!mapping.columnType) {
                continue;
            }
            for (var _b = 0, _c = config.taxonomy.columnTypes; _b < _c.length; _b++) {
                var ct = _c[_b];
                if (mapping.columnType === ct.name) {
                    mNameToCtTitle[mapping.name] = ct.title;
                }
            }
        }
        // Normalize pivoting parameters
        var usedColumns = [];
        for (var _d = 0, _e = config.model.mapping; _d < _e.length; _d++) {
            var mapping = _e[_d];
            if (mapping.normalizeTarget) {
                this.unpivot_target = mNameToCtTitle[mapping.normalizeTarget] || mapping.normalizeTarget;
                var _normalize = {};
                for (var _f = 0, _g = Object.keys(mapping.normalize); _f < _g.length; _f++) {
                    var column = _g[_f];
                    var _column = mNameToCtTitle[column] || column;
                    if (this.unpivot_columns.indexOf(_column) < 0) {
                        this.unpivot_columns.push(_column);
                    }
                    _normalize[_column] = mapping.normalize[column];
                }
                this.unpivot_fields.push({ field_name: mapping.name, mapping: _normalize });
            }
        }
        console.log('UNPIVOT: target', this.unpivot_target, 'columns', this.unpivot_columns, 'fields', this.unpivot_fields);
        for (var _h = 0, _j = config.taxonomy.columnTypes; _h < _j.length; _h++) {
            var ct = _j[_h];
            var mapping = {};
            var constant = null;
            for (var _k = 0, _l = config.model.mapping; _k < _l.length; _k++) {
                var _mapping = _l[_k];
                if (_mapping.columnType === ct.name) {
                    mapping = _mapping;
                    break;
                }
            }
            for (var _m = 0, _o = config.constants; _m < _o.length; _m++) {
                var extra = _o[_m];
                if (extra[0] === ct.title) {
                    constant = extra[1];
                }
            }
            var mappingType = '';
            if (constant !== null) {
                mappingType = FIELD_CONSTANT;
            }
            else if (this.unpivot_columns.indexOf(ct.title) >= 0) {
                mappingType = FIELD_UNPIVOT_COLUMN;
            }
            else if (this.unpivot_target && ct.title === this.unpivot_target) {
                mappingType = FIELD_UNPIVOT_TARGET;
            }
            else if (mapping.name) {
                mappingType = mapping.name;
            }
            if (mappingType !== FIELD_CONSTANT && mappingType !== FIELD_UNPIVOT_TARGET &&
                mappingType !== FIELD_UNPIVOT_COLUMN && mappingType !== '') {
                if (usedColumns.indexOf(mappingType) >= 0) {
                    mappingType = '';
                    delete mapping['name'];
                }
                else {
                    usedColumns.push(mappingType);
                }
            }
            this.mapping[ct.name] = { ct: ct, mapping: mapping, constant: constant, mappingType: mappingType };
            if (ct.mandatory || ct.treat_as_mandatory) {
                this.mandatory_cts.push({ ct: ct, mapping: mapping, constant: constant, mappingType: mappingType });
            }
            else {
                this.optional_cts.push({ ct: ct, mapping: mapping, constant: constant, mappingType: mappingType });
            }
        }
    };
    StepFlippedMappingComponent.prototype.updateMapping = function (entry) {
        this.mapping[entry.ct.name] = entry;
        this.recreateMappings();
    };
    StepFlippedMappingComponent.prototype.recreateMappings = function () {
        var mapping = [];
        var constants = [];
        var unpivot_target = null;
        var unpivot_columns = [];
        for (var _i = 0, _a = this.config.taxonomy.columnTypes; _i < _a.length; _i++) {
            var _ct = _a[_i];
            if (this.mapping[_ct.name]) {
                var entry = this.mapping[_ct.name];
                if (entry.mappingType === FIELD_CONSTANT) {
                    mapping.push(Object.assign(entry.mapping, { name: entry.ct.title }));
                    constants.push([entry.ct.title, entry.constant]);
                }
                else if (entry.mappingType === FIELD_UNPIVOT_TARGET) {
                    unpivot_target = entry.ct.title;
                    mapping.push(Object.assign(entry.mapping, { name: unpivot_target }));
                }
                else if (entry.mappingType === FIELD_UNPIVOT_COLUMN) {
                    unpivot_columns.push(_ct.title);
                    mapping.push(Object.assign(entry.mapping, { name: entry.ct.title }));
                }
                else if (entry.mappingType === '') {
                }
                else {
                    mapping.push(Object.assign(entry.mapping, { name: entry.mappingType }));
                }
            }
        }
        // Add unpivot columns mapping
        if (unpivot_target !== null) {
            if (this.unpivot_fields.length === 0) {
                this.unpivot_fields.push({ field_name: this.FIELD_UNPIVOT_DUMMY, mapping: {} });
            }
            for (var _b = 0, _c = this.unpivot_fields; _b < _c.length; _b++) {
                var unpivot_field = _c[_b];
                for (var _d = 0, unpivot_columns_1 = unpivot_columns; _d < unpivot_columns_1.length; _d++) {
                    var column = unpivot_columns_1[_d];
                    unpivot_field.mapping[column] = unpivot_field.mapping[column] || '';
                }
                if (unpivot_field.field_name === this.FIELD_UNPIVOT_DUMMY &&
                    this.unpivot_fields.length > 1) {
                    continue;
                }
                if (unpivot_field.field_name) {
                    mapping.push({
                        name: unpivot_field.field_name,
                        normalizeTarget: unpivot_target,
                        normalize: unpivot_field.mapping
                    });
                }
            }
        }
        console.log('RECREATED MAPPING:', mapping);
        this.config.model.mapping = mapping;
        this.config.constants = constants;
        this.processConfig(this.config);
        this.store.setConfig(this.config);
    };
    StepFlippedMappingComponent.prototype.add_unpivot_field = function (name) {
        console.log('add_unpivot_field', name);
        this.unpivot_fields = this.unpivot_fields.filter(function (x) { return x.field_name !== name; });
        this.unpivot_fields.push({
            field_name: name,
            mapping: {}
        });
        this.recreateMappings();
    };
    StepFlippedMappingComponent.prototype.delete_unpivot_field = function (name) {
        this.unpivot_fields = this.unpivot_fields.filter(function (x) { return x.field_name !== name; });
        this.recreateMappings();
    };
    StepFlippedMappingComponent.prototype.ngOnInit = function () {
    };
    StepFlippedMappingComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    StepFlippedMappingComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-flipped-mapping',
            template: _raw_loader_step_flipped_mapping_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_flipped_mapping_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], StepFlippedMappingComponent);
    return StepFlippedMappingComponent;
}());



/***/ }),

/***/ "Xtub":
/*!******************************************************************************!*\
  !*** ./src/app/step-extract-structure/step-extract-structure.component.less ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3N0ZXAtZXh0cmFjdC1zdHJ1Y3R1cmUvc3RlcC1leHRyYWN0LXN0cnVjdHVyZS5jb21wb25lbnQubGVzcyJ9 */");

/***/ }),

/***/ "Y7eG":
/*!**********************************!*\
  !*** ./src/app/extras/extras.ts ***!
  \**********************************/
/*! exports provided: extraDeclarations, extraMapping, ExtraModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "extraDeclarations", function() { return extraDeclarations; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "extraMapping", function() { return extraMapping; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExtraModule", function() { return ExtraModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


var extraDeclarations = [];
var extraMapping = {};
var ExtraModule = /** @class */ (function () {
    function ExtraModule() {
    }
    ExtraModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [],
            entryComponents: [],
        })
    ], ExtraModule);
    return ExtraModule;
}());



/***/ }),

/***/ "Z/Wp":
/*!************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-list-item/pipeline-list-item.component.html ***!
  \************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='name'>{{item.display}}</div>\n<div class='status'>\n    <span [class]='item.status.status'>{{status}}</span>\n</div>\n<div class='kind'>{{((api.configuration | async).kinds_map[item.kind] || {display:item.kind}).display }}</div>\n<div class='schedule'>{{((api.configuration | async).schedules_map[item.schedule] || {display:item.schedules}).display }}</div>\n<div class='delete'><a *ngIf='canDelete()' (click)='delete($event)' i18n>Delete</a></div>\n<div class='view-status'><a *ngIf='roles._.pipelinesStatusPublic' [routerLink]='\"/status/\" + item.id' i18n>View Status</a></div>\n<div class='edit'><a *ngIf='canEdit()' [routerLink]='\"/edit/\" + item.id' i18n>Edit</a></div>\n<div class='view'><a *ngIf='item.result && item.result.view_url' [href]='item.result.view_url' target='_blank'><i class=\"far fa-eye\"></i></a></div>\n");

/***/ }),

/***/ "ZAI4":
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/*! exports provided: AppModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppModule", function() { return AppModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./app-routing.module */ "vY5A");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./app.component */ "Sy1n");
/* harmony import */ var _pipeline_status_pipeline_status_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./pipeline-status/pipeline-status.component */ "zCYW");
/* harmony import */ var _edit_pipeline_edit_pipeline_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./edit-pipeline/edit-pipeline.component */ "qn5Q");
/* harmony import */ var _pipeline_list_pipeline_list_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./pipeline-list/pipeline-list.component */ "X49k");
/* harmony import */ var _pipeline_list_item_pipeline_list_item_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./pipeline-list-item/pipeline-list-item.component */ "suJK");
/* harmony import */ var _pipeline_status_dashboard_pipeline_status_dashboard_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./pipeline-status-dashboard/pipeline-status-dashboard.component */ "qjdf");
/* harmony import */ var _pipeline_list_headers_pipeline_list_headers_component__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./pipeline-list-headers/pipeline-list-headers.component */ "JjgC");
/* harmony import */ var _dynamic_fields_editor_dynamic_fields_editor_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./dynamic-fields-editor/dynamic-fields-editor.component */ "Qa3L");
/* harmony import */ var _dgp_workbench_dgp_workbench_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./dgp-workbench/dgp-workbench.component */ "Loy1");
/* harmony import */ var _step_enrich_step_enrich_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./step-enrich/step-enrich.component */ "muwd");
/* harmony import */ var _results_results_component__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./results/results.component */ "NUXy");
/* harmony import */ var _result_tabs_result_tabs_component__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./result-tabs/result-tabs.component */ "S6Lp");
/* harmony import */ var _result_table_result_table_component__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./result-table/result-table.component */ "ld2h");
/* harmony import */ var _step_tabs_step_tabs_component__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./step-tabs/step-tabs.component */ "mF1b");
/* harmony import */ var _step_extract_source_step_extract_source_component__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./step-extract-source/step-extract-source.component */ "yb8t");
/* harmony import */ var _step_extract_structure_step_extract_structure_component__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./step-extract-structure/step-extract-structure.component */ "1Gxh");
/* harmony import */ var _step_mapping_field_step_mapping_field_component__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./step-mapping-field/step-mapping-field.component */ "4cWX");
/* harmony import */ var _extendable_keyvalue_list_extendable_keyvalue_list_component__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./extendable-keyvalue-list/extendable-keyvalue-list.component */ "on5d");
/* harmony import */ var _failure_marquee_failure_marquee_component__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./failure-marquee/failure-marquee.component */ "7YSA");
/* harmony import */ var _extra_config_question_extra_config_question_component__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./extra-config-question/extra-config-question.component */ "j/XB");
/* harmony import */ var _extra_config_questions_extra_config_questions_component__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./extra-config-questions/extra-config-questions.component */ "AGu5");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./login/login.component */ "vtpD");
/* harmony import */ var _header_header_component__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./header/header.component */ "fECr");
/* harmony import */ var _container_container_component__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./container/container.component */ "s7Ec");
/* harmony import */ var _dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./dashboard/dashboard.component */ "QX6l");
/* harmony import */ var _logout_logout_component__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./logout/logout.component */ "n1B2");
/* harmony import */ var _users_users_component__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./users/users.component */ "oYre");
/* harmony import */ var _user_list_item_user_list_item_component__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./user-list-item/user-list-item.component */ "/ARz");
/* harmony import */ var _files_files_component__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./files/files.component */ "jL/9");
/* harmony import */ var _file_uploader_file_uploader_component__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./file-uploader/file-uploader.component */ "ACWU");
/* harmony import */ var _file_list_item_file_list_item_component__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./file-list-item/file-list-item.component */ "1jOV");
/* harmony import */ var _step_taxonomy_step_taxonomy_component__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./step-taxonomy/step-taxonomy.component */ "Wbot");
/* harmony import */ var _results_tab_selector_results_tab_selector_component__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./results-tab-selector/results-tab-selector.component */ "0mIb");
/* harmony import */ var _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./step-flipped-mapping/step-flipped-mapping.component */ "XG5g");
/* harmony import */ var _step_flipped_mapping_field_step_flipped_mapping_field_component__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./step-flipped-mapping-field/step-flipped-mapping-field.component */ "vyeE");
/* harmony import */ var _confirmer_confirmer_component__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./confirmer/confirmer.component */ "j74D");
/* harmony import */ var _taxonomies_taxonomies_component__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./taxonomies/taxonomies.component */ "HV3y");
/* harmony import */ var _taxonomy_item_taxonomy_item_component__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./taxonomy-item/taxonomy-item.component */ "gl/P");
/* harmony import */ var _data_record_list_data_record_list_component__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./data-record-list/data-record-list.component */ "sJCo");
/* harmony import */ var _data_record_edit_data_record_edit_component__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./data-record-edit/data-record-edit.component */ "K1Oo");
/* harmony import */ var _data_record_edit_inner_data_record_edit_inner_component__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./data-record-edit-inner/data-record-edit-inner.component */ "8uQj");
/* harmony import */ var _data_record_edit_aux_directive__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./data-record-edit-aux.directive */ "mUmp");
/* harmony import */ var _extras_extras__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./extras/extras */ "Y7eG");
/* harmony import */ var _dgp_workbench_buttons_dgp_workbench_buttons_component__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./dgp-workbench-buttons/dgp-workbench-buttons.component */ "HmNa");
/* harmony import */ var _pipeline_list_section_pipeline_list_section_component__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./pipeline-list-section/pipeline-list-section.component */ "o9hB");




















































var AppModule = /** @class */ (function () {
    function AppModule() {
    }
    AppModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["NgModule"])({
            declarations: [
                _app_component__WEBPACK_IMPORTED_MODULE_7__["AppComponent"],
                _pipeline_status_pipeline_status_component__WEBPACK_IMPORTED_MODULE_8__["PipelineStatusComponent"],
                _edit_pipeline_edit_pipeline_component__WEBPACK_IMPORTED_MODULE_9__["EditPipelineComponent"],
                _pipeline_list_pipeline_list_component__WEBPACK_IMPORTED_MODULE_10__["PipelineListComponent"],
                _pipeline_list_item_pipeline_list_item_component__WEBPACK_IMPORTED_MODULE_11__["PipelineListItemComponent"],
                _pipeline_status_dashboard_pipeline_status_dashboard_component__WEBPACK_IMPORTED_MODULE_12__["PipelineStatusDashboardComponent"],
                _pipeline_list_headers_pipeline_list_headers_component__WEBPACK_IMPORTED_MODULE_13__["PipelineListHeadersComponent"],
                _dynamic_fields_editor_dynamic_fields_editor_component__WEBPACK_IMPORTED_MODULE_14__["DynamicFieldsEditorComponent"],
                _dgp_workbench_dgp_workbench_component__WEBPACK_IMPORTED_MODULE_15__["DgpWorkbenchComponent"],
                _step_enrich_step_enrich_component__WEBPACK_IMPORTED_MODULE_16__["StepEnrichComponent"],
                _results_results_component__WEBPACK_IMPORTED_MODULE_17__["ResultsComponent"],
                _result_tabs_result_tabs_component__WEBPACK_IMPORTED_MODULE_18__["ResultTabsComponent"],
                _result_table_result_table_component__WEBPACK_IMPORTED_MODULE_19__["ResultTableComponent"],
                _step_tabs_step_tabs_component__WEBPACK_IMPORTED_MODULE_20__["StepTabsComponent"],
                _step_extract_source_step_extract_source_component__WEBPACK_IMPORTED_MODULE_21__["StepExtractSourceComponent"],
                _step_extract_structure_step_extract_structure_component__WEBPACK_IMPORTED_MODULE_22__["StepExtractStructureComponent"],
                _step_mapping_field_step_mapping_field_component__WEBPACK_IMPORTED_MODULE_23__["StepMappingFieldComponent"],
                _extendable_keyvalue_list_extendable_keyvalue_list_component__WEBPACK_IMPORTED_MODULE_24__["ExtendableKeyvalueListComponent"],
                _failure_marquee_failure_marquee_component__WEBPACK_IMPORTED_MODULE_25__["FailureMarqueeComponent"],
                _extra_config_question_extra_config_question_component__WEBPACK_IMPORTED_MODULE_26__["ExtraConfigQuestionComponent"],
                _extra_config_questions_extra_config_questions_component__WEBPACK_IMPORTED_MODULE_27__["ExtraConfigQuestionsComponent"],
                _login_login_component__WEBPACK_IMPORTED_MODULE_28__["LoginComponent"],
                _header_header_component__WEBPACK_IMPORTED_MODULE_29__["HeaderComponent"],
                _container_container_component__WEBPACK_IMPORTED_MODULE_30__["ContainerComponent"],
                _dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_31__["DashboardComponent"],
                _logout_logout_component__WEBPACK_IMPORTED_MODULE_32__["LogoutComponent"],
                _users_users_component__WEBPACK_IMPORTED_MODULE_33__["UsersComponent"],
                _user_list_item_user_list_item_component__WEBPACK_IMPORTED_MODULE_34__["UserListItemComponent"],
                _files_files_component__WEBPACK_IMPORTED_MODULE_35__["FilesComponent"],
                _file_uploader_file_uploader_component__WEBPACK_IMPORTED_MODULE_36__["FileUploaderComponent"],
                _file_list_item_file_list_item_component__WEBPACK_IMPORTED_MODULE_37__["FileListItemComponent"],
                _step_taxonomy_step_taxonomy_component__WEBPACK_IMPORTED_MODULE_38__["StepTaxonomyComponent"],
                _results_tab_selector_results_tab_selector_component__WEBPACK_IMPORTED_MODULE_39__["ResultsTabSelectorComponent"],
                _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_40__["StepFlippedMappingComponent"],
                _step_flipped_mapping_field_step_flipped_mapping_field_component__WEBPACK_IMPORTED_MODULE_41__["StepFlippedMappingFieldComponent"],
                _confirmer_confirmer_component__WEBPACK_IMPORTED_MODULE_42__["ConfirmerComponent"],
                _taxonomies_taxonomies_component__WEBPACK_IMPORTED_MODULE_43__["TaxonomiesComponent"],
                _taxonomy_item_taxonomy_item_component__WEBPACK_IMPORTED_MODULE_44__["TaxonomyItemComponent"],
                _data_record_list_data_record_list_component__WEBPACK_IMPORTED_MODULE_45__["DataRecordListComponent"],
                _data_record_edit_data_record_edit_component__WEBPACK_IMPORTED_MODULE_46__["DataRecordEditComponent"],
                _data_record_edit_inner_data_record_edit_inner_component__WEBPACK_IMPORTED_MODULE_47__["DataRecordEditInnerComponent"],
                _data_record_edit_aux_directive__WEBPACK_IMPORTED_MODULE_48__["DataRecordEditAuxDirective"],
                _dgp_workbench_buttons_dgp_workbench_buttons_component__WEBPACK_IMPORTED_MODULE_50__["DgpWorkbenchButtonsComponent"],
                _pipeline_list_section_pipeline_list_section_component__WEBPACK_IMPORTED_MODULE_51__["PipelineListSectionComponent"],
            ],
            entryComponents: [
                _data_record_edit_inner_data_record_edit_inner_component__WEBPACK_IMPORTED_MODULE_47__["DataRecordEditInnerComponent"]
            ],
            imports: [
                _angular_platform_browser__WEBPACK_IMPORTED_MODULE_1__["BrowserModule"],
                _app_routing_module__WEBPACK_IMPORTED_MODULE_5__["AppRoutingModule"],
                _angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClientModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_4__["FormsModule"],
                dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_6__["DgpOauth2Module"],
                _extras_extras__WEBPACK_IMPORTED_MODULE_49__["ExtraModule"],
            ],
            providers: [],
            bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_7__["AppComponent"]]
        })
    ], AppModule);
    return AppModule;
}());



/***/ }),

/***/ "a3Je":
/*!************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-mapping-field/step-mapping-field.component.html ***!
  \************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='selection'>\n  <i class=\"fas fa-caret-right\" *ngIf='!hasErrors' [class.open]='more' (click)='more = !more'></i>\n  <i class=\"fa fa-exclamation-triangle\" *ngIf='hasErrors'></i>\n  <label class='main'>{{mapping.name}}</label>\n  <i class='fa fa-arrow-right'></i>\n  <select *ngIf='!mapping.compound'\n          class='ct-selector'\n          [value]='mapping.columnType'\n          (change)='updateMapping($event.target.value); changed()'>\n    <option [value]='null'>-</option>\n    <option *ngFor='let ct of taxonomy.columnTypes'\n            [value]='ct.name'>{{ct.title}}\n    </option>\n  </select>\n  <select *ngIf='mapping.compound'\n          class='ct-selector'\n          [value]='mapping.normalizeTarget'\n          (change)='mapping.normalizeTarget = $event.target.value; changed()'>\n    <option [value]='null'>-</option>\n    <option *ngFor='let ct of taxonomy.columnTypes'\n            [value]='ct.name'>{{ct.title}}\n    </option>\n  </select>\n</div>\n<div class='description' *ngIf='mapping.description && !mapping.compound'>\n  {{ mapping.description }}\n</div>\n<div class='compound-mapping' *ngIf='mapping.compound'>\n  <span class='for' i18n>for</span>\n  <app-extendable-keyvalue-list\n    [taxonomy]='taxonomy'\n    [data]='mapping.normalize || {}'\n    (update)='mapping.normalize = $event; changed()'\n  ></app-extendable-keyvalue-list>\n</div>\n<div class='more' *ngIf='more || hasErrors'>\n  <div class='options'>\n    <div>\n      <div class='formish'>\n        <label i18n>Title:</label>\n        <input [(ngModel)]='mapping.title' type='text'>\n      </div>\n      <ng-container *ngIf='ct.dataType === \"date\"'>\n        <ng-container *ngIf='api.currentConfig.dateFormats && api.currentConfig.dateFormats.length > 0'>\n          <div class='formish'>\n            <label i18n>Date Format:</label>\n            <select [(ngModel)]='mapping.options.format'>\n              <option [value]='df.format' *ngFor='let df of api.currentConfig.dateFormats'>{{df.display}}</option>\n            </select>\n          </div>\n        </ng-container>\n        <div class='formish'>\n          <label i18n>Custom Format:</label>\n          <input [(ngModel)]='mapping.options.format' type='text'>\n        </div>\n        <div class='workbench-explanation' i18n>More information on custom formats can be found <a href='https://strftime.org/' target='_blank'>here</a>.</div>\n      </ng-container>\n      <ng-container *ngIf='ct.dataType === \"boolean\"'>\n        <div class='formish'>\n          <label i18n>True Values:</label>\n          <input [(ngModel)]='trueValues' type='text'>\n        </div>\n        <div class='formish'>\n          <label i18n>False Values:</label>\n          <input [(ngModel)]='falseValues' type='text'>\n        </div>\n      </ng-container>\n      <ng-container *ngIf='ct.dataType === \"number\"'>\n        <div class='formish'>\n          <label i18n>Decimal Separator:</label>\n          <input [(ngModel)]='mapping.options.decimalChar' type='text'>\n        </div>\n        <div class='formish'>\n          <label i18n>Thousands Separator:</label>\n          <input [(ngModel)]='mapping.options.groupChar' type='text'>\n        </div>\n      </ng-container>\n    </div>\n    <div class='sample'>\n      <table *ngIf='sample && sample.length'>\n        <tr><th colspan='2' i18n>Sample of bad values</th></tr>\n        <tr><th i18n>Row #</th><th>Value</th></tr>\n        <tr *ngFor='let item of sample'>\n          <td>{{ item.idx }}</td>\n          <td>{{ item.value }}</td>\n        </tr>\n      </table>\n    </div>\n  </div>\n  <a class='toggle-compound' (click)='mapping.compound=true' i18n *ngIf='!mapping.compound'>Change to compound mapping</a>\n  <a class='toggle-compound' (click)='mapping.compound=false' i18n *ngIf='mapping.compound'>Change to simple mapping</a>\n</div>");

/***/ }),

/***/ "aRl/":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/data-record-edit-inner/data-record-edit-inner.component.html ***!
  \********************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='def.fields'>\n  <app-dynamic-fields-editor [item]='datarecord' [fields]='def.fields'></app-dynamic-fields-editor>\n</ng-container>\n");

/***/ }),

/***/ "atfz":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-taxonomy/step-taxonomy.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("  <ng-container *ngIf='!hidden'>\n    <h2 class='workbench-subtitle'>Data Taxonomy</h2>\n\n    <div class='workbench-explanation' i18n>\n      The detected data taxonomy for this dataset -\n    </div>\n    <div class='formish'>\n      <label i18n>Taxonomy:</label>\n      <select [(ngModel)]='taxonomy.id' (change)='changed()'>\n        <option *ngFor='let txid of taxonomy.options' [value]='txid.id'>{{txid.title}}</option>\n      </select>\n    </div>\n  </ng-container>\n\n  <h2 class='workbench-subtitle'>Ignored Values</h2>\n\n  <div class='workbench-explanation' i18n>\n    By default, only empty cells will be considered as empty.<br/>\n    If other values need to be ignored as well, add them here in a comma separated list (with no extra whitespace).\n  </div>\n  <div class='formish'>\n    <label i18n>Empty Values:</label>\n    <input type='text'\n      [(ngModel)]='missingValues'\n      (change)='changed()'\n    />\n  </div>\n");

/***/ }),

/***/ "bdr3":
/*!**********************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/files/files.component.html ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Source Data</h1>\n  <div *ngIf='roles._.filesUpload' class='add-new'><a (click)='upload()' i18n>\n    <i class=\"fas fa-plus-circle\" aria-hidden=\"true\"></i>\n    Upload Data File</a>\n  </div>\n  <app-file-uploader *ngIf='uploaderVisible' (close)='uploaderVisible=false' [filename]='forceFilename'></app-file-uploader>\n\n  <div class='controls'>\n    <a i18n (click)='sort = \"alpha\"; processFiles()'>\n      <i class='far' [class.fa-check-square]=\"sort==='alpha'\" [class.fa-square]=\"sort!=='alpha'\"></i>\n      Sort Alphabetically\n    </a>&nbsp;|&nbsp;\n    <a i18n (click)='sort = \"date\"; processFiles()'>\n      <i class='far' [class.fa-check-square]=\"sort==='date'\" [class.fa-square]=\"sort!=='date'\"></i>\n      Sort by Update Date\n    </a>&nbsp;|&nbsp;\n    <a i18n (click)='justMine = !justMine; processFiles()'>\n      <i class='far' [class.fa-check-square]='justMine' [class.fa-square]='!justMine'></i>\n      Show only My Files\n    </a>\n  </div>\n  <ng-container *ngFor='let item of showFiles'>\n    <app-file-list-item [item]='item' (update)='update(item.filename)'></app-file-list-item>\n  </ng-container>\n</app-container>");

/***/ }),

/***/ "c41A":
/*!**************************************!*\
  !*** ./src/app/confirmer.service.ts ***!
  \**************************************/
/*! exports provided: ConfirmerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfirmerService", function() { return ConfirmerService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "kU1M");




var ConfirmerService = /** @class */ (function () {
    function ConfirmerService() {
        this.ACTION_DELETE_USER = 0;
        this.ACTION_DELETE_TASK = 1;
        this.ACTION_DELETE_FILE = 2;
        this.action = null;
        this.what = null;
        this.active = false;
        this.result = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
    }
    ConfirmerService.prototype.confirm = function (action, what) {
        var _this = this;
        this.action = action;
        this.what = what;
        this.active = true;
        return this.result.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["first"])(), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["map"])(function (result) {
            _this.action = null;
            _this.what = null;
            _this.active = false;
            return result;
        }));
    };
    ConfirmerService.prototype.choose = function (result) {
        this.result.next(result);
    };
    ConfirmerService.ctorParameters = function () { return []; };
    ConfirmerService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ConfirmerService);
    return ConfirmerService;
}());



/***/ }),

/***/ "cQqm":
/*!********************************************!*\
  !*** ./src/app/users/users.component.less ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3VzZXJzL3VzZXJzLmNvbXBvbmVudC5sZXNzIn0= */");

/***/ }),

/***/ "crnd":
/*!**********************************************************!*\
  !*** ./src/$$_lazy_route_resource lazy namespace object ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncaught exception popping up in devtools
	return Promise.resolve().then(function() {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	});
}
webpackEmptyAsyncContext.keys = function() { return []; };
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
module.exports = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = "crnd";

/***/ }),

/***/ "deNa":
/*!**********************************!*\
  !*** ./src/app/theme.service.ts ***!
  \**********************************/
/*! exports provided: ThemeService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ThemeService", function() { return ThemeService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./api.service */ "yTNM");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");





var ThemeService = /** @class */ (function () {
    function ThemeService(api, locale) {
        this.api = api;
        this.locale = locale;
        this.api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["first"])()).subscribe(function (configuration) {
            var theme = configuration.theme || {};
            console.log('THEME=', configuration);
            console.log('LOCALE=', locale);
            var primary = theme.primary || '#059';
            var primary_dark = theme.primary_dark || '#003b6b';
            var secondary = theme.secondary || '#fff';
            var right = locale === 'he' ? 'left' : 'right;';
            var left = locale === 'he' ? 'right' : 'left;';
            var css = "\n          body {\n            direction: " + Object(_angular_common__WEBPACK_IMPORTED_MODULE_2__["getLocaleDirection"])(locale) + ";\n          }\n          a, a:visited {\n              color: " + primary + ";\n          }\n          .theme-primary-fg {\n            color: " + primary + ";\n          }\n          .theme-secondary-fg {\n              color: " + secondary + " !important;\n          }\n          .theme-primary-bg {\n              background-color: " + primary + ";\n          }\n          .theme-secondary-bg {\n              background-color: " + secondary + ";\n          }\n          .theme-primary-dark-bg {\n              background-color: " + primary_dark + ";\n          }\n          .theme-primary-dark-border {\n              border-color: " + primary_dark + ";\n          }\n          .buttons .button {\n              color: " + secondary + ";\n              background-color: " + primary + ";\n              border-color: " + primary_dark + ";\n          }\n          .buttons .button:hover {\n              background-color: " + secondary + ";\n              color: " + primary + ";\n          }\n          h2.workbench-subtitle {\n            color: " + secondary + ";\n            background-color: " + primary + ";\n            min-width: 70%;\n            padding: 3px 10px;\n            margin: 20px -10px;\n            font-size: 18px;\n            font-weight: bold;\n          }\n          h3.workbench-subsubtitle {\n            color: " + secondary + ";\n            background-color: " + primary + ";\n            min-width: 70%;\n            padding: 3px 8px;\n            margin: 12px -8px;\n            font-size: 16px;\n            font-weight: normal;\n            margin-" + right + ": 40px;\n          }\n          h4.workbench-subsubsubtitle {\n            color: " + primary + ";\n            border-" + left + ": solid 8px " + primary + ";\n            padding: 0px 8px;\n            margin-" + left + ": -16px;\n            margin-top: 20px;\n            margin-bottom: 8px;\n            font-size: 16px;\n            font-weight: bold;\n          }\n          div.workbench-explanation {\n            color: " + primary + ";\n            font-size: 14px;\n            font-weight: lighter;\n          }\n      ";
            var style = document.createElement('style');
            style.type = 'text/css';
            style.innerHTML = css;
            document.getElementsByTagName('head')[0].appendChild(style);
            var scripts = configuration.extraScripts || [];
            for (var _i = 0, scripts_1 = scripts; _i < scripts_1.length; _i++) {
                var scriptContent = scripts_1[_i];
                var script = document.createElement('script');
                script.type = 'text/javascript';
                script.innerHTML = scriptContent;
                document.body.appendChild(script);
            }
        });
    }
    ThemeService.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_3__["ApiService"] },
        { type: String, decorators: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Inject"], args: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["LOCALE_ID"],] }] }
    ]; };
    ThemeService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_3__["ApiService"], String])
    ], ThemeService);
    return ThemeService;
}());



/***/ }),

/***/ "e5Yk":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-flipped-mapping-field/step-flipped-mapping-field.component.html ***!
  \****************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<h4 class='workbench-subsubsubtitle'>{{ct.title}}</h4>\n<div class='description' *ngIf='ct.description'>{{ct.description}}</div>\n<div class='formish'>\n  <label i18n>Take value from...</label>\n  <select [(ngModel)]='_mappingType'>\n    <option *ngIf='!ct.mandatory' selected value='' i18n>No value for this field</option>\n    <option [value]='MT_FIELD_CONSTANT' i18n>Constant...</option>\n    <option [selected]='ct.mandatory' disabled value=''>---</option>\n    <optgroup label='Un-pivoting'>\n      <option [value]='MT_FIELD_UNPIVOT_TARGET' i18n>Un-pivoting value</option>\n      <option [value]='MT_FIELD_UNPIVOT_COLUMN' i18n>Un-pivoting additional column</option>\n    </optgroup>\n    <optgroup label='Source Columns'>\n      <option *ngFor='let header of config.structure.headers' [value]='header'>{{ header }}</option>\n    </optgroup>\n  </select>\n  <div class='constant' *ngIf='mappingType === MT_FIELD_CONSTANT'>\n    <label i18n>Constant Value:</label>\n    <input type='text' [(ngModel)]='constant' (change)='changed()'>\n  </div>\n</div>\n<div *ngIf='expanded || (sample && sample.length)'>\n  <div class='options'>\n    <div>\n      <div class='formish' *ngIf='titleVisible'>\n        <label i18n>Title:</label>\n        <input [(ngModel)]='mapping.title' type='text' (change)='changed()' [readonly]='!titleEditable'>\n      </div>\n      <ng-container *ngIf='ct.dataType === \"date\"'>\n        <ng-container *ngIf='api.currentConfig.dateFormats && api.currentConfig.dateFormats.length > 0'>\n          <div class='formish'>\n            <label i18n>Date Format:</label>\n            <select [(ngModel)]='mapping.options.format' (change)='changed()'>\n              <option [value]='df.format' *ngFor='let df of api.currentConfig.dateFormats'>{{df.display}}</option>\n            </select>\n          </div>\n        </ng-container>\n        <div class='formish'>\n          <label i18n>Custom Format:</label>\n          <input [(ngModel)]='mapping.options.format' type='text' (change)='changed()'>\n        </div>\n        <div class='workbench-explanation' i18n>More information on custom formats can be found <a href='https://strftime.org/' target='_blank'>here</a>.</div>\n      </ng-container>\n      <ng-container *ngIf='ct.dataType === \"boolean\"'>\n        <div class='formish'>\n          <label i18n>True Values:</label>\n          <input [(ngModel)]='trueValues' type='text' (change)='changed()'>\n        </div>\n        <div class='formish'>\n          <label i18n>False Values:</label>\n          <input [(ngModel)]='falseValues' type='text' (change)='changed()'>\n        </div>\n      </ng-container>\n      <ng-container *ngIf='ct.dataType === \"number\"'>\n        <div class='formish'>\n          <label i18n>Decimal Separator:</label>\n          <input [(ngModel)]='mapping.options.decimalChar' type='text' (change)='changed()'>\n        </div>\n        <div class='formish'>\n          <label i18n>Thousands Separator:</label>\n          <input [(ngModel)]='mapping.options.groupChar' type='text' (change)='changed()'>\n        </div>\n        <div class='formish'>\n          <label i18n>Bare Number:</label>\n          <input [(ngModel)]='mapping.options.bareNumber' type='checkbox' (change)='changed()'>\n        </div>\n      </ng-container>\n    </div>\n    <div class='sample'>\n      <table *ngIf='sample && sample.length'>\n        <tr><th colspan='2' i18n>Sample of bad values</th></tr>\n        <tr><th i18n>Row #</th><th i18n>Value</th></tr>\n        <tr *ngFor='let item of sample'>\n          <td>{{ item.idx }}</td>\n          <td>{{ item.value }}</td>\n        </tr>\n      </table>\n    </div>\n  </div>\n</div>\n<ng-container *ngIf='canExpand() && (!sample || !sample.length)'>\n  <a class='expander' *ngIf='expanded' (click)='expanded=false' i18n>less settings...</a>\n  <a class='expander' *ngIf='!expanded' (click)='expanded=true' i18n>more settings...</a>\n</ng-container>");

/***/ }),

/***/ "eXth":
/*!**********************************!*\
  !*** ./src/app/store.service.ts ***!
  \**********************************/
/*! exports provided: StoreService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreService", function() { return StoreService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./api.service */ "yTNM");





function compare(obj1, obj2, prefix) {
    if (!obj1 || !obj2) {
        return false;
    }
    if (!prefix) {
        prefix = '';
    }
    try {
        // Loop through properties in object 1
        for (var _i = 0, _a = Object.keys(obj1); _i < _a.length; _i++) {
            var p = _a[_i];
            // ignore properties starting with '_'
            if (p[0] === '_') {
                continue;
            }
            // Check property exists on both objects
            if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
                return false;
            }
            switch (typeof (obj1[p])) {
                // Deep compare objects
                case 'object':
                    if (obj1[p]) {
                        if (!compare(obj1[p], obj2[p], prefix + p + '.')) {
                            return false;
                        }
                    }
                    else {
                        if (obj2[p]) {
                            return false;
                        }
                    }
                    break;
                // Compare values
                default:
                    if (obj1[p] !== obj2[p]) {
                        console.log('mismatch', prefix + p);
                        return false;
                    }
            }
        }
        // Check object 2 for any extra properties
        for (var p in obj2) {
            if (typeof (obj1[p]) === 'undefined') {
                return false;
            }
        }
    }
    catch (e) {
        console.log('error in', prefix, e);
    }
    return true;
}
var StoreService = /** @class */ (function () {
    function StoreService(api) {
        var _this = this;
        this.api = api;
        this._config = new rxjs__WEBPACK_IMPORTED_MODULE_2__["BehaviorSubject"](Object.assign({}, this.BASE_CONFIG));
        this.currentConfig = JSON.parse(JSON.stringify(this._config.getValue()));
        this._rows = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
        this._rowcount = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
        this._errors = new rxjs__WEBPACK_IMPORTED_MODULE_2__["BehaviorSubject"]([]);
        this._failure = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
        this.pipeline = null;
        this._config.subscribe(function (config) {
            if (_this.pipeline && config.__revision > 1) {
                _this.pipeline.params.dgpConfig = _this.currentConfig;
                _this.api.savePipeline(_this.pipeline)
                    .subscribe(function () {
                    console.log('SAVED CONFIGURATION');
                });
            }
        });
    }
    StoreService.prototype.getPipelineId = function () {
        return this.pipeline && this.pipeline.id;
    };
    StoreService.prototype.setPipelineId = function (pipelineId) {
        var _this = this;
        this.pipeline = null;
        if (pipelineId) {
            return this.api.queryPipeline(pipelineId)
                .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["map"])(function (result) {
                _this.pipeline = result;
                if (result && result.params && result.params.dgpConfig) {
                    result.params.dgpConfig.__revision = -1;
                    _this.setConfig(result.params.dgpConfig);
                }
                return result;
            }));
        }
        else {
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_2__["from"])([null]);
        }
    };
    StoreService.prototype.getConfig = function () {
        return this._config;
    };
    StoreService.prototype.getRows = function () {
        return this._rows;
    };
    StoreService.prototype.getRowCount = function () {
        return this._rowcount;
    };
    StoreService.prototype.getErrors = function () {
        return this._errors;
    };
    StoreService.prototype.getFailure = function () {
        return this._failure;
    };
    Object.defineProperty(StoreService.prototype, "BASE_CONFIG", {
        get: function () {
            var base_config = {
                source: {
                    path: '',
                },
                loader: {}, constants: {}, model: {}, structure: {},
                __revision: -1
            };
            return base_config;
        },
        enumerable: false,
        configurable: true
    });
    StoreService.prototype.newConfig = function () {
        this.setConfig(this.BASE_CONFIG);
    };
    StoreService.prototype.str = function (conf) {
        var revision = conf.__revision || null;
        var source = conf.source || null;
        var loader = conf.loader || null;
        var tid = (conf.taxonomy || {}).id || null;
        return JSON.stringify({ revision: revision, source: source, loader: loader, tid: tid });
    };
    StoreService.prototype.setConfig = function (newConfig, result) {
        if (!newConfig) {
            console.log('clearing configuration', newConfig);
            this._config.next(newConfig);
            return;
        }
        if (newConfig.__revision === -1) {
            console.log('Resetting the revision to 1');
            this.currentConfig.__revision = 1;
            newConfig.__revision = 1;
        }
        var newRevision = newConfig.__revision || 1;
        var currentRevision = this.currentConfig.__revision || 1;
        console.log('NEW REV', newRevision, 'CURRENT REV', currentRevision);
        if (newRevision < currentRevision) {
            console.log('DISCARDING OLD CONFIG', newRevision, '<', currentRevision);
        }
        else if (!compare(this.currentConfig, newConfig, null)) {
            newConfig['_result'] = !!result;
            newConfig.__revision = currentRevision + 1;
            this.currentConfig = JSON.parse(JSON.stringify(newConfig));
            console.log('setting new configuration rev', this.currentConfig.__revision, this.str(this.currentConfig));
            this._config.next(newConfig);
        }
        else {
            console.log('new configuration identical', this.str(this.currentConfig), this.str(newConfig));
        }
    };
    StoreService.prototype.setErrors = function (newErrors) {
        console.log(newErrors);
        this._errors.next(newErrors);
    };
    StoreService.prototype.addRow = function (row) {
        this._rows.next(row);
    };
    StoreService.prototype.setRowCount = function (count) {
        this._rowcount.next(count);
    };
    StoreService.prototype.strize = function (v) {
        if (v !== null && v !== undefined) {
            if (v.hasOwnProperty('type{decimal}')) {
                return "<span class='number'>" + parseFloat(v['type{decimal}']).toFixed(2) + "</span>";
            }
            else if (v.hasOwnProperty('type{date}')) {
                return v['type{date}'];
            }
            else if (v.hasOwnProperty('type{datetime}')) {
                return v['type{datetime}'];
            }
            else if (v.hasOwnProperty('type{time}')) {
                return v['type{time}'];
            }
        }
        return '' + v;
    };
    StoreService.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    StoreService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], StoreService);
    return StoreService;
}());



/***/ }),

/***/ "fECr":
/*!********************************************!*\
  !*** ./src/app/header/header.component.ts ***!
  \********************************************/
/*! exports provided: HeaderComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HeaderComponent", function() { return HeaderComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_header_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./header.component.html */ "kjkU");
/* harmony import */ var _header_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./header.component.less */ "Fw5j");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "kU1M");








var HeaderComponent = /** @class */ (function () {
    function HeaderComponent(activatedRoute, roles, api) {
        var _this = this;
        this.activatedRoute = activatedRoute;
        this.roles = roles;
        this.api = api;
        this.detected = '';
        this.detectedName = '';
        this.datarecords = [];
        this.extraLinks = [];
        this.activatedRoute.data.subscribe(function (data) {
            _this.detected = data.name;
        });
        this.activatedRoute.params.subscribe(function (params) {
            _this.detectedName = params.name;
        });
        this.api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["first"])()).subscribe(function (configuration) {
            _this.homepage = configuration.homepage || '/dashboard';
            _this.datarecords = configuration.dataRecords || [];
            _this.extraLinks = configuration.headerLinks || [];
        });
    }
    HeaderComponent.prototype.ngOnInit = function () {
    };
    HeaderComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"] }
    ]; };
    HeaderComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-header',
            template: _raw_loader_header_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_header_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"], _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"], _api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"]])
    ], HeaderComponent);
    return HeaderComponent;
}());



/***/ }),

/***/ "g+N0":
/*!****************************************************!*\
  !*** ./src/app/container/container.component.less ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100vw;\n  display: flex;\n  flex-flow: column;\n  align-items: center;\n}\n:host > .container {\n  width: calc(100% - 40px);\n  max-width: 1140px;\n  display: flex;\n  flex-flow: column;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvY29udGFpbmVyL2NvbnRhaW5lci5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvY29udGFpbmVyL2NvbnRhaW5lci5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLFlBQUE7RUFDQSxhQUFBO0VBQ0EsaUJBQUE7RUFDQSxtQkFBQTtBQ0NKO0FETEE7RUFPUSx3QkFBQTtFQUNBLGlCQUFBO0VBQ0EsYUFBQTtFQUNBLGlCQUFBO0FDQ1IiLCJmaWxlIjoic3JjL2FwcC9jb250YWluZXIvY29udGFpbmVyLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIHdpZHRoOiAxMDB2dztcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZmxvdzogY29sdW1uO1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbiAgICA+IC5jb250YWluZXIge1xuICAgICAgICB3aWR0aDogfidjYWxjKDEwMCUgLSA0MHB4KSc7XG4gICAgICAgIG1heC13aWR0aDogMTE0MHB4O1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWZsb3c6IGNvbHVtbjtcbiAgICB9ICAgIFxufSIsIjpob3N0IHtcbiAgd2lkdGg6IDEwMHZ3O1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IGNvbHVtbjtcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn1cbjpob3N0ID4gLmNvbnRhaW5lciB7XG4gIHdpZHRoOiBjYWxjKDEwMCUgLSA0MHB4KTtcbiAgbWF4LXdpZHRoOiAxMTQwcHg7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZmxvdzogY29sdW1uO1xufVxuIl19 */");

/***/ }),

/***/ "gVy0":
/*!******************************************************************!*\
  !*** ./src/app/data-record-edit/data-record-edit.component.less ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2RhdGEtcmVjb3JkLWVkaXQvZGF0YS1yZWNvcmQtZWRpdC5jb21wb25lbnQubGVzcyJ9 */");

/***/ }),

/***/ "gl/P":
/*!**********************************************************!*\
  !*** ./src/app/taxonomy-item/taxonomy-item.component.ts ***!
  \**********************************************************/
/*! exports provided: TaxonomyItemComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TaxonomyItemComponent", function() { return TaxonomyItemComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_taxonomy_item_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./taxonomy-item.component.html */ "qpQU");
/* harmony import */ var _taxonomy_item_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./taxonomy-item.component.less */ "tPIJ");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var TaxonomyItemComponent = /** @class */ (function () {
    function TaxonomyItemComponent() {
        this.changed = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
    }
    TaxonomyItemComponent.prototype.ngOnInit = function () {
    };
    TaxonomyItemComponent.prototype.emit = function () {
        this.changed.emit();
    };
    TaxonomyItemComponent.ctorParameters = function () { return []; };
    TaxonomyItemComponent.propDecorators = {
        ct: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        changed: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    TaxonomyItemComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-taxonomy-item',
            template: _raw_loader_taxonomy_item_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_taxonomy_item_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], TaxonomyItemComponent);
    return TaxonomyItemComponent;
}());



/***/ }),

/***/ "hjel":
/*!****************************************************!*\
  !*** ./src/app/step-tabs/step-tabs.component.less ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  flex: 0 0 auto;\n  width: 100px;\n}\n:host .tab-container {\n  position: fixed;\n  top: 0;\n  left: 20px;\n  display: flex;\n  flex-flow: column;\n  align-items: flex-end;\n  margin-top: 100px;\n  width: 100px;\n}\n:host .tab-container > span {\n  margin: 10px;\n}\n:host .tab-container .tab {\n  margin: 5px 0;\n  margin-left: -5px;\n  border: 1px solid rgba(0, 0, 0, 0.25);\n  padding: 3px 10px;\n  border-radius: 4px;\n  cursor: pointer;\n  z-index: 1;\n  background-color: #fff;\n  white-space: nowrap;\n}\n:host .tab-container .tab.active {\n  border-width: 3px;\n  border-color: rgba(0, 0, 0, 0.75);\n  padding: 1px 8px;\n}\n:host .tab-container .fa-check-circle {\n  display: none;\n  color: #66e866;\n}\n:host .tab-container .fa-circle-notch {\n  display: none;\n  color: #ffba00;\n}\n:host .tab-container .fa-exclamation-triangle {\n  display: none;\n  color: red;\n}\n:host .tab-container .fa-question-circle {\n  display: inline-block;\n  color: #aaa;\n}\n:host .tab-container .tab.valid .fa-check-circle {\n  display: inline-block;\n}\n:host .tab-container .tab.valid .fa-question-circle {\n  display: none;\n}\n:host .tab-container .tab.inprogress .fa-circle-notch {\n  display: inline-block;\n}\n:host .tab-container .tab.inprogress .fa-question-circle {\n  display: none;\n}\n:host .tab-container .tab.errored .fa-exclamation-triangle {\n  display: inline-block;\n}\n:host .tab-container .tab.errored .fa-question-circle {\n  display: none;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "i0Sx":
/*!******************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-status/pipeline-status.component.html ***!
  \******************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Task Status</h1>\n  <h2>{{item.name}}</h2>\n  <h3 i18n>Current Status :</h3>\n  <div class='status-box'>\n    <div [class]='\"status \" + item.status.status'>{{status}}</div>\n    <div class='started' *ngIf='item.status.start_date'>\n      <label i18n>Started:</label>\n      <span [title]='item.status.start_date'>{{ _moment(item.status.start_date).fromNow() }}</span>\n    </div>\n    <div class='finished' *ngIf='item.status.end_date'>\n      <label i18n>Finished:</label>\n      <span [title]='item.status.end_date'>{{ _moment(item.status.end_date).fromNow() }}</span>\n    </div>\n    <div class='duration' *ngIf='item.status.end_date'>\n      <label i18n>Took:</label>\n      <span>{{ _moment(item.status.end_date).from(item.status.start_date, true) }}</span>\n    </div>\n  </div>\n  <h3 i18n>Last Execution Status :</h3>\n  <div class='logs'>{{item.status.logs}}</div>\n  <div *ngIf='item.status.table'  class='result-table' [innerHtml]='item.status.table'></div>\n  <div class='buttons'>\n  <a *ngIf='canEdit()' class='edit button' [routerLink]='\"/edit/\" + item.id' i18n>\n    <i class=\"fas fa-pencil-alt\" aria-hidden=\"true\"></i>\n    Edit Task\n  </a>\n  <a class='refresh button' (click)='refresh()' *ngIf='item.status.status === \"running\"' i18n>\n    <i class=\"fas fa-redo-alt\" aria-hidden=\"true\"></i>\n    Refresh Status\n  </a>\n  <a *ngIf='roles._.pipelinesExecute && item.status.status !== \"running\"' class='trigger button' (click)='trigger()' i18n>\n    <i class=\"fas fa-play\" aria-hidden=\"true\"></i>\n    Trigger Task\n  </a>\n  </div>\n</app-container>\n");

/***/ }),

/***/ "iRn5":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/edit-pipeline/edit-pipeline.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Edit Task</h1>\n  <label i18n>Task Name</label>\n  <div class='field-description' [innerHtml]='api.currentConfig.taskNameDescription' *ngIf='api.currentConfig && api.currentConfig.taskNameDescription'></div>\n  <input type='text' [(ngModel)]='item.name'/>\n  <label i18n>Description</label>\n  <div class='field-description' [innerHtml]='api.currentConfig.taskDescription' *ngIf='api.currentConfig && api.currentConfig.taskDescription'></div>\n  <textarea rows='3' [(ngModel)]='item.description'></textarea>\n  <ng-container *ngIf='api.currentConfig'>\n    <ng-container *ngIf='(api.currentConfig.kinds && api.currentConfig.kinds.length > 1) || !api.currentConfig.kinds_map[item.kind]'>\n      <label i18n>Kind</label>\n      <select [(ngModel)]='item.kind'>\n        <option [value]='kind.name' *ngFor='let kind of api.currentConfig.kinds'>{{kind.display}}</option>\n      </select>\n    </ng-container>\n    <ng-container *ngIf='api.currentConfig.kinds_map[item.kind]'>\n      <app-dynamic-fields-editor [item]='item.params' [fields]='(api.currentConfig.kinds_map[item.kind] || {fields:[]}).fields' #fieldsEditor\n                                 (updated)='updateValidity()'\n      ></app-dynamic-fields-editor>\n      <ng-container *ngIf='roles._.pipelinesExecute'>\n        <label i18n>Schedule</label>\n        <select [(ngModel)]='item.schedule'>\n          <ng-container *ngFor='let schedule of api.currentConfig.schedules'>\n            <option *ngIf='schedule.name === \"manual\" || roles._.pipelinesExecute' [value]='schedule.name'>{{schedule.display}}</option>\n          </ng-container>\n        </select>\n      </ng-container>\n      <ng-container *ngIf='showVisiblity()'>\n        <label i18n>Visibility</label>\n        <select type='checkbox' [(ngModel)]='item.private'>\n          <option [value]='true' i18n>Only Visible to Me</option>\n          <option [value]='false' i18n>Publicly Visible</option>\n        </select>  \n      </ng-container>\n      <div class='buttons'>\n        <div class='dgp button' (click)='dgp()' *ngIf='roles._.workbench && api.currentConfig.kinds_map[item.kind].dgp' [class.disabled]='!valid()' i18n>\n          <i class=\"fas fa-cogs\" aria-hidden=\"true\"></i>\n          Save &amp; go to Workbench\n        </div>\n        <div class='save button' (click)='save()' [class.disabled]='!valid()' i18n>\n          <i class=\"fas fa-save\" aria-hidden=\"true\"></i>\n          Save Task\n        </div>\n        <div *ngIf='roles._.pipelinesDeleteOwn && item.id' class='delete button' (click)='delete()' i18n>\n          <i class=\"fas fa-trash\" aria-hidden=\"true\"></i>\n          Delete Task\n        </div>\n      </div>\n    </ng-container>\n  </ng-container>\n</app-container>");

/***/ }),

/***/ "in5m":
/*!**********************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/login/login.component.html ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<img src='assets/logo.png'/>\n<a class='login theme-primary-bg' [href]='login_href()' *ngIf='!api.authenticated' i18n>Login to the System</a>\n<h2 class='theme-primary-fg' *ngIf='api.authenticated && !api.authorized'>\n    <span i18n>You don't have access to this system</span><br/>\n    <span i18n>Please ask an administrator to grant {{api.currentUser.profile.email}} access</span><br/>\n    <a href='/logout' i18n>Logout</a>\n</h2>");

/***/ }),

/***/ "ivW9":
/*!************************************************************!*\
  !*** ./src/app/dgp-workbench/dgp-workbench.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2RncC13b3JrYmVuY2gvZGdwLXdvcmtiZW5jaC5jb21wb25lbnQubGVzcyJ9 */");

/***/ }),

/***/ "iwbm":
/*!**************************************!*\
  !*** ./src/app/workbench.service.ts ***!
  \**************************************/
/*! exports provided: WorkbenchService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WorkbenchService", function() { return WorkbenchService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./store.service */ "eXth");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var ng_event_source__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ng-event-source */ "eZdR");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./api.service */ "yTNM");








var WorkbenchService = /** @class */ (function () {
    function WorkbenchService(http, store, api) {
        var _this = this;
        this.http = http;
        this.store = store;
        this.api = api;
        this.executionId = null;
        this.configurations = new rxjs__WEBPACK_IMPORTED_MODULE_4__["BehaviorSubject"]([]);
        this.SERVER = this.api.API_ENDPOINT;
        var events = (this.store.getConfig())
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["filter"])(function (x) { return !!x; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["filter"])(function (x) { return ((x.source && x.source.path && x.source.path.length) ||
            (x.loader && x.loader.filename && x.loader.filename.length)); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["debounceTime"])(3000), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["switchMap"])(function (config) { return _this.storeConfig(config); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["switchMap"])(function (response) {
            _this.executionId = response.uid;
            console.log('FETCHING EVENTS');
            _this.store.addRow({
                kind: -1,
            });
            return _this.fetchEvents(_this.executionId);
        }));
        var that = this;
        var eventObserver = {
            config: null,
            next: function (event) {
                // console.log('EVENT', event);
                if (event.complete) {
                }
                else if (event.t) {
                    if (event.t === 'c') {
                        this.config = event.p;
                        if (this.config) {
                            var config = this.config;
                            this.config = null;
                            that.store.setConfig(config, true);
                        }
                    }
                    else if (event.t === 'r') {
                        if (event.i % 1000 === 0 || event.i <= 0) {
                            console.log('ROW', event);
                        }
                        that.store.addRow({
                            kind: event.j,
                            index: event.i,
                            data: event.p,
                            errors: event.e,
                            errors_field: event.ef
                        });
                        that.store.setRowCount({
                            kind: event.j,
                            index: event.i,
                        });
                    }
                    else if (event.t === 'n') {
                        if (event.i % 1000 === 0) {
                            console.log('ROW', event);
                        }
                        that.store.setRowCount({
                            kind: event.j,
                            index: event.i,
                        });
                    }
                    else if (event.t === 'd') {
                        that.store.addRow({
                            kind: event.j,
                            index: -2,
                        });
                    }
                    else if (event.t === 'e') {
                        console.log('got error', event.c, event.p, event.e);
                        that.store.setErrors(event.e);
                    }
                    else if (event.t === 'f') {
                        console.log('got FAILURE', event.e);
                        that.store.getFailure().next(event.e);
                        // that.store.setErrors(event.e);
                    }
                }
            },
            error: function () {
            }
        };
        events.subscribe(eventObserver);
    }
    WorkbenchService.prototype.storeConfig = function (config) {
        if (!config['_result']) {
            var suffix = this.executionId ? '?uid=' + this.executionId : '';
            console.log('OPT', this.api.httpOptions);
            return this.http.post(this.SERVER + '/config' + suffix, config, this.api.httpOptions);
        }
        else {
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["from"])([]);
        }
    };
    WorkbenchService.prototype.fetchEvents = function (executionId) {
        var _this = this;
        this.store.setErrors([]);
        this.store.getFailure().next(null);
        var observable = rxjs__WEBPACK_IMPORTED_MODULE_4__["Observable"].create(function (observer) {
            var eventSource;
            // this.error.emit(null);
            try {
                eventSource = new ng_event_source__WEBPACK_IMPORTED_MODULE_6__["EventSourcePolyfill"](_this.SERVER + '/events/' + _this.executionId, {
                    heartbeatTimeout: 300000,
                    errorOnTimeout: false,
                    connectionTimeout: 300000,
                    headers: _this.api.httpOptions.headers,
                });
            }
            catch (e) {
                // this.error.emit(e.message);
                observer.error(e);
            }
            eventSource.onmessage = function (x) {
                if (x.data !== 'close') {
                    try {
                        var parsed = JSON.parse(x.data);
                        observer.next(parsed);
                    }
                    catch (exception) {
                        console.log('Warning - bad data received', x);
                        throw exception;
                    }
                }
                else {
                    observer.next({ complete: true });
                    observer.complete();
                    eventSource.close();
                }
            };
            eventSource.onerror = function (x) {
                console.log('ERROR', x);
                // this.error.emit(x.message);
                // observer.error(x);
                observer.next({ complete: true });
                observer.complete();
            };
            return function () {
                if (eventSource) {
                    eventSource.close();
                }
            };
        });
        return observable;
    };
    WorkbenchService.ctorParameters = function () { return [
        { type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"] },
        { type: _store_service__WEBPACK_IMPORTED_MODULE_3__["StoreService"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_7__["ApiService"] }
    ]; };
    WorkbenchService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"],
            _store_service__WEBPACK_IMPORTED_MODULE_3__["StoreService"],
            _api_service__WEBPACK_IMPORTED_MODULE_7__["ApiService"]])
    ], WorkbenchService);
    return WorkbenchService;
}());



/***/ }),

/***/ "j/XB":
/*!**************************************************************************!*\
  !*** ./src/app/extra-config-question/extra-config-question.component.ts ***!
  \**************************************************************************/
/*! exports provided: ExtraConfigQuestionComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExtraConfigQuestionComponent", function() { return ExtraConfigQuestionComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_extra_config_question_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./extra-config-question.component.html */ "lyPA");
/* harmony import */ var _extra_config_question_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./extra-config-question.component.less */ "peth");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var ExtraConfigQuestionComponent = /** @class */ (function () {
    function ExtraConfigQuestionComponent(store) {
        this.store = store;
        this.config = null;
        this._value = null;
    }
    ExtraConfigQuestionComponent.prototype.ngOnInit = function () {
        var _this = this;
        this._value = this.question.default;
        this.store.getConfig()
            .subscribe(function (config) {
            _this.config = config;
            _this.extract();
        });
    };
    ExtraConfigQuestionComponent.prototype.extract = function () {
        var key = this.question.key;
        var parts = key.split('.');
        var value = this.config;
        while (value && parts.length > 0) {
            var part = parts.shift();
            value = value[part];
        }
        this._value = value;
    };
    ExtraConfigQuestionComponent.prototype.insert = function () {
        var key = this.question.key;
        var parts = key.split('.');
        var value = this.config;
        while (parts.length > 1) {
            var part = parts.shift();
            if (!value[part]) {
                value[part] = {};
            }
            value = value[part];
        }
        value[parts[0]] = this._value;
        this.store.setConfig(this.config);
    };
    Object.defineProperty(ExtraConfigQuestionComponent.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (value) {
            this._value = value;
            this.insert();
        },
        enumerable: false,
        configurable: true
    });
    ExtraConfigQuestionComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    ExtraConfigQuestionComponent.propDecorators = {
        question: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    ExtraConfigQuestionComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-extra-config-question',
            template: _raw_loader_extra_config_question_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_extra_config_question_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], ExtraConfigQuestionComponent);
    return ExtraConfigQuestionComponent;
}());



/***/ }),

/***/ "j74D":
/*!**************************************************!*\
  !*** ./src/app/confirmer/confirmer.component.ts ***!
  \**************************************************/
/*! exports provided: ConfirmerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfirmerComponent", function() { return ConfirmerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_confirmer_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./confirmer.component.html */ "1tCB");
/* harmony import */ var _confirmer_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./confirmer.component.less */ "1aDE");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../confirmer.service */ "c41A");





var ConfirmerComponent = /** @class */ (function () {
    function ConfirmerComponent(srv) {
        this.srv = srv;
    }
    ConfirmerComponent.prototype.ngOnInit = function () {
    };
    ConfirmerComponent.ctorParameters = function () { return [
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_4__["ConfirmerService"] }
    ]; };
    ConfirmerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-confirmer',
            template: _raw_loader_confirmer_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_confirmer_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_confirmer_service__WEBPACK_IMPORTED_MODULE_4__["ConfirmerService"]])
    ], ConfirmerComponent);
    return ConfirmerComponent;
}());



/***/ }),

/***/ "jL/9":
/*!******************************************!*\
  !*** ./src/app/files/files.component.ts ***!
  \******************************************/
/*! exports provided: FilesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FilesComponent", function() { return FilesComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_files_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./files.component.html */ "bdr3");
/* harmony import */ var _files_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./files.component.less */ "Hi4r");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../roles.service */ "FYRw");






var FilesComponent = /** @class */ (function () {
    function FilesComponent(api, roles) {
        this.api = api;
        this.roles = roles;
        this.uploaderVisible = false;
        this.justMine = false;
        this.sort = 'alpha';
        this.files = [];
        this.showFiles = [];
        this.sub = null;
        this.api.queryFiles();
        this.processFiles();
    }
    FilesComponent.prototype.ngOnInit = function () {
    };
    FilesComponent.prototype.upload = function () {
        this.forceFilename = null;
        this.uploaderVisible = true;
    };
    FilesComponent.prototype.update = function (filename) {
        this.forceFilename = filename;
        this.uploaderVisible = true;
    };
    FilesComponent.prototype.processFiles = function () {
        var _this = this;
        var source = this.justMine ? this.api.ownFiles : this.api.files;
        if (this.sub) {
            this.sub.unsubscribe();
        }
        this.sub = source.subscribe(function (files) {
            _this.showFiles = files.slice();
            _this.showFiles.forEach(function (item) {
                if (!item.last_modified_date) {
                    item.last_modified_date = new Date(item.last_modified * 1000).toLocaleDateString();
                    item.last_modified_time = new Date(item.last_modified * 1000).toLocaleTimeString();
                }
            });
            if (_this.sort === 'alpha') {
                _this.showFiles = _this.showFiles.sort(function (a, b) { return a.name < b.name ? -1 : 1; });
            }
            else {
                _this.showFiles = _this.showFiles.sort(function (a, b) { return b.last_modified - a.last_modified; });
            }
        });
    };
    FilesComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"] }
    ]; };
    FilesComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-files',
            template: _raw_loader_files_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_files_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"]])
    ], FilesComponent);
    return FilesComponent;
}());



/***/ }),

/***/ "kjkU":
/*!************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/header/header.component.html ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='container theme-primary-dark-border theme-primary-bg'>\n    <a [href]='homepage' class='logo'><img class='theme-secondary-bg' src='assets/logo.png'/></a>\n    <a class='menu theme-secondary-fg' [class.theme-primary-dark-bg]='detected === \"dashboard\"' routerLink='/dashboard' i18n>Dashboard</a>\n    <a class='menu theme-secondary-fg' *ngIf='roles._.filesListOwn' [class.theme-primary-dark-bg]='detected === \"files\"' routerLink='/files' i18n>Source Data</a>\n    <a class='menu theme-secondary-fg' *ngIf='roles._.pipelinesListPublic' [class.theme-primary-dark-bg]='detected === \"pipelines\"' routerLink='/pipelines' i18n>Processing Tasks</a>\n    <a class='menu theme-secondary-fg' *ngIf='roles._.usersList' [class.theme-primary-dark-bg]='detected === \"users\"' routerLink='/users' i18n>User Management</a>\n    <a class='menu theme-secondary-fg' *ngIf='roles._.taxonomyRead' [class.theme-primary-dark-bg]='detected === \"taxonomies\"' routerLink='/taxonomies' i18n>Taxonomies</a>\n    <ng-container *ngIf='roles._.datarecordRead' >\n        <a class='menu theme-secondary-fg' *ngFor='let datarecord of datarecords' [class.theme-primary-dark-bg]='detected === \"records\" && datarecordName === datarecord.name' [routerLink]='\"/datarecords/\" + datarecord.name'>{{datarecord.display_plural}}</a>\n    </ng-container>\n    <ng-container *ngFor='let link of extraLinks' >\n        <a class='menu theme-secondary-fg' [href]='link.url'>{{link.display}}</a>\n    </ng-container>\n</div>");

/***/ }),

/***/ "lGKN":
/*!******************************************************************************!*\
  !*** ./src/app/extra-config-questions/extra-config-questions.component.less ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: column;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZXh0cmEtY29uZmlnLXF1ZXN0aW9ucy9leHRyYS1jb25maWctcXVlc3Rpb25zLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9leHRyYS1jb25maWctcXVlc3Rpb25zL2V4dHJhLWNvbmZpZy1xdWVzdGlvbnMuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsaUJBQUE7QUNDSiIsImZpbGUiOiJzcmMvYXBwL2V4dHJhLWNvbmZpZy1xdWVzdGlvbnMvZXh0cmEtY29uZmlnLXF1ZXN0aW9ucy5jb21wb25lbnQubGVzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZmxvdzogY29sdW1uO1xufSIsIjpob3N0IHtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1mbG93OiBjb2x1bW47XG59XG4iXX0= */");

/***/ }),

/***/ "ld2h":
/*!********************************************************!*\
  !*** ./src/app/result-table/result-table.component.ts ***!
  \********************************************************/
/*! exports provided: ResultTableComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResultTableComponent", function() { return ResultTableComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_result_table_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./result-table.component.html */ "Az0/");
/* harmony import */ var _result_table_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./result-table.component.less */ "q4V3");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var ResultTableComponent = /** @class */ (function () {
    function ResultTableComponent(store) {
        var _this = this;
        this.store = store;
        this.rows = [];
        this.headers = [];
        this.subs = [];
        this.subs.push(this.store.getRows()
            .subscribe(function (row) {
            if (row.kind === -1) {
                _this.rows = [];
            }
            else if (_this.kind === row.kind) {
                if (row.index === -1) {
                    console.log('GOT HEADERS', row);
                    _this.rows = [];
                    _this.headers = row.data;
                    _this.headers.unshift('#');
                }
                else if (row.index >= 0) {
                    if (_this.rows.length !== 0) {
                        if (_this.rows[_this.rows.length - 1].data[0] !== row.index) {
                            _this.rows.push({ data: _this.headers.map(function (h) { return '&hellip;'; }) });
                        }
                    }
                    var data = _this.headers.map(function (h) { return _this.store.strize(row.data[h]); });
                    data[0] = row.index + 1;
                    var errd = row.errors && row.errors.length > 0 && !row.errors_field;
                    var errd_field = row.errors_field ? _this.headers.indexOf(row.errors_field) : null;
                    _this.rows.push({ data: data, errd: errd, errd_field: errd_field });
                }
            }
        }));
    }
    ResultTableComponent.prototype.ngOnInit = function () {
    };
    ResultTableComponent.prototype.ngOnDestroy = function () {
        for (var _i = 0, _a = this.subs; _i < _a.length; _i++) {
            var s = _a[_i];
            s.unsubscribe();
        }
    };
    ResultTableComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    ResultTableComponent.propDecorators = {
        kind: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        kindName: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    ResultTableComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-result-table',
            template: _raw_loader_result_table_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_result_table_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], ResultTableComponent);
    return ResultTableComponent;
}());



/***/ }),

/***/ "lyPA":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/extra-config-question/extra-config-question.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<label>{{question.title}}</label>\n<input *ngIf='question.kind===\"text\"' type='text' [(ngModel)]='value'/>\n<input *ngIf='question.kind===\"boolean\"' type='checkbox' [(ngModel)]='value'/>\n<select *ngIf='question.kind===\"select\"' [(ngModel)]='value'>\n    <option value=''>-</option>\n    <option [value]='option' *ngFor='let option of question.options'>{{option}}</option>\n</select>");

/***/ }),

/***/ "mF1b":
/*!**************************************************!*\
  !*** ./src/app/step-tabs/step-tabs.component.ts ***!
  \**************************************************/
/*! exports provided: StepTabsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepTabsComponent", function() { return StepTabsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_tabs_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-tabs.component.html */ "RDkR");
/* harmony import */ var _step_tabs_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-tabs.component.less */ "hjel");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");





var StepTabsComponent = /** @class */ (function () {
    function StepTabsComponent(store) {
        this.store = store;
        this.validation = {};
        this.change = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
    }
    StepTabsComponent.prototype.ngOnInit = function () {
        if (!this.validation.map) {
            this.validation.map = {};
        }
        if (!this.validation.extract) {
            this.validation.extract = {};
        }
        if (!this.validation.enrich) {
            this.validation.enrich = {};
        }
        if (!this.validation.publish) {
            this.validation.publish = {};
        }
    };
    StepTabsComponent.prototype.select = function (selected) {
        this.selected = selected;
        this.change.emit(selected);
    };
    StepTabsComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    StepTabsComponent.propDecorators = {
        selected: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        validation: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        change: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    StepTabsComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-tabs',
            template: _raw_loader_step_tabs_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_tabs_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], StepTabsComponent);
    return StepTabsComponent;
}());



/***/ }),

/***/ "mUmp":
/*!***************************************************!*\
  !*** ./src/app/data-record-edit-aux.directive.ts ***!
  \***************************************************/
/*! exports provided: DataRecordEditAuxDirective */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataRecordEditAuxDirective", function() { return DataRecordEditAuxDirective; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


var DataRecordEditAuxDirective = /** @class */ (function () {
    function DataRecordEditAuxDirective(viewContainerRef) {
        this.viewContainerRef = viewContainerRef;
    }
    DataRecordEditAuxDirective.ctorParameters = function () { return [
        { type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewContainerRef"] }
    ]; };
    DataRecordEditAuxDirective = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Directive"])({
            selector: '[appDataRecordEditAux]'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewContainerRef"]])
    ], DataRecordEditAuxDirective);
    return DataRecordEditAuxDirective;
}());



/***/ }),

/***/ "muwd":
/*!******************************************************!*\
  !*** ./src/app/step-enrich/step-enrich.component.ts ***!
  \******************************************************/
/*! exports provided: StepEnrichComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepEnrichComponent", function() { return StepEnrichComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_enrich_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-enrich.component.html */ "xq0+");
/* harmony import */ var _step_enrich_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-enrich.component.less */ "DDN7");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../store.service */ "eXth");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "kU1M");






var StepEnrichComponent = /** @class */ (function () {
    function StepEnrichComponent(store) {
        this.store = store;
        this.params = null;
        this.fields = null;
    }
    StepEnrichComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.store.getConfig()
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["first"])())
            .subscribe(function (config) {
            var transformConfig = (config &&
                config.taxonomy &&
                config.taxonomy.settings &&
                config.taxonomy.settings['extra-config'] &&
                config.taxonomy.settings['extra-config'].metadata);
            if (transformConfig) {
                _this.fields = transformConfig;
            }
        });
    };
    StepEnrichComponent.ctorParameters = function () { return [
        { type: _store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"] }
    ]; };
    StepEnrichComponent.propDecorators = {
        params: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    StepEnrichComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-enrich',
            template: _raw_loader_step_enrich_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_enrich_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_store_service__WEBPACK_IMPORTED_MODULE_4__["StoreService"]])
    ], StepEnrichComponent);
    return StepEnrichComponent;
}());



/***/ }),

/***/ "n1B2":
/*!********************************************!*\
  !*** ./src/app/logout/logout.component.ts ***!
  \********************************************/
/*! exports provided: LogoutComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogoutComponent", function() { return LogoutComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_logout_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./logout.component.html */ "r6bu");
/* harmony import */ var _logout_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./logout.component.less */ "IThQ");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");





var LogoutComponent = /** @class */ (function () {
    function LogoutComponent(auth) {
        this.auth = auth;
    }
    LogoutComponent.prototype.ngOnInit = function () {
        this.auth.logout('/').subscribe(function (result) {
            console.log('logged out', result);
            window.location.href = '/';
        });
    };
    LogoutComponent.ctorParameters = function () { return [
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"] }
    ]; };
    LogoutComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-logout',
            template: _raw_loader_logout_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_logout_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_4__["AuthService"]])
    ], LogoutComponent);
    return LogoutComponent;
}());



/***/ }),

/***/ "nP4O":
/*!********************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/data-record-list/data-record-list.component.html ***!
  \********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg'>{{def.display_plural}}</h1>\n  <div *ngIf='roles._.datarecordNew' class='add-new'><a [routerLink]='\"/datarecords/\" + def.name + \"/new\"' i18n>\n    <i class=\"fas fa-plus-circle\" aria-hidden=\"true\"></i>\n    New {{def.display}}\n  </a></div>\n  <ng-container *ngFor='let item of datarecords'>\n    <a class='item' [routerLink]='\"/datarecords/\" + def.name + \"/\" + item.value.id'>{{ item.value[def.snippet] }}</a>\n  </ng-container>\n</app-container>");

/***/ }),

/***/ "o9hB":
/*!**************************************************************************!*\
  !*** ./src/app/pipeline-list-section/pipeline-list-section.component.ts ***!
  \**************************************************************************/
/*! exports provided: PipelineListSectionComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineListSectionComponent", function() { return PipelineListSectionComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_list_section_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-list-section.component.html */ "JfQE");
/* harmony import */ var _pipeline_list_section_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-list-section.component.less */ "6bTb");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var PipelineListSectionComponent = /** @class */ (function () {
    function PipelineListSectionComponent() {
        this.root = false;
        this.sections = [];
    }
    PipelineListSectionComponent.prototype.ngOnInit = function () {
    };
    PipelineListSectionComponent.ctorParameters = function () { return []; };
    PipelineListSectionComponent.propDecorators = {
        root: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        sections: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    PipelineListSectionComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-list-section',
            template: _raw_loader_pipeline_list_section_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_list_section_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], PipelineListSectionComponent);
    return PipelineListSectionComponent;
}());



/***/ }),

/***/ "oYre":
/*!******************************************!*\
  !*** ./src/app/users/users.component.ts ***!
  \******************************************/
/*! exports provided: UsersComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UsersComponent", function() { return UsersComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_users_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./users.component.html */ "sgLn");
/* harmony import */ var _users_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./users.component.less */ "cQqm");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");





var UsersComponent = /** @class */ (function () {
    function UsersComponent(api) {
        this.api = api;
    }
    UsersComponent.prototype.ngOnInit = function () {
        this.api.queryUsers();
    };
    UsersComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    UsersComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-users',
            template: _raw_loader_users_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_users_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], UsersComponent);
    return UsersComponent;
}());



/***/ }),

/***/ "on5d":
/*!********************************************************************************!*\
  !*** ./src/app/extendable-keyvalue-list/extendable-keyvalue-list.component.ts ***!
  \********************************************************************************/
/*! exports provided: ExtendableKeyvalueListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExtendableKeyvalueListComponent", function() { return ExtendableKeyvalueListComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");


var ExtendableKeyvalueListComponent = /** @class */ (function () {
    function ExtendableKeyvalueListComponent() {
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.updateList = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.values = [];
    }
    ExtendableKeyvalueListComponent.prototype.ngOnInit = function () {
        if (this.dataList) {
            this.values = this.dataList.slice();
        }
        else {
            this.values = Object.entries(this.data);
        }
        this.values.push(['', '']);
    };
    ExtendableKeyvalueListComponent.prototype.changed = function () {
        this.updateList.emit(this.values.slice(0, -1));
        var x = [];
        var ret = {};
        for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
            var v = _a[_i];
            if (v[0]) {
                x.push(v);
                ret[v[0]] = v[1];
            }
        }
        x.push(['', '']);
        this.values = x;
        this.update.emit(ret);
    };
    ExtendableKeyvalueListComponent.ctorParameters = function () { return []; };
    ExtendableKeyvalueListComponent.propDecorators = {
        data: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }],
        dataList: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }],
        taxonomy: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"] }],
        update: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"] }],
        updateList: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"] }]
    };
    ExtendableKeyvalueListComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-extendable-keyvalue-list',
            template: "\n    <div>\n      <span class='item' *ngFor='let value of values'>\n        <select [(ngModel)]='value[0]' (change)='changed()'>\n          <option *ngFor='let ct of taxonomy.columnTypes'\n                  [value]='ct.title'>{{ct.title}}</option>\n        </select>\n        <span class='separator'> = </span>\n        <input type='text'\n          [(ngModel)]='value[1]'\n          (change)='changed()'\n        />\n        <a *ngIf='value[0]' (click)='value[0]=\"\"; changed()'><i class=\"fas fa-trash\"></i></a>\n      </span>\n    </div>\n  ",
            styles: ["\ndiv {\n  display: flex;\n  flex-flow: column;\n  padding: 5px 10px;\n}\n\n.separator {\n  margin: 0 5px;\n}\n\n.item {\n  display: flex;\n  flex-flow: row;\n}\n\ninput {\n  flex: 1 1 auto;\n}\n    "]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ExtendableKeyvalueListComponent);
    return ExtendableKeyvalueListComponent;
}());



/***/ }),

/***/ "peth":
/*!****************************************************************************!*\
  !*** ./src/app/extra-config-question/extra-config-question.component.less ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n}\n:host > *:first-child {\n  flex: 0 0 200px;\n}\n:host > *:last-child {\n  flex: 1 1 auto;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZXh0cmEtY29uZmlnLXF1ZXN0aW9uL2V4dHJhLWNvbmZpZy1xdWVzdGlvbi5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvZXh0cmEtY29uZmlnLXF1ZXN0aW9uL2V4dHJhLWNvbmZpZy1xdWVzdGlvbi5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxjQUFBO0VBQ0EsbUJBQUE7QUNDSjtBREpBO0VBTVEsZUFBQTtBQ0NSO0FEUEE7RUFTUSxjQUFBO0FDQ1IiLCJmaWxlIjoic3JjL2FwcC9leHRyYS1jb25maWctcXVlc3Rpb24vZXh0cmEtY29uZmlnLXF1ZXN0aW9uLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1mbG93OiByb3c7XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcblxuICAgID4gKjpmaXJzdC1jaGlsZCB7XG4gICAgICAgIGZsZXg6IDAgMCAyMDBweDtcbiAgICB9XG4gICAgPiAqOmxhc3QtY2hpbGQge1xuICAgICAgICBmbGV4OiAxIDEgYXV0bztcbiAgICB9XG59IiwiOmhvc3Qge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWZsb3c6IHJvdztcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn1cbjpob3N0ID4gKjpmaXJzdC1jaGlsZCB7XG4gIGZsZXg6IDAgMCAyMDBweDtcbn1cbjpob3N0ID4gKjpsYXN0LWNoaWxkIHtcbiAgZmxleDogMSAxIGF1dG87XG59XG4iXX0= */");

/***/ }),

/***/ "pfSI":
/*!****************************************************************!*\
  !*** ./src/app/failure-marquee/failure-marquee.component.less ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  margin: 20px;\n  align-self: center;\n}\n:host .failure-marquee {\n  background-color: white;\n  border: 3px solid lightsalmon;\n  padding: 5px 10px;\n  display: flex;\n  flex-flow: column;\n  max-width: 80vw;\n}\n:host .failure-marquee pre {\n  background-color: white;\n  width: 100%;\n  direction: ltr;\n  text-align: left;\n  min-height: 20px;\n  margin: 0px;\n  flex: 0 0 auto;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZmFpbHVyZS1tYXJxdWVlL2ZhaWx1cmUtbWFycXVlZS5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvZmFpbHVyZS1tYXJxdWVlL2ZhaWx1cmUtbWFycXVlZS5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLFlBQUE7RUFDQSxrQkFBQTtBQ0NKO0FESEE7RUFLUSx1QkFBQTtFQUVBLDZCQUFBO0VBQ0EsaUJBQUE7RUFDQSxhQUFBO0VBQ0EsaUJBQUE7RUFDQSxlQUFBO0FDQVI7QURYQTtFQWNZLHVCQUFBO0VBQ0EsV0FBQTtFQUNBLGNBQUE7RUFDQSxnQkFBQTtFQUNBLGdCQUFBO0VBQ0EsV0FBQTtFQUNBLGNBQUE7QUNBWiIsImZpbGUiOiJzcmMvYXBwL2ZhaWx1cmUtbWFycXVlZS9mYWlsdXJlLW1hcnF1ZWUuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgbWFyZ2luOiAyMHB4O1xuICAgIGFsaWduLXNlbGY6IGNlbnRlcjtcbiAgICBcbiAgICAuZmFpbHVyZS1tYXJxdWVlIHtcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogd2hpdGU7XG4gICAgXG4gICAgICAgIGJvcmRlcjogM3B4IHNvbGlkIGxpZ2h0c2FsbW9uO1xuICAgICAgICBwYWRkaW5nOiA1cHggMTBweDtcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1mbG93OiBjb2x1bW47XG4gICAgICAgIG1heC13aWR0aDogODB2dztcbiAgICBcbiAgICAgICAgcHJlIHtcbiAgICAgICAgICAgIGJhY2tncm91bmQtY29sb3I6IHdoaXRlO1xuICAgICAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgICAgICBkaXJlY3Rpb246IGx0cjtcbiAgICAgICAgICAgIHRleHQtYWxpZ246IGxlZnQ7XG4gICAgICAgICAgICBtaW4taGVpZ2h0OiAyMHB4O1xuICAgICAgICAgICAgbWFyZ2luOiAwcHg7XG4gICAgICAgICAgICBmbGV4OiAwIDAgYXV0bztcbiAgICAgICAgfVxuICAgIH1cbn1cbiIsIjpob3N0IHtcbiAgbWFyZ2luOiAyMHB4O1xuICBhbGlnbi1zZWxmOiBjZW50ZXI7XG59XG46aG9zdCAuZmFpbHVyZS1tYXJxdWVlIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogd2hpdGU7XG4gIGJvcmRlcjogM3B4IHNvbGlkIGxpZ2h0c2FsbW9uO1xuICBwYWRkaW5nOiA1cHggMTBweDtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1mbG93OiBjb2x1bW47XG4gIG1heC13aWR0aDogODB2dztcbn1cbjpob3N0IC5mYWlsdXJlLW1hcnF1ZWUgcHJlIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogd2hpdGU7XG4gIHdpZHRoOiAxMDAlO1xuICBkaXJlY3Rpb246IGx0cjtcbiAgdGV4dC1hbGlnbjogbGVmdDtcbiAgbWluLWhlaWdodDogMjBweDtcbiAgbWFyZ2luOiAwcHg7XG4gIGZsZXg6IDAgMCBhdXRvO1xufVxuIl19 */");

/***/ }),

/***/ "q4V3":
/*!**********************************************************!*\
  !*** ./src/app/result-table/result-table.component.less ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  max-height: 70vh;\n  display: block;\n  overflow-x: scroll;\n  overflow-y: scroll;\n  overscroll-behavior-x: contain;\n}\n:host table {\n  border-collapse: collapse;\n  border: 1px solid #444;\n  border-top: none;\n}\n:host ::ng-deep .number {\n  text-align: right;\n  width: 100%;\n  display: inline-block;\n}\n:host th {\n  font-weight: bold;\n  text-align: start;\n  padding: 3px 6px;\n}\n:host tr:nth-child(2n+1) {\n  background-color: #eee;\n}\n:host tr.errd td,\n:host tr td.errd {\n  background-color: salmon;\n}\n:host tr td {\n  padding: 1px 6px;\n  white-space: nowrap;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "qjdf":
/*!**********************************************************************************!*\
  !*** ./src/app/pipeline-status-dashboard/pipeline-status-dashboard.component.ts ***!
  \**********************************************************************************/
/*! exports provided: PipelineStatusDashboardComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineStatusDashboardComponent", function() { return PipelineStatusDashboardComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_status_dashboard_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-status-dashboard.component.html */ "PNdE");
/* harmony import */ var _pipeline_status_dashboard_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-status-dashboard.component.less */ "vqbR");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");





var PipelineStatusDashboardComponent = /** @class */ (function () {
    function PipelineStatusDashboardComponent(api) {
        var _this = this;
        this.api = api;
        this.total = 0;
        this.successful = 0;
        this.failed = 0;
        this.api.pipelines
            .subscribe(function (pipelines) {
            _this.total = pipelines.length;
            console.log(pipelines);
            console.log(pipelines.filter(function (x) { return x.status.status === 'success'; }));
            _this.successful = pipelines.filter(function (x) { return x.status.status === 'success'; }).length;
            _this.failed = pipelines.filter(function (x) { return x.status.status === 'failed'; }).length;
        });
    }
    PipelineStatusDashboardComponent.prototype.ngOnInit = function () {
    };
    PipelineStatusDashboardComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] }
    ]; };
    PipelineStatusDashboardComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-status-dashboard',
            template: _raw_loader_pipeline_status_dashboard_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_status_dashboard_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"]])
    ], PipelineStatusDashboardComponent);
    return PipelineStatusDashboardComponent;
}());



/***/ }),

/***/ "qn5Q":
/*!**********************************************************!*\
  !*** ./src/app/edit-pipeline/edit-pipeline.component.ts ***!
  \**********************************************************/
/*! exports provided: EditPipelineComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EditPipelineComponent", function() { return EditPipelineComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_edit_pipeline_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./edit-pipeline.component.html */ "iRn5");
/* harmony import */ var _edit_pipeline_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit-pipeline.component.less */ "4gMr");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _store_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../store.service */ "eXth");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../confirmer.service */ "c41A");
/* harmony import */ var _dynamic_fields_editor_dynamic_fields_editor_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../dynamic-fields-editor/dynamic-fields-editor.component */ "Qa3L");











var EditPipelineComponent = /** @class */ (function () {
    function EditPipelineComponent(route, router, api, store, roles, confirmer) {
        var _this = this;
        this.route = route;
        this.router = router;
        this.api = api;
        this.store = store;
        this.roles = roles;
        this.confirmer = confirmer;
        this.item = { params: {}, schedule: '' };
        this.isNew = false;
        this._valid = false;
        this._showVisibility = true;
        this.route.paramMap.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function (params) {
            var id = params.get('id');
            if (id === 'new') {
                _this.isNew = true;
                return api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["map"])(function (configuration) {
                    var privateValue = _this.processForcePrivate(configuration);
                    return {
                        private: privateValue,
                        kind: configuration.kinds[0].name,
                        schedule: 'manual'
                    };
                }));
            }
            return _this.api.queryPipeline(id);
        })).subscribe(function (pipeline) {
            _this.item = pipeline;
            _this.item.params = _this.item.params || {};
            _this.item.schedule = _this.item.schedule || '';
            _this.item.kind = _this.item.kind || '';
        });
    }
    EditPipelineComponent.prototype.processForcePrivate = function (configuration) {
        console.log('FP', configuration.features.forcePrivate);
        if (configuration.features.forcePrivate === false) {
            this._showVisibility = false;
            return false;
        }
        else if (configuration.features.forcePrivate === true) {
            this._showVisibility = false;
            return true;
        }
        else {
            this._showVisibility = true;
            return true;
        }
    };
    EditPipelineComponent.prototype.showVisiblity = function () {
        return this._showVisibility || this.roles._.pipelinesEditAll;
    };
    EditPipelineComponent.prototype.ngOnInit = function () {
        this.store.newConfig();
    };
    EditPipelineComponent.prototype.updateValidity = function () {
        this._valid = !!this.fieldsEditor && this.fieldsEditor.valid;
    };
    EditPipelineComponent.prototype.valid = function () {
        return this._valid;
    };
    EditPipelineComponent.prototype._save = function () {
        this.item.private = this.item.private !== 'false' && this.item.private !== false;
        return this.api.savePipeline(this.item);
    };
    EditPipelineComponent.prototype.save = function () {
        var _this = this;
        this._save()
            .subscribe(function (result) {
            if (result.id) {
                _this.api.queryPipelines();
                _this.router.navigate(['/pipelines']);
            }
            else {
                console.log('Failed to SAVE!');
            }
        });
    };
    EditPipelineComponent.prototype.dgp = function () {
        var _this = this;
        this._save()
            .subscribe(function (result) {
            if (result.id) {
                _this.router.navigate(['/dgp/' + result.id]);
            }
            else {
                console.log('Failed to SAVE!');
            }
        });
    };
    EditPipelineComponent.prototype.delete = function () {
        var _this = this;
        this.confirmer.confirm(this.confirmer.ACTION_DELETE_TASK, this.item.name)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["filter"])(function (x) { return x; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function () { return _this.api.deletePipeline(_this.item.id); })).subscribe(function (result) {
            if (result) {
                _this.router.navigate(['/']);
            }
            else {
                console.log('Failed to DELETE!');
            }
        });
    };
    EditPipelineComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"] },
        { type: _store_service__WEBPACK_IMPORTED_MODULE_7__["StoreService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_8__["RolesService"] },
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_9__["ConfirmerService"] }
    ]; };
    EditPipelineComponent.propDecorators = {
        fieldsEditor: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["ViewChild"], args: ['fieldsEditor', { static: false },] }]
    };
    EditPipelineComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-edit-pipeline',
            template: _raw_loader_edit_pipeline_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_edit_pipeline_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"], _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"],
            _store_service__WEBPACK_IMPORTED_MODULE_7__["StoreService"], _roles_service__WEBPACK_IMPORTED_MODULE_8__["RolesService"], _confirmer_service__WEBPACK_IMPORTED_MODULE_9__["ConfirmerService"]])
    ], EditPipelineComponent);
    return EditPipelineComponent;
}());



/***/ }),

/***/ "qpQU":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/taxonomy-item/taxonomy-item.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='item'>\n  <div class='field title'>\n    <h4 class='workbench-subsubsubtitle' i18n>{{ct.name}}</h4>\n    <a (click)='ct.name = \"\"; emit()' i18n>Delete</a>\n  </div>  \n  <div class='line'>\n    <div class='field'>\n      <label i18n>Title:</label>\n      <input type='text' [(ngModel)]='ct.title' (change)='emit()'/>\n    </div>\n    <div class='field small'>\n      <label i18n>Data Type:</label>\n      <select [(ngModel)]='ct.dataType' (change)='emit()'>\n        <option value='string' i18n>string</option>\n        <option value='integer' i18n>integer</option>\n        <option value='number' i18n>number</option>\n        <option value='boolean' i18n>boolean</option>\n        <option value='date' i18n>date</option>\n        <option value='datetime' i18n>datetime</option>\n      </select>  \n    </div>\n  </div>\n  <div class='line'>\n    <div class='field'>\n      <label i18n>Required:</label>\n      <input type='checkbox' [(ngModel)]='ct.mandatory' (change)='emit()'/>\n    </div>\n    <div class='field' *ngIf='!ct.mandatory'>\n      <label i18n>Show in 'Required' section:</label>\n      <input type='checkbox' [(ngModel)]='ct.treat_as_mandatory' (change)='emit()'/>\n    </div>\n    <div class='field'>\n      <label i18n>Primary Key:</label>\n      <input type='checkbox' [(ngModel)]='ct.unique' (change)='emit()'/>\n    </div>\n  </div>\n  <div class='line'>\n    <div class='field big'>\n      <label i18n>Description:</label>\n      <textarea rows='1' type='text' [(ngModel)]='ct.description' (change)='emit()'></textarea>\n    </div>  \n  </div>\n</div>\n");

/***/ }),

/***/ "r6bu":
/*!************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/logout/logout.component.html ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("");

/***/ }),

/***/ "rGKi":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/results-tab-selector/results-tab-selector.component.html ***!
  \****************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<div class='selector theme-secondary-fg' [class.theme-primary-dark-bg]='active'  [class.theme-primary-bg]='!active' (click)='select.emit()'>\n  <div class='main'>\n    <i class='fa fa-check-circle' *ngIf='state === \"success\"'></i>\n    <i class='fa fa-circle-notch fa-spin' *ngIf='state === \"progress\"'></i>\n    <i class='fa fa-question-circle' *ngIf='state === \"unknown\"'></i>\n    <i class='fa fa-exclamation-triangle' [title]='table.errors'  *ngIf='state === \"fail\"'></i>\n    <label>{{ label }}</label>\n  </div>\n  <div class='secondary'>\n    <span class='number'>{{ table.rowCount }}</span>&nbsp;\n    <span class='text' i18n>rows</span>\n  </div>\n</div>\n");

/***/ }),

/***/ "s7Ec":
/*!**************************************************!*\
  !*** ./src/app/container/container.component.ts ***!
  \**************************************************/
/*! exports provided: ContainerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContainerComponent", function() { return ContainerComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_container_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./container.component.html */ "86H0");
/* harmony import */ var _container_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./container.component.less */ "g+N0");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");




var ContainerComponent = /** @class */ (function () {
    function ContainerComponent() {
    }
    ContainerComponent.prototype.ngOnInit = function () {
    };
    ContainerComponent.ctorParameters = function () { return []; };
    ContainerComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-container',
            template: _raw_loader_container_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_container_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [])
    ], ContainerComponent);
    return ContainerComponent;
}());



/***/ }),

/***/ "sEft":
/*!****************************************************************************!*\
  !*** ./src/app/dgp-workbench-buttons/dgp-workbench-buttons.component.less ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host .buttons {\n  margin: 20px 0;\n  align-items: center;\n}\n:host .buttons .button {\n  margin: 0 20px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvZGdwLXdvcmtiZW5jaC1idXR0b25zL2RncC13b3JrYmVuY2gtYnV0dG9ucy5jb21wb25lbnQubGVzcyIsInNyYy9hcHAvZGdwLXdvcmtiZW5jaC1idXR0b25zL2RncC13b3JrYmVuY2gtYnV0dG9ucy5jb21wb25lbnQubGVzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUVRLGNBQUE7RUFDQSxtQkFBQTtBQ0FSO0FESEE7RUFNWSxjQUFBO0FDQVoiLCJmaWxlIjoic3JjL2FwcC9kZ3Atd29ya2JlbmNoLWJ1dHRvbnMvZGdwLXdvcmtiZW5jaC1idXR0b25zLmNvbXBvbmVudC5sZXNzIiwic291cmNlc0NvbnRlbnQiOlsiOmhvc3Qge1xuICAgIC5idXR0b25zIHtcbiAgICAgICAgbWFyZ2luOiAyMHB4IDA7XG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbiAgICAgICAgLmJ1dHRvbiB7XG4gICAgICAgICAgICBtYXJnaW46IDAgMjBweDtcbiAgICAgICAgfVxuICAgIH1cbn0iLCI6aG9zdCAuYnV0dG9ucyB7XG4gIG1hcmdpbjogMjBweCAwO1xuICBhbGlnbi1pdGVtczogY2VudGVyO1xufVxuOmhvc3QgLmJ1dHRvbnMgLmJ1dHRvbiB7XG4gIG1hcmdpbjogMCAyMHB4O1xufVxuIl19 */");

/***/ }),

/***/ "sJCo":
/*!****************************************************************!*\
  !*** ./src/app/data-record-list/data-record-list.component.ts ***!
  \****************************************************************/
/*! exports provided: DataRecordListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DataRecordListComponent", function() { return DataRecordListComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_data_record_list_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./data-record-list.component.html */ "nP4O");
/* harmony import */ var _data_record_list_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-record-list.component.less */ "ACr3");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../roles.service */ "FYRw");








var DataRecordListComponent = /** @class */ (function () {
    function DataRecordListComponent(api, roles, activatedRoute) {
        var _this = this;
        this.api = api;
        this.roles = roles;
        this.activatedRoute = activatedRoute;
        this.datarecords = [];
        this.def = {};
        var defs = null;
        this.api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["switchMap"])(function (configuration) {
            defs = configuration.dataRecords || [];
            return _this.activatedRoute.params;
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_5__["switchMap"])(function (params) {
            var detectedName = params.name;
            for (var _i = 0, defs_1 = defs; _i < defs_1.length; _i++) {
                var def = defs_1[_i];
                if (def.name === detectedName) {
                    _this.def = def;
                    return _this.api.queryDatarecords(detectedName);
                }
            }
        }))
            .subscribe(function (datarecords) {
            _this.datarecords = datarecords;
        });
    }
    DataRecordListComponent.prototype.ngOnInit = function () {
    };
    DataRecordListComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_7__["RolesService"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] }
    ]; };
    DataRecordListComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-data-record-list',
            template: _raw_loader_data_record_list_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_data_record_list_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_6__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_7__["RolesService"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"]])
    ], DataRecordListComponent);
    return DataRecordListComponent;
}());



/***/ }),

/***/ "sgLn":
/*!**********************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/users/users.component.html ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Users</h1>\n  <ng-container *ngFor='let item of (api.users | async)'>\n    <app-user-list-item [item]='item'></app-user-list-item>\n  </ng-container>\n</app-container>");

/***/ }),

/***/ "suJK":
/*!********************************************************************!*\
  !*** ./src/app/pipeline-list-item/pipeline-list-item.component.ts ***!
  \********************************************************************/
/*! exports provided: PipelineListItemComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineListItemComponent", function() { return PipelineListItemComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-list-item.component.html */ "Z/Wp");
/* harmony import */ var _pipeline_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-list-item.component.less */ "x+ns");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _confirmer_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../confirmer.service */ "c41A");









var PipelineListItemComponent = /** @class */ (function () {
    function PipelineListItemComponent(api, roles, auth, confirmer) {
        var _this = this;
        this.api = api;
        this.roles = roles;
        this.auth = auth;
        this.confirmer = confirmer;
        this.status = '';
        this.userId = null;
        this.auth.getUser().pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["filter"])(function (x) { return !!x.profile; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["first"])()).subscribe(function (user) {
            _this.userId = user.profile.id;
        });
    }
    PipelineListItemComponent.prototype.ngOnInit = function () {
        this.status = (this.item.status && this.item.status.status === 'didnt-run' ? 'Pending' : this.item.status.status);
    };
    PipelineListItemComponent.prototype.canEdit = function () {
        return (this.item.owner === this.userId && this.roles._.pipelinesEditOwn) || this.roles._.pipelinesEditAll;
    };
    PipelineListItemComponent.prototype.canDelete = function () {
        return (this.item.owner === this.userId && this.roles._.pipelinesDeleteOwn) || this.roles._.pipelinesDeleteAll;
    };
    PipelineListItemComponent.prototype.delete = function (e) {
        var _this = this;
        console.log('DELETING', this.item);
        this.confirmer.confirm(this.confirmer.ACTION_DELETE_TASK, this.item.name)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["filter"])(function (x) { return x; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_7__["switchMap"])(function () { return _this.api.deletePipeline(_this.item.id); })).subscribe(function (result) {
            if (!result) {
                console.log('Failed to DELETE!');
            }
        });
        e.preventDefault();
        return false;
    };
    PipelineListItemComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"] },
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_6__["AuthService"] },
        { type: _confirmer_service__WEBPACK_IMPORTED_MODULE_8__["ConfirmerService"] }
    ]; };
    PipelineListItemComponent.propDecorators = {
        item: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }]
    };
    PipelineListItemComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-list-item',
            template: _raw_loader_pipeline_list_item_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_list_item_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_4__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_5__["RolesService"],
            dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_6__["AuthService"], _confirmer_service__WEBPACK_IMPORTED_MODULE_8__["ConfirmerService"]])
    ], PipelineListItemComponent);
    return PipelineListItemComponent;
}());



/***/ }),

/***/ "tJ4o":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-extract-structure/step-extract-structure.component.html ***!
  \********************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='structure'>\n  <h2 class='workbench-subtitle' i18n>Data Structure</h2>\n  <div class='workbench-explanation' i18n>\n    If the file headers are not located on the first row and column, set the following values to skip some rows or columns.\n  </div>\n  <div class='formish'>\n    <label i18n>Skip Rows:</label>\n    <input type='number'\n      min=\"0\" max=\"100\"\n      [(ngModel)]='structure.skip_rows'\n      (change)='changed()'\n    />\n  </div>\n  <div class='formish'>\n    <label i18n>Skip Columns:</label>\n    <input type='number'\n      min=\"0\" max=\"100\"\n      [(ngModel)]='structure.skip_cols'\n      (change)='changed()'\n    />\n  </div>\n</ng-container>");

/***/ }),

/***/ "tPIJ":
/*!************************************************************!*\
  !*** ./src/app/taxonomy-item/taxonomy-item.component.less ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  padding: 0 20px;\n}\n:host .item .line {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n}\n:host .item .title {\n  max-width: 100%;\n  width: 710px;\n}\n:host .item .title a {\n  padding: 0px 8px;\n  margin-left: auto;\n  margin-top: 20px;\n  margin-bottom: 8px;\n  text-decoration: underline;\n  font-size: 12px;\n}\n:host .item .field {\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  margin-right: 40px;\n}\n:host .item .field label {\n  margin-right: 20px;\n}\n:host .item .field input [type=text],\n:host .item .field textarea {\n  font-size: 11px;\n}\n:host .item .field input[type=text],\n:host .item .field select {\n  width: 200px;\n}\n:host .item .field input[type=checkbox] {\n  width: 50px;\n}\n:host .item .field.big textarea {\n  width: 600px;\n  padding: 3px;\n}\n:host .item .field.small input {\n  width: 100px;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "uBPG":
/*!************************************!*\
  !*** ./src/app/app.component.less ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  height: 100%;\n  display: flex;\n  flex-flow: column;\n  align-items: center;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9Vc2Vycy9hZGFtL0NvZGUvZGF0YXJpdmVyL2RncC9kZ3AtYXBwL3VpL3NyYy9hcHAvYXBwLmNvbXBvbmVudC5sZXNzIiwic3JjL2FwcC9hcHAuY29tcG9uZW50Lmxlc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxXQUFBO0VBQ0EsWUFBQTtFQUNBLGFBQUE7RUFDQSxpQkFBQTtFQUNBLG1CQUFBO0FDQ0oiLCJmaWxlIjoic3JjL2FwcC9hcHAuY29tcG9uZW50Lmxlc3MiLCJzb3VyY2VzQ29udGVudCI6WyI6aG9zdCB7XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1mbG93OiBjb2x1bW47XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn0iLCI6aG9zdCB7XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDEwMCU7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZmxvdzogY29sdW1uO1xuICBhbGlnbi1pdGVtczogY2VudGVyO1xufVxuIl19 */");

/***/ }),

/***/ "vLuJ":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-flipped-mapping/step-flipped-mapping.component.html ***!
  \****************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<h2 class='workbench-subtitle' i18n>Column Mapping</h2>\n<ng-container *ngIf='mandatory_cts.length > 0'>\n  <h3 class='workbench-subsubtitle' i18n>Required Fields</h3>\n  <app-step-flipped-mapping-field *ngFor='let ct of mandatory_cts' \n      [ct]='ct.ct' [mapping]='ct.mapping' [constant]='ct.constant' [config]='config' [mappingType]='ct.mappingType'\n      [sample]='badSample[ct.ct.name]' (update)='updateMapping($event)'>\n  </app-step-flipped-mapping-field>\n</ng-container>\n<ng-container *ngIf='optional_cts.length > 0'>\n  <h3 class='workbench-subsubtitle' i18n>Optional Fields</h3>\n  <app-step-flipped-mapping-field *ngFor='let ct of optional_cts' \n      [ct]='ct.ct' [mapping]='ct.mapping' [constant]='ct.constant' [config]='config' [mappingType]='ct.mappingType'\n      [sample]='badSample[ct.ct.name]' (update)='updateMapping($event)'>\n  </app-step-flipped-mapping-field>\n</ng-container>\n<ng-container *ngIf='unpivot_target !== null'>\n  <h3 class='workbench-subsubtitle' i18n>Data Unpivoting</h3>\n  <h4 class='unpivot-info workbench-subsubsubtitle' i18n>Unpivoting into <strong>{{unpivot_target}}</strong></h4>\n  <table class='unpivot'>\n    <thead class='theme-primary-dark-bg theme-secondary-fg'>\n      <th i18n>Column to unpivot</th>\n      <th *ngFor='let unpivot_column of unpivot_columns'>{{ unpivot_column }}</th>\n      <th></th>\n    </thead>\n    <tbody>\n      <ng-container  *ngFor='let unpivot_field of unpivot_fields'>\n        <tr *ngIf='unpivot_field.field_name !== FIELD_UNPIVOT_DUMMY'>\n          <td>{{unpivot_field.field_name}}</td>\n          <td *ngFor='let unpivot_column of unpivot_columns'>\n            <input [(ngModel)]='unpivot_field.mapping[unpivot_column]' type='text' (change)='recreateMappings()'>\n          </td>\n          <td><a (click)='delete_unpivot_field(unpivot_field.field_name)'><i class=\"fas fa-trash\" aria-hidden=\"true\"></i></a></td>\n        </tr>\n      </ng-container>  \n      <tr>\n        <td>\n          <select (change)='add_unpivot_field($event.target.value)'>\n            <option i18n disabled selected>Select source field to unpivot...</option>\n            <ng-container  *ngFor='let field_name of config.structure.headers'>\n              <option [value]='field_name'>{{field_name}}</option>\n            </ng-container>\n          </select>\n        </td>\n        <td *ngFor='let unpivot_column of unpivot_columns'></td><td></td>\n      </tr>\n    </tbody>\n  </table>\n</ng-container>\n");

/***/ }),

/***/ "vY5A":
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/*! exports provided: AppRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppRoutingModule", function() { return AppRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _pipeline_status_pipeline_status_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pipeline-status/pipeline-status.component */ "zCYW");
/* harmony import */ var _edit_pipeline_edit_pipeline_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./edit-pipeline/edit-pipeline.component */ "qn5Q");
/* harmony import */ var _pipeline_list_pipeline_list_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./pipeline-list/pipeline-list.component */ "X49k");
/* harmony import */ var _dgp_workbench_dgp_workbench_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dgp-workbench/dgp-workbench.component */ "Loy1");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./login/login.component */ "vtpD");
/* harmony import */ var _dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dashboard/dashboard.component */ "QX6l");
/* harmony import */ var _logout_logout_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./logout/logout.component */ "n1B2");
/* harmony import */ var _users_users_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./users/users.component */ "oYre");
/* harmony import */ var _files_files_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./files/files.component */ "jL/9");
/* harmony import */ var _taxonomies_taxonomies_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./taxonomies/taxonomies.component */ "HV3y");
/* harmony import */ var _data_record_list_data_record_list_component__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./data-record-list/data-record-list.component */ "sJCo");
/* harmony import */ var _data_record_edit_data_record_edit_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./data-record-edit/data-record-edit.component */ "K1Oo");















var routes = [
    { path: 'edit/:id', component: _edit_pipeline_edit_pipeline_component__WEBPACK_IMPORTED_MODULE_4__["EditPipelineComponent"], data: { name: 'pipeline-edit' } },
    { path: 'status/:id', component: _pipeline_status_pipeline_status_component__WEBPACK_IMPORTED_MODULE_3__["PipelineStatusComponent"], data: { name: 'pipeline-status' } },
    { path: 'dgp/:id', component: _dgp_workbench_dgp_workbench_component__WEBPACK_IMPORTED_MODULE_6__["DgpWorkbenchComponent"], data: { name: 'workbench' } },
    { path: 'dashboard', component: _dashboard_dashboard_component__WEBPACK_IMPORTED_MODULE_8__["DashboardComponent"], data: { name: 'dashboard' } },
    { path: 'pipelines', component: _pipeline_list_pipeline_list_component__WEBPACK_IMPORTED_MODULE_5__["PipelineListComponent"], data: { name: 'pipelines' } },
    { path: 'users', component: _users_users_component__WEBPACK_IMPORTED_MODULE_10__["UsersComponent"], data: { name: 'users' } },
    { path: 'files', component: _files_files_component__WEBPACK_IMPORTED_MODULE_11__["FilesComponent"], data: { name: 'files' } },
    { path: 'taxonomies', component: _taxonomies_taxonomies_component__WEBPACK_IMPORTED_MODULE_12__["TaxonomiesComponent"], data: { name: 'taxonomies' } },
    { path: 'datarecords/:name', component: _data_record_list_data_record_list_component__WEBPACK_IMPORTED_MODULE_13__["DataRecordListComponent"], data: { name: 'datarecords' } },
    { path: 'datarecords/:name/:id', component: _data_record_edit_data_record_edit_component__WEBPACK_IMPORTED_MODULE_14__["DataRecordEditComponent"], data: { name: 'datarecords' } },
    { path: 'logout', component: _logout_logout_component__WEBPACK_IMPORTED_MODULE_9__["LogoutComponent"], data: { name: 'logout' } },
    { path: '', component: _login_login_component__WEBPACK_IMPORTED_MODULE_7__["LoginComponent"], data: { name: 'login' } }
];
var AppRoutingModule = /** @class */ (function () {
    function AppRoutingModule() {
    }
    AppRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forRoot(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], AppRoutingModule);
    return AppRoutingModule;
}());



/***/ }),

/***/ "vqbR":
/*!************************************************************************************!*\
  !*** ./src/app/pipeline-status-dashboard/pipeline-status-dashboard.component.less ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  display: flex;\n  flex-flow: column;\n}\n:host .indicators {\n  width: 100%;\n  display: flex;\n  flex-flow: row;\n  justify-content: space-between;\n}\n:host .indicators .indicator {\n  display: flex;\n  flex-flow: column;\n  align-items: center;\n  justify-content: center;\n  flex: auto;\n  color: #fff;\n  margin: 10px;\n  padding: 1rem;\n  cursor: pointer;\n}\n:host .indicators .indicator .count {\n  font-size: 2.5rem;\n}\n:host .indicators .indicator .text {\n  margin-top: 1rem;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "vtpD":
/*!******************************************!*\
  !*** ./src/app/login/login.component.ts ***!
  \******************************************/
/*! exports provided: LoginComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginComponent", function() { return LoginComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_login_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./login.component.html */ "in5m");
/* harmony import */ var _login_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./login.component.less */ "RJ08");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../api.service */ "yTNM");






var LoginComponent = /** @class */ (function () {
    function LoginComponent(activatedRoute, router, api) {
        var _this = this;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.api = api;
        this.next = 'dashboard';
        this.activatedRoute.queryParamMap.subscribe(function (params) {
            if (params.has('next')) {
                var next = params.get('next');
                if (next && next.indexOf('logout') === -1) {
                    _this.next = next;
                }
            }
        });
        this.api.token.subscribe(function (token) {
            if (token) {
                _this.router.navigate([_this.next]);
            }
        });
    }
    LoginComponent.prototype.ngOnInit = function () {
    };
    LoginComponent.prototype.login_href = function () {
        if (this.api.providers) {
            if (this.api.providers.google) {
                return this.api.providers.google.url;
            }
            else if (this.api.providers.github) {
                return this.api.providers.github.url;
            }
        }
        return '#';
    };
    LoginComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"] }
    ]; };
    LoginComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-login',
            template: _raw_loader_login_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_login_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"],
            _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"],
            _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"]])
    ], LoginComponent);
    return LoginComponent;
}());



/***/ }),

/***/ "vyeE":
/*!************************************************************************************!*\
  !*** ./src/app/step-flipped-mapping-field/step-flipped-mapping-field.component.ts ***!
  \************************************************************************************/
/*! exports provided: StepFlippedMappingFieldComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepFlippedMappingFieldComponent", function() { return StepFlippedMappingFieldComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_flipped_mapping_field_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-flipped-mapping-field.component.html */ "e5Yk");
/* harmony import */ var _step_flipped_mapping_field_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./step-flipped-mapping-field.component.less */ "8KsV");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../step-flipped-mapping/step-flipped-mapping.component */ "XG5g");







var StepFlippedMappingFieldComponent = /** @class */ (function () {
    function StepFlippedMappingFieldComponent(api) {
        var _this = this;
        this.api = api;
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_3__["EventEmitter"]();
        this.expanded = false;
        this.titleVisible = false;
        this.titleEditable = false;
        this.MT_FIELD_CONSTANT = _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_6__["FIELD_CONSTANT"];
        this.MT_FIELD_UNPIVOT_TARGET = _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_6__["FIELD_UNPIVOT_TARGET"];
        this.MT_FIELD_UNPIVOT_COLUMN = _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_6__["FIELD_UNPIVOT_COLUMN"];
        api.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["first"])()).subscribe(function (configuration) {
            _this.titleVisible = false; //configuration.features.titleVisible !== false;
            _this.titleEditable = configuration.features.titleEditable !== false;
        });
    }
    StepFlippedMappingFieldComponent.prototype.ngOnInit = function () {
        this.mapping = this.mapping || {};
        this.mapping.columnType = this.mapping.columnType || this.ct.name;
        this.mapping.title = this.mapping.title || this.ct.name;
        this.mapping.options = this.mapping.options || {};
        this.updateMappingOptions();
    };
    StepFlippedMappingFieldComponent.prototype.canExpand = function () {
        return (this.titleVisible ||
            this.ct.dataType === 'date' ||
            this.ct.dataType === 'boolean' ||
            this.ct.dataType === 'number' ||
            false);
    };
    Object.defineProperty(StepFlippedMappingFieldComponent.prototype, "_mappingType", {
        get: function () {
            return this.mappingType;
        },
        set: function (mt) {
            this.mappingType = mt;
            if (mt !== _step_flipped_mapping_step_flipped_mapping_component__WEBPACK_IMPORTED_MODULE_6__["FIELD_CONSTANT"]) {
                this.constant = null;
                this.changed();
            }
        },
        enumerable: false,
        configurable: true
    });
    StepFlippedMappingFieldComponent.prototype.updateMappingOptions = function () {
        this.ct.options = this.ct.options || {};
        if (this.ct.dataType === 'date') {
            this.mapping.options.format = this.mapping.options.format || 'default';
        }
        else if (this.ct.dataType === 'boolean') {
            this.mapping.options.trueValues = this.mapping.options.trueValues ||
                this.ct.options.trueValues || ['true', 'True', 'TRUE', '1'];
            this.mapping.options.falseValues = this.mapping.options.falseValues ||
                this.ct.options.falseValues || ['false', 'False', 'FALSE', '0'];
        }
        else if (this.ct.dataType === 'number') {
            this.mapping.options.decimalChar = this.mapping.options.decimalChar || this.ct.options.decimalChar || '.';
            this.mapping.options.groupChar = this.mapping.options.groupChar || this.ct.options.groupChar || '';
            this.mapping.options.bareNumber = this.mapping.options.bareNumber === undefined ? true : this.mapping.options.bareNumber;
        }
        else if (this.ct.dataType === 'integer') {
            this.mapping.options.bareNumber = this.mapping.options.bareNumber === undefined ? true : this.mapping.options.bareNumber;
        }
    };
    Object.defineProperty(StepFlippedMappingFieldComponent.prototype, "trueValues", {
        get: function () {
            if (this.mapping.options.trueValues && Array.isArray(this.mapping.options.trueValues)) {
                return this.mapping.options.trueValues.join(',');
            }
            return null;
        },
        set: function (values) {
            this.mapping.options.trueValues = values.split(',');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StepFlippedMappingFieldComponent.prototype, "falseValues", {
        get: function () {
            if (this.mapping.options.falseValues && Array.isArray(this.mapping.options.falseValues)) {
                return this.mapping.options.falseValues.join(',');
            }
            return null;
        },
        set: function (values) {
            this.mapping.options.falseValues = values.split(',');
        },
        enumerable: false,
        configurable: true
    });
    StepFlippedMappingFieldComponent.prototype.changed = function () {
        var _this = this;
        setTimeout(function () {
            _this.update.emit({ ct: _this.ct, mappingType: _this.mappingType, mapping: _this.mapping, constant: _this.constant });
        }, 0);
    };
    StepFlippedMappingFieldComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"] }
    ]; };
    StepFlippedMappingFieldComponent.propDecorators = {
        ct: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        mapping: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        constant: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        config: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        sample: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        mappingType: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Input"] }],
        update: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_3__["Output"] }]
    };
    StepFlippedMappingFieldComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-step-flipped-mapping-field',
            template: _raw_loader_step_flipped_mapping_field_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_step_flipped_mapping_field_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"]])
    ], StepFlippedMappingFieldComponent);
    return StepFlippedMappingFieldComponent;
}());



/***/ }),

/***/ "wV9K":
/*!**************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/pipeline-list/pipeline-list.component.html ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<app-container>\n  <h1 class='theme-primary-fg' i18n>Processing Tasks</h1>\n  <div *ngIf='roles._.pipelinesNew' class='add-new'><a routerLink='/edit/new' i18n>\n    <i class=\"fas fa-plus-circle\" aria-hidden=\"true\"></i>\n    New Processing Task\n  </a></div>\n  <app-pipeline-list-section [root]='true' [sections]='pipelineSections'></app-pipeline-list-section> \n</app-container>");

/***/ }),

/***/ "x+ns":
/*!**********************************************************************!*\
  !*** ./src/app/pipeline-list-item/pipeline-list-item.component.less ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (":host {\n  width: 100%;\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  border: 0.5px solid #888;\n  margin: 0;\n  padding: 0.5rem 1rem;\n  margin-top: -1px;\n}\n:host .name {\n  flex: 1 1 auto;\n  font-weight: bold;\n}\n:host .status {\n  flex: 0 0 10%;\n  display: flex;\n  flex-flow: row;\n  align-items: center;\n  justify-content: flex-start;\n}\n:host .status span {\n  text-transform: capitalize;\n  padding: 0.25rem;\n  border-radius: 0.25rem;\n  border: 1px solid #888;\n  font-size: 0.75rem;\n  color: black;\n}\n:host .status span.success {\n  background-color: #28a745;\n  border-color: #28a745;\n  color: white;\n}\n:host .status span.failed {\n  background-color: #a93226;\n  border-color: #a93226;\n  color: white;\n}\n:host .status span.running {\n  background-color: #f4d03f;\n  border-color: #f4d03f;\n}\n:host .kind {\n  flex: 0 0 10%;\n}\n:host .schedule {\n  flex: 0 0 10%;\n  text-transform: capitalize;\n}\n:host .delete {\n  flex: 0 0 8%;\n  text-decoration: underline;\n}\n:host .view {\n  flex: 0 0 5%;\n  text-decoration: underline;\n}\n:host .view-status {\n  flex: 0 0 12%;\n}\n:host .edit {\n  flex: 0 0 8%;\n}\n\n/*# sourceMappingURL=data:application/json;base64,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 */");

/***/ }),

/***/ "xq0+":
/*!**********************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/step-enrich/step-enrich.component.html ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='fields && params'>\n    <app-dynamic-fields-editor [item]='params' [fields]='fields'></app-dynamic-fields-editor>\n</ng-container>\n");

/***/ }),

/***/ "yTNM":
/*!********************************!*\
  !*** ./src/app/api.service.ts ***!
  \********************************/
/*! exports provided: ApiService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApiService", function() { return ApiService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./roles.service */ "FYRw");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../environments/environment */ "AytR");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");










var ApiService = /** @class */ (function () {
    function ApiService(http, auth, router, roles, title) {
        var _this = this;
        this.http = http;
        this.auth = auth;
        this.router = router;
        this.roles = roles;
        this.title = title;
        this.pipelines = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.users = new rxjs__WEBPACK_IMPORTED_MODULE_3__["BehaviorSubject"]([]);
        this.files = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.ownFiles = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.otherFiles = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.configuration = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.taxonomies = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.currentConfig = null;
        this.options = {};
        this.API_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_8__["environment"].api_endpoint;
        this.token_ = new rxjs__WEBPACK_IMPORTED_MODULE_3__["ReplaySubject"](1);
        this.providers_ = null;
        this.authenticated_ = false;
        this.authorized_ = false;
        this.currentUser_ = null;
        this.auth.configure({
            authServerUrl: _environments_environment__WEBPACK_IMPORTED_MODULE_8__["environment"].auth_endpoint,
            jwtLocalStorageKey: 'jwt',
            jwtQueryParam: 'jwt',
            profilePagePath: '/p/'
        });
        this.auth.check(window.location.href)
            .subscribe(function (authInfo) {
            if (authInfo) {
                _this.providers_ = authInfo.providers;
                _this.authenticated_ = authInfo.authenticated;
                if (!_this.authenticated_) {
                    _this.router.navigate(['/'], { queryParams: { next: window.location.pathname } });
                }
                else {
                    _this.currentUser_ = authInfo;
                }
            }
        });
        this.auth.getJwt()
            .subscribe(function (token) {
            if (token) {
                _this.auth.permission('etl-server')
                    .subscribe(function (permission) {
                    _this.authorized_ = permission.permissions && permission.permissions.level;
                    if (_this.authorized_) {
                        _this.token_.next(permission.token);
                        _this.roles.setRoles(permission.permissions.roles || []);
                    }
                    else {
                        _this.router.navigate(['/']);
                    }
                });
            }
        });
        this.token_.subscribe(function (token) {
            if (token) {
                _this.getConfiguration();
                _this.queryPipelines();
            }
            _this.options = { headers: { 'X-Auth': token } };
        });
    }
    Object.defineProperty(ApiService.prototype, "authenticated", {
        get: function () {
            return this.authenticated_;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ApiService.prototype, "authorized", {
        get: function () {
            return this.authenticated_ && this.authorized_;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ApiService.prototype, "currentUser", {
        get: function () {
            return this.currentUser_;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ApiService.prototype, "providers", {
        get: function () {
            return this.providers_;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ApiService.prototype, "token", {
        get: function () {
            return this.token_;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ApiService.prototype, "httpOptions", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    ApiService.prototype.createMap = function (obj, field, target) {
        var ret = {};
        for (var _i = 0, _a = obj[field]; _i < _a.length; _i++) {
            var item = _a[_i];
            ret[item.name] = item;
        }
        obj[target] = ret;
    };
    ApiService.prototype.getConfiguration = function () {
        var _this = this;
        this.token_.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function (token) { return _this.http.get(_this.API_ENDPOINT + "/configuration?jwt=" + token, _this.options); })).subscribe(function (result) {
            var configuration = result['result'];
            _this.createMap(configuration, 'kinds', 'kinds_map');
            _this.createMap(configuration, 'schedules', 'schedules_map');
            if (configuration.siteTitle) {
                _this.title.setTitle(configuration.siteTitle);
            }
            configuration.features = configuration.features || {};
            _this.configuration.next(configuration);
            _this.currentConfig = configuration;
        });
    };
    ApiService.prototype.queryUsers = function () {
        var _this = this;
        this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/users", _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'].map(function (x) { return Object.assign(x.value, { self: x.self }); });
            }
            return [];
        })).subscribe(function (users) {
            _this.users.next(users);
        });
    };
    ApiService.prototype.queryTaxonomies = function () {
        var _this = this;
        this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/taxonomies", _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'].map(function (x) { return Object.assign(x.value); });
            }
            return [];
        })).subscribe(function (taxonomies) {
            _this.taxonomies.next(taxonomies);
        });
    };
    ApiService.prototype.updateTaxonomy = function (user) {
        return this.http.post(this.API_ENDPOINT + "/taxonomy", user, this.options);
    };
    ApiService.prototype.deleteUser = function (userId) {
        var _this = this;
        return this.http.delete(this.API_ENDPOINT + "/user/" + userId, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            _this.queryUsers();
            return result;
        }));
    };
    ApiService.prototype.updateUser = function (user) {
        var _this = this;
        return this.http.post(this.API_ENDPOINT + "/user", user, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            _this.queryUsers();
            return result;
        }));
    };
    ApiService.prototype.queryPipelines = function () {
        var _this = this;
        this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/pipelines", _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'];
            }
            return [];
        })).subscribe(function (pipelines) {
            for (var _i = 0, pipelines_1 = pipelines; _i < pipelines_1.length; _i++) {
                var x = pipelines_1[_i];
                x['params'] = x['params'] || {};
                x['status'] = x['status'] || {};
            }
            _this.pipelines.next(pipelines);
        });
    };
    ApiService.prototype.queryPipeline = function (id) {
        var _this = this;
        return this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/pipeline/" + id, _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'];
            }
            return {};
        }));
    };
    ApiService.prototype.savePipeline = function (pipeline) {
        var _this = this;
        return this.http.post(this.API_ENDPOINT + "/pipeline", pipeline, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                _this.queryPipelines();
                return result['result'];
            }
            return {};
        }));
    };
    ApiService.prototype.deletePipeline = function (id) {
        var _this = this;
        return this.http.delete(this.API_ENDPOINT + "/pipeline/" + id, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                _this.queryPipelines();
            }
            return result.success;
        }));
    };
    ApiService.prototype.triggerPipeline = function (id) {
        var _this = this;
        return this.http.post(this.API_ENDPOINT + "/pipeline/start/" + id, {}, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                _this.queryPipelines();
            }
            return result.success;
        }));
    };
    ApiService.prototype.queryFiles = function (subscribe) {
        var _this = this;
        if (subscribe === void 0) { subscribe = true; }
        var o = this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/files", _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result.result;
            }
            return [];
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (files) {
            _this.files.next(files);
            _this.ownFiles.next(files.filter(function (x) { return x.owner_id === _this.currentUser_.profile.id; }));
            _this.otherFiles.next(files.filter(function (x) { return x.owner_id !== _this.currentUser_.profile.id; }));
            return files;
        }));
        if (subscribe) {
            o.subscribe(function (files) {
                console.log('FILES:', files);
            });
        }
        return o;
    };
    ApiService.prototype.uploadFile = function (file, filename, progress, success) {
        var _this = this;
        this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () {
            return _this.http.post(_this.API_ENDPOINT + "/upload", file, Object.assign({
                observe: 'events',
                reportProgress: true,
                params: {
                    filename: filename
                }
            }, _this.options));
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(function (err) {
            success(false);
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_3__["of"])([err]);
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (event) {
            if (event.type === _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpEventType"].UploadProgress) {
                var percentDone = Math.round(100 * event.loaded / event.total);
                progress(percentDone);
            }
            else {
                return event;
            }
        }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["filter"])(function (event) { return event && (!event.type || event.type === _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpEventType"].Response); })).subscribe(function (result) {
            if (result.body) {
                success(result.body.success);
                _this.queryFiles();
            }
        });
    };
    ApiService.prototype.deleteFile = function (filename) {
        var _this = this;
        return this.http.delete(this.API_ENDPOINT + "/file", Object.assign({
            params: {
                filename: filename
            }
        }, this.options))
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            _this.queryFiles();
            return result;
        }));
    };
    ApiService.prototype.queryDatarecords = function (kind) {
        var _this = this;
        return this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/datarecords/" + kind, _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'];
            }
            return [];
        }));
    };
    ApiService.prototype.queryDatarecord = function (kind, id) {
        var _this = this;
        return this.configuration.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["switchMap"])(function () { return _this.http.get(_this.API_ENDPOINT + "/datarecord/" + kind + "/" + id, _this.options); }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'];
            }
            return {};
        }));
    };
    ApiService.prototype.saveDatarecord = function (kind, datarecord) {
        return this.http.post(this.API_ENDPOINT + "/datarecord/" + kind, datarecord, this.options)
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["map"])(function (result) {
            if (result.success) {
                return result['result'];
            }
            return {};
        }));
    };
    ApiService.ctorParameters = function () { return [
        { type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"] },
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_5__["AuthService"] },
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_6__["Router"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_7__["RolesService"] },
        { type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_9__["Title"] }
    ]; };
    ApiService = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"], dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_5__["AuthService"], _angular_router__WEBPACK_IMPORTED_MODULE_6__["Router"],
            _roles_service__WEBPACK_IMPORTED_MODULE_7__["RolesService"], _angular_platform_browser__WEBPACK_IMPORTED_MODULE_9__["Title"]])
    ], ApiService);
    return ApiService;
}());



/***/ }),

/***/ "yb8t":
/*!**********************************************************************!*\
  !*** ./src/app/step-extract-source/step-extract-source.component.ts ***!
  \**********************************************************************/
/*! exports provided: StepExtractSourceComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StepExtractSourceComponent", function() { return StepExtractSourceComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_step_extract_source_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./step-extract-source.component.html */ "9//7");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../api.service */ "yTNM");




var StepExtractSourceComponent = /** @class */ (function () {
    function StepExtractSourceComponent(api) {
        this.api = api;
        this.update = new _angular_core__WEBPACK_IMPORTED_MODULE_2__["EventEmitter"]();
    }
    StepExtractSourceComponent.prototype.ngOnInit = function () {
    };
    StepExtractSourceComponent.prototype.changed = function (config) {
        if (config) {
            config.__revision = -1;
        }
        this.update.emit(config);
    };
    StepExtractSourceComponent.ctorParameters = function () { return [
        { type: _api_service__WEBPACK_IMPORTED_MODULE_3__["ApiService"] }
    ]; };
    StepExtractSourceComponent.propDecorators = {
        source: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["Input"] }],
        loader: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["Input"] }],
        update: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_2__["Output"] }]
    };
    StepExtractSourceComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_2__["Component"])({
            selector: 'app-step-extract-source',
            template: _raw_loader_step_extract_source_component_html__WEBPACK_IMPORTED_MODULE_1__["default"]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_api_service__WEBPACK_IMPORTED_MODULE_3__["ApiService"]])
    ], StepExtractSourceComponent);
    return StepExtractSourceComponent;
}());



/***/ }),

/***/ "zCYW":
/*!**************************************************************!*\
  !*** ./src/app/pipeline-status/pipeline-status.component.ts ***!
  \**************************************************************/
/*! exports provided: PipelineStatusComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PipelineStatusComponent", function() { return PipelineStatusComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "mrSG");
/* harmony import */ var _raw_loader_pipeline_status_component_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! raw-loader!./pipeline-status.component.html */ "i0Sx");
/* harmony import */ var _pipeline_status_component_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pipeline-status.component.less */ "Wcxb");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../api.service */ "yTNM");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! moment */ "wd/R");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _roles_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../roles.service */ "FYRw");
/* harmony import */ var dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! dgp-oauth2-ng */ "f15z");










var PipelineStatusComponent = /** @class */ (function () {
    function PipelineStatusComponent(route, api, roles, auth) {
        var _this = this;
        this.route = route;
        this.api = api;
        this.roles = roles;
        this.auth = auth;
        this.item = { status: {} };
        this.visible = false;
        this.userId = null;
        this.status = '';
        this.auth.getUser().pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["filter"])(function (x) { return x && !!x.profile; }), Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["first"])()).subscribe(function (user) {
            _this.userId = user.profile.id;
        });
        this.refresh();
        this._moment = moment__WEBPACK_IMPORTED_MODULE_7__;
    }
    PipelineStatusComponent.prototype.refresh = function () {
        var _this = this;
        this.route.paramMap.pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_6__["switchMap"])(function (params) {
            return _this.api.queryPipeline(params.get('id'));
        })).subscribe(function (pipeline) {
            _this.item = pipeline;
            if (_this.item.status.status === 'running' && _this.visible) {
                setTimeout(function () { _this.refresh(); }, 1000);
            }
            _this.status = (_this.item.status && _this.item.status.status === 'didnt-run' ? 'Pending for Approval' : _this.item.status.status);
        });
    };
    PipelineStatusComponent.prototype.ngOnInit = function () {
        this.visible = true;
    };
    PipelineStatusComponent.prototype.ngOnDestroy = function () {
        this.visible = false;
    };
    PipelineStatusComponent.prototype.canEdit = function () {
        return (this.item.owner === this.userId && this.roles._.pipelinesEditOwn) || this.roles._.pipelinesEditAll;
    };
    PipelineStatusComponent.prototype.trigger = function () {
        var _this = this;
        this.api.triggerPipeline(this.item.id)
            .subscribe(function (result) {
            _this.refresh();
        });
    };
    PipelineStatusComponent.ctorParameters = function () { return [
        { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
        { type: _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"] },
        { type: _roles_service__WEBPACK_IMPORTED_MODULE_8__["RolesService"] },
        { type: dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_9__["AuthService"] }
    ]; };
    PipelineStatusComponent = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_3__["Component"])({
            selector: 'app-pipeline-status',
            template: _raw_loader_pipeline_status_component_html__WEBPACK_IMPORTED_MODULE_1__["default"],
            styles: [_pipeline_status_component_less__WEBPACK_IMPORTED_MODULE_2__["default"]]
        }),
        Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"])("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"], _api_service__WEBPACK_IMPORTED_MODULE_5__["ApiService"], _roles_service__WEBPACK_IMPORTED_MODULE_8__["RolesService"], dgp_oauth2_ng__WEBPACK_IMPORTED_MODULE_9__["AuthService"]])
    ], PipelineStatusComponent);
    return PipelineStatusComponent;
}());



/***/ }),

/***/ "zUnb":
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/platform-browser-dynamic */ "a3Wg");
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app/app.module */ "ZAI4");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./environments/environment */ "AytR");




if (_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].production) {
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["enableProdMode"])();
}
Object(_angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_1__["platformBrowserDynamic"])().bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_2__["AppModule"])
    .catch(function (err) { return console.error(err); });


/***/ }),

/***/ "zvAQ":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/dynamic-fields-editor/dynamic-fields-editor.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ng-container *ngIf='item'>\n  <ng-container *ngFor='let field of fields'>\n    <div class='field' [class.invalid]='!field.__valid'>\n      <ng-container *ngIf='field.type !== \"section\"'>\n        <label [innerHtml]='field.display'></label>\n      </ng-container>\n      <ng-container *ngIf='field.type === \"text\" || !field.type'>\n        <input type='text' [(ngModel)]='item[field.name]' (change)='update()'/>\n      </ng-container>\n      <ng-container *ngIf='field.type === \"boolean\"'>\n        <input type='checkbox' [(ngModel)]='item[field.name]' (change)='update()'/>\n      </ng-container>\n      <ng-container *ngIf='field.type === \"enum\" || field.options'>\n        <select [(ngModel)]='item[field.name]' (change)='update()'>\n          <option *ngFor='let option of field.options' [value]='option.value || option'>{{ option.display || option }}</option>\n        </select>\n      </ng-container>\n      <ng-container *ngIf='field.type !== \"section\"'>\n        <div class='field-description' [innerHtml]='field.description' *ngIf='field.description'></div>\n      </ng-container>\n      <ng-container *ngIf='field.type === \"section\"'>\n        <div class='section'>\n          <h2 [innerHtml]='field.display' class='theme-secondary-fg theme-primary-bg'></h2>\n          <div class='section-description' [innerHtml]='field.description' *ngIf='field.description'></div>\n          <app-dynamic-fields-editor [item]='item' [fields]='field.fields' *ngIf='!field.expandable || expanded[field.display]' (updated)='update()'></app-dynamic-fields-editor>\n          <a class='expander' *ngIf='field.expandable && expanded[field.display]' (click)='expanded[field.display]=false'>less...</a>\n          <a class='expander' *ngIf='field.expandable && !expanded[field.display]' (click)='expanded[field.display]=true'>more...</a>\n        </div>\n      </ng-container>\n    </div>\n  </ng-container> \n</ng-container>\n");

/***/ })

},[[0,"runtime","vendor"]]]);
//# sourceMappingURL=main.js.map