# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/70_imgs.ipynb.

# %% auto 0
__all__ = ['Img', 'Image', 'ImageLike', 'ImageSize', 'ImgSize', 'Video', 'VideoCapture', 'VidCap', 'VideoSize', 'VidSize',
           'Coordinate', 'Coord', 'Point', 'XYPos', 'Width', 'Height', 'Rect', 'BBox', 'BoundingBox', 'Size', 'RGB',
           'RGBA', 'Color']

# %% ../nbs/70_imgs.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/70_imgs.ipynb 8
from typing import (Union, Tuple, TypeAlias, ForwardRef)

# %% ../nbs/70_imgs.ipynb 11
try:
    from cv2 import VideoCapture as vidcap
except ImportError:
    vidcap = ForwardRef('cv2.VideoCapture', module='cv2', is_class=True)

# %% ../nbs/70_imgs.ipynb 13
try:
    from PIL.Image import Image as image
except ImportError:
    image = ForwardRef('PIL.Image.Image', module='PIL.Image', is_class=True)

# %% ../nbs/70_imgs.ipynb 15
#| export


# %% ../nbs/70_imgs.ipynb 17
from .npty import NPArray
from .nums import Numeric

# %% ../nbs/70_imgs.ipynb 20
Img: TypeAlias = image
Image: TypeAlias = image
ImageLike: TypeAlias = Union[NPArray, Image]

ImageSize: TypeAlias = Union[Tuple[int, int], Tuple[int, int, int]]
ImgSize: TypeAlias = ImageSize

# %% ../nbs/70_imgs.ipynb 22
Video: TypeAlias = vidcap
VideoCapture: TypeAlias = Video
VidCap: TypeAlias = Video

VideoSize: TypeAlias = Union[Tuple[int, int, int], Tuple[int, int, int, int]]
VidSize: TypeAlias = VideoSize

# %% ../nbs/70_imgs.ipynb 24
Coordinate: TypeAlias = Tuple[Numeric, ...]
Coord: TypeAlias = Coordinate
Point: TypeAlias = Coordinate

XYPos: TypeAlias = Tuple[int, int]

Width: TypeAlias = int
'''the width of an object'''
Height: TypeAlias = int
'''the height of an object'''
Rect: TypeAlias = Tuple[Width, Height]
'''the width and height of a rectangle'''

BBox: TypeAlias = Tuple[XYPos, XYPos]
BoundingBox: TypeAlias = BBox
Size: TypeAlias = Tuple[int, ...]

# %% ../nbs/70_imgs.ipynb 26
RGB: TypeAlias = Tuple[int, int, int]
RGBA: TypeAlias = Tuple[int, int, int, int]

Color: TypeAlias = Union[RGB, RGBA]
