"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Java Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineJavaProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineJavaProject", {
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)["src/test/java/projenrc.java"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineJavaProject({
            artifactId: "test",
            cdkVersion: "2.0.0",
            groupId: "test",
            mainClass: "software.aws.Pipeline",
            version: "0.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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