Print["Testing the matching of the Scalar singlet on the SMEFT"];

Get["matcher`"];


eft = "SMEFT_Green_Bpreserving_MM";
full = "Scalar_Singlet_BFM_MM";


MatchModeltoEFT[full, eft];

Get[FileNameJoin[{full,"MatchingResult.dat"}]];

literaturetree = {
   alphaOlambda -> 1/2 (\[Lambda]h - A^2/M^2),
   alphaOHBox -> -A^2/2/M^4,
   alphaOH -> A^3 \[Mu]/6/M^6 - A^2 \[Kappa]/2/M^4};


(* One Loop *)
literaturelooplogsMME = {
    alphaKH -> 0*A^2/4/M^2,
    alphaOHBox -> -\[Kappa]^2/(24 M^2) + (25 A^2 \[Kappa] - 
         6 A^2 \[Lambda]\[Phi] - 
         5 A \[Kappa] \[Mu])/(12 M^4) + (38 A^4 - 26 A^3 \[Mu] + 
         11 A^2 \[Mu]^2)/(24 M^6) - (31 A^2 (g1^2 + 
           3 g2^2))/(72 M^4) + ((4 A^2 \[Kappa] - 
            A^2 \[Lambda]\[Phi])/M^4 + 2 A^4/M^6 - 
         5 A^2 (g1^2 + 3 g2^2)/(6 M^4)) Log[\[Mu]M/M],
    alphaOH -> -\[Kappa]^3/(12 M^2) - (6 A^2 \[Kappa] \[Lambda]\[Phi] \
+ 162 A^2 \[Kappa] \[Lambda] - 66 A^2 \[Kappa]^2 - 
         164 A^2 \[Lambda]^2 + 
         3 A \[Kappa]^2 \[Mu])/(12 M^4) + (87 A^4 \[Kappa] - 
         6 A^4 \[Lambda]\[Phi] - 72 A^4 \[Lambda] - 
         60 A^3 \[Kappa] \[Mu] + 4 A^3 \[Mu] \[Lambda]\[Phi] + 
         78 A^3 \[Lambda] \[Mu] + 
         6 A^2 \[Kappa] \[Mu]^2)/(12 M^6) - (8 A^6 + 21 A^5 \[Mu] - 
         12 A^4 \[Mu]^2 + 2 A^3 \[Mu]^3)/(12 M^8) - 
      31 A^2 \[Lambda] g2^2/(18 M^4) + (-(A^2 \[Kappa] \
\[Lambda]\[Phi] + 36 A^2 \[Kappa] \[Lambda] - 12 A^2 \[Kappa]^2 - 
             40 A^2 \[Lambda]^2)/(2 M^4) + (18 A^4 \[Kappa] - 
            12 A^3 \[Kappa] \[Mu] + A^3 \[Mu] \[Lambda]\[Phi] + 
            36 A^3 \[Lambda] \[Mu])/(6 M^6) - A^5 \[Mu]/M^8 - 
         10 A^2 \[Lambda] g2^2/(3 M^4)) Log[\[Mu]M/M],
    alphaOHD -> -31 A^2 g1^2/(18 M^4) + (20 g1^2/
          3) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHB -> A^2 g1^2/(12 M^4),
    alphaOHW -> A^2 g2^2/(12 M^4),
    alphaOHWB -> A^2 g1 g2/(6 M^4),
    alphaOuH[fli_, 
      flj_] -> -A^2 /(36 M^4) (yu[fli, 
           flj] (27 \[Kappa] - 87 \[Lambda] - 9 A \[Mu]/M^2 + 
            31 g2^2) - 
         45 yu[fli, fl1] yubar[fl2, fl1] yu[fl2, 
           flj]) + (-yu[fli, flj] (2 \[Lambda] - 10 g2^2/3) - 
         6 yu[fli, fl1] yubar[fl2, fl1] yu[fl2, 
           flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOdH[fli_, 
      flj_] -> -A^2 /(36 M^4) (yd[fli, 
           flj] (27 \[Kappa] - 87 \[Lambda] - 9 A \[Mu]/M^2 + 
            31 g2^2) - 
         45 yd[fli, fl1] ydbar[fl2, fl1] yd[fl2, 
           flj]) + (-yd[fli, flj] (2 \[Lambda] - 10 g2^2/3) - 
         6 yd[fli, fl1] ydbar[fl2, fl1] yd[fl2, 
           flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOeH[fli_, 
      flj_] -> -A^2 /(36 M^4) (yl[fli, 
           flj] (27 \[Kappa] - 87 \[Lambda] - 9 A \[Mu]/M^2 + 
            31 g2^2) - 
         45 yl[fli, fl1] ylbar[fl2, fl1] yl[fl2, 
           flj]) + (-yl[fli, flj] (2 \[Lambda] - 10 g2^2/3) - 
         6 yl[fli, fl1] ylbar[fl2, fl1] yl[fl2, 
           flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHu[fli_, 
      flj_] -> -A^2/(216 M^4) (34 g1^2 KroneckerDelta[fli, flj] - 
         135 yubar[fl1, fli] yu[fl1, flj]) + (2 g1^2/9 KroneckerDelta[
           fli, flj] - 
         yubar[fl1, fli] yu[fl1, flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHd[fli_, flj_] -> 
     A^2/(216 M^4) (17 g1^2 KroneckerDelta[fli, flj] - 
         135 ydbar[fl1, fli] yd[fl1, flj]) + (-g1^2/9 KroneckerDelta[
           fli, flj] + 
         ydbar[fl1, fli] yd[fl1, flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHud[fli_, 
      flj_] -> -5 A^2/(4 M^4) yubar[fl1, fli] yd[fl1, 
        flj] + (2 yubar[fl1, fli] yd[fl1, 
          flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHe[fli_, flj_] -> 
     A^2/(72 M^4) (17 g1^2 KroneckerDelta[fli, flj] - 
         45 ylbar[fl1, fli] yl[fl1, flj]) + (-g1^2/3 KroneckerDelta[
           fli, flj] + 
         ylbar[fl1, fli] yl[fl1, flj]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHq1[fli_, 
      flj_] -> -A^2/(432 M^4) (17 g1^2 KroneckerDelta[fli, flj] + 
         135 (yu[fli, fl1] yubar[flj, fl1] - 
            yd[fli, fl1] ydbar[flj, fl1])) + (g1^2/18 KroneckerDelta[
           fli, flj] + 
         1/2 (yu[fli, fl1] yubar[flj, fl1] - 
            yd[fli, fl1] ydbar[flj, fl1])) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHq3[fli_, 
      flj_] -> -A^2/(144 M^4) (17 g2^2 KroneckerDelta[fli, flj] - 
         45 (yu[fli, fl1] yubar[flj, fl1] + 
            yd[fli, fl1] ydbar[flj, fl1])) + (g2^2/6 KroneckerDelta[
           fli, flj] - 
         1/2 (yu[fli, fl1] yubar[flj, fl1] + 
            yd[fli, fl1] ydbar[flj, fl1])) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHl1[fli_, flj_] -> 
     A^2/(144 M^4) (17 g1^2 KroneckerDelta[fli, flj] + 
         45 yl[fli, fl1] ylbar[flj, fl1]) + (-g1^2/6 KroneckerDelta[
           fli, flj] - 
         1/2 yl[fli, fl1] ylbar[flj, fl1]) alphaOHBox0 Log[\[Mu]M/M],
    alphaOHl3[fli_, 
      flj_] -> -A^2/(144 M^4) (17 g2^2 KroneckerDelta[fli, flj] - 
         45 yl[fli, fl1] ylbar[flj, fl1]) + (g2^2/6 KroneckerDelta[
           fli, flj] - 
         1/2 yl[fli, fl1] ylbar[flj, fl1]) alphaOHBox0 Log[\[Mu]M/M]
    } /. {alphaOHBox0 -> -A^2/2/M^4,
    alphaOH0 -> A^3 \[Mu]/6/M^6 - A^2 \[Kappa]/2/M^4};

ustothem = {aprime -> A, kappaprime -> \[Kappa], Msphi -> M, 
   muprime -> \[Mu], lam -> \[Lambda]h/2, 
   lambdaphi -> \[Lambda]\[Phi], invepsilonbar -> 0, 
   muH -> 0 \[Mu]H};
ustothemloop = ustothem /. {\[Lambda]h -> \[Lambda] + A^2/M^2};
nologs = {Log[M^2/\[Mu]^2] -> 0, \[Mu]M -> M};
yeslogs = {Log[M^2/\[Mu]^2] -> -2 Log[\[Mu]M/M]};

oursoltree = 
  DeleteCases[
    MatchingResult[[1, 1, 1]] /. {Rule[a_, 0] -> 0, Rule[a_, 1] -> 0, 
      Rule[a_, KroneckerDelta[b__]] -> 0, Rule[a_, yu[b__]] -> 0, 
      Rule[a_, yubar[b__]] -> 0, Rule[a_, yd[b__]] -> 0, 
      Rule[a_, ydbar[b__]] -> 0, Rule[a_, yl[b__]] -> 0, 
      Rule[a_, ylbar[b__]] -> 0, Rule[a_, muH^2] -> 0}, 0] /. ustothem;
oursolloopphys = MatchingResult[[3]];

res={}

Print["Comparing the tree level matching"];
Do[
 diferencia = 
  DummyZeroQ[
   literaturetree[[i, 2]] - 
      RemoveUnderscore[literaturetree[[i, 1]]] /. oursoltree /. 
    ustothem];
     AppendTo[res,diferencia];
 , {i, Length[literaturetree]}]

Print["Comparing the one-loop matching"];
Do[
 diferencia = 
  DummyZeroQ[(literaturelooplogsMME[[i, 2]] /. yeslogs) - 
    Coefficient[
     16 Pi^2 RemoveUnderscore[literaturelooplogsMME[[i, 1]]] /. 
        oursolloopphys /. ustothemloop /. yeslogs, onelooporder]];
     AppendTo[res,diferencia];
 , {i, Length[literaturelooplogsMME]}]

Print["\n\n\n"];
If[Length[res]>0&&Length[DeleteCases[res,0]]==0,Print["Test for Scalar_Singlet_BFM_MM ok"],
Print["There was a problem with the test for Scalar_Singlet_BFM_MM"]; Exit[1]]
Print["\n\n\n"];
