"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ListenerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "ListenerProperty", { enumerable: true, get: function () { return slb_generated_1.RosListener; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::Listener`
 */
class Listener extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::Listener`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosListener = new slb_generated_1.RosListener(this, id, {
            requestTimeout: props.requestTimeout,
            listenerPort: props.listenerPort,
            vServerGroupId: props.vServerGroupId,
            description: props.description,
            caCertificateId: props.caCertificateId,
            scheduler: props.scheduler === undefined || props.scheduler === null ? 'wrr' : props.scheduler,
            aclId: props.aclId,
            healthCheck: props.healthCheck,
            idleTimeout: props.idleTimeout,
            loadBalancerId: props.loadBalancerId,
            backendServerPort: props.backendServerPort,
            persistence: props.persistence,
            portRange: props.portRange,
            aclStatus: props.aclStatus === undefined || props.aclStatus === null ? 'off' : props.aclStatus,
            bandwidth: props.bandwidth,
            masterSlaveServerGroupId: props.masterSlaveServerGroupId,
            serverCertificateId: props.serverCertificateId,
            startListener: props.startListener === undefined || props.startListener === null ? true : props.startListener,
            httpConfig: props.httpConfig,
            aclType: props.aclType,
            protocol: props.protocol,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosListener;
        this.attrListenerPortsAndProtocol = rosListener.attrListenerPortsAndProtocol;
        this.attrLoadBalancerId = rosListener.attrLoadBalancerId;
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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