"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "LoadBalancerProperty", { enumerable: true, get: function () { return slb_generated_1.RosLoadBalancer; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::LoadBalancer`
 */
class LoadBalancer extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::LoadBalancer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancer = new slb_generated_1.RosLoadBalancer(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            resourceGroupId: props.resourceGroupId,
            pricingCycle: props.pricingCycle,
            addressIpVersion: props.addressIpVersion,
            vSwitchId: props.vSwitchId,
            autoRenew: props.autoRenew,
            duration: props.duration,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            payType: props.payType,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            slaveZoneId: props.slaveZoneId,
            modificationProtectionStatus: props.modificationProtectionStatus,
            internetChargeType: props.internetChargeType === undefined || props.internetChargeType === null ? 'paybytraffic' : props.internetChargeType,
            loadBalancerSpec: props.loadBalancerSpec,
            loadBalancerName: props.loadBalancerName,
            vpcId: props.vpcId,
            bandwidth: props.bandwidth === undefined || props.bandwidth === null ? 1 : props.bandwidth,
            modificationProtectionReason: props.modificationProtectionReason,
            addressType: props.addressType === undefined || props.addressType === null ? 'internet' : props.addressType,
            tags: props.tags,
            masterZoneId: props.masterZoneId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancer;
        this.attrAddressIpVersion = rosLoadBalancer.attrAddressIpVersion;
        this.attrAddressType = rosLoadBalancer.attrAddressType;
        this.attrBandwidth = rosLoadBalancer.attrBandwidth;
        this.attrIpAddress = rosLoadBalancer.attrIpAddress;
        this.attrLoadBalancerId = rosLoadBalancer.attrLoadBalancerId;
        this.attrLoadBalancerName = rosLoadBalancer.attrLoadBalancerName;
        this.attrLoadBalancerSpec = rosLoadBalancer.attrLoadBalancerSpec;
        this.attrMasterZoneId = rosLoadBalancer.attrMasterZoneId;
        this.attrNetworkType = rosLoadBalancer.attrNetworkType;
        this.attrOrderId = rosLoadBalancer.attrOrderId;
        this.attrPayType = rosLoadBalancer.attrPayType;
        this.attrResourceGroupId = rosLoadBalancer.attrResourceGroupId;
        this.attrSlaveZoneId = rosLoadBalancer.attrSlaveZoneId;
        this.attrVSwitchId = rosLoadBalancer.attrVSwitchId;
        this.attrVpcId = rosLoadBalancer.attrVpcId;
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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