from collections import namedtuple
from itertools import starmap

ElementInformation = namedtuple("ElementInformation", ("symbol", "name", "atomic_number", "mass_number", "valence"))

_raw_data = (
    ("H", "Hydrogen", 1, 1, 1),
    ("He", "Helium", 2, 4, 0),
    ("Li", "Lithium", 3, 7, 1),
    ("Be", "Beryllium", 4, 9, 2),
    ("B", "Boron", 5, 11, 3),
    ("C", "Carbon", 6, 12, 4),
    ("N", "Nitrogen", 7, 14, 3),
    ("O", "Oxygen", 8, 16, 2),
    ("F", "Fluorine", 9, 19, 1),
    ("Ne", "Neon", 10, 20, 0),

    ("Na", "Sodium", 11, 23, 1),
    ("Mg", "Magnesium", 12, 24, 2),
    ("Al", "Aluminium", 13, 27, 3),
    ("Si", "Silicon", 14, 28, 4),
    ("P", "Phosphorous", 15, 31, 5),
    ("S", "Sulfur", 16, 32, 6),
    ("Cl", "Chlorine", 17, 35, 7),
    ("Ar", "Argon", 18, 40, 0),

    ("K", "Potassium", 19, 39, 1),
    ("Ca", "Calcium", 20, 40, 1),
    ("Sc", "Scandium", 21, 45, 1),
    ("Ti", "Titanium", 22, 48, 1),
    ("V", "Vanadium", 23, 51, 1),
    ("Cr", "Chromium", 24, 52, 1),
    ("Mn", "Manganese", 25, 55, 1),
    ("Fe", "Iron", 26, 56, 1),
    ("Co", "Cobalt", 27, 59, 1),
    ("Ni", "Nickel", 28, 58, 1),
    ("Cu", "Copper", 29, 63, 1),
    ("Zn", "Zinc", 30, 64, 1),
    ("Ga", "Gallium", 31, 69, 1),
    ("Ge", "Germanium", 32, 74, 1),
    ("As", "Arsenic", 33, 75, 1),
    ("Se", "Selenium", 34, 80, 1),
    ("Br", "Bromine", 35, 79, 1),
    ("Kr", "Krypton", 36, 84, 1),

    ("Rb", "Rubidium", 37, 85, 1),
    ("Sr", "Strontium", 38, 88, 1),
    ("Y", "Yttrium", 39, 89, 1),
    ("Zr", "Zirconium", 40, 90, 1),
    ("Nb", "Niobium", 41, 93, 1),
    ("Mo", "Molybdenum", 42, 98, 1),
    ("Tc", "Technetium", 43, 98, 1),
    ("Ru", "Ruthenium", 44, 102, 1),
    ("Rh", "Rhodium", 45, 103, 1),
    ("Pd", "Palladium", 46, 106, 1),
    ("Ag", "Silver", 47, 107, 1),
    ("Cd", "Cadmium", 48, 114, 1),
    ("In", "Indium", 49, 115, 1),
    ("Sn", "Tin", 50, 120, 1),
    ("Sb", "Antimony", 51, 121, 1),
    ("Te", "Tellurium", 52, 130, 1),
    ("I", "Iodine", 53, 127, 1),
    ("Xe", "Xenon", 54, 132, 1),

    ("Cs", "Caesium", 55, 133, 1),
    ("Ba", "Barium", 56, 138, 1),
    ("La", "Lanthanum", 57, 139, 1),
    ("Ce", "Cerium", 58, 140, 1),
    ("Pr", "Praseodymium", 59, 141, 1),
    ("Nd", "Neodymium", 60, 142, 1),
    ("Pm", "Promethium", 61, 145, 1),
    ("Sm", "Samarium", 62, 152, 1),
    ("Eu", "Europium", 63, 153, 1),
    ("Gd", "Gadolinium", 64, 158, 1),
    ("Tb", "Terbium", 65, 159, 1),
    ("Dy", "Dysprosium", 66, 164, 1),
    ("Ho", "Holmium", 67, 165, 1),
    ("Er", "Erbium", 68, 166, 1),
    ("Tm", "Thulium", 69, 169, 1),
    ("Yb", "Ytterbium", 70, 174, 1),
    ("Lu", "Lutetium", 71, 175, 1),
    ("Hf", "Hafnium", 72, 180, 1),
    ("Ta", "Tantalum", 73, 181, 1),
    ("W", "Tungsten", 74, 184, 1),
    ("Re", "Rhenium", 75, 187, 1),
    ("Os", "Osmium", 76, 192, 1),
    ("Ir", "Iridium", 77, 193, 1),
    ("Pt", "Platinum", 78, 195, 1),
    ("Au", "Gold", 79, 197, 1),
    ("Hg", "Mercury", 80, 202, 1),
    ("Tl", "Thallium", 81, 205, 1),
    ("Pb", "Lead", 82, 208, 1),
    ("Bi", "Bismuth", 83, 209, 1),
    ("Th", "Thorium", 90, 232, 1),
    ("Pa", "Protactinium", 91, 231, 1),
    ("U", "Uranium", 92, 238, 1),
)

element_information = {
    ad.symbol: ad for ad in starmap(ElementInformation, _raw_data)
}
