import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerFrontendRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the load balancer frontend to which the rule is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#frontend LoadbalancerFrontendRule#frontend}
    */
    readonly frontend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#id LoadbalancerFrontendRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the frontend rule must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#priority LoadbalancerFrontendRule#priority}
    */
    readonly priority: number;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#actions LoadbalancerFrontendRule#actions}
    */
    readonly actions?: LoadbalancerFrontendRuleActions;
    /**
    * matchers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#matchers LoadbalancerFrontendRule#matchers}
    */
    readonly matchers?: LoadbalancerFrontendRuleMatchers;
}
export interface LoadbalancerFrontendRuleActionsHttpRedirect {
    /**
    * Target location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#location LoadbalancerFrontendRule#location}
    */
    readonly location: string;
}
export declare function loadbalancerFrontendRuleActionsHttpRedirectToTerraform(struct?: LoadbalancerFrontendRuleActionsHttpRedirect | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleActionsHttpRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleActionsHttpRedirect | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActionsHttpRedirect | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleActionsHttpRedirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleActionsHttpRedirectOutputReference;
}
export interface LoadbalancerFrontendRuleActionsHttpReturn {
    /**
    * Content type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#content_type LoadbalancerFrontendRule#content_type}
    */
    readonly contentType: string;
    /**
    * The payload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#payload LoadbalancerFrontendRule#payload}
    */
    readonly payload: string;
    /**
    * HTTP status code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#status LoadbalancerFrontendRule#status}
    */
    readonly status: number;
}
export declare function loadbalancerFrontendRuleActionsHttpReturnToTerraform(struct?: LoadbalancerFrontendRuleActionsHttpReturn | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleActionsHttpReturnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleActionsHttpReturn | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActionsHttpReturn | cdktf.IResolvable | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    get contentTypeInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    get payloadInput(): string | undefined;
    private _status?;
    get status(): number;
    set status(value: number);
    get statusInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleActionsHttpReturnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleActionsHttpReturnOutputReference;
}
export interface LoadbalancerFrontendRuleActionsSetForwardedHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#active LoadbalancerFrontendRule#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleActionsSetForwardedHeadersToTerraform(struct?: LoadbalancerFrontendRuleActionsSetForwardedHeaders | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleActionsSetForwardedHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleActionsSetForwardedHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActionsSetForwardedHeaders | cdktf.IResolvable | undefined);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class LoadbalancerFrontendRuleActionsSetForwardedHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleActionsSetForwardedHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleActionsSetForwardedHeadersOutputReference;
}
export interface LoadbalancerFrontendRuleActionsTcpReject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#active LoadbalancerFrontendRule#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleActionsTcpRejectToTerraform(struct?: LoadbalancerFrontendRuleActionsTcpReject | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleActionsTcpRejectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleActionsTcpReject | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActionsTcpReject | cdktf.IResolvable | undefined);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class LoadbalancerFrontendRuleActionsTcpRejectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleActionsTcpRejectOutputReference;
}
export interface LoadbalancerFrontendRuleActionsUseBackend {
    /**
    * The name of the backend where traffic will be routed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#backend_name LoadbalancerFrontendRule#backend_name}
    */
    readonly backendName: string;
}
export declare function loadbalancerFrontendRuleActionsUseBackendToTerraform(struct?: LoadbalancerFrontendRuleActionsUseBackend | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleActionsUseBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleActionsUseBackend | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActionsUseBackend | cdktf.IResolvable | undefined);
    private _backendName?;
    get backendName(): string;
    set backendName(value: string);
    get backendNameInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleActionsUseBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleActionsUseBackendOutputReference;
}
export interface LoadbalancerFrontendRuleActions {
    /**
    * http_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_redirect LoadbalancerFrontendRule#http_redirect}
    */
    readonly httpRedirect?: LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable;
    /**
    * http_return block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_return LoadbalancerFrontendRule#http_return}
    */
    readonly httpReturn?: LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable;
    /**
    * set_forwarded_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#set_forwarded_headers LoadbalancerFrontendRule#set_forwarded_headers}
    */
    readonly setForwardedHeaders?: LoadbalancerFrontendRuleActionsSetForwardedHeaders[] | cdktf.IResolvable;
    /**
    * tcp_reject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#tcp_reject LoadbalancerFrontendRule#tcp_reject}
    */
    readonly tcpReject?: LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable;
    /**
    * use_backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#use_backend LoadbalancerFrontendRule#use_backend}
    */
    readonly useBackend?: LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleActionsToTerraform(struct?: LoadbalancerFrontendRuleActionsOutputReference | LoadbalancerFrontendRuleActions): any;
export declare class LoadbalancerFrontendRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerFrontendRuleActions | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActions | undefined);
    private _httpRedirect;
    get httpRedirect(): LoadbalancerFrontendRuleActionsHttpRedirectList;
    putHttpRedirect(value: LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable): void;
    resetHttpRedirect(): void;
    get httpRedirectInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsHttpRedirect[] | undefined;
    private _httpReturn;
    get httpReturn(): LoadbalancerFrontendRuleActionsHttpReturnList;
    putHttpReturn(value: LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable): void;
    resetHttpReturn(): void;
    get httpReturnInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsHttpReturn[] | undefined;
    private _setForwardedHeaders;
    get setForwardedHeaders(): LoadbalancerFrontendRuleActionsSetForwardedHeadersList;
    putSetForwardedHeaders(value: LoadbalancerFrontendRuleActionsSetForwardedHeaders[] | cdktf.IResolvable): void;
    resetSetForwardedHeaders(): void;
    get setForwardedHeadersInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsSetForwardedHeaders[] | undefined;
    private _tcpReject;
    get tcpReject(): LoadbalancerFrontendRuleActionsTcpRejectList;
    putTcpReject(value: LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable): void;
    resetTcpReject(): void;
    get tcpRejectInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsTcpReject[] | undefined;
    private _useBackend;
    get useBackend(): LoadbalancerFrontendRuleActionsUseBackendList;
    putUseBackend(value: LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable): void;
    resetUseBackend(): void;
    get useBackendInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsUseBackend[] | undefined;
}
export interface LoadbalancerFrontendRuleMatchersBodySize {
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersBodySizeToTerraform(struct?: LoadbalancerFrontendRuleMatchersBodySize | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersBodySizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersBodySize | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersBodySize | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersBodySizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersBodySizeOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersBodySizeRange {
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_end LoadbalancerFrontendRule#range_end}
    */
    readonly rangeEnd: number;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_start LoadbalancerFrontendRule#range_start}
    */
    readonly rangeStart: number;
}
export declare function loadbalancerFrontendRuleMatchersBodySizeRangeToTerraform(struct?: LoadbalancerFrontendRuleMatchersBodySizeRange | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersBodySizeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersBodySizeRange | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersBodySizeRange | cdktf.IResolvable | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersBodySizeRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersBodySizeRangeOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersCookie {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersCookieToTerraform(struct?: LoadbalancerFrontendRuleMatchersCookie | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersCookieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersCookie | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersCookie | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersCookieList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersCookieOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersHeader {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersHeaderToTerraform(struct?: LoadbalancerFrontendRuleMatchersHeader | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersHeader | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersHeader | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersHeaderOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersHost {
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersHostToTerraform(struct?: LoadbalancerFrontendRuleMatchersHost | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersHostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersHost | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersHost | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersHostList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersHostOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersHttpMethod {
    /**
    * String value (`GET`, `HEAD`, `POST`, `PUT`, `PATCH`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersHttpMethodToTerraform(struct?: LoadbalancerFrontendRuleMatchersHttpMethod | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersHttpMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersHttpMethod | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersHttpMethod | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersHttpMethodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersHttpMethodOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersNumMembersUp {
    /**
    * The name of the `backend` which members will be monitored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#backend_name LoadbalancerFrontendRule#backend_name}
    */
    readonly backendName: string;
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersNumMembersUpToTerraform(struct?: LoadbalancerFrontendRuleMatchersNumMembersUp | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersNumMembersUpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersNumMembersUp | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersNumMembersUp | cdktf.IResolvable | undefined);
    private _backendName?;
    get backendName(): string;
    set backendName(value: string);
    get backendNameInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersNumMembersUpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersNumMembersUpOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersPath {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersPathToTerraform(struct?: LoadbalancerFrontendRuleMatchersPath | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersPath | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersPath | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersPathOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersSrcIp {
    /**
    * IP address. CIDR masks are supported, e.g. `192.168.0.0/24`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersSrcIpToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcIp | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersSrcIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersSrcIp | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersSrcIp | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersSrcIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersSrcIpOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersSrcPort {
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersSrcPortToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcPort | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersSrcPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersSrcPort | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersSrcPort | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersSrcPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersSrcPortOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersSrcPortRange {
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_end LoadbalancerFrontendRule#range_end}
    */
    readonly rangeEnd: number;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_start LoadbalancerFrontendRule#range_start}
    */
    readonly rangeStart: number;
}
export declare function loadbalancerFrontendRuleMatchersSrcPortRangeToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcPortRange | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersSrcPortRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersSrcPortRange | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersSrcPortRange | cdktf.IResolvable | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersSrcPortRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersSrcPortRangeOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersUrl {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrl | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersUrl | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersUrl | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersUrlOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersUrlParam {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlParamToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrlParam | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersUrlParamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersUrlParam | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersUrlParam | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersUrlParamList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersUrlParamOutputReference;
}
export interface LoadbalancerFrontendRuleMatchersUrlQuery {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlQueryToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrlQuery | cdktf.IResolvable): any;
export declare class LoadbalancerFrontendRuleMatchersUrlQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerFrontendRuleMatchersUrlQuery | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchersUrlQuery | cdktf.IResolvable | undefined);
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class LoadbalancerFrontendRuleMatchersUrlQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerFrontendRuleMatchersUrlQueryOutputReference;
}
export interface LoadbalancerFrontendRuleMatchers {
    /**
    * body_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#body_size LoadbalancerFrontendRule#body_size}
    */
    readonly bodySize?: LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable;
    /**
    * body_size_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#body_size_range LoadbalancerFrontendRule#body_size_range}
    */
    readonly bodySizeRange?: LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable;
    /**
    * cookie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#cookie LoadbalancerFrontendRule#cookie}
    */
    readonly cookie?: LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#header LoadbalancerFrontendRule#header}
    */
    readonly header?: LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#host LoadbalancerFrontendRule#host}
    */
    readonly host?: LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable;
    /**
    * http_method block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_method LoadbalancerFrontendRule#http_method}
    */
    readonly httpMethod?: LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable;
    /**
    * num_members_up block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#num_members_up LoadbalancerFrontendRule#num_members_up}
    */
    readonly numMembersUp?: LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable;
    /**
    * path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#path LoadbalancerFrontendRule#path}
    */
    readonly path?: LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable;
    /**
    * src_ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_ip LoadbalancerFrontendRule#src_ip}
    */
    readonly srcIp?: LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable;
    /**
    * src_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_port LoadbalancerFrontendRule#src_port}
    */
    readonly srcPort?: LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable;
    /**
    * src_port_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_port_range LoadbalancerFrontendRule#src_port_range}
    */
    readonly srcPortRange?: LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable;
    /**
    * url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url LoadbalancerFrontendRule#url}
    */
    readonly url?: LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable;
    /**
    * url_param block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url_param LoadbalancerFrontendRule#url_param}
    */
    readonly urlParam?: LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable;
    /**
    * url_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url_query LoadbalancerFrontendRule#url_query}
    */
    readonly urlQuery?: LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleMatchersToTerraform(struct?: LoadbalancerFrontendRuleMatchersOutputReference | LoadbalancerFrontendRuleMatchers): any;
export declare class LoadbalancerFrontendRuleMatchersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerFrontendRuleMatchers | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchers | undefined);
    private _bodySize;
    get bodySize(): LoadbalancerFrontendRuleMatchersBodySizeList;
    putBodySize(value: LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable): void;
    resetBodySize(): void;
    get bodySizeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersBodySize[] | undefined;
    private _bodySizeRange;
    get bodySizeRange(): LoadbalancerFrontendRuleMatchersBodySizeRangeList;
    putBodySizeRange(value: LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable): void;
    resetBodySizeRange(): void;
    get bodySizeRangeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersBodySizeRange[] | undefined;
    private _cookie;
    get cookie(): LoadbalancerFrontendRuleMatchersCookieList;
    putCookie(value: LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable): void;
    resetCookie(): void;
    get cookieInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersCookie[] | undefined;
    private _header;
    get header(): LoadbalancerFrontendRuleMatchersHeaderList;
    putHeader(value: LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHeader[] | undefined;
    private _host;
    get host(): LoadbalancerFrontendRuleMatchersHostList;
    putHost(value: LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable): void;
    resetHost(): void;
    get hostInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHost[] | undefined;
    private _httpMethod;
    get httpMethod(): LoadbalancerFrontendRuleMatchersHttpMethodList;
    putHttpMethod(value: LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable): void;
    resetHttpMethod(): void;
    get httpMethodInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHttpMethod[] | undefined;
    private _numMembersUp;
    get numMembersUp(): LoadbalancerFrontendRuleMatchersNumMembersUpList;
    putNumMembersUp(value: LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable): void;
    resetNumMembersUp(): void;
    get numMembersUpInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersNumMembersUp[] | undefined;
    private _path;
    get path(): LoadbalancerFrontendRuleMatchersPathList;
    putPath(value: LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable): void;
    resetPath(): void;
    get pathInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersPath[] | undefined;
    private _srcIp;
    get srcIp(): LoadbalancerFrontendRuleMatchersSrcIpList;
    putSrcIp(value: LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable): void;
    resetSrcIp(): void;
    get srcIpInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcIp[] | undefined;
    private _srcPort;
    get srcPort(): LoadbalancerFrontendRuleMatchersSrcPortList;
    putSrcPort(value: LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable): void;
    resetSrcPort(): void;
    get srcPortInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcPort[] | undefined;
    private _srcPortRange;
    get srcPortRange(): LoadbalancerFrontendRuleMatchersSrcPortRangeList;
    putSrcPortRange(value: LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable): void;
    resetSrcPortRange(): void;
    get srcPortRangeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcPortRange[] | undefined;
    private _url;
    get url(): LoadbalancerFrontendRuleMatchersUrlList;
    putUrl(value: LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable): void;
    resetUrl(): void;
    get urlInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrl[] | undefined;
    private _urlParam;
    get urlParam(): LoadbalancerFrontendRuleMatchersUrlParamList;
    putUrlParam(value: LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable): void;
    resetUrlParam(): void;
    get urlParamInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrlParam[] | undefined;
    private _urlQuery;
    get urlQuery(): LoadbalancerFrontendRuleMatchersUrlQueryList;
    putUrlQuery(value: LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable): void;
    resetUrlQuery(): void;
    get urlQueryInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrlQuery[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule upcloud_loadbalancer_frontend_rule}
*/
export declare class LoadbalancerFrontendRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_frontend_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule upcloud_loadbalancer_frontend_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerFrontendRuleConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerFrontendRuleConfig);
    private _frontend?;
    get frontend(): string;
    set frontend(value: string);
    get frontendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _actions;
    get actions(): LoadbalancerFrontendRuleActionsOutputReference;
    putActions(value: LoadbalancerFrontendRuleActions): void;
    resetActions(): void;
    get actionsInput(): LoadbalancerFrontendRuleActions | undefined;
    private _matchers;
    get matchers(): LoadbalancerFrontendRuleMatchersOutputReference;
    putMatchers(value: LoadbalancerFrontendRuleMatchers): void;
    resetMatchers(): void;
    get matchersInput(): LoadbalancerFrontendRuleMatchers | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
