import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of CPU for the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#cpu Server#cpu}
    */
    readonly cpu?: number;
    /**
    * Are firewall rules active for the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#firewall Server#firewall}
    */
    readonly firewall?: boolean | cdktf.IResolvable;
    /**
    * Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#host Server#host}
    */
    readonly host?: number;
    /**
    * A valid domain name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#hostname Server#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#id Server#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The size of memory for the server (in megabytes)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#mem Server#mem}
    */
    readonly mem?: number;
    /**
    * Is the metadata service active for the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#metadata Server#metadata}
    */
    readonly metadata?: boolean | cdktf.IResolvable;
    /**
    * The pricing plan used for the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#plan Server#plan}
    */
    readonly plan?: string;
    /**
    * The server related tags
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#tags Server#tags}
    */
    readonly tags?: string[];
    /**
    * A short, informational description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#title Server#title}
    */
    readonly title?: string;
    /**
    * Defines URL for a server setup script, or the script body itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#user_data Server#user_data}
    */
    readonly userData?: string;
    /**
    * The zone in which the server will be hosted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#zone Server#zone}
    */
    readonly zone: string;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#login Server#login}
    */
    readonly login?: ServerLogin;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#network_interface Server#network_interface}
    */
    readonly networkInterface: ServerNetworkInterface[] | cdktf.IResolvable;
    /**
    * simple_backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#simple_backup Server#simple_backup}
    */
    readonly simpleBackup?: ServerSimpleBackup;
    /**
    * storage_devices block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#storage_devices Server#storage_devices}
    */
    readonly storageDevices?: ServerStorageDevices[] | cdktf.IResolvable;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#template Server#template}
    */
    readonly template?: ServerTemplate;
}
export interface ServerLogin {
    /**
    * Indicates a password should be create to allow access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#create_password Server#create_password}
    */
    readonly createPassword?: boolean | cdktf.IResolvable;
    /**
    * A list of ssh keys to access the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#keys Server#keys}
    */
    readonly keys?: string[];
    /**
    * The delivery method for the server’s root password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#password_delivery Server#password_delivery}
    */
    readonly passwordDelivery?: string;
    /**
    * Username to be create to access the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#user Server#user}
    */
    readonly user?: string;
}
export declare function serverLoginToTerraform(struct?: ServerLoginOutputReference | ServerLogin): any;
export declare class ServerLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerLogin | undefined;
    set internalValue(value: ServerLogin | undefined);
    private _createPassword?;
    get createPassword(): boolean | cdktf.IResolvable;
    set createPassword(value: boolean | cdktf.IResolvable);
    resetCreatePassword(): void;
    get createPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _keys?;
    get keys(): string[];
    set keys(value: string[]);
    resetKeys(): void;
    get keysInput(): string[] | undefined;
    private _passwordDelivery?;
    get passwordDelivery(): string;
    set passwordDelivery(value: string);
    resetPasswordDelivery(): void;
    get passwordDeliveryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface ServerNetworkInterface {
    /**
    * `true` if this interface should be used for network booting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#bootable Server#bootable}
    */
    readonly bootable?: boolean | cdktf.IResolvable;
    /**
    * The assigned IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#ip_address Server#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The IP address type of this interface (one of `IPv4` or `IPv6`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#ip_address_family Server#ip_address_family}
    */
    readonly ipAddressFamily?: string;
    /**
    * The unique ID of a network to attach this network to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#network Server#network}
    */
    readonly network?: string;
    /**
    * `true` if source IP should be filtered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#source_ip_filtering Server#source_ip_filtering}
    */
    readonly sourceIpFiltering?: boolean | cdktf.IResolvable;
    /**
    * Network interface type. For private network interfaces, a network must be specified with an existing network id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#type Server#type}
    */
    readonly type: string;
}
export declare function serverNetworkInterfaceToTerraform(struct?: ServerNetworkInterface | cdktf.IResolvable): any;
export declare class ServerNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServerNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: ServerNetworkInterface | cdktf.IResolvable | undefined);
    private _bootable?;
    get bootable(): boolean | cdktf.IResolvable;
    set bootable(value: boolean | cdktf.IResolvable);
    resetBootable(): void;
    get bootableInput(): boolean | cdktf.IResolvable | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipAddressFamily?;
    get ipAddressFamily(): string;
    set ipAddressFamily(value: string);
    resetIpAddressFamily(): void;
    get ipAddressFamilyInput(): string | undefined;
    get ipAddressFloating(): cdktf.IResolvable;
    get macAddress(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _sourceIpFiltering?;
    get sourceIpFiltering(): boolean | cdktf.IResolvable;
    set sourceIpFiltering(value: boolean | cdktf.IResolvable);
    resetSourceIpFiltering(): void;
    get sourceIpFilteringInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ServerNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServerNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServerNetworkInterfaceOutputReference;
}
export interface ServerSimpleBackup {
    /**
    * Simple backup plan. Accepted values: dailies, weeklies, monthlies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#plan Server#plan}
    */
    readonly plan: string;
    /**
    * Time of the day at which backup will be taken. Should be provided in a hhmm format (e.g. 2230).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#time Server#time}
    */
    readonly time: string;
}
export declare function serverSimpleBackupToTerraform(struct?: ServerSimpleBackupOutputReference | ServerSimpleBackup): any;
export declare class ServerSimpleBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerSimpleBackup | undefined;
    set internalValue(value: ServerSimpleBackup | undefined);
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface ServerStorageDevices {
    /**
    * The device address the storage will be attached to. Specify only the bus name (ide/scsi/virtio) to auto-select next available address from that bus.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#address Server#address}
    */
    readonly address?: string;
    /**
    * A valid storage UUID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#storage Server#storage}
    */
    readonly storage: string;
    /**
    * The device type the storage will be attached as
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#type Server#type}
    */
    readonly type?: string;
}
export declare function serverStorageDevicesToTerraform(struct?: ServerStorageDevices | cdktf.IResolvable): any;
export declare class ServerStorageDevicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServerStorageDevices | cdktf.IResolvable | undefined;
    set internalValue(value: ServerStorageDevices | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    get storageInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ServerStorageDevicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServerStorageDevices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServerStorageDevicesOutputReference;
}
export interface ServerTemplateBackupRule {
    /**
    * The weekday when the backup is created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#interval Server#interval}
    */
    readonly interval: string;
    /**
    * The number of days before a backup is automatically deleted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#retention Server#retention}
    */
    readonly retention: number;
    /**
    * The time of day when the backup is created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#time Server#time}
    */
    readonly time: string;
}
export declare function serverTemplateBackupRuleToTerraform(struct?: ServerTemplateBackupRuleOutputReference | ServerTemplateBackupRule): any;
export declare class ServerTemplateBackupRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerTemplateBackupRule | undefined;
    set internalValue(value: ServerTemplateBackupRule | undefined);
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _retention?;
    get retention(): number;
    set retention(value: number);
    get retentionInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface ServerTemplate {
    /**
    * The device address the storage will be attached to. Specify only the bus name (ide/scsi/virtio) to auto-select next available address from that bus.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#address Server#address}
    */
    readonly address?: string;
    /**
    * If set to true, the backup taken before the partition and filesystem resize attempt will be deleted immediately after success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#delete_autoresize_backup Server#delete_autoresize_backup}
    */
    readonly deleteAutoresizeBackup?: boolean | cdktf.IResolvable;
    /**
    * If set to true, provider will attempt to resize partition and filesystem when the size of template storage changes.
                              Please note that before the resize attempt is made, backup of the storage will be taken. If the resize attempt fails, the backup will be used
                              to restore the storage and then deleted. If the resize attempt succeeds, backup will be kept (unless delete_autoresize_backup option is set to true).
                              Taking and keeping backups incure costs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#filesystem_autoresize Server#filesystem_autoresize}
    */
    readonly filesystemAutoresize?: boolean | cdktf.IResolvable;
    /**
    * The size of the storage in gigabytes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#size Server#size}
    */
    readonly size?: number;
    /**
    * A valid storage UUID or template name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#storage Server#storage}
    */
    readonly storage: string;
    /**
    * A short, informative description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#title Server#title}
    */
    readonly title?: string;
    /**
    * backup_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/server#backup_rule Server#backup_rule}
    */
    readonly backupRule?: ServerTemplateBackupRule;
}
export declare function serverTemplateToTerraform(struct?: ServerTemplateOutputReference | ServerTemplate): any;
export declare class ServerTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerTemplate | undefined;
    set internalValue(value: ServerTemplate | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _deleteAutoresizeBackup?;
    get deleteAutoresizeBackup(): boolean | cdktf.IResolvable;
    set deleteAutoresizeBackup(value: boolean | cdktf.IResolvable);
    resetDeleteAutoresizeBackup(): void;
    get deleteAutoresizeBackupInput(): boolean | cdktf.IResolvable | undefined;
    private _filesystemAutoresize?;
    get filesystemAutoresize(): boolean | cdktf.IResolvable;
    set filesystemAutoresize(value: boolean | cdktf.IResolvable);
    resetFilesystemAutoresize(): void;
    get filesystemAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    get storageInput(): string | undefined;
    get tier(): string;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _backupRule;
    get backupRule(): ServerTemplateBackupRuleOutputReference;
    putBackupRule(value: ServerTemplateBackupRule): void;
    resetBackupRule(): void;
    get backupRuleInput(): ServerTemplateBackupRule | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/server upcloud_server}
*/
export declare class Server extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/server upcloud_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerConfig
    */
    constructor(scope: Construct, id: string, config: ServerConfig);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _firewall?;
    get firewall(): boolean | cdktf.IResolvable;
    set firewall(value: boolean | cdktf.IResolvable);
    resetFirewall(): void;
    get firewallInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    get host(): number;
    set host(value: number);
    resetHost(): void;
    get hostInput(): number | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mem?;
    get mem(): number;
    set mem(value: number);
    resetMem(): void;
    get memInput(): number | undefined;
    private _metadata?;
    get metadata(): boolean | cdktf.IResolvable;
    set metadata(value: boolean | cdktf.IResolvable);
    resetMetadata(): void;
    get metadataInput(): boolean | cdktf.IResolvable | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    resetPlan(): void;
    get planInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _login;
    get login(): ServerLoginOutputReference;
    putLogin(value: ServerLogin): void;
    resetLogin(): void;
    get loginInput(): ServerLogin | undefined;
    private _networkInterface;
    get networkInterface(): ServerNetworkInterfaceList;
    putNetworkInterface(value: ServerNetworkInterface[] | cdktf.IResolvable): void;
    get networkInterfaceInput(): cdktf.IResolvable | ServerNetworkInterface[] | undefined;
    private _simpleBackup;
    get simpleBackup(): ServerSimpleBackupOutputReference;
    putSimpleBackup(value: ServerSimpleBackup): void;
    resetSimpleBackup(): void;
    get simpleBackupInput(): ServerSimpleBackup | undefined;
    private _storageDevices;
    get storageDevices(): ServerStorageDevicesList;
    putStorageDevices(value: ServerStorageDevices[] | cdktf.IResolvable): void;
    resetStorageDevices(): void;
    get storageDevicesInput(): cdktf.IResolvable | ServerStorageDevices[] | undefined;
    private _template;
    get template(): ServerTemplateOutputReference;
    putTemplate(value: ServerTemplate): void;
    resetTemplate(): void;
    get templateInput(): ServerTemplate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
