# mypy: ignore-errors

# generated by datamodel-codegen:
#   filename:  https://schemas.getdbt.com/dbt/manifest/v10.json

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union

from pydantic import AwareDatetime, BaseModel, ConfigDict, Field, constr
from typing_extensions import Literal


class ManifestMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = (
        'https://schemas.getdbt.com/dbt/manifest/v10.json'
    )
    dbt_version: Optional[str] = '1.6.5'
    generated_at: Optional[AwareDatetime] = '2023-10-05T00:33:14.410024Z'
    invocation_id: Optional[str] = '603e2fae-9c7d-4d17-8530-7d28c9875263'
    env: Optional[Dict[str, str]] = {}
    project_name: Optional[str] = Field(None, description='Name of the root project')
    project_id: Optional[str] = Field(
        None,
        description='A unique identifier for the project, hashed from the project name',
    )
    user_id: Optional[
        constr(pattern=r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}')
    ] = Field(None, description='A unique identifier for the user')
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class FileHash(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class Hook(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class Docs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class ContractConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False


class ColumnLevelConstraint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Literal['check', 'not_null', 'unique', 'primary_key', 'foreign_key', 'custom']
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True


class RefArgs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    package: Optional[str] = None
    version: Optional[Union[str, float]] = None


class DependsOn(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []
    nodes: Optional[List[str]] = []


class InjectedCTE(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class Contract(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    checksum: Optional[str] = None


class TestConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class ModelLevelConstraint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Literal['check', 'not_null', 'unique', 'primary_key', 'foreign_key', 'custom']
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    columns: Optional[List[str]] = []


class DeferRelation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None


class TestMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    kwargs: Optional[Dict[str, Any]] = {}
    namespace: Optional[str] = None


class SnapshotConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[str] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None


class SeedConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )
    quote_columns: Optional[bool] = None


class MacroDependsOn(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = []


class Quoting(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class Time(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Literal['minute', 'hour', 'day']] = None


class ExternalPartition(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}


class SourceConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True


class MacroArgument(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class Documentation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['doc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    block_contents: str


class Owner(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    email: Optional[str] = None
    name: Optional[str] = None


class ExposureConfig(SourceConfig):
    pass


class WhereFilter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_sql_template: str


class MetricTimeWindow(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Literal['day', 'week', 'month', 'quarter', 'year']


class FileSlice(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str
    content: str
    start_line_number: int
    end_line_number: int


class MetricConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    group: Optional[str] = None


class Group(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['group']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    owner: Owner


class NodeRelation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    alias: str
    schema_name: str
    database: Optional[str] = None
    relation_name: Optional[str] = None


class Defaults(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    agg_time_dimension: Optional[str] = None


class Entity(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Literal['foreign', 'natural', 'primary', 'unique']
    description: Optional[str] = None
    label: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class MeasureAggregationParameters(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    percentile: Optional[float] = None
    use_discrete_percentile: Optional[bool] = False
    use_approximate_percentile: Optional[bool] = False


class NonAdditiveDimension(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: Literal[
        'sum',
        'min',
        'max',
        'count_distinct',
        'sum_boolean',
        'average',
        'percentile',
        'median',
        'count',
    ]
    window_groupings: List[str]


class DimensionValidityParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    is_start: Optional[bool] = False
    is_end: Optional[bool] = False


class SemanticModelConfig(SourceConfig):
    pass


class NodeConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = 'apply'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    contract: Optional[ContractConfig] = Field(
        default_factory=lambda: ContractConfig.model_validate({'enforced': False})
    )


class ColumnInfo(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    data_type: Optional[str] = None
    constraints: Optional[List[ColumnLevelConstraint]] = []
    quote: Optional[bool] = None
    tags: Optional[List[str]] = []


class SingularTestNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.413604
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class HookNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.414359
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    index: Optional[int] = None


class ModelNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.4150689
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    access: Optional[Literal['private', 'protected', 'public']] = 'protected'
    constraints: Optional[List[ModelLevelConstraint]] = []
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[AwareDatetime] = None
    defer_relation: Optional[DeferRelation] = None


class RPCNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['rpc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.416128
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class SqlNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.41679
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class GenericTestNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    test_metadata: TestMetadata
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = Field(
        default_factory=lambda: TestConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': 'dbt_test__audit',
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'test',
                'severity': 'ERROR',
                'store_failures': None,
                'where': None,
                'limit': None,
                'fail_calc': 'count(*)',
                'warn_if': '!= 0',
                'error_if': '!= 0',
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.4175282
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None


class SnapshotNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.418854
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )
    defer_relation: Optional[DeferRelation] = None


class SeedNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = Field(
        default_factory=lambda: SeedConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'seed',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'quote_columns': None,
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.420199
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[MacroDependsOn] = Field(
        default_factory=lambda: MacroDependsOn.model_validate({'macros': []})
    )
    defer_relation: Optional[DeferRelation] = None


class FreshnessThreshold(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[Time] = {'count': None, 'period': None}
    error_after: Optional[Time] = {'count': None, 'period': None}
    filter: Optional[str] = None


class ExternalTable(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[ExternalPartition]]] = None


class Macro(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['macro']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    macro_sql: str
    depends_on: Optional[MacroDependsOn] = Field(
        default_factory=lambda: MacroDependsOn.model_validate({'macros': []})
    )
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    arguments: Optional[List[MacroArgument]] = []
    created_at: Optional[float] = 1696465994.421958
    supported_languages: Optional[List[Literal['python', 'sql']]] = None


class Exposure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['exposure']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Literal['dashboard', 'notebook', 'analysis', 'ml', 'application']
    owner: Owner
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Literal['low', 'medium', 'high']] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[ExposureConfig] = Field(
        default_factory=lambda: ExposureConfig.model_validate({'enabled': True})
    )
    unrendered_config: Optional[Dict[str, Any]] = {}
    url: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1696465994.422623


class MetricInputMeasure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilter] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class MetricInput(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilter] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class SourceFileMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice


class Measure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Literal[
        'sum',
        'min',
        'max',
        'count_distinct',
        'sum_boolean',
        'average',
        'percentile',
        'median',
        'count',
    ]
    description: Optional[str] = None
    label: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[MeasureAggregationParameters] = None
    non_additive_dimension: Optional[NonAdditiveDimension] = None
    agg_time_dimension: Optional[str] = None


class DimensionTypeParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: Literal['day', 'week', 'month', 'quarter', 'year']
    validity_params: Optional[DimensionValidityParams] = None


class AnalysisNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = Field(
        default_factory=lambda: NodeConfig.model_validate(
            {
                'enabled': True,
                'alias': None,
                'schema': None,
                'database': None,
                'tags': [],
                'meta': {},
                'group': None,
                'materialized': 'view',
                'incremental_strategy': None,
                'persist_docs': {},
                'quoting': {},
                'column_types': {},
                'full_refresh': None,
                'unique_key': None,
                'on_schema_change': 'ignore',
                'on_configuration_change': 'apply',
                'grants': {},
                'packages': [],
                'docs': {'show': True, 'node_color': None},
                'contract': {'enforced': False},
                'post-hook': [],
                'pre-hook': [],
            }
        )
    )
    tags: Optional[List[str]] = []
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    group: Optional[str] = None
    docs: Optional[Docs] = Field(
        default_factory=lambda: Docs.model_validate({'show': True, 'node_color': None})
    )
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1696465994.411958
    config_call_dict: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    contract: Optional[Contract] = Field(
        default_factory=lambda: Contract.model_validate(
            {'enforced': False, 'checksum': None}
        )
    )


class SourceDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    quoting: Optional[Quoting] = Field(
        default_factory=lambda: Quoting.model_validate(
            {'database': None, 'schema': None, 'identifier': None, 'column': None}
        )
    )
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold] = None
    external: Optional[ExternalTable] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    source_meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[SourceConfig] = Field(
        default_factory=lambda: SourceConfig.model_validate({'enabled': True})
    )
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = {}
    relation_name: Optional[str] = None
    created_at: Optional[float] = 1696465994.421661


class MetricTypeParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[MetricInputMeasure] = None
    input_measures: Optional[List[MetricInputMeasure]] = []
    numerator: Optional[MetricInput] = None
    denominator: Optional[MetricInput] = None
    expr: Optional[str] = None
    window: Optional[MetricTimeWindow] = None
    grain_to_date: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None
    metrics: Optional[List[MetricInput]] = None


class Dimension(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Literal['categorical', 'time']
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[DimensionTypeParams] = None
    expr: Optional[str] = None
    metadata: Optional[SourceFileMetadata] = None


class Metric(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Literal['simple', 'ratio', 'cumulative', 'derived']
    type_params: MetricTypeParams
    filter: Optional[WhereFilter] = None
    metadata: Optional[SourceFileMetadata] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[MetricConfig] = Field(
        default_factory=lambda: MetricConfig.model_validate(
            {'enabled': True, 'group': None}
        )
    )
    unrendered_config: Optional[Dict[str, Any]] = {}
    sources: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1696465994.4238322
    group: Optional[str] = None


class SemanticModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal[
        'model',
        'analysis',
        'test',
        'snapshot',
        'operation',
        'seed',
        'rpc',
        'sql_operation',
        'doc',
        'source',
        'macro',
        'exposure',
        'metric',
        'group',
        'semantic_model',
    ]
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = []
    measures: Optional[List[Measure]] = []
    dimensions: Optional[List[Dimension]] = []
    metadata: Optional[SourceFileMetadata] = None
    depends_on: Optional[DependsOn] = Field(
        default_factory=lambda: DependsOn.model_validate({'macros': [], 'nodes': []})
    )
    refs: Optional[List[RefArgs]] = []
    created_at: Optional[float] = 1696465994.425479
    config: Optional[SemanticModelConfig] = Field(
        default_factory=lambda: SemanticModelConfig.model_validate({'enabled': True})
    )
    primary_entity: Optional[str] = None


class DbtManifest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            AnalysisNode,
            SingularTestNode,
            HookNode,
            ModelNode,
            RPCNode,
            SqlNode,
            GenericTestNode,
            SnapshotNode,
            SeedNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, SourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, Macro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, Documentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, Exposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, Metric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    groups: Dict[str, Group] = Field(
        ..., description='The groups defined in the dbt project'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Dict[
            str,
            List[
                Union[
                    AnalysisNode,
                    SingularTestNode,
                    HookNode,
                    ModelNode,
                    RPCNode,
                    SqlNode,
                    GenericTestNode,
                    SnapshotNode,
                    SeedNode,
                    SourceDefinition,
                    Exposure,
                    Metric,
                    SemanticModel,
                ]
            ],
        ]
    ] = Field(None, description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from parent nodes to their dependents'
    )
    group_map: Optional[Dict[str, List[str]]] = Field(
        None, description='A mapping from group names to their nodes'
    )
    semantic_models: Dict[str, SemanticModel] = Field(
        ..., description='The semantic models defined in the dbt project'
    )
