# mypy: ignore-errors

# generated by datamodel-codegen:
#   filename:  https://schemas.getdbt.com/dbt/manifest/v11.json

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field, constr
from typing_extensions import Literal


class ManifestMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbt_schema_version: Optional[str] = None
    dbt_version: Optional[str] = '1.7.7'
    generated_at: Optional[str] = None
    invocation_id: Optional[str] = None
    env: Optional[Dict[str, str]] = None
    project_name: Optional[str] = Field(None, description='Name of the root project')
    project_id: Optional[str] = Field(
        None,
        description='A unique identifier for the project, hashed from the project name',
    )
    user_id: Optional[UUID] = Field(
        None, description='A unique identifier for the user'
    )
    send_anonymous_usage_stats: Optional[bool] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[str] = Field(
        None, description='The type name of the adapter'
    )


class FileHash(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    checksum: str


class Hook(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    sql: str
    transaction: Optional[bool] = True
    index: Optional[int] = None


class Docs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    show: Optional[bool] = True
    node_color: Optional[str] = None


class ContractConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True


class NodeConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[ContractConfig] = Field(None, title='ContractConfig')


class ColumnLevelConstraint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Literal['check', 'not_null', 'unique', 'primary_key', 'foreign_key', 'custom']
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True


class ColumnInfo(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    data_type: Optional[str] = None
    constraints: Optional[List[ColumnLevelConstraint]] = None
    quote: Optional[bool] = None
    tags: Optional[List[str]] = None
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')


class RefArgs(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    package: Optional[str] = None
    version: Optional[Union[str, float]] = None


class DependsOn(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None
    nodes: Optional[List[str]] = None


class InjectedCTE(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    sql: str


class Contract(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enforced: Optional[bool] = False
    alias_types: Optional[bool] = True
    checksum: Optional[str] = None


class AnalysisNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class TestConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field('dbt_test__audit', alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'test'
    severity: Optional[constr(pattern=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')] = (
        'ERROR'
    )
    store_failures: Optional[bool] = None
    store_failures_as: Optional[str] = None
    where: Optional[str] = None
    limit: Optional[int] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class ColumnInfo1(ColumnInfo):
    pass


class SingularTestNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[TestConfig] = Field(None, title='TestConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo1]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class NodeConfig1(NodeConfig):
    pass


class ColumnInfo2(ColumnInfo):
    pass


class HookNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig1] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo2]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    index: Optional[int] = None


class ModelConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[ContractConfig] = Field(None, title='ContractConfig')
    access: Optional[Literal['private', 'protected', 'public']] = 'protected'


class ColumnInfo3(ColumnInfo):
    pass


class ModelLevelConstraint(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Literal['check', 'not_null', 'unique', 'primary_key', 'foreign_key', 'custom']
    name: Optional[str] = None
    expression: Optional[str] = None
    warn_unenforced: Optional[bool] = True
    warn_unsupported: Optional[bool] = True
    columns: Optional[List[str]] = None


class DeferRelation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    alias: str
    relation_name: Optional[str] = None


class ModelNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[ModelConfig] = Field(None, title='ModelConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo3]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    access: Optional[Literal['private', 'protected', 'public']] = 'protected'
    constraints: Optional[List[ModelLevelConstraint]] = None
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[str] = None
    defer_relation: Optional[DeferRelation] = None


class NodeConfig2(NodeConfig):
    pass


class ColumnInfo4(ColumnInfo):
    pass


class RPCNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['rpc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig2] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo4]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class NodeConfig3(NodeConfig):
    pass


class ColumnInfo5(ColumnInfo):
    pass


class SqlNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig3] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo5]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class TestMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    kwargs: Optional[Dict[str, Any]] = None
    namespace: Optional[str] = None


class ColumnInfo6(ColumnInfo):
    pass


class GenericTestNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    test_metadata: TestMetadata = Field(..., title='TestMetadata')
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[TestConfig] = Field(None, title='TestConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo6]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None


class SnapshotConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[str] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[ContractConfig] = Field(None, title='ContractConfig')
    strategy: Optional[str] = None
    target_schema: Optional[str] = None
    target_database: Optional[str] = None
    updated_at: Optional[str] = None
    check_cols: Optional[Union[str, List[str]]] = None


class ColumnInfo7(ColumnInfo):
    pass


class SnapshotNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: SnapshotConfig = Field(..., title='SnapshotConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo7]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    defer_relation: Optional[DeferRelation] = None


class SeedConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    alias: Optional[str] = None
    schema_: Optional[str] = Field(None, alias='schema')
    database: Optional[str] = None
    tags: Optional[Union[List[str], str]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[str] = None
    persist_docs: Optional[Dict[str, Any]] = None
    post_hook: Optional[List[Hook]] = Field(None, alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field(None, alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = None
    column_types: Optional[Dict[str, Any]] = None
    full_refresh: Optional[bool] = None
    unique_key: Optional[Union[str, List[str]]] = None
    on_schema_change: Optional[str] = 'ignore'
    on_configuration_change: Optional[Literal['apply', 'continue', 'fail']] = None
    grants: Optional[Dict[str, Any]] = None
    packages: Optional[List[str]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    contract: Optional[ContractConfig] = Field(None, title='ContractConfig')
    delimiter: Optional[str] = ','
    quote_columns: Optional[bool] = None


class ColumnInfo8(ColumnInfo):
    pass


class MacroDependsOn(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    macros: Optional[List[str]] = None


class SeedNode(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[SeedConfig] = Field(None, title='SeedConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo8]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[MacroDependsOn] = Field(None, title='MacroDependsOn')
    defer_relation: Optional[DeferRelation] = None


class Quoting(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[bool] = None
    schema_: Optional[bool] = Field(None, alias='schema')
    identifier: Optional[bool] = None
    column: Optional[bool] = None


class Time(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: Optional[int] = None
    period: Optional[Literal['minute', 'hour', 'day']] = None


class FreshnessThreshold(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    warn_after: Optional[Time] = None
    error_after: Optional[Time] = None
    filter: Optional[str] = None


class ExternalPartition(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None


class ExternalTable(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    location: Optional[str] = None
    file_format: Optional[str] = None
    row_format: Optional[str] = None
    tbl_properties: Optional[str] = None
    partitions: Optional[Union[List[str], List[ExternalPartition]]] = None


class ColumnInfo9(ColumnInfo):
    pass


class SourceConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True


class SourceDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    quoting: Optional[Quoting] = Field(None, title='Quoting')
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold] = None
    external: Optional[ExternalTable] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo9]] = None
    meta: Optional[Dict[str, Any]] = None
    source_meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[SourceConfig] = Field(None, title='SourceConfig')
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    created_at: Optional[float] = None


class MacroArgument(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Optional[str] = None
    description: Optional[str] = ''


class Macro(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['macro']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    macro_sql: str
    depends_on: Optional[MacroDependsOn] = Field(None, title='MacroDependsOn')
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    arguments: Optional[List[MacroArgument]] = None
    created_at: Optional[float] = None
    supported_languages: Optional[List[Literal['python', 'sql']]] = None


class Documentation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['doc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    block_contents: str


class Owner(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    email: Optional[str] = None
    name: Optional[str] = None


class ExposureConfig(SourceConfig):
    pass


class Exposure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['exposure']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    type: Literal['dashboard', 'notebook', 'analysis', 'ml', 'application']
    owner: Owner = Field(..., title='Owner')
    description: Optional[str] = ''
    label: Optional[str] = None
    maturity: Optional[Literal['low', 'medium', 'high']] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[ExposureConfig] = Field(None, title='ExposureConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    url: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None


class WhereFilter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_sql_template: str


class WhereFilterIntersection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    where_filters: List[WhereFilter]


class MetricInputMeasure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection1(WhereFilterIntersection):
    pass


class MetricInputMeasure1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection1] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection2(WhereFilterIntersection):
    pass


class MetricTimeWindow(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    count: int
    granularity: Literal['day', 'week', 'month', 'quarter', 'year']


class MetricInput(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection2] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection3(WhereFilterIntersection):
    pass


class MetricInput1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection3] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection4(WhereFilterIntersection):
    pass


class MetricInput2(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection4] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection5(WhereFilterIntersection):
    pass


class MetricInputMeasure2(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection5] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection6(WhereFilterIntersection):
    pass


class MetricInputMeasure3(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection6] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class ConstantPropertyInput(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_property: str
    conversion_property: str


class ConversionTypeParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_measure: MetricInputMeasure2 = Field(..., title='MetricInputMeasure')
    conversion_measure: MetricInputMeasure3 = Field(..., title='MetricInputMeasure')
    entity: str
    calculation: Optional[Literal['conversions', 'conversion_rate']] = 'conversion_rate'
    window: Optional[MetricTimeWindow] = None
    constant_properties: Optional[List[ConstantPropertyInput]] = None


class MetricTypeParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[MetricInputMeasure] = None
    input_measures: Optional[List[MetricInputMeasure1]] = None
    numerator: Optional[MetricInput] = None
    denominator: Optional[MetricInput1] = None
    expr: Optional[str] = None
    window: Optional[MetricTimeWindow] = None
    grain_to_date: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None
    metrics: Optional[List[MetricInput2]] = None
    conversion_type_params: Optional[ConversionTypeParams] = None


class WhereFilterIntersection7(WhereFilterIntersection):
    pass


class FileSlice(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str
    content: str
    start_line_number: int
    end_line_number: int


class SourceFileMetadata(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    repo_file_path: str
    file_slice: FileSlice = Field(..., title='FileSlice')


class MetricConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None


class Metric(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Literal['simple', 'ratio', 'cumulative', 'derived', 'conversion']
    type_params: MetricTypeParams = Field(..., title='MetricTypeParams')
    filter: Optional[WhereFilterIntersection7] = None
    metadata: Optional[SourceFileMetadata] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[MetricConfig] = Field(None, title='MetricConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    sources: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    refs: Optional[List[RefArgs]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None
    group: Optional[str] = None


class Group(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['group']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    owner: Owner = Field(..., title='Owner')


class NodeConfig4(NodeConfig):
    pass


class ColumnInfo10(ColumnInfo):
    pass


class AnalysisNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['analysis']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig4] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo10]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class ColumnInfo11(ColumnInfo):
    pass


class SingularTestNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[TestConfig] = Field(None, title='TestConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo11]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class NodeConfig5(NodeConfig):
    pass


class ColumnInfo12(ColumnInfo):
    pass


class HookNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig5] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo12]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    index: Optional[int] = None


class ModelConfig1(ModelConfig):
    pass


class ColumnInfo13(ColumnInfo):
    pass


class ModelNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['model']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[ModelConfig1] = Field(None, title='ModelConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo13]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    access: Optional[Literal['private', 'protected', 'public']] = 'protected'
    constraints: Optional[List[ModelLevelConstraint]] = None
    version: Optional[Union[str, float]] = None
    latest_version: Optional[Union[str, float]] = None
    deprecation_date: Optional[str] = None
    defer_relation: Optional[DeferRelation] = None


class NodeConfig6(NodeConfig):
    pass


class ColumnInfo14(ColumnInfo):
    pass


class RPCNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['rpc']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig6] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo14]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class NodeConfig7(NodeConfig):
    pass


class ColumnInfo15(ColumnInfo):
    pass


class SqlNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['sql_operation']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[NodeConfig7] = Field(None, title='NodeConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo15]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')


class ColumnInfo16(ColumnInfo):
    pass


class GenericTestNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    test_metadata: TestMetadata = Field(..., title='TestMetadata')
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['test']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[TestConfig] = Field(None, title='TestConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo16]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    column_name: Optional[str] = None
    file_key_name: Optional[str] = None
    attached_node: Optional[str] = None


class SnapshotConfig1(SnapshotConfig):
    pass


class ColumnInfo17(ColumnInfo):
    pass


class SnapshotNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['snapshot']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: SnapshotConfig1 = Field(..., title='SnapshotConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo17]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    language: Optional[str] = 'sql'
    refs: Optional[List[RefArgs]] = None
    sources: Optional[List[List[str]]] = None
    metrics: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    compiled_path: Optional[str] = None
    compiled: Optional[bool] = False
    compiled_code: Optional[str] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = None
    field_pre_injected_sql: Optional[str] = Field(None, alias='_pre_injected_sql')
    contract: Optional[Contract] = Field(None, title='Contract')
    defer_relation: Optional[DeferRelation] = None


class SeedConfig1(SeedConfig):
    pass


class ColumnInfo18(ColumnInfo):
    pass


class SeedNode1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['seed']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    alias: str
    checksum: FileHash = Field(..., title='FileHash')
    config: Optional[SeedConfig1] = Field(None, title='SeedConfig')
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    tags: Optional[List[str]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo18]] = None
    meta: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    docs: Optional[Docs] = Field(None, title='Docs')
    patch_path: Optional[str] = None
    build_path: Optional[str] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = None
    created_at: Optional[float] = None
    config_call_dict: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    raw_code: Optional[str] = ''
    root_path: Optional[str] = None
    depends_on: Optional[MacroDependsOn] = Field(None, title='MacroDependsOn')
    defer_relation: Optional[DeferRelation] = None


class FreshnessThreshold1(FreshnessThreshold):
    pass


class ExternalTable1(ExternalTable):
    pass


class ColumnInfo19(ColumnInfo):
    pass


class SourceDefinition1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Optional[str] = None
    schema_: str = Field(..., alias='schema')
    name: str
    resource_type: Literal['source']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    source_name: str
    source_description: str
    loader: str
    identifier: str
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    quoting: Optional[Quoting] = Field(None, title='Quoting')
    loaded_at_field: Optional[str] = None
    freshness: Optional[FreshnessThreshold1] = None
    external: Optional[ExternalTable1] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo19]] = None
    meta: Optional[Dict[str, Any]] = None
    source_meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[SourceConfig] = Field(None, title='SourceConfig')
    patch_path: Optional[str] = None
    unrendered_config: Optional[Dict[str, Any]] = None
    relation_name: Optional[str] = None
    created_at: Optional[float] = None


class Exposure1(Exposure):
    pass


class WhereFilterIntersection8(WhereFilterIntersection):
    pass


class MetricInputMeasure4(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection8] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection9(WhereFilterIntersection):
    pass


class MetricInputMeasure5(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection9] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection10(WhereFilterIntersection):
    pass


class MetricInput3(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection10] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection11(WhereFilterIntersection):
    pass


class MetricInput4(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection11] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection12(WhereFilterIntersection):
    pass


class MetricInput5(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection12] = None
    alias: Optional[str] = None
    offset_window: Optional[MetricTimeWindow] = None
    offset_to_grain: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None


class WhereFilterIntersection13(WhereFilterIntersection):
    pass


class MetricInputMeasure6(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection13] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class WhereFilterIntersection14(WhereFilterIntersection):
    pass


class MetricInputMeasure7(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    filter: Optional[WhereFilterIntersection14] = None
    alias: Optional[str] = None
    join_to_timespine: Optional[bool] = False
    fill_nulls_with: Optional[int] = None


class ConversionTypeParams1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    base_measure: MetricInputMeasure6 = Field(..., title='MetricInputMeasure')
    conversion_measure: MetricInputMeasure7 = Field(..., title='MetricInputMeasure')
    entity: str
    calculation: Optional[Literal['conversions', 'conversion_rate']] = 'conversion_rate'
    window: Optional[MetricTimeWindow] = None
    constant_properties: Optional[List[ConstantPropertyInput]] = None


class MetricTypeParams1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    measure: Optional[MetricInputMeasure4] = None
    input_measures: Optional[List[MetricInputMeasure5]] = None
    numerator: Optional[MetricInput3] = None
    denominator: Optional[MetricInput4] = None
    expr: Optional[str] = None
    window: Optional[MetricTimeWindow] = None
    grain_to_date: Optional[Literal['day', 'week', 'month', 'quarter', 'year']] = None
    metrics: Optional[List[MetricInput5]] = None
    conversion_type_params: Optional[ConversionTypeParams1] = None


class WhereFilterIntersection15(WhereFilterIntersection):
    pass


class SourceFileMetadata1(SourceFileMetadata):
    pass


class Metric1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal['metric']
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    description: str
    label: str
    type: Literal['simple', 'ratio', 'cumulative', 'derived', 'conversion']
    type_params: MetricTypeParams1 = Field(..., title='MetricTypeParams')
    filter: Optional[WhereFilterIntersection15] = None
    metadata: Optional[SourceFileMetadata1] = None
    meta: Optional[Dict[str, Any]] = None
    tags: Optional[List[str]] = None
    config: Optional[MetricConfig] = Field(None, title='MetricConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    sources: Optional[List[List[str]]] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    refs: Optional[List[RefArgs]] = None
    metrics: Optional[List[List[str]]] = None
    created_at: Optional[float] = None
    group: Optional[str] = None


class WhereFilterIntersection16(WhereFilterIntersection):
    pass


class QueryParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metrics: List[str]
    group_by: List[str]
    where: Optional[WhereFilterIntersection16] = None


class ExportConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    export_as: Literal['table', 'view']
    schema_name: Optional[str] = None
    alias: Optional[str] = None


class Export(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    config: ExportConfig = Field(..., title='ExportConfig')


class SourceFileMetadata2(SourceFileMetadata):
    pass


class SavedQueryConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None
    export_as: Optional[Literal['table', 'view']] = None
    schema_: Optional[str] = Field(None, alias='schema')


class SavedQuery(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal[
        'model',
        'analysis',
        'test',
        'snapshot',
        'operation',
        'seed',
        'rpc',
        'sql_operation',
        'doc',
        'source',
        'macro',
        'exposure',
        'metric',
        'group',
        'saved_query',
        'semantic_model',
    ]
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    query_params: QueryParams = Field(..., title='QueryParams')
    exports: List[Export]
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    description: Optional[str] = None
    label: Optional[str] = None
    metadata: Optional[SourceFileMetadata2] = None
    config: Optional[SavedQueryConfig] = Field(None, title='SavedQueryConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    created_at: Optional[float] = None
    refs: Optional[List[RefArgs]] = None


class NodeRelation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    alias: str
    schema_name: str
    database: Optional[str] = None
    relation_name: Optional[str] = None


class Defaults(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    agg_time_dimension: Optional[str] = None


class Entity(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Literal['foreign', 'natural', 'primary', 'unique']
    description: Optional[str] = None
    label: Optional[str] = None
    role: Optional[str] = None
    expr: Optional[str] = None


class MeasureAggregationParameters(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    percentile: Optional[float] = None
    use_discrete_percentile: Optional[bool] = False
    use_approximate_percentile: Optional[bool] = False


class NonAdditiveDimension(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    window_choice: Literal[
        'sum',
        'min',
        'max',
        'count_distinct',
        'sum_boolean',
        'average',
        'percentile',
        'median',
        'count',
    ]
    window_groupings: List[str]


class Measure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    agg: Literal[
        'sum',
        'min',
        'max',
        'count_distinct',
        'sum_boolean',
        'average',
        'percentile',
        'median',
        'count',
    ]
    description: Optional[str] = None
    label: Optional[str] = None
    create_metric: Optional[bool] = False
    expr: Optional[str] = None
    agg_params: Optional[MeasureAggregationParameters] = None
    non_additive_dimension: Optional[NonAdditiveDimension] = None
    agg_time_dimension: Optional[str] = None


class DimensionValidityParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    is_start: Optional[bool] = False
    is_end: Optional[bool] = False


class DimensionTypeParams(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    time_granularity: Literal['day', 'week', 'month', 'quarter', 'year']
    validity_params: Optional[DimensionValidityParams] = None


class SourceFileMetadata3(SourceFileMetadata):
    pass


class Dimension(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Literal['categorical', 'time']
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[DimensionTypeParams] = None
    expr: Optional[str] = None
    metadata: Optional[SourceFileMetadata3] = None


class SourceFileMetadata4(SourceFileMetadata):
    pass


class SemanticModelConfig(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    field_extra: Optional[Dict[str, Any]] = Field(None, alias='_extra')
    enabled: Optional[bool] = True
    group: Optional[str] = None
    meta: Optional[Dict[str, Any]] = None


class SemanticModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal[
        'model',
        'analysis',
        'test',
        'snapshot',
        'operation',
        'seed',
        'rpc',
        'sql_operation',
        'doc',
        'source',
        'macro',
        'exposure',
        'metric',
        'group',
        'saved_query',
        'semantic_model',
    ]
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = None
    measures: Optional[List[Measure]] = None
    dimensions: Optional[List[Dimension]] = None
    metadata: Optional[SourceFileMetadata4] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    refs: Optional[List[RefArgs]] = None
    created_at: Optional[float] = None
    config: Optional[SemanticModelConfig] = Field(None, title='SemanticModelConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    primary_entity: Optional[str] = None
    group: Optional[str] = None


class WhereFilterIntersection17(WhereFilterIntersection):
    pass


class QueryParams1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metrics: List[str]
    group_by: List[str]
    where: Optional[WhereFilterIntersection17] = None


class Export1(Export):
    pass


class SourceFileMetadata5(SourceFileMetadata):
    pass


class SavedQuery1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal[
        'model',
        'analysis',
        'test',
        'snapshot',
        'operation',
        'seed',
        'rpc',
        'sql_operation',
        'doc',
        'source',
        'macro',
        'exposure',
        'metric',
        'group',
        'saved_query',
        'semantic_model',
    ]
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    query_params: QueryParams1 = Field(..., title='QueryParams')
    exports: List[Export1]
    field_event_status: Optional[Dict[str, Any]] = Field(None, alias='_event_status')
    description: Optional[str] = None
    label: Optional[str] = None
    metadata: Optional[SourceFileMetadata5] = None
    config: Optional[SavedQueryConfig] = Field(None, title='SavedQueryConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    group: Optional[str] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    created_at: Optional[float] = None
    refs: Optional[List[RefArgs]] = None


class Measure1(Measure):
    pass


class DimensionTypeParams1(DimensionTypeParams):
    pass


class SourceFileMetadata6(SourceFileMetadata):
    pass


class Dimension1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    type: Literal['categorical', 'time']
    description: Optional[str] = None
    label: Optional[str] = None
    is_partition: Optional[bool] = False
    type_params: Optional[DimensionTypeParams1] = None
    expr: Optional[str] = None
    metadata: Optional[SourceFileMetadata6] = None


class SourceFileMetadata7(SourceFileMetadata):
    pass


class SemanticModel1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    resource_type: Literal[
        'model',
        'analysis',
        'test',
        'snapshot',
        'operation',
        'seed',
        'rpc',
        'sql_operation',
        'doc',
        'source',
        'macro',
        'exposure',
        'metric',
        'group',
        'saved_query',
        'semantic_model',
    ]
    package_name: str
    path: str
    original_file_path: str
    unique_id: str
    fqn: List[str]
    model: str
    node_relation: Optional[NodeRelation] = None
    description: Optional[str] = None
    label: Optional[str] = None
    defaults: Optional[Defaults] = None
    entities: Optional[List[Entity]] = None
    measures: Optional[List[Measure1]] = None
    dimensions: Optional[List[Dimension1]] = None
    metadata: Optional[SourceFileMetadata7] = None
    depends_on: Optional[DependsOn] = Field(None, title='DependsOn')
    refs: Optional[List[RefArgs]] = None
    created_at: Optional[float] = None
    config: Optional[SemanticModelConfig] = Field(None, title='SemanticModelConfig')
    unrendered_config: Optional[Dict[str, Any]] = None
    primary_entity: Optional[str] = None
    group: Optional[str] = None


class WritableManifest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: ManifestMetadata = Field(
        ..., description='Metadata about the manifest', title='ManifestMetadata'
    )
    nodes: Dict[
        str,
        Union[
            AnalysisNode,
            SingularTestNode,
            HookNode,
            ModelNode,
            RPCNode,
            SqlNode,
            GenericTestNode,
            SnapshotNode,
            SeedNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, SourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, Macro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, Documentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, Exposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, Metric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    groups: Dict[str, Group] = Field(
        ..., description='The groups defined in the dbt project'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Dict[
            str,
            List[
                Union[
                    AnalysisNode1,
                    SingularTestNode1,
                    HookNode1,
                    ModelNode1,
                    RPCNode1,
                    SqlNode1,
                    GenericTestNode1,
                    SnapshotNode1,
                    SeedNode1,
                    SourceDefinition1,
                    Exposure1,
                    Metric1,
                    SavedQuery,
                    SemanticModel,
                ]
            ],
        ]
    ] = Field(..., description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from parent nodes to their dependents'
    )
    group_map: Optional[Dict[str, List[str]]] = Field(
        ..., description='A mapping from group names to their nodes'
    )
    saved_queries: Dict[str, SavedQuery1] = Field(
        ..., description='The saved queries defined in the dbt project'
    )
    semantic_models: Dict[str, SemanticModel1] = Field(
        ..., description='The semantic models defined in the dbt project'
    )
