from typing import Any, List, Type, Generic, TypeVar

from google.protobuf import descriptor_pb2, message

from proto.fields import Field
from proto.marshal import Marshal

MessageType = TypeVar('MessageType', bound='Message')

class MessageMeta(type):
    def __new__(mcls, name, bases, attrs): ...
    @classmethod
    def __prepare__(mcls, name, bases, **kwargs): ...
    @property
    def meta(cls): ...
    def pb(cls, obj: Any | None = ..., *, coerce: bool = ...): ...
    def wrap(cls, pb): ...
    def serialize(cls, instance) -> bytes: ...
    def deserialize(cls, payload: bytes) -> Message: ...
    def to_json(
        cls,
        instance,
        *,
        use_integers_for_enums: bool = ...,
        including_default_value_fields: bool = ...,
        preserving_proto_field_name: bool = ...
    ) -> str: ...
    def from_json(cls: Type[MessageType],
                  payload,
                  *,
                  ignore_unknown_fields: bool = ...) -> MessageType: ...
    def to_dict(
        cls,
        instance,
        *,
        use_integers_for_enums: bool = ...,
        preserving_proto_field_name: bool = ...
    ) -> Message: ...
    def copy_from(cls, instance, other) -> None: ...

class Message(metaclass=MessageMeta):
    def __init__(
        self, mapping: Any | None = ..., *, ignore_unknown_fields: bool = ..., **kwargs
    ) -> None: ...
    def __bool__(self): ...
    def __contains__(self, key): ...
    def __delattr__(self, key) -> None: ...
    def __eq__(self, other): ...
    def __getattr__(self, key): ...
    def __ne__(self, other): ...
    def __setattr__(self, key, value): ...

class _MessageInfo:
    package: Any
    full_name: Any
    options: Any
    fields: Any
    fields_by_number: Any
    marshal: Any
    def __init__(
        self,
        fields: List[Field],
        package: str,
        full_name: str,
        marshal: Marshal,
        options: descriptor_pb2.MessageOptions,
    ) -> None: ...
    @property
    def pb(self) -> Type[message.Message]: ...
