import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application Object ID for an existing service principal that will be used instead of creating dynamic service principals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#application_object_id AzureSecretBackendRole#application_object_id}
    */
    readonly applicationObjectId?: string;
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#backend AzureSecretBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#description AzureSecretBackendRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#id AzureSecretBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#max_ttl AzureSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#namespace AzureSecretBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#role AzureSecretBackendRole#role}
    */
    readonly role: string;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#ttl AzureSecretBackendRole#ttl}
    */
    readonly ttl?: string;
    /**
    * azure_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#azure_groups AzureSecretBackendRole#azure_groups}
    */
    readonly azureGroups?: AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable;
    /**
    * azure_roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#azure_roles AzureSecretBackendRole#azure_roles}
    */
    readonly azureRoles?: AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable;
}
export interface AzureSecretBackendRoleAzureGroups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#group_name AzureSecretBackendRole#group_name}
    */
    readonly groupName: string;
}
export declare function azureSecretBackendRoleAzureGroupsToTerraform(struct?: AzureSecretBackendRoleAzureGroups | cdktf.IResolvable): any;
export declare class AzureSecretBackendRoleAzureGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AzureSecretBackendRoleAzureGroups | cdktf.IResolvable | undefined;
    set internalValue(value: AzureSecretBackendRoleAzureGroups | cdktf.IResolvable | undefined);
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    get groupNameInput(): string | undefined;
    get objectId(): string;
}
export declare class AzureSecretBackendRoleAzureGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AzureSecretBackendRoleAzureGroupsOutputReference;
}
export interface AzureSecretBackendRoleAzureRoles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#role_id AzureSecretBackendRole#role_id}
    */
    readonly roleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#role_name AzureSecretBackendRole#role_name}
    */
    readonly roleName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role#scope AzureSecretBackendRole#scope}
    */
    readonly scope: string;
}
export declare function azureSecretBackendRoleAzureRolesToTerraform(struct?: AzureSecretBackendRoleAzureRoles | cdktf.IResolvable): any;
export declare class AzureSecretBackendRoleAzureRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AzureSecretBackendRoleAzureRoles | cdktf.IResolvable | undefined;
    set internalValue(value: AzureSecretBackendRoleAzureRoles | cdktf.IResolvable | undefined);
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    resetRoleId(): void;
    get roleIdInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    resetRoleName(): void;
    get roleNameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
}
export declare class AzureSecretBackendRoleAzureRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AzureSecretBackendRoleAzureRolesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role vault_azure_secret_backend_role}
*/
export declare class AzureSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_azure_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/azure_secret_backend_role vault_azure_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: AzureSecretBackendRoleConfig);
    private _applicationObjectId?;
    get applicationObjectId(): string;
    set applicationObjectId(value: string);
    resetApplicationObjectId(): void;
    get applicationObjectIdInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _azureGroups;
    get azureGroups(): AzureSecretBackendRoleAzureGroupsList;
    putAzureGroups(value: AzureSecretBackendRoleAzureGroups[] | cdktf.IResolvable): void;
    resetAzureGroups(): void;
    get azureGroupsInput(): cdktf.IResolvable | AzureSecretBackendRoleAzureGroups[] | undefined;
    private _azureRoles;
    get azureRoles(): AzureSecretBackendRoleAzureRolesList;
    putAzureRoles(value: AzureSecretBackendRoleAzureRoles[] | cdktf.IResolvable): void;
    resetAzureRoles(): void;
    get azureRolesInput(): cdktf.IResolvable | AzureSecretBackendRoleAzureRoles[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
