import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMfaOktaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Okta API token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#api_token IdentityMfaOkta#api_token}
    */
    readonly apiToken: string;
    /**
    * The base domain to use for API requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#base_url IdentityMfaOkta#base_url}
    */
    readonly baseUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#id IdentityMfaOkta#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#namespace IdentityMfaOkta#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the organization to be used in the Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#org_name IdentityMfaOkta#org_name}
    */
    readonly orgName: string;
    /**
    * Only match the primary email for the account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#primary_email IdentityMfaOkta#primary_email}
    */
    readonly primaryEmail?: boolean | cdktf.IResolvable;
    /**
    * A template string for mapping Identity names to MFA methods.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta#username_format IdentityMfaOkta#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta vault_identity_mfa_okta}
*/
export declare class IdentityMfaOkta extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_mfa_okta";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_okta vault_identity_mfa_okta} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMfaOktaConfig
    */
    constructor(scope: Construct, id: string, config: IdentityMfaOktaConfig);
    private _apiToken?;
    get apiToken(): string;
    set apiToken(value: string);
    get apiTokenInput(): string | undefined;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get methodId(): string;
    get mountAccessor(): string;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get namespacePath(): string;
    private _orgName?;
    get orgName(): string;
    set orgName(value: string);
    get orgNameInput(): string | undefined;
    private _primaryEmail?;
    get primaryEmail(): boolean | cdktf.IResolvable;
    set primaryEmail(value: boolean | cdktf.IResolvable);
    resetPrimaryEmail(): void;
    get primaryEmailInput(): boolean | cdktf.IResolvable | undefined;
    get type(): string;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
