import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of managed key registry entry names that the mount in question is allowed to access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#allowed_managed_keys KubernetesSecretBackend#allowed_managed_keys}
    */
    readonly allowedManagedKeys?: string[];
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#audit_non_hmac_request_keys KubernetesSecretBackend#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#audit_non_hmac_response_keys KubernetesSecretBackend#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Default lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#default_lease_ttl_seconds KubernetesSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#description KubernetesSecretBackend#description}
    */
    readonly description?: string;
    /**
    * Disable defaulting to the local CA certificate and service account JWT when running in a Kubernetes pod.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#disable_local_ca_jwt KubernetesSecretBackend#disable_local_ca_jwt}
    */
    readonly disableLocalCaJwt?: boolean | cdktf.IResolvable;
    /**
    * Enable the secrets engine to access Vault's external entropy source
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#external_entropy_access KubernetesSecretBackend#external_entropy_access}
    */
    readonly externalEntropyAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#id KubernetesSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A PEM-encoded CA certificate used by the secret engine to verify the Kubernetes API server certificate. Defaults to the local pod’s CA if found, or otherwise the host's root CA set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#kubernetes_ca_cert KubernetesSecretBackend#kubernetes_ca_cert}
    */
    readonly kubernetesCaCert?: string;
    /**
    * The Kubernetes API URL to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#kubernetes_host KubernetesSecretBackend#kubernetes_host}
    */
    readonly kubernetesHost?: string;
    /**
    * Local mount flag that can be explicitly set to true to enforce local mount in HA environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#local KubernetesSecretBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum possible lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#max_lease_ttl_seconds KubernetesSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#namespace KubernetesSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies mount type specific options that are passed to the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#options KubernetesSecretBackend#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Where the secret backend will be mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#path KubernetesSecretBackend#path}
    */
    readonly path: string;
    /**
    * Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#seal_wrap KubernetesSecretBackend#seal_wrap}
    */
    readonly sealWrap?: boolean | cdktf.IResolvable;
    /**
    * The JSON web token of the service account used by the secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if found.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend#service_account_jwt KubernetesSecretBackend#service_account_jwt}
    */
    readonly serviceAccountJwt?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend vault_kubernetes_secret_backend}
*/
export declare class KubernetesSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kubernetes_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend vault_kubernetes_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesSecretBackendConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesSecretBackendConfig);
    get accessor(): string;
    private _allowedManagedKeys?;
    get allowedManagedKeys(): string[];
    set allowedManagedKeys(value: string[]);
    resetAllowedManagedKeys(): void;
    get allowedManagedKeysInput(): string[] | undefined;
    private _auditNonHmacRequestKeys?;
    get auditNonHmacRequestKeys(): string[];
    set auditNonHmacRequestKeys(value: string[]);
    resetAuditNonHmacRequestKeys(): void;
    get auditNonHmacRequestKeysInput(): string[] | undefined;
    private _auditNonHmacResponseKeys?;
    get auditNonHmacResponseKeys(): string[];
    set auditNonHmacResponseKeys(value: string[]);
    resetAuditNonHmacResponseKeys(): void;
    get auditNonHmacResponseKeysInput(): string[] | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableLocalCaJwt?;
    get disableLocalCaJwt(): boolean | cdktf.IResolvable;
    set disableLocalCaJwt(value: boolean | cdktf.IResolvable);
    resetDisableLocalCaJwt(): void;
    get disableLocalCaJwtInput(): boolean | cdktf.IResolvable | undefined;
    private _externalEntropyAccess?;
    get externalEntropyAccess(): boolean | cdktf.IResolvable;
    set externalEntropyAccess(value: boolean | cdktf.IResolvable);
    resetExternalEntropyAccess(): void;
    get externalEntropyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesCaCert?;
    get kubernetesCaCert(): string;
    set kubernetesCaCert(value: string);
    resetKubernetesCaCert(): void;
    get kubernetesCaCertInput(): string | undefined;
    private _kubernetesHost?;
    get kubernetesHost(): string;
    set kubernetesHost(value: string);
    resetKubernetesHost(): void;
    get kubernetesHostInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _sealWrap?;
    get sealWrap(): boolean | cdktf.IResolvable;
    set sealWrap(value: boolean | cdktf.IResolvable);
    resetSealWrap(): void;
    get sealWrapInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccountJwt?;
    get serviceAccountJwt(): string;
    set serviceAccountJwt(value: string);
    resetServiceAccountJwt(): void;
    get serviceAccountJwtInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
