"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VaultProvider = exports.vaultProviderHeadersToTerraform = exports.vaultProviderClientAuthToTerraform = exports.vaultProviderAuthLoginUserpassToTerraform = exports.vaultProviderAuthLoginRadiusToTerraform = exports.vaultProviderAuthLoginOidcToTerraform = exports.vaultProviderAuthLoginOciToTerraform = exports.vaultProviderAuthLoginKerberosToTerraform = exports.vaultProviderAuthLoginJwtToTerraform = exports.vaultProviderAuthLoginGcpToTerraform = exports.vaultProviderAuthLoginCertToTerraform = exports.vaultProviderAuthLoginAzureToTerraform = exports.vaultProviderAuthLoginAwsToTerraform = exports.vaultProviderAuthLoginToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function vaultProviderAuthLoginToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        method: cdktf.stringToTerraform(struct.method),
        namespace: cdktf.stringToTerraform(struct.namespace),
        parameters: cdktf.hashMapper(cdktf.stringToTerraform)(struct.parameters),
        path: cdktf.stringToTerraform(struct.path),
    };
}
exports.vaultProviderAuthLoginToTerraform = vaultProviderAuthLoginToTerraform;
function vaultProviderAuthLoginAwsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        aws_access_key_id: cdktf.stringToTerraform(struct.awsAccessKeyId),
        aws_iam_endpoint: cdktf.stringToTerraform(struct.awsIamEndpoint),
        aws_profile: cdktf.stringToTerraform(struct.awsProfile),
        aws_region: cdktf.stringToTerraform(struct.awsRegion),
        aws_role_arn: cdktf.stringToTerraform(struct.awsRoleArn),
        aws_role_session_name: cdktf.stringToTerraform(struct.awsRoleSessionName),
        aws_secret_access_key: cdktf.stringToTerraform(struct.awsSecretAccessKey),
        aws_session_token: cdktf.stringToTerraform(struct.awsSessionToken),
        aws_shared_credentials_file: cdktf.stringToTerraform(struct.awsSharedCredentialsFile),
        aws_sts_endpoint: cdktf.stringToTerraform(struct.awsStsEndpoint),
        aws_web_identity_token_file: cdktf.stringToTerraform(struct.awsWebIdentityTokenFile),
        header_value: cdktf.stringToTerraform(struct.headerValue),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginAwsToTerraform = vaultProviderAuthLoginAwsToTerraform;
function vaultProviderAuthLoginAzureToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_id: cdktf.stringToTerraform(struct.clientId),
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        resource_group_name: cdktf.stringToTerraform(struct.resourceGroupName),
        role: cdktf.stringToTerraform(struct.role),
        scope: cdktf.stringToTerraform(struct.scope),
        subscription_id: cdktf.stringToTerraform(struct.subscriptionId),
        tenant_id: cdktf.stringToTerraform(struct.tenantId),
        vm_name: cdktf.stringToTerraform(struct.vmName),
        vmss_name: cdktf.stringToTerraform(struct.vmssName),
    };
}
exports.vaultProviderAuthLoginAzureToTerraform = vaultProviderAuthLoginAzureToTerraform;
function vaultProviderAuthLoginCertToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cert_file: cdktf.stringToTerraform(struct.certFile),
        key_file: cdktf.stringToTerraform(struct.keyFile),
        mount: cdktf.stringToTerraform(struct.mount),
        name: cdktf.stringToTerraform(struct.name),
        namespace: cdktf.stringToTerraform(struct.namespace),
    };
}
exports.vaultProviderAuthLoginCertToTerraform = vaultProviderAuthLoginCertToTerraform;
function vaultProviderAuthLoginGcpToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        credentials: cdktf.stringToTerraform(struct.credentials),
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
        service_account: cdktf.stringToTerraform(struct.serviceAccount),
    };
}
exports.vaultProviderAuthLoginGcpToTerraform = vaultProviderAuthLoginGcpToTerraform;
function vaultProviderAuthLoginJwtToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginJwtToTerraform = vaultProviderAuthLoginJwtToTerraform;
function vaultProviderAuthLoginKerberosToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_fast_negotiation: cdktf.booleanToTerraform(struct.disableFastNegotiation),
        keytab_path: cdktf.stringToTerraform(struct.keytabPath),
        krb5conf_path: cdktf.stringToTerraform(struct.krb5ConfPath),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        realm: cdktf.stringToTerraform(struct.realm),
        remove_instance_name: cdktf.booleanToTerraform(struct.removeInstanceName),
        service: cdktf.stringToTerraform(struct.service),
        token: cdktf.stringToTerraform(struct.token),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginKerberosToTerraform = vaultProviderAuthLoginKerberosToTerraform;
function vaultProviderAuthLoginOciToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auth_type: cdktf.stringToTerraform(struct.authType),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginOciToTerraform = vaultProviderAuthLoginOciToTerraform;
function vaultProviderAuthLoginOidcToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        callback_address: cdktf.stringToTerraform(struct.callbackAddress),
        callback_listener_address: cdktf.stringToTerraform(struct.callbackListenerAddress),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginOidcToTerraform = vaultProviderAuthLoginOidcToTerraform;
function vaultProviderAuthLoginRadiusToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        password: cdktf.stringToTerraform(struct.password),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginRadiusToTerraform = vaultProviderAuthLoginRadiusToTerraform;
function vaultProviderAuthLoginUserpassToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        password: cdktf.stringToTerraform(struct.password),
        password_file: cdktf.stringToTerraform(struct.passwordFile),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginUserpassToTerraform = vaultProviderAuthLoginUserpassToTerraform;
function vaultProviderClientAuthToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cert_file: cdktf.stringToTerraform(struct.certFile),
        key_file: cdktf.stringToTerraform(struct.keyFile),
    };
}
exports.vaultProviderClientAuthToTerraform = vaultProviderClientAuthToTerraform;
function vaultProviderHeadersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.vaultProviderHeadersToTerraform = vaultProviderHeadersToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault vault}
*/
class VaultProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VaultProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.9.1',
                providerVersionConstraint: '~> 3.7'
            },
            terraformProviderSource: 'hashicorp/vault'
        });
        this._addAddressToEnv = config.addAddressToEnv;
        this._address = config.address;
        this._caCertDir = config.caCertDir;
        this._caCertFile = config.caCertFile;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._maxRetries = config.maxRetries;
        this._maxRetriesCcc = config.maxRetriesCcc;
        this._namespace = config.namespace;
        this._skipChildToken = config.skipChildToken;
        this._skipTlsVerify = config.skipTlsVerify;
        this._tlsServerName = config.tlsServerName;
        this._token = config.token;
        this._tokenName = config.tokenName;
        this._alias = config.alias;
        this._authLogin = config.authLogin;
        this._authLoginAws = config.authLoginAws;
        this._authLoginAzure = config.authLoginAzure;
        this._authLoginCert = config.authLoginCert;
        this._authLoginGcp = config.authLoginGcp;
        this._authLoginJwt = config.authLoginJwt;
        this._authLoginKerberos = config.authLoginKerberos;
        this._authLoginOci = config.authLoginOci;
        this._authLoginOidc = config.authLoginOidc;
        this._authLoginRadius = config.authLoginRadius;
        this._authLoginUserpass = config.authLoginUserpass;
        this._clientAuth = config.clientAuth;
        this._headers = config.headers;
    }
    get addAddressToEnv() {
        return this._addAddressToEnv;
    }
    set addAddressToEnv(value) {
        this._addAddressToEnv = value;
    }
    resetAddAddressToEnv() {
        this._addAddressToEnv = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addAddressToEnvInput() {
        return this._addAddressToEnv;
    }
    get address() {
        return this._address;
    }
    set address(value) {
        this._address = value;
    }
    // Temporarily expose input value. Use with caution.
    get addressInput() {
        return this._address;
    }
    get caCertDir() {
        return this._caCertDir;
    }
    set caCertDir(value) {
        this._caCertDir = value;
    }
    resetCaCertDir() {
        this._caCertDir = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caCertDirInput() {
        return this._caCertDir;
    }
    get caCertFile() {
        return this._caCertFile;
    }
    set caCertFile(value) {
        this._caCertFile = value;
    }
    resetCaCertFile() {
        this._caCertFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caCertFileInput() {
        return this._caCertFile;
    }
    get maxLeaseTtlSeconds() {
        return this._maxLeaseTtlSeconds;
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    resetMaxRetries() {
        this._maxRetries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesInput() {
        return this._maxRetries;
    }
    get maxRetriesCcc() {
        return this._maxRetriesCcc;
    }
    set maxRetriesCcc(value) {
        this._maxRetriesCcc = value;
    }
    resetMaxRetriesCcc() {
        this._maxRetriesCcc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesCccInput() {
        return this._maxRetriesCcc;
    }
    get namespace() {
        return this._namespace;
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get skipChildToken() {
        return this._skipChildToken;
    }
    set skipChildToken(value) {
        this._skipChildToken = value;
    }
    resetSkipChildToken() {
        this._skipChildToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipChildTokenInput() {
        return this._skipChildToken;
    }
    get skipTlsVerify() {
        return this._skipTlsVerify;
    }
    set skipTlsVerify(value) {
        this._skipTlsVerify = value;
    }
    resetSkipTlsVerify() {
        this._skipTlsVerify = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipTlsVerifyInput() {
        return this._skipTlsVerify;
    }
    get tlsServerName() {
        return this._tlsServerName;
    }
    set tlsServerName(value) {
        this._tlsServerName = value;
    }
    resetTlsServerName() {
        this._tlsServerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsServerNameInput() {
        return this._tlsServerName;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get tokenName() {
        return this._tokenName;
    }
    set tokenName(value) {
        this._tokenName = value;
    }
    resetTokenName() {
        this._tokenName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNameInput() {
        return this._tokenName;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get authLogin() {
        return this._authLogin;
    }
    set authLogin(value) {
        this._authLogin = value;
    }
    resetAuthLogin() {
        this._authLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginInput() {
        return this._authLogin;
    }
    get authLoginAws() {
        return this._authLoginAws;
    }
    set authLoginAws(value) {
        this._authLoginAws = value;
    }
    resetAuthLoginAws() {
        this._authLoginAws = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginAwsInput() {
        return this._authLoginAws;
    }
    get authLoginAzure() {
        return this._authLoginAzure;
    }
    set authLoginAzure(value) {
        this._authLoginAzure = value;
    }
    resetAuthLoginAzure() {
        this._authLoginAzure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginAzureInput() {
        return this._authLoginAzure;
    }
    get authLoginCert() {
        return this._authLoginCert;
    }
    set authLoginCert(value) {
        this._authLoginCert = value;
    }
    resetAuthLoginCert() {
        this._authLoginCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginCertInput() {
        return this._authLoginCert;
    }
    get authLoginGcp() {
        return this._authLoginGcp;
    }
    set authLoginGcp(value) {
        this._authLoginGcp = value;
    }
    resetAuthLoginGcp() {
        this._authLoginGcp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginGcpInput() {
        return this._authLoginGcp;
    }
    get authLoginJwt() {
        return this._authLoginJwt;
    }
    set authLoginJwt(value) {
        this._authLoginJwt = value;
    }
    resetAuthLoginJwt() {
        this._authLoginJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginJwtInput() {
        return this._authLoginJwt;
    }
    get authLoginKerberos() {
        return this._authLoginKerberos;
    }
    set authLoginKerberos(value) {
        this._authLoginKerberos = value;
    }
    resetAuthLoginKerberos() {
        this._authLoginKerberos = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginKerberosInput() {
        return this._authLoginKerberos;
    }
    get authLoginOci() {
        return this._authLoginOci;
    }
    set authLoginOci(value) {
        this._authLoginOci = value;
    }
    resetAuthLoginOci() {
        this._authLoginOci = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginOciInput() {
        return this._authLoginOci;
    }
    get authLoginOidc() {
        return this._authLoginOidc;
    }
    set authLoginOidc(value) {
        this._authLoginOidc = value;
    }
    resetAuthLoginOidc() {
        this._authLoginOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginOidcInput() {
        return this._authLoginOidc;
    }
    get authLoginRadius() {
        return this._authLoginRadius;
    }
    set authLoginRadius(value) {
        this._authLoginRadius = value;
    }
    resetAuthLoginRadius() {
        this._authLoginRadius = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginRadiusInput() {
        return this._authLoginRadius;
    }
    get authLoginUserpass() {
        return this._authLoginUserpass;
    }
    set authLoginUserpass(value) {
        this._authLoginUserpass = value;
    }
    resetAuthLoginUserpass() {
        this._authLoginUserpass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginUserpassInput() {
        return this._authLoginUserpass;
    }
    get clientAuth() {
        return this._clientAuth;
    }
    set clientAuth(value) {
        this._clientAuth = value;
    }
    resetClientAuth() {
        this._clientAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientAuthInput() {
        return this._clientAuth;
    }
    get headers() {
        return this._headers;
    }
    set headers(value) {
        this._headers = value;
    }
    resetHeaders() {
        this._headers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get headersInput() {
        return this._headers;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            add_address_to_env: cdktf.stringToTerraform(this._addAddressToEnv),
            address: cdktf.stringToTerraform(this._address),
            ca_cert_dir: cdktf.stringToTerraform(this._caCertDir),
            ca_cert_file: cdktf.stringToTerraform(this._caCertFile),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            max_retries: cdktf.numberToTerraform(this._maxRetries),
            max_retries_ccc: cdktf.numberToTerraform(this._maxRetriesCcc),
            namespace: cdktf.stringToTerraform(this._namespace),
            skip_child_token: cdktf.booleanToTerraform(this._skipChildToken),
            skip_tls_verify: cdktf.booleanToTerraform(this._skipTlsVerify),
            tls_server_name: cdktf.stringToTerraform(this._tlsServerName),
            token: cdktf.stringToTerraform(this._token),
            token_name: cdktf.stringToTerraform(this._tokenName),
            alias: cdktf.stringToTerraform(this._alias),
            auth_login: vaultProviderAuthLoginToTerraform(this._authLogin),
            auth_login_aws: vaultProviderAuthLoginAwsToTerraform(this._authLoginAws),
            auth_login_azure: vaultProviderAuthLoginAzureToTerraform(this._authLoginAzure),
            auth_login_cert: vaultProviderAuthLoginCertToTerraform(this._authLoginCert),
            auth_login_gcp: vaultProviderAuthLoginGcpToTerraform(this._authLoginGcp),
            auth_login_jwt: vaultProviderAuthLoginJwtToTerraform(this._authLoginJwt),
            auth_login_kerberos: vaultProviderAuthLoginKerberosToTerraform(this._authLoginKerberos),
            auth_login_oci: vaultProviderAuthLoginOciToTerraform(this._authLoginOci),
            auth_login_oidc: vaultProviderAuthLoginOidcToTerraform(this._authLoginOidc),
            auth_login_radius: vaultProviderAuthLoginRadiusToTerraform(this._authLoginRadius),
            auth_login_userpass: vaultProviderAuthLoginUserpassToTerraform(this._authLoginUserpass),
            client_auth: vaultProviderClientAuthToTerraform(this._clientAuth),
            headers: cdktf.listMapper(vaultProviderHeadersToTerraform, true)(this._headers),
        };
    }
}
exports.VaultProvider = VaultProvider;
_a = JSII_RTTI_SYMBOL_1;
VaultProvider[_a] = { fqn: "@cdktf/provider-vault.provider.VaultProvider", version: "3.0.7" };
// =================
// STATIC PROPERTIES
// =================
VaultProvider.tfResourceType = "vault";
//# sourceMappingURL=data:application/json;base64,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