# pulp_2to3_migration-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.11.10
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_2to3_migration
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_2to3_migration
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_2to3_migration
from pulpcore.client.pulp_2to3_migration.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_2to3_migration.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_2to3_migration.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_2to3_migration.Configuration(
    host = "http://pulp",
    api_key = {
        'Session': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Session'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_2to3_migration.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_2to3_migration.MigrationPlansApi(api_client)
    pulp2to3_migration_migration_plan = pulpcore.client.pulp_2to3_migration.Pulp2to3MigrationMigrationPlan() # Pulp2to3MigrationMigrationPlan | 

    try:
        # Create a migration plan
        api_response = api_instance.create(pulp2to3_migration_migration_plan)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling MigrationPlansApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MigrationPlansApi* | [**create**](docs/MigrationPlansApi.md#create) | **POST** /pulp/api/v3/migration-plans/ | Create a migration plan
*MigrationPlansApi* | [**delete**](docs/MigrationPlansApi.md#delete) | **DELETE** {pulp_2to3_migration_migration_plan_href} | Delete a migration plan
*MigrationPlansApi* | [**list**](docs/MigrationPlansApi.md#list) | **GET** /pulp/api/v3/migration-plans/ | List migration plans
*MigrationPlansApi* | [**read**](docs/MigrationPlansApi.md#read) | **GET** {pulp_2to3_migration_migration_plan_href} | Inspect a migration plan
*MigrationPlansApi* | [**reset**](docs/MigrationPlansApi.md#reset) | **POST** {pulp_2to3_migration_migration_plan_href}reset/ | Reset Pulp 3 data for plugins specified in the migration plan
*MigrationPlansApi* | [**run**](docs/MigrationPlansApi.md#run) | **POST** {pulp_2to3_migration_migration_plan_href}run/ | Run migration plan
*Pulp2ContentApi* | [**list**](docs/Pulp2ContentApi.md#list) | **GET** /pulp/api/v3/pulp2content/ | List pulp2 contents
*Pulp2ContentApi* | [**read**](docs/Pulp2ContentApi.md#read) | **GET** {pulp_2to3_migration_pulp2_content_href} | Inspect a pulp2 content
*Pulp2RepositoriesApi* | [**list**](docs/Pulp2RepositoriesApi.md#list) | **GET** /pulp/api/v3/pulp2repositories/ | List pulp2 repositorys
*Pulp2RepositoriesApi* | [**read**](docs/Pulp2RepositoriesApi.md#read) | **GET** {pulp_2to3_migration_pulp2_repository_href} | Inspect a pulp2 repository


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [MigrationPlanRun](docs/MigrationPlanRun.md)
 - [Pulp2to3MigrationMigrationPlan](docs/Pulp2to3MigrationMigrationPlan.md)
 - [Pulp2to3MigrationMigrationPlanResponse](docs/Pulp2to3MigrationMigrationPlanResponse.md)
 - [Pulp2to3MigrationPulp2ContentResponse](docs/Pulp2to3MigrationPulp2ContentResponse.md)
 - [Pulp2to3MigrationPulp2RepositoryResponse](docs/Pulp2to3MigrationPulp2RepositoryResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: Session
- **Location**: 


## Author

pulp-list@redhat.com


