"""create truck_tracking_log table

Revision ID: 5a215d376732
Revises:
Create Date: 2022-08-31 16:46:22.045877

"""
import sqlalchemy as sa
from alembic import op


# revision identifiers, used by Alembic.
revision = '5a215d376732'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'truck_tracking_log',
        sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
        sa.Column('ts', sa.DateTime(), nullable=False),
        sa.Column('camera_id', sa.Enum('one', 'two', 'three', name='cameras'), nullable=False),
        sa.Column('licence_plate', sa.String(length=15), nullable=False),
        sa.Column('arrived', sa.DateTime(), nullable=False),
        sa.Column('waiting', sa.DateTime(), nullable=False),
        sa.Column('finished', sa.DateTime(), nullable=False),
        sa.Column('status', sa.String(length=10), nullable=False),
        sa.PrimaryKeyConstraint('id'),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('truck_tracking_log')
    # ### end Alembic commands ###
