"""create report table

Revision ID: ce22ee326805
Revises: 0d27559e0399
Create Date: 2022-11-05 10:26:38.562538

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = 'ce22ee326805'
down_revision = '0d27559e0399'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'report',
        sa.Column('licence_plate', sa.String(12), nullable=False),
        sa.Column('entry_point_camera_id', mysql.TINYINT(4), nullable=False, server_default='1'),
        sa.Column('arrived_to_entry_point', sa.DateTime(), nullable=False),
        sa.Column('leaved_entry_point', sa.DateTime(), nullable=False),
        sa.Column('entry_time_in_minutes', mysql.TINYINT(4), nullable=False),
        sa.Column('start_loading_point_camera_id', mysql.TINYINT(4), nullable=False, server_default='2'),
        sa.Column('arrived_to_start_loading_point', sa.DateTime(), nullable=False),
        sa.Column('leaved_start_loading_point', sa.DateTime(), nullable=False),
        sa.Column('start_loading_time_in_minutes', mysql.TINYINT(4), nullable=False),
        sa.Column('finish_loading_point_camera_id', mysql.TINYINT(4), nullable=False, server_default='3'),
        sa.Column('arrived_to_finish_loading_point', sa.DateTime(), nullable=False),
        sa.Column('leaved_finish_loading_point', sa.DateTime(), nullable=False),
        sa.Column('finish_loading_time_in_minutes', mysql.TINYINT(4), nullable=False),
        sa.Column('loading_time_in_minutes', mysql.SMALLINT(6), nullable=False),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('report')
    # ### end Alembic commands ###
