# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 continuous: Optional[pulumi.Input['JobContinuousArgs']] = None,
                 dbt_task: Optional[pulumi.Input['JobDbtTaskArgs']] = None,
                 email_notifications: Optional[pulumi.Input['JobEmailNotificationsArgs']] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input['JobGitSourceArgs']] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input['JobNewClusterArgs']] = None,
                 notebook_task: Optional[pulumi.Input['JobNotebookTaskArgs']] = None,
                 pipeline_task: Optional[pulumi.Input['JobPipelineTaskArgs']] = None,
                 python_wheel_task: Optional[pulumi.Input['JobPythonWheelTaskArgs']] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['JobScheduleArgs']] = None,
                 spark_jar_task: Optional[pulumi.Input['JobSparkJarTaskArgs']] = None,
                 spark_python_task: Optional[pulumi.Input['JobSparkPythonTaskArgs']] = None,
                 spark_submit_task: Optional[pulumi.Input['JobSparkSubmitTaskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 webhook_notifications: Optional[pulumi.Input['JobWebhookNotificationsArgs']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input['JobEmailNotificationsArgs'] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]] libraries: (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] max_retries: (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input['JobNewClusterArgs'] new_cluster: Same set of parameters as for Cluster resource.
        :param pulumi.Input[bool] retry_on_timeout: (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        :param pulumi.Input['JobScheduleArgs'] schedule: (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        :param pulumi.Input[Mapping[str, Any]] tags: (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input['JobWebhookNotificationsArgs'] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        if always_running is not None:
            pulumi.set(__self__, "always_running", always_running)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if dbt_task is not None:
            pulumi.set(__self__, "dbt_task", dbt_task)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if git_source is not None:
            pulumi.set(__self__, "git_source", git_source)
        if job_clusters is not None:
            pulumi.set(__self__, "job_clusters", job_clusters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_retry_interval_millis is not None:
            pulumi.set(__self__, "min_retry_interval_millis", min_retry_interval_millis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster is not None:
            pulumi.set(__self__, "new_cluster", new_cluster)
        if notebook_task is not None:
            pulumi.set(__self__, "notebook_task", notebook_task)
        if pipeline_task is not None:
            pulumi.set(__self__, "pipeline_task", pipeline_task)
        if python_wheel_task is not None:
            pulumi.set(__self__, "python_wheel_task", python_wheel_task)
        if retry_on_timeout is not None:
            pulumi.set(__self__, "retry_on_timeout", retry_on_timeout)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if spark_jar_task is not None:
            pulumi.set(__self__, "spark_jar_task", spark_jar_task)
        if spark_python_task is not None:
            pulumi.set(__self__, "spark_python_task", spark_python_task)
        if spark_submit_task is not None:
            pulumi.set(__self__, "spark_submit_task", spark_submit_task)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if webhook_notifications is not None:
            pulumi.set(__self__, "webhook_notifications", webhook_notifications)

    @property
    @pulumi.getter(name="alwaysRunning")
    def always_running(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @always_running.setter
    def always_running(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_running", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input['JobContinuousArgs']]:
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input['JobContinuousArgs']]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter(name="dbtTask")
    def dbt_task(self) -> Optional[pulumi.Input['JobDbtTaskArgs']]:
        return pulumi.get(self, "dbt_task")

    @dbt_task.setter
    def dbt_task(self, value: Optional[pulumi.Input['JobDbtTaskArgs']]):
        pulumi.set(self, "dbt_task", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input['JobEmailNotificationsArgs']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input['JobEmailNotificationsArgs']]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> Optional[pulumi.Input['JobGitSourceArgs']]:
        return pulumi.get(self, "git_source")

    @git_source.setter
    def git_source(self, value: Optional[pulumi.Input['JobGitSourceArgs']]):
        pulumi.set(self, "git_source", value)

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @job_clusters.setter
    def job_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]):
        pulumi.set(self, "job_clusters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]:
        """
        (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @max_concurrent_runs.setter
    def max_concurrent_runs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_runs", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    def min_retry_interval_millis(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @min_retry_interval_millis.setter
    def min_retry_interval_millis(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_retry_interval_millis", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> Optional[pulumi.Input['JobNewClusterArgs']]:
        """
        Same set of parameters as for Cluster resource.
        """
        return pulumi.get(self, "new_cluster")

    @new_cluster.setter
    def new_cluster(self, value: Optional[pulumi.Input['JobNewClusterArgs']]):
        pulumi.set(self, "new_cluster", value)

    @property
    @pulumi.getter(name="notebookTask")
    def notebook_task(self) -> Optional[pulumi.Input['JobNotebookTaskArgs']]:
        return pulumi.get(self, "notebook_task")

    @notebook_task.setter
    def notebook_task(self, value: Optional[pulumi.Input['JobNotebookTaskArgs']]):
        pulumi.set(self, "notebook_task", value)

    @property
    @pulumi.getter(name="pipelineTask")
    def pipeline_task(self) -> Optional[pulumi.Input['JobPipelineTaskArgs']]:
        return pulumi.get(self, "pipeline_task")

    @pipeline_task.setter
    def pipeline_task(self, value: Optional[pulumi.Input['JobPipelineTaskArgs']]):
        pulumi.set(self, "pipeline_task", value)

    @property
    @pulumi.getter(name="pythonWheelTask")
    def python_wheel_task(self) -> Optional[pulumi.Input['JobPythonWheelTaskArgs']]:
        return pulumi.get(self, "python_wheel_task")

    @python_wheel_task.setter
    def python_wheel_task(self, value: Optional[pulumi.Input['JobPythonWheelTaskArgs']]):
        pulumi.set(self, "python_wheel_task", value)

    @property
    @pulumi.getter(name="retryOnTimeout")
    def retry_on_timeout(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        """
        return pulumi.get(self, "retry_on_timeout")

    @retry_on_timeout.setter
    def retry_on_timeout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retry_on_timeout", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['JobScheduleArgs']]:
        """
        (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['JobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sparkJarTask")
    def spark_jar_task(self) -> Optional[pulumi.Input['JobSparkJarTaskArgs']]:
        return pulumi.get(self, "spark_jar_task")

    @spark_jar_task.setter
    def spark_jar_task(self, value: Optional[pulumi.Input['JobSparkJarTaskArgs']]):
        pulumi.set(self, "spark_jar_task", value)

    @property
    @pulumi.getter(name="sparkPythonTask")
    def spark_python_task(self) -> Optional[pulumi.Input['JobSparkPythonTaskArgs']]:
        return pulumi.get(self, "spark_python_task")

    @spark_python_task.setter
    def spark_python_task(self, value: Optional[pulumi.Input['JobSparkPythonTaskArgs']]):
        pulumi.set(self, "spark_python_task", value)

    @property
    @pulumi.getter(name="sparkSubmitTask")
    def spark_submit_task(self) -> Optional[pulumi.Input['JobSparkSubmitTaskArgs']]:
        return pulumi.get(self, "spark_submit_task")

    @spark_submit_task.setter
    def spark_submit_task(self, value: Optional[pulumi.Input['JobSparkSubmitTaskArgs']]):
        pulumi.set(self, "spark_submit_task", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]:
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> Optional[pulumi.Input['JobWebhookNotificationsArgs']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

    @webhook_notifications.setter
    def webhook_notifications(self, value: Optional[pulumi.Input['JobWebhookNotificationsArgs']]):
        pulumi.set(self, "webhook_notifications", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 continuous: Optional[pulumi.Input['JobContinuousArgs']] = None,
                 dbt_task: Optional[pulumi.Input['JobDbtTaskArgs']] = None,
                 email_notifications: Optional[pulumi.Input['JobEmailNotificationsArgs']] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input['JobGitSourceArgs']] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input['JobNewClusterArgs']] = None,
                 notebook_task: Optional[pulumi.Input['JobNotebookTaskArgs']] = None,
                 pipeline_task: Optional[pulumi.Input['JobPipelineTaskArgs']] = None,
                 python_wheel_task: Optional[pulumi.Input['JobPythonWheelTaskArgs']] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['JobScheduleArgs']] = None,
                 spark_jar_task: Optional[pulumi.Input['JobSparkJarTaskArgs']] = None,
                 spark_python_task: Optional[pulumi.Input['JobSparkPythonTaskArgs']] = None,
                 spark_submit_task: Optional[pulumi.Input['JobSparkSubmitTaskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 webhook_notifications: Optional[pulumi.Input['JobWebhookNotificationsArgs']] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input['JobEmailNotificationsArgs'] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]] libraries: (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] max_retries: (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input['JobNewClusterArgs'] new_cluster: Same set of parameters as for Cluster resource.
        :param pulumi.Input[bool] retry_on_timeout: (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        :param pulumi.Input['JobScheduleArgs'] schedule: (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        :param pulumi.Input[Mapping[str, Any]] tags: (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input[str] url: URL of the Git repository to use.
        :param pulumi.Input['JobWebhookNotificationsArgs'] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        if always_running is not None:
            pulumi.set(__self__, "always_running", always_running)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if dbt_task is not None:
            pulumi.set(__self__, "dbt_task", dbt_task)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if git_source is not None:
            pulumi.set(__self__, "git_source", git_source)
        if job_clusters is not None:
            pulumi.set(__self__, "job_clusters", job_clusters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_retry_interval_millis is not None:
            pulumi.set(__self__, "min_retry_interval_millis", min_retry_interval_millis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster is not None:
            pulumi.set(__self__, "new_cluster", new_cluster)
        if notebook_task is not None:
            pulumi.set(__self__, "notebook_task", notebook_task)
        if pipeline_task is not None:
            pulumi.set(__self__, "pipeline_task", pipeline_task)
        if python_wheel_task is not None:
            pulumi.set(__self__, "python_wheel_task", python_wheel_task)
        if retry_on_timeout is not None:
            pulumi.set(__self__, "retry_on_timeout", retry_on_timeout)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if spark_jar_task is not None:
            pulumi.set(__self__, "spark_jar_task", spark_jar_task)
        if spark_python_task is not None:
            pulumi.set(__self__, "spark_python_task", spark_python_task)
        if spark_submit_task is not None:
            pulumi.set(__self__, "spark_submit_task", spark_submit_task)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if webhook_notifications is not None:
            pulumi.set(__self__, "webhook_notifications", webhook_notifications)

    @property
    @pulumi.getter(name="alwaysRunning")
    def always_running(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @always_running.setter
    def always_running(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_running", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input['JobContinuousArgs']]:
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input['JobContinuousArgs']]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter(name="dbtTask")
    def dbt_task(self) -> Optional[pulumi.Input['JobDbtTaskArgs']]:
        return pulumi.get(self, "dbt_task")

    @dbt_task.setter
    def dbt_task(self, value: Optional[pulumi.Input['JobDbtTaskArgs']]):
        pulumi.set(self, "dbt_task", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input['JobEmailNotificationsArgs']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input['JobEmailNotificationsArgs']]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> Optional[pulumi.Input['JobGitSourceArgs']]:
        return pulumi.get(self, "git_source")

    @git_source.setter
    def git_source(self, value: Optional[pulumi.Input['JobGitSourceArgs']]):
        pulumi.set(self, "git_source", value)

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @job_clusters.setter
    def job_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]):
        pulumi.set(self, "job_clusters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]:
        """
        (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @max_concurrent_runs.setter
    def max_concurrent_runs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_runs", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    def min_retry_interval_millis(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @min_retry_interval_millis.setter
    def min_retry_interval_millis(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_retry_interval_millis", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> Optional[pulumi.Input['JobNewClusterArgs']]:
        """
        Same set of parameters as for Cluster resource.
        """
        return pulumi.get(self, "new_cluster")

    @new_cluster.setter
    def new_cluster(self, value: Optional[pulumi.Input['JobNewClusterArgs']]):
        pulumi.set(self, "new_cluster", value)

    @property
    @pulumi.getter(name="notebookTask")
    def notebook_task(self) -> Optional[pulumi.Input['JobNotebookTaskArgs']]:
        return pulumi.get(self, "notebook_task")

    @notebook_task.setter
    def notebook_task(self, value: Optional[pulumi.Input['JobNotebookTaskArgs']]):
        pulumi.set(self, "notebook_task", value)

    @property
    @pulumi.getter(name="pipelineTask")
    def pipeline_task(self) -> Optional[pulumi.Input['JobPipelineTaskArgs']]:
        return pulumi.get(self, "pipeline_task")

    @pipeline_task.setter
    def pipeline_task(self, value: Optional[pulumi.Input['JobPipelineTaskArgs']]):
        pulumi.set(self, "pipeline_task", value)

    @property
    @pulumi.getter(name="pythonWheelTask")
    def python_wheel_task(self) -> Optional[pulumi.Input['JobPythonWheelTaskArgs']]:
        return pulumi.get(self, "python_wheel_task")

    @python_wheel_task.setter
    def python_wheel_task(self, value: Optional[pulumi.Input['JobPythonWheelTaskArgs']]):
        pulumi.set(self, "python_wheel_task", value)

    @property
    @pulumi.getter(name="retryOnTimeout")
    def retry_on_timeout(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        """
        return pulumi.get(self, "retry_on_timeout")

    @retry_on_timeout.setter
    def retry_on_timeout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retry_on_timeout", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['JobScheduleArgs']]:
        """
        (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['JobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sparkJarTask")
    def spark_jar_task(self) -> Optional[pulumi.Input['JobSparkJarTaskArgs']]:
        return pulumi.get(self, "spark_jar_task")

    @spark_jar_task.setter
    def spark_jar_task(self, value: Optional[pulumi.Input['JobSparkJarTaskArgs']]):
        pulumi.set(self, "spark_jar_task", value)

    @property
    @pulumi.getter(name="sparkPythonTask")
    def spark_python_task(self) -> Optional[pulumi.Input['JobSparkPythonTaskArgs']]:
        return pulumi.get(self, "spark_python_task")

    @spark_python_task.setter
    def spark_python_task(self, value: Optional[pulumi.Input['JobSparkPythonTaskArgs']]):
        pulumi.set(self, "spark_python_task", value)

    @property
    @pulumi.getter(name="sparkSubmitTask")
    def spark_submit_task(self) -> Optional[pulumi.Input['JobSparkSubmitTaskArgs']]:
        return pulumi.get(self, "spark_submit_task")

    @spark_submit_task.setter
    def spark_submit_task(self, value: Optional[pulumi.Input['JobSparkSubmitTaskArgs']]):
        pulumi.set(self, "spark_submit_task", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]:
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Git repository to use.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> Optional[pulumi.Input['JobWebhookNotificationsArgs']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

    @webhook_notifications.setter
    def webhook_notifications(self, value: Optional[pulumi.Input['JobWebhookNotificationsArgs']]):
        pulumi.set(self, "webhook_notifications", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 continuous: Optional[pulumi.Input[pulumi.InputType['JobContinuousArgs']]] = None,
                 dbt_task: Optional[pulumi.Input[pulumi.InputType['JobDbtTaskArgs']]] = None,
                 email_notifications: Optional[pulumi.Input[pulumi.InputType['JobEmailNotificationsArgs']]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input[pulumi.InputType['JobGitSourceArgs']]] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobClusterArgs']]]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLibraryArgs']]]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input[pulumi.InputType['JobNewClusterArgs']]] = None,
                 notebook_task: Optional[pulumi.Input[pulumi.InputType['JobNotebookTaskArgs']]] = None,
                 pipeline_task: Optional[pulumi.Input[pulumi.InputType['JobPipelineTaskArgs']]] = None,
                 python_wheel_task: Optional[pulumi.Input[pulumi.InputType['JobPythonWheelTaskArgs']]] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['JobScheduleArgs']]] = None,
                 spark_jar_task: Optional[pulumi.Input[pulumi.InputType['JobSparkJarTaskArgs']]] = None,
                 spark_python_task: Optional[pulumi.Input[pulumi.InputType['JobSparkPythonTaskArgs']]] = None,
                 spark_submit_task: Optional[pulumi.Input[pulumi.InputType['JobSparkSubmitTaskArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTaskArgs']]]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 webhook_notifications: Optional[pulumi.Input[pulumi.InputType['JobWebhookNotificationsArgs']]] = None,
                 __props__=None):
        """
        ## Import

        The resource job can be imported using the id of the job bash

        ```sh
         $ pulumi import databricks:index/job:Job this <job-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[pulumi.InputType['JobEmailNotificationsArgs']] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobClusterArgs']]]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLibraryArgs']]]] libraries: (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] max_retries: (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input[pulumi.InputType['JobNewClusterArgs']] new_cluster: Same set of parameters as for Cluster resource.
        :param pulumi.Input[bool] retry_on_timeout: (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        :param pulumi.Input[pulumi.InputType['JobScheduleArgs']] schedule: (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        :param pulumi.Input[Mapping[str, Any]] tags: (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input[pulumi.InputType['JobWebhookNotificationsArgs']] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[JobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        The resource job can be imported using the id of the job bash

        ```sh
         $ pulumi import databricks:index/job:Job this <job-id>
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 continuous: Optional[pulumi.Input[pulumi.InputType['JobContinuousArgs']]] = None,
                 dbt_task: Optional[pulumi.Input[pulumi.InputType['JobDbtTaskArgs']]] = None,
                 email_notifications: Optional[pulumi.Input[pulumi.InputType['JobEmailNotificationsArgs']]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input[pulumi.InputType['JobGitSourceArgs']]] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobClusterArgs']]]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLibraryArgs']]]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input[pulumi.InputType['JobNewClusterArgs']]] = None,
                 notebook_task: Optional[pulumi.Input[pulumi.InputType['JobNotebookTaskArgs']]] = None,
                 pipeline_task: Optional[pulumi.Input[pulumi.InputType['JobPipelineTaskArgs']]] = None,
                 python_wheel_task: Optional[pulumi.Input[pulumi.InputType['JobPythonWheelTaskArgs']]] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['JobScheduleArgs']]] = None,
                 spark_jar_task: Optional[pulumi.Input[pulumi.InputType['JobSparkJarTaskArgs']]] = None,
                 spark_python_task: Optional[pulumi.Input[pulumi.InputType['JobSparkPythonTaskArgs']]] = None,
                 spark_submit_task: Optional[pulumi.Input[pulumi.InputType['JobSparkSubmitTaskArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTaskArgs']]]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 webhook_notifications: Optional[pulumi.Input[pulumi.InputType['JobWebhookNotificationsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["always_running"] = always_running
            __props__.__dict__["continuous"] = continuous
            __props__.__dict__["dbt_task"] = dbt_task
            __props__.__dict__["email_notifications"] = email_notifications
            __props__.__dict__["existing_cluster_id"] = existing_cluster_id
            __props__.__dict__["format"] = format
            __props__.__dict__["git_source"] = git_source
            __props__.__dict__["job_clusters"] = job_clusters
            __props__.__dict__["libraries"] = libraries
            __props__.__dict__["max_concurrent_runs"] = max_concurrent_runs
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["min_retry_interval_millis"] = min_retry_interval_millis
            __props__.__dict__["name"] = name
            __props__.__dict__["new_cluster"] = new_cluster
            __props__.__dict__["notebook_task"] = notebook_task
            __props__.__dict__["pipeline_task"] = pipeline_task
            __props__.__dict__["python_wheel_task"] = python_wheel_task
            __props__.__dict__["retry_on_timeout"] = retry_on_timeout
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["spark_jar_task"] = spark_jar_task
            __props__.__dict__["spark_python_task"] = spark_python_task
            __props__.__dict__["spark_submit_task"] = spark_submit_task
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tasks"] = tasks
            __props__.__dict__["timeout_seconds"] = timeout_seconds
            __props__.__dict__["webhook_notifications"] = webhook_notifications
            __props__.__dict__["url"] = None
        super(Job, __self__).__init__(
            'databricks:index/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_running: Optional[pulumi.Input[bool]] = None,
            continuous: Optional[pulumi.Input[pulumi.InputType['JobContinuousArgs']]] = None,
            dbt_task: Optional[pulumi.Input[pulumi.InputType['JobDbtTaskArgs']]] = None,
            email_notifications: Optional[pulumi.Input[pulumi.InputType['JobEmailNotificationsArgs']]] = None,
            existing_cluster_id: Optional[pulumi.Input[str]] = None,
            format: Optional[pulumi.Input[str]] = None,
            git_source: Optional[pulumi.Input[pulumi.InputType['JobGitSourceArgs']]] = None,
            job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobClusterArgs']]]]] = None,
            libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLibraryArgs']]]]] = None,
            max_concurrent_runs: Optional[pulumi.Input[int]] = None,
            max_retries: Optional[pulumi.Input[int]] = None,
            min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_cluster: Optional[pulumi.Input[pulumi.InputType['JobNewClusterArgs']]] = None,
            notebook_task: Optional[pulumi.Input[pulumi.InputType['JobNotebookTaskArgs']]] = None,
            pipeline_task: Optional[pulumi.Input[pulumi.InputType['JobPipelineTaskArgs']]] = None,
            python_wheel_task: Optional[pulumi.Input[pulumi.InputType['JobPythonWheelTaskArgs']]] = None,
            retry_on_timeout: Optional[pulumi.Input[bool]] = None,
            schedule: Optional[pulumi.Input[pulumi.InputType['JobScheduleArgs']]] = None,
            spark_jar_task: Optional[pulumi.Input[pulumi.InputType['JobSparkJarTaskArgs']]] = None,
            spark_python_task: Optional[pulumi.Input[pulumi.InputType['JobSparkPythonTaskArgs']]] = None,
            spark_submit_task: Optional[pulumi.Input[pulumi.InputType['JobSparkSubmitTaskArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            tasks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTaskArgs']]]]] = None,
            timeout_seconds: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None,
            webhook_notifications: Optional[pulumi.Input[pulumi.InputType['JobWebhookNotificationsArgs']]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[pulumi.InputType['JobEmailNotificationsArgs']] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobJobClusterArgs']]]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobLibraryArgs']]]] libraries: (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] max_retries: (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input[pulumi.InputType['JobNewClusterArgs']] new_cluster: Same set of parameters as for Cluster resource.
        :param pulumi.Input[bool] retry_on_timeout: (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        :param pulumi.Input[pulumi.InputType['JobScheduleArgs']] schedule: (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        :param pulumi.Input[Mapping[str, Any]] tags: (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input[str] url: URL of the Git repository to use.
        :param pulumi.Input[pulumi.InputType['JobWebhookNotificationsArgs']] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["always_running"] = always_running
        __props__.__dict__["continuous"] = continuous
        __props__.__dict__["dbt_task"] = dbt_task
        __props__.__dict__["email_notifications"] = email_notifications
        __props__.__dict__["existing_cluster_id"] = existing_cluster_id
        __props__.__dict__["format"] = format
        __props__.__dict__["git_source"] = git_source
        __props__.__dict__["job_clusters"] = job_clusters
        __props__.__dict__["libraries"] = libraries
        __props__.__dict__["max_concurrent_runs"] = max_concurrent_runs
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["min_retry_interval_millis"] = min_retry_interval_millis
        __props__.__dict__["name"] = name
        __props__.__dict__["new_cluster"] = new_cluster
        __props__.__dict__["notebook_task"] = notebook_task
        __props__.__dict__["pipeline_task"] = pipeline_task
        __props__.__dict__["python_wheel_task"] = python_wheel_task
        __props__.__dict__["retry_on_timeout"] = retry_on_timeout
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["spark_jar_task"] = spark_jar_task
        __props__.__dict__["spark_python_task"] = spark_python_task
        __props__.__dict__["spark_submit_task"] = spark_submit_task
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tasks"] = tasks
        __props__.__dict__["timeout_seconds"] = timeout_seconds
        __props__.__dict__["url"] = url
        __props__.__dict__["webhook_notifications"] = webhook_notifications
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysRunning")
    def always_running(self) -> pulumi.Output[Optional[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @property
    @pulumi.getter
    def continuous(self) -> pulumi.Output[Optional['outputs.JobContinuous']]:
        return pulumi.get(self, "continuous")

    @property
    @pulumi.getter(name="dbtTask")
    def dbt_task(self) -> pulumi.Output[Optional['outputs.JobDbtTask']]:
        return pulumi.get(self, "dbt_task")

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> pulumi.Output[Optional['outputs.JobEmailNotifications']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes and fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[str]:
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> pulumi.Output[Optional['outputs.JobGitSource']]:
        return pulumi.get(self, "git_source")

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> pulumi.Output[Optional[Sequence['outputs.JobJobCluster']]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @property
    @pulumi.getter
    def libraries(self) -> pulumi.Output[Optional[Sequence['outputs.JobLibrary']]]:
        """
        (Set) An optional list of libraries to be installed on the cluster that will execute the job. Please consult libraries section for Cluster resource.
        """
        return pulumi.get(self, "libraries")

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with a FAILED or INTERNAL_ERROR lifecycle state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry. A run can have the following lifecycle state: PENDING, RUNNING, TERMINATING, TERMINATED, SKIPPED or INTERNAL_ERROR
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    def min_retry_interval_millis(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> pulumi.Output[Optional['outputs.JobNewCluster']]:
        """
        Same set of parameters as for Cluster resource.
        """
        return pulumi.get(self, "new_cluster")

    @property
    @pulumi.getter(name="notebookTask")
    def notebook_task(self) -> pulumi.Output[Optional['outputs.JobNotebookTask']]:
        return pulumi.get(self, "notebook_task")

    @property
    @pulumi.getter(name="pipelineTask")
    def pipeline_task(self) -> pulumi.Output[Optional['outputs.JobPipelineTask']]:
        return pulumi.get(self, "pipeline_task")

    @property
    @pulumi.getter(name="pythonWheelTask")
    def python_wheel_task(self) -> pulumi.Output[Optional['outputs.JobPythonWheelTask']]:
        return pulumi.get(self, "python_wheel_task")

    @property
    @pulumi.getter(name="retryOnTimeout")
    def retry_on_timeout(self) -> pulumi.Output[Optional[bool]]:
        """
        (Bool) An optional policy to specify whether to retry a job when it times out. The default behavior is to not retry on timeout.
        """
        return pulumi.get(self, "retry_on_timeout")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.JobSchedule']]:
        """
        (List) An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. This field is a block and is documented below.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sparkJarTask")
    def spark_jar_task(self) -> pulumi.Output[Optional['outputs.JobSparkJarTask']]:
        return pulumi.get(self, "spark_jar_task")

    @property
    @pulumi.getter(name="sparkPythonTask")
    def spark_python_task(self) -> pulumi.Output[Optional['outputs.JobSparkPythonTask']]:
        return pulumi.get(self, "spark_python_task")

    @property
    @pulumi.getter(name="sparkSubmitTask")
    def spark_submit_task(self) -> pulumi.Output[Optional['outputs.JobSparkSubmitTask']]:
        return pulumi.get(self, "spark_submit_task")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        (Map) An optional map of the tags associated with the job. Specified tags will be used as cluster tags for job clusters.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tasks(self) -> pulumi.Output[Optional[Sequence['outputs.JobTask']]]:
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL of the Git repository to use.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> pulumi.Output[Optional['outputs.JobWebhookNotifications']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes and fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

