import { Duration } from 'aws-cdk-lib';
import { IRestApi } from 'aws-cdk-lib/aws-apigateway';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { XAmazonApigatewayAuthorizer } from '../x-amazon-apigateway/authorizer';
import { XAmazonApigatewayAuthType } from '../x-amazon-apigateway/authtype';
import { Id } from './authorizer';
export interface LambdaAuthorizerProps {
    readonly fn: IFunction;
    /**
     * @example
     * apigateway.IdentitySource.header('Authorization')
     */
    readonly identitySource: string;
    readonly type: 'token' | 'request';
    readonly authType: string;
    readonly resultsCacheTtl?: Duration;
}
export declare class LambdaAuthorizer extends Construct {
    readonly id: Id;
    readonly fn: IFunction;
    readonly xAmazonApigatewayAuthtype: XAmazonApigatewayAuthType;
    readonly xAmazonApigatewayAuthorizer: XAmazonApigatewayAuthorizer;
    constructor(scope: Construct, id: Id, props: LambdaAuthorizerProps);
    /**
     * Allow Lambda invoke action to be performed by given identity.
     *
     * The ARN format for authorizers is different compared to integrations when granting permissions,
     * ex. arn:aws:execute-api:us-east-1:123456789012:api-id/authorizers/authorizer-id
    */
    grantFunctionInvoke(api: IRestApi): void;
}
