"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const lambda_invocation_1 = require("../lambda-invocation");
// implements AuthorizerConfig ... JSII doesn't like
class LambdaAuthorizer extends constructs_1.Construct {
    constructor(scope, id, props) {
        const { fn, identitySource, type, authType: authtype, resultsCacheTtl } = props;
        super(scope, id);
        this.id = id;
        this.fn = fn;
        this.xAmazonApigatewayAuthtype = authtype;
        this.xAmazonApigatewayAuthorizer = {
            type,
            authorizerUri: new lambda_invocation_1.LambdaInvocation(scope, fn).uri,
            identitySource,
            authorizerResultTtlInSeconds: (function () {
                if (typeof resultsCacheTtl !== 'undefined') {
                    return resultsCacheTtl.toSeconds();
                }
                return undefined;
            }()),
        };
    }
    /**
     * Allow Lambda invoke action to be performed by given identity.
     *
     * The ARN format for authorizers is different compared to integrations when granting permissions,
     * ex. arn:aws:execute-api:us-east-1:123456789012:api-id/authorizers/authorizer-id
    */
    grantFunctionInvoke(api) {
        /**
         * if the lambda functions are created in separate stacks, circular dependencies appear
         * when we grant function invoke permissions directly. This is a hacky way to avoid the issue
         */
        const fn = aws_lambda_1.Function.fromFunctionAttributes(this, `ImportFunction${this.id}`, {
            functionArn: this.fn.functionArn,
            sameEnvironment: true,
        });
        const authorizerArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: api.restApiId,
            resourceName: 'authorizers/*',
        });
        fn.grantInvoke(new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com', {
            conditions: {
                ArnLike: {
                    'aws:SourceArn': authorizerArn,
                },
            },
        }));
    }
}
exports.LambdaAuthorizer = LambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
LambdaAuthorizer[_a] = { fqn: "@alma-cdk/openapix.LambdaAuthorizer", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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