"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CorsIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
//import { readFileSync } from 'fs';
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const base_1 = require("./base");
//const template = readFileSync(__dirname+'/cors.vtl', 'utf-8');
const template = `
$input.json("$")
#set($domains = [__DOMAINS__])
#set($origin = $input.params("origin"))
#if($domains.size()==0)
#set($context.responseOverride.header.Access-Control-Allow-Origin="*")
#elseif($domains.contains($origin))
#set($context.responseOverride.header.Access-Control-Allow-Origin="$origin")
#end
`.trim();
/**
 * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-cors.html
 * @see https://medium.com/@srikanth650/use-api-gateway-with-mock-integration-to-allow-cors-from-multiple-origins-bdcb431d07d3
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html#mapping-response-parameters
 */
class CorsIntegration extends base_1.Integration {
    /**
     * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
     *
     * @example
     * '/bar': {
     *   'OPTIONS': new openapix.CorsIntegration(this, {
     *     headers: 'Content-Type,X-Amz-Date,Authorization',
     *     origins: '*',
     *     methods: 'OPTIONS,GET',
     *   }),
     * },
     */
    constructor(_, props) {
        const { headers, origins, methods } = props;
        const integration = {
            type: aws_apigateway_1.IntegrationType.MOCK,
            options: {
                integrationResponses: [
                    {
                        statusCode: '204',
                        responseParameters: {
                            'method.response.header.Access-Control-Allow-Methods': methods,
                            'method.response.header.Access-Control-Allow-Headers': headers,
                        },
                        responseTemplates: {
                            'application/json': CorsIntegration.buildTemplate(origins),
                        },
                    },
                ],
            },
        };
        const config = {
            type: base_1.InternalIntegrationType.CORS,
            validator: props?.validator,
        };
        super(integration, config);
    }
    /** Build Apache Velocity (`.vtl`) template for CORS response. */
    static buildTemplate(origins) {
        const originsForTmpl = origins.split(',').map(o => `"${o}"`).join(',');
        const tmpl = template.replace('__DOMAINS__', originsForTmpl);
        return tmpl;
    }
}
exports.CorsIntegration = CorsIntegration;
_a = JSII_RTTI_SYMBOL_1;
CorsIntegration[_a] = { fqn: "@alma-cdk/openapix.CorsIntegration", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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