"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const base_1 = require("./base");
/** Defines a HTTP(S) integration. */
class HttpIntegration extends base_1.Integration {
    /**
     * Defines a HTTP(S) integration.
     *
     * @example
     * '/ext': {
     *   'ANY': new openapix.HttpIntegration(this, "https://example.com"),
     * },
     */
    constructor(_, url, props) {
        const integration = {
            type: HttpIntegration.selectIntegrationType(props?.proxy),
            uri: url,
            integrationHttpMethod: HttpIntegration.selectIntegrationHttpMethod(props?.httpMethod),
            options: props?.options,
        };
        const config = {
            type: base_1.InternalIntegrationType.HTTP,
            validator: props?.validator,
        };
        super(integration, config);
    }
    /**
     * Selects the integration HTTP method.
     *
     * @default
     * 'GET'
     */
    static selectIntegrationHttpMethod(httpMethod) {
        if (typeof httpMethod === 'string' && httpMethod.length > 0) {
            return httpMethod;
        }
        return 'GET';
    }
    /** Selects the correct integration type configuration. */
    static selectIntegrationType(proxy) {
        if (proxy === false) {
            return apigateway.IntegrationType.HTTP;
        }
        // default to proxy as CDK does
        return apigateway.IntegrationType.HTTP_PROXY;
    }
}
exports.HttpIntegration = HttpIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpIntegration[_a] = { fqn: "@alma-cdk/openapix.HttpIntegration", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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