"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValidVersion = void 0;
const semver = require("semver");
const prefixRegex = /^[=|v]/i;
function getValidVersion(range, version) {
    if (isPrefixed(version)) {
        const message = 'Do not prefix the version value';
        throw new Error(message);
    }
    const coerced = semver.coerce(version)?.version;
    if (!isValid(coerced)) {
        const message = `Invalid OpenApi version "${version}"`;
        throw new Error(message);
    }
    if (!isSupported(range, coerced)) {
        const message = `Unsupported OpenApi version "${coerced}": Must be ${range}`;
        throw new Error(message);
    }
    return coerced;
}
exports.getValidVersion = getValidVersion;
function isPrefixed(version) {
    return (typeof version === 'string' && prefixRegex.test(version));
}
function isValid(version) {
    return typeof semver.valid(version) === 'string';
}
function isSupported(range, version) {
    return semver.satisfies(version, range);
}
//# sourceMappingURL=data:application/json;base64,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