/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc3;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.FMSQLException;
import java.sql.SQLException;

public abstract class CommonJ3ParameterMetaData {
    private final BaseConnection connection;
    private final int[] types;

    public CommonJ3ParameterMetaData(BaseConnection baseConnection, int[] nArray) {
        this.connection = baseConnection;
        this.types = nArray;
    }

    public int getParameterCount() {
        return this.types.length;
    }

    public int getParameterMode(int n) throws SQLException {
        this.checkParamIndex(n);
        return 1;
    }

    public int getParameterType(int n) throws SQLException {
        return 0;
    }

    public String getParameterTypeName(int n) throws SQLException {
        return new String("");
    }

    public int getPrecision(int n) throws SQLException {
        this.checkParamIndex(n);
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.checkParamIndex(n);
        return 0;
    }

    public int isNullable(int n) throws SQLException {
        this.checkParamIndex(n);
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkParamIndex(n);
        return false;
    }

    private void checkParamIndex(int n) throws SQLException {
        if (n < 1 || n > this.types.length) {
            throw new FMSQLException("The parameter index is out of range.", "22023", 27225);
        }
    }
}

