"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sipRuleValidator = void 0;
var E164_NUMBER = /^\+[1-9]\d{10,14}$/;
var URI_HOSTNAME = /^[0-9a-z]{22}.voiceconnector.chime.aws$/;
var SMA_ID = /^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$/;
function sipRuleValidator(props) {
    if (props.triggerType) {
        if (props.triggerValue.includes('Token')) {
        }
        else {
            if (props.triggerType === 'ToPhoneNumber' &&
                !E164_NUMBER.test(props.triggerValue)) {
                throw new Error('Trigger Value must be must be valid E.164 number');
            }
            if (props.triggerType === 'RequestUriHostname' &&
                !URI_HOSTNAME.test(props.triggerValue)) {
                throw new Error('Trigger Value must be valid Chime Voice Connector');
            }
        }
    }
    for (var target of props.targetApplications) {
        if (target.sipMediaApplicationId.includes('Token')) {
        }
        else {
            if (!SMA_ID.test(target.sipMediaApplicationId)) {
                throw new Error('sipMediaApplicationId must be valid');
            }
        }
    }
    for (var target of props.targetApplications) {
        if (target.priority < 1 || target.priority > 25) {
            throw new Error('Priority should be between 1 and 25');
        }
    }
    for (var target of props.targetApplications) {
        if (target.region) {
            if (!(target.region.includes('Token[AWS.Region.') ||
                target.region === 'us-east-1' ||
                target.region === 'us-west-2')) {
                throw new Error('Region must be us-east-1 or us-west-2');
            }
        }
    }
    return true;
}
exports.sipRuleValidator = sipRuleValidator;
//# sourceMappingURL=data:application/json;base64,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