# Femwell

[![Docs](https://github.com/helgegehring/femwell/actions/workflows/docs.yml/badge.svg)](https://HelgeGehring.github.io/femwell/)
[![Build](https://github.com/helgegehring/femwell/actions/workflows/build.yml/badge.svg)](https://github.com/HelgeGehring/femwell/actions/workflows/build.yml)
[![PiPy](https://img.shields.io/pypi/v/femwell)](https://pypi.org/project/femwell/)
[![Downloads](https://static.pepy.tech/badge/femwell/month)](https://pepy.tech/project/femwell)

Working on a finite element based simulation tool for integrated circuits, electric and photonic!
The documentation is lagging behind the state of code, so there's several features for which there are only examples in the code.

**You can try out the examples in the browser! Hover the rocket at the top on the example pages and click live code!**
(Might take some time to load)

# Working Features
- Photonic eigenmode solver
- Electric eigenmode solver
- Thermal mode solver (static and transient)
- Coulomb solver

# Possible Simulations
- Eigenmodes of waveguides and determining their effective refractive index
- Eigenmodes of electric transmission lines and determining their propagation constant (in work)
- Static thermal profiles
- Transient thermal behavior
- Static electric fields
- Overlap integrals between waveguide modes
- Overlap integral between a waveguide mode and a fiber mode
- Coupled mode theory - coupling between adjacent waveguides
- Heat based photonic phase shifters
- Pockels based photonic phase shifters

# Contributors
- Helge Gehring (Google): Maintainer
- Simon Bilodeau (Google): Meshes everything
- Joaquin Matres (Google): Code simplifications

Happy about every form of contribution - pull requests, feature requests, issues, questions, ... :)
