"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
/**
 * @experimental
 */
class Redis extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options = {}) {
        var _b;
        super(scope, id);
        const master = new service_deployment_1.ServiceDeployment(this, 'master', {
            image: 'k8s.gcr.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'master',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'master',
                ...options.labels,
            },
        });
        this.masterHost = master.host;
        const slaveReplicas = (_b = options.slaveReplicas) !== null && _b !== void 0 ? _b : 2;
        if (slaveReplicas > 0) {
            const slave = new service_deployment_1.ServiceDeployment(this, 'slave', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'slave',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.masterHost },
                replicas: slaveReplicas,
                labels: {
                    app: 'redis',
                    role: 'slave',
                    ...options.labels,
                },
            });
            this.slaveHost = slave.host;
        }
        else {
            // if we have no slave, then use the same host as the master
            this.slaveHost = master.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.21" };
//# sourceMappingURL=data:application/json;base64,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