import setuptools

with open("README.rst", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="astir",
    version="0.0.10",
    author="Jinyu Hou, Sunyun Lee, Michael Geuenich, Kieran Campbell",
    author_email="jhou@lunenfeld.ca",
    description=" ",
    long_description=long_description,
    # long_description_content_type="text/markdown",
    url="https://github.com/camlab-bioml/astir",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: OS Independent",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
    ],
    license="GPLv2",
    install_requires=[
        "torch",
        "pandas",
        "numpy",
        "nbformat",
        "pyyaml",
        "sklearn",
        "argparse",
        "matplotlib",
        "loompy",
        "tqdm",
        "anndata",
        "rootpath",
        "nbconvert",
        "nbformat",
        "seaborn",
        "jupyter_client",
        "ipykernel",
        "ipython",
        "h5py",
        "FlowCytometryTools",
        "fastcluster",
        "sphinx",
        "sphinx_autodoc_typehints",
        "sphinx_rtd_theme",
        "autodocsumm",
        "nbsphinx",
        "nbsphinx_link",
        "tables",
        "typeguard",
        "mypy",
    ],
    project_urls={
        "Documentation": "https://astir.readthedocs.io/en/latest/",
        "Source Code": "https://github.com/camlab-bioml",
    },
    include_package_data=True,
    zip_safe=False,
    test_suite="nose.collector",
    test_require=["nose"],
    scripts=["bin/astir"],
)
