# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI.ipynb (unless otherwise specified).

__all__ = ["logger", "app"]

# Cell

from typing import *
import logging

# Internal Cell

import typer

from . import ds, model, pred, user, api_key
from .token import token
from .version import version
from ..logger import get_logger, set_level

# Cell

logger = get_logger(__name__)

set_level(logging.WARNING)

# Cell

app = typer.Typer(help="airt CLI for accessing airt services.")

# Internal Cell

# token root command

app.command()(token)

# Internal Cell

# Datasource root command

app.add_typer(
    ds.app,
    name="ds",
    short_help="A command for encapsulating the data from sources like AWS S3 bucket or a database.",
    help="A class for encapsulating the data from sources like AWS S3 bucket or a database. "
    "Currently, we support reading and pushing the data to a MySql database, and to an "
    "AWS S3 bucket in the Parquet file format. We plan to add other databases and storage "
    "mediums in the future.",
)

# Internal Cell

# Model root command

app.add_typer(
    model.app,
    name="model",
    short_help="Query the status of the model training, evaluation, and prediction on the remote server.",
    help="Query the status of the model training, evaluation, and prediction on the remote server.",
)

# Internal Cell

# Pred root command

app.add_typer(
    pred.app,
    name="pred",
    short_help="Run predictions on the data source.",
    help="Run predictions on the data source.",
)

# Internal Cell

# User root command

app.add_typer(
    user.app,
    name="user",
    short_help="User management commands",
    help="User management commands. All the user management routes are only accessable to super users. "
    "If a non-super user tried to access the user management commands a permission error will be displayed.",
)

# Internal Cell

# API Keys root command

app.add_typer(
    api_key.app,
    name="api-key",
    short_help="API keys management commands",
    help="""Set of commands for managing the API keys in airt service.

        Both the API key and the token can be used for accessing the airt services. However, there is a slight difference in generating and managing the two.

        For generating the API key, you first need to get the token. Please refer to the documentation of the airt token command for generating one.

        Once successfully authenticated, you can create any number of API keys and set an expiration date for each key individually. Also, you can use the other
        methods available in the APIKey class to list, revoke the keys at any time.

        You can now set the API key in the environment variable AIRT_SERVICE_TOKEN and start accessing airt services with it.""",
)

# Internal Cell

# version root command

app.command()(version)
