```
    ___    __                          __         
   /   |  / /___  _________  _________/ /__  _____
  / /| | / / __ `/ ___/ __ \/ ___/ __  / _ \/ ___/
 / ___ |/ / /_/ / /__/ /_/ / /  / /_/ /  __/ /    
/_/  |_/_/\__,_/\___/\____/_/   \__,_/\___/_/     
                                                  
```
# **Alacorder**
### Alacorder collects and processes case detail PDFs into data tables suitable for research purposes.

<sup>[GitHub](https://github.com/sbrobson959/alacorder)  | [PyPI](https://pypi.org/project/alacorder/)     | [Report an issue](mailto:sbrobson@crimson.ua.edu)
</sup>

## **Installation**

**If your device can run Python 3.9+, it can run Alacorder. Use `pip` to install the command line interface and Python module `alac`.**

* Install [Anaconda Distribution](https://www.anaconda.com/products/distribution) to install the latest Python.
* Once your Anaconda environment is configured, open a terminal from Anaconda Navigator and enter `pip install alacorder` to install.
* Enter `python -m alacorder` to use the command line interface.

```
 Usage: python -m alacorder [OPTIONS] COMMAND [ARGS]...                                                            
                                                                                                       
 Alacorder collects case detail PDFs from Alacourt.com and processes them into data tables suitable    
 for research purposes.                                                                                
                                                                                                       
╭─ Options ───────────────────────────────────────────────────────────────────────────────────────────╮
│ --version          Show the version and exit.                                                       │
│ --help             Show this message and exit.                                                      │
╰─────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭─ Commands ──────────────────────────────────────────────────────────────────────────────────────────╮
│ crawl-adoc     Collect full inmates list from ADOC Inmate Search and write to table at              │
│                `output_path` (.xls, .xlsx, .csv, .json, .parquet).                                  │
│ fetch-cases    From a queue table with `CaseNumber` column, download case detail PDFs to directory  │
│                at `output_path`.                                                                    │
│ make-archive   Create case text archive from directory of case detail PDFs.                         │
│ make-summary   Create voting rights summary grouped by person using a completed name/AIS pairing    │
│                template (use make-template to create empty template).                               │
│ make-table     Create table at `output_path` from archive or directory at `input_path`.             │
│ make-template  Create empty pairing template to be used as input for make-summary to create a       │
│                voting rights summary grouped by person instead of by case.                          │
│ party-search   Collect results from Alacourt Party Search into a table at `output_path`. Input      │
│                `queue_path` table from .xls(x), .csv, .json, or .parquet with columns corresponding │
│                to Alacourt Party Search fields: Name, Party Type, SSN, DOB, County, Division, Case  │
│                Year, Filed Before, Filed After, No Records.                                         │
│ rename-cases   Rename all cases in a directory to full case number. Duplicates will be removed.     │
│ search-adoc    Search ADOC using queue with First Name, Last Name, and AIS columns to retrieve      │
│                sentencing information from ADOC. Record table to `output_path`.                     │
╰─────────────────────────────────────────────────────────────────────────────────────────────────────╯
```
