#!/bin/sh

##
## This script will auto-generate the AUTHORS attribution file.
## If your name does not display correctly, then please
## update the .mailmap file in the root repo directory
##

git log --reverse --format='%aN <%aE>' | perl -we '

BEGIN {
  %seen = (), @authors = ();
}

## must manually add Lew first, since he generated the code prior to CVS
push @authors, "Lew Rossman <LRossman\@cinci.rr.com>\n";

while (<>) {
  next if $seen{$_};
  next if /orquina.jessica\@epa.gov/; ## this individual never authored code; just init-ed the repo
  $seen{$_} = push @authors, $_;
}

END {
  print "# Authors ordered by first contribution.\n";
  print "# Generated by tools/update-authors.sh\n";
  print "\n", @authors;
  print "\n*** some works are in the public domain, all others licensed under terms: see LICENSE";

}

'

echo "\n\nSome commits are co-authored:\n"

git log | grep Co-Author
