# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/cli/create_nc_template.ipynb.

# %% auto 0
__all__ = ['main']

# %% ../../nbs/cli/create_nc_template.ipynb 1
from pathlib import Path

from fastcore.script import *

from ..configs import BASE_PATH, CONFIGS, CONFIGS_CDL
from ..nc_template import NCTemplate
from ..utils import read_toml

# %% ../../nbs/cli/create_nc_template.ipynb 2
def main():
    "Create MARIS NetCDF template"
    cfgs = read_toml(BASE_PATH / 'configs.toml')
    tpl_fname = BASE_PATH / cfgs['names']['nc_template']
    dbo_nuc = [n for n in list(cfgs['paths']['luts']) if '_nuclide' in n][0]
    cdl = read_toml(BASE_PATH / 'cdl.toml')
    
    nc_tpl = NCTemplate(tpl_fname,
                        vars_fname=Path(cfgs['dirs']['lut']) / dbo_nuc, 
                        dest_dir=BASE_PATH,
                        cdl=cdl)
    nc_tpl.generate()
