# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/cli/init.ipynb.

# %% auto 0
__all__ = ['cfg_fname', 'cdl_fname', 'download_luts', 'main']

# %% ../../nbs/cli/init.ipynb 1
from pathlib import Path
import sys
from urllib import request

from fastcore.script import *
from fastcore.xtras import mkdir
from fastcore.style import S

from ..configs import BASE_PATH, CONFIGS, CONFIGS_CDL
from ..utils import write_toml

# %% ../../nbs/cli/init.ipynb 2
cfg_fname = 'configs.toml'
cdl_fname = 'cdl.toml'

# %% ../../nbs/cli/init.ipynb 3
def download_luts(luts):
    print('Downloading lookup tables ...')
    for fname, url in luts.items():
        print(f'  {url}')
        request.urlretrieve(url, BASE_PATH / f'lut/{fname}')

# %% ../../nbs/cli/init.ipynb 4
@call_parse
def main():
    "Create configuration files & download lookup tables"
    if BASE_PATH.exists():
        msg = S.red('Configuration files already exist. Do you want to overwrite them? (y/[n]): ')
        if not input(msg).lower().startswith('y'): 
            sys.exit(1)

    mkdir(BASE_PATH, overwrite=True)
    for k, v in CONFIGS['dirs'].items():
        mkdir(v, parents=True, overwrite=True)
            
    write_toml(BASE_PATH / cfg_fname, CONFIGS)
    write_toml(BASE_PATH / cdl_fname, CONFIGS_CDL) 
    download_luts(CONFIGS['paths']['luts'])
