# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/api/configs.ipynb.

# %% auto 0
__all__ = ['BASE_PATH', 'GITHUB_REPO', 'CONFIGS', 'CONFIGS_CDL', 'get_nc_tpl_path']

# %% ../nbs/api/configs.ipynb 1
from pathlib import Path
from .utils import read_toml

# %% ../nbs/api/configs.ipynb 2
BASE_PATH = Path.home() / '.marisco'
GITHUB_REPO = 'franckalbinet/marisco'

# %% ../nbs/api/configs.ipynb 3
CONFIGS = {
    'names': {
        'nc_template': 'maris-template.nc'
    },
    'dirs': {
        'lut': str(BASE_PATH / 'lut'), # Look-up tables
        'tmp': str(BASE_PATH / 'tmp'), # Look-up tables
    },
    'paths': {
        'luts': {
            'dbo_nuclide.xlsx': f'https://github.com/{GITHUB_REPO}/blob/main/nbs/files/lut/dbo_nuclide.xlsx?raw=true'
        }
    }
}

# %% ../nbs/api/configs.ipynb 4
CONFIGS_CDL = { 
    'placeholder': '_to_be_filled_in_',
    'grps': {
        'sea': {
            'name': 'seawater'
        },
        'bio': {
            'name': 'biota'
        },
        'sed': {
            'name': 'sediment'
        },
        'sus': {
            'name': 'suspended-matter'
        }
    },
    'global_attrs': {
        'description': 'Template description',
        'summary': 'Template summary',
        'keyword': 'MARIS other-key-words',
        'license': 'Common ...'
        },
    'dim': {
        'name': 'sample',
        'long_name': 'Sample ID of measurement'
    },
    'vars': {    
        'defaults': {
            'lon': {
                'name': 'lon',
                'long_name': 'Measurement longitude',
                'standard_name': 'longitude',
                'units': 'degrees_north',
                'axis': 'Y',
                '_CoordinateAxisType': 'Lon'
            },
            'lat': {
                'name': 'lat',
                'long_name': 'Measurement latitude',
                'standard_name': 'latitude',
                'units': 'degrees_east',
                'axis': 'X',
                '_CoordinateAxisType': 'Lat'
            },
            'depth': {
                'name': 'depth',
                'long_name': 'Depth below seal level',
                'standard_name': 'depth_below_sea_floor',
                'units': 'm',
                'axis': 'Z'
            },
            'time': {
                'name': 'time',
                'long_name': 'Time of measurement',
                'standard_name': 'time',
                'units': 'seconds since 1970-01-01 00:00:00.0',
                'time_origin': '1970-01-01 00:00:00',
                'time_zone': 'UTC',
                'abbreviation': 'Date/Time',
                'axis': 'T',
                'calendar': 'gregorian'
            },
        },
        'suffixes':  {
            'uncertainty': {
                'name': '_unc',
                'long_name': ' uncertainty',
                'standard_name': '_uncertainty'
            },
            'detection_limit': {
                'name': '_dl',
                'long_name': ' detection limit',
                'standard_name': '_detection_limit'
            }
        }
    }
}

# %% ../nbs/api/configs.ipynb 5
def get_nc_tpl_path():
    return BASE_PATH / read_toml(BASE_PATH / 'configs.toml')['names']['nc_template']
