import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendServiceSignedUrlKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The backend service this signed URL key belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#backend_service ComputeBackendServiceSignedUrlKey#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * 128-bit key value used for signing the URL.
     *
     * The key value must be a
     * valid RFC 4648 Section 5 base64url encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#key_value ComputeBackendServiceSignedUrlKey#key_value}
     *
     * @stability stable
     */
    readonly keyValue: string;
    /**
     * Name of the signed URL key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#name ComputeBackendServiceSignedUrlKey#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#project ComputeBackendServiceSignedUrlKey#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#timeouts ComputeBackendServiceSignedUrlKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendServiceSignedUrlKeyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceSignedUrlKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#create ComputeBackendServiceSignedUrlKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#delete ComputeBackendServiceSignedUrlKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ComputeBackendServiceSignedUrlKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html google_compute_backend_service_signed_url_key}.
 *
 * @stability stable
 */
export declare class ComputeBackendServiceSignedUrlKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html google_compute_backend_service_signed_url_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendServiceSignedUrlKeyConfig);
    private _backendService?;
    /**
     * @stability stable
     */
    get backendService(): string;
    /**
     * @stability stable
     */
    set backendService(value: string);
    /**
     * @stability stable
     */
    get backendServiceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyValue?;
    /**
     * @stability stable
     */
    get keyValue(): string;
    /**
     * @stability stable
     */
    set keyValue(value: string);
    /**
     * @stability stable
     */
    get keyValueInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendServiceSignedUrlKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeBackendServiceSignedUrlKeyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendServiceSignedUrlKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
