import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html#project ProjectIamAuditConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Service which will be enabled for audit logging. The special value allServices covers all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html#service ProjectIamAuditConfig#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * audit_log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html#audit_log_config ProjectIamAuditConfig#audit_log_config}
     *
     * @stability stable
     */
    readonly auditLogConfig: ProjectIamAuditConfigAuditLogConfig[];
}
/**
 * @stability stable
 */
export interface ProjectIamAuditConfigAuditLogConfig {
    /**
     * Identities that do not cause logging for this type of permission.
     *
     * Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html#exempted_members ProjectIamAuditConfig#exempted_members}
     *
     * @stability stable
     */
    readonly exemptedMembers?: string[];
    /**
     * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html#log_type ProjectIamAuditConfig#log_type}
     *
     * @stability stable
     */
    readonly logType: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html google_project_iam_audit_config}.
 *
 * @stability stable
 */
export declare class ProjectIamAuditConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_iam_audit_config.html google_project_iam_audit_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectIamAuditConfigConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _auditLogConfig?;
    /**
     * @stability stable
     */
    get auditLogConfig(): ProjectIamAuditConfigAuditLogConfig[];
    /**
     * @stability stable
     */
    set auditLogConfig(value: ProjectIamAuditConfigAuditLogConfig[]);
    /**
     * @stability stable
     */
    get auditLogConfigInput(): ProjectIamAuditConfigAuditLogConfig[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
