# mypy-boto3-networkmanager

[![PyPI - mypy-boto3-networkmanager](https://img.shields.io/pypi/v/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.NetworkManager 1.12.22](https://boto3.amazonaws.com/v1/documentation/api/1.12.22/reference/services/networkmanager.html#NetworkManager) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.5](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-networkmanager](#mypy-boto3-networkmanager)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `NetworkManager` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-networkmanager]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import networkmanager
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_networkmanager as networkmanager

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("networkmanager")
client: networkmanager.NetworkManagerClient = boto3.client("networkmanager")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: networkmanager.NetworkManagerClient = session.client("networkmanager")


# Paginators need type annotation on creation
describe_global_networks_paginator: networkmanager.DescribeGlobalNetworksPaginator = client.get_paginator("describe_global_networks")
get_customer_gateway_associations_paginator: networkmanager.GetCustomerGatewayAssociationsPaginator = client.get_paginator("get_customer_gateway_associations")
get_devices_paginator: networkmanager.GetDevicesPaginator = client.get_paginator("get_devices")
get_link_associations_paginator: networkmanager.GetLinkAssociationsPaginator = client.get_paginator("get_link_associations")
get_links_paginator: networkmanager.GetLinksPaginator = client.get_paginator("get_links")
get_sites_paginator: networkmanager.GetSitesPaginator = client.get_paginator("get_sites")
get_transit_gateway_registrations_paginator: networkmanager.GetTransitGatewayRegistrationsPaginator = client.get_paginator("get_transit_gateway_registrations")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.